require  'sketchup.rb' # Link Sketchup 6.0
require  File.dirname(__FILE__) + '/Bezier_curve.rb' # Bezier curve class
require  File.dirname(__FILE__) + '/Bezier_surf.rb' # Bezier surface class
require  File.dirname(__FILE__) + '/Mid_point.rb' # Find mid_point for Bezier curves
require  File.dirname(__FILE__) + '/Rational.rb' # Rational number
require  File.dirname(__FILE__) + '/Wireframe.rb' # Wireframe methods

class Matchbox
    def initialize(g, i)

        Sketchup.set_status_text('Running Matchbox: Generating seed# ' + i.to_s)
        # Global Constants
        @dimension_coef = 0.15
        @eps = 0.000001
        
        y = i/4
        x = i - y*4
        @origin = Geom::Vector3d.new(300*x, 200*y, 0)
        
        ex = Geom::Vector3d.new(1, 0, 0)
        ey = Geom::Vector3d.new(0, 1, 0)
        ez = Geom::Vector3d.new(0, 0, 1)
        
        # Global Variables
        #@center = Geom::Point3d.new((@box_l+@box_r)/2, 0, 0)
        
        # Global Parameters
        @numseg = 8
        
        model = Sketchup.active_model
        @matchbox = model.entities.add_group
        aCar = @matchbox.entities.add_group
        
    # Component 1: Front window, roof and rear window
    # 17 variables: Genotype 0 ~ 16
            Sketchup.set_status_text('Running Matchbox: Generating seed# ' + i.to_s + '_Component1')
            
            c1 = aCar.entities.add_group
            profile1 = Hash.new
#--------------------------------------------------------------------------------------------------------------------------------------------------------------
            # Local Parameters
            @eta = 0.8 # eta is a coef to smooth the curve, see notes on constraint on component 1
            @well_scale = 1.5
            @r_wheel = 89.0
            @roof_end_pt_x = 800.0 # higher limit on @roof_end_pt
            @bw_end_pt_x = 900.0 # higher limit on @bw_end_pt
@roof_end_pt_z = @origin.z + @r_wheel*@well_scale + 150.0 # lower limit on @roof_end_pt
            @bw_end_pt_z = @roof_end_pt_z - 20.0 # lower limit on @bw_end_pt
            @hood_u_n = 100 # to avoid surface intrution (@nose_mid_pt is on the negative side of center plane)

            # Variables and Curves with Constraints
            @hood_end_pt = Geom::Point3d.new(50.0 + 100*g.x[0],0.0,220.0 + 30*g.x[1])
            @roof_start_pt = Geom::Point3d.new(@hood_end_pt.x + 240.0 + 10*g.x[2],0.0,@hood_end_pt.z + 90.0 + 30*g.x[3])

            temp = (@roof_start_pt - @hood_end_pt).normalize.x * (0.8 + 0.2 * g.x[4])
            @fw_vec = Geom::Vector3d.new(temp, 0.0, Math.sqrt(1.0-temp*temp))

            # We restrict @fw_n so that there will be no front window that bend down (m<0)
            @fw_n = (@roof_start_pt.z - @hood_end_pt.z)*0.8/ @fw_vec.z +  (@roof_start_pt.z - @hood_end_pt.z)*0.2/ @fw_vec.z*g.x[5]

            @fw_v_n = 90.0  

            temp = Wireframe.link_tan(@hood_end_pt, @roof_start_pt, @fw_vec, @fw_n, @numseg)
            profile1['fw'] = temp['all_pt']
            profile1['fw_ctrl_pt'] = temp['mid_pt']

            # The position of @roof_end_pt is constrained by the requirement that roof_ctrl_pt shall be "between" @roof_end_pt and @roof_start_pt
            # See notes on "Constraints on Component 1, 2"
            # Here we first randomize @roof_end_pt.x and then find the acceptable domain for @roof_end_pt.z
            ux = @hood_end_pt.x - profile1['fw_ctrl_pt'].x
            uz = @hood_end_pt.z - profile1['fw_ctrl_pt'].z
            vx = @roof_start_pt.x - profile1['fw_ctrl_pt'].x
            vz = @roof_start_pt.z - profile1['fw_ctrl_pt'].z
            d = vx*uz-vz*ux
            xb = @roof_end_pt_x - @roof_start_pt.x
            xbb = 0
            #zb = @hood_end_pt.z + 200 - @roof_start_pt.z
            zb = 10
            zbb = @roof_end_pt_z - @roof_start_pt.z
            #xbb = [([xb/vx, zb/vz].min*d + zb*ux)/uz, 0].max
            if ux>0 && uz<0 #case 1
                if vz < 0
                    UI.messagebox('Error generating shape_Error#_c1_10: Shape not acceptable.')
                else
                    eta = xb/vx*0.5
                    m = [(xbb*uz-zbb*ux)/d, zbb/vz].max #lower bound for psi
                    n = [(xb*uz-zb*ux)/d, xb/vx].min
                    if m > n
                        UI.messagebox('Error generating shape_Error#_c1_20: Boundary condition not acceptable')
                    else
                        psi = m + (n - m)*g.x[6]
                        mm = [(zb-psi*vz)/uz, (xbb-psi*vx)/ux, 0, vx/ux*(eta-psi)].max
                        nn = [(zbb-psi*vz)/uz, (xb-psi*vx)/ux].min
                        if mm > nn
                            UI.messagebox('Error generating shape_Error#_c1_01: Wrong range for phi')
                        end
                    end
                end
                flag = 1
            elsif ux<0 && uz<0 #case 2
                if vz<0
                    eta = [(xb*uz-zbb*ux)/d, xb/vx, zbb/vz].min*0.5
                    m = [(xbb*uz-zb*ux)/d, xbb/vx, (vx*uz*eta-zb*ux)/d, (zb-uz*eta*eta)/vz, eta].max
                    n = [(xb*uz-zbb*ux)/d, zbb/vz, (xb-ux*eta*eta)/vx].min
                elsif vz>0 && d<0
                    eta = [(xb*uz-zbb*ux)/d, xb/vx, (xb*d/vx+zb*ux)/vx/uz, (zb*d/vx+zb*uz)/vz/uz].min*0.5
                    m = [(xbb*uz-zb*ux)/d, xbb/vx, eta, (vx*uz*eta-zb*ux)/d].max
                    n = [(xb*uz-zbb*ux)/d, (xb-ux*eta*eta)/vx, (zb-uz*eta*eta)/vz].min
                    flag = 1
                else
                    eta = [(xbb*uz-zb*ux)/d, xb/vx].min*0.5
                    m = [(xb*uz-zbb*ux)/d, xbb/vx, eta].max
                    n = [(xbb*uz-zb*ux)/d, (xb-ux*eta*eta)/vx, (zb-uz*eta*eta)/vz, (vx*uz*eta-zb*ux)/d].min
                    flag = 2
                end
                
                if m > n
                    UI.messagebox('Error generating shape_Error#_c1_21: Boundary condition not acceptable')
#UI.messagebox(flag.to_s + ' ' + ((xbb*uz-zb*ux)/d).to_s + ' ' + (xbb/vx).to_s + ' ' + (eta).to_s + ' ' + ((vx*uz*eta-zb*ux)/d).to_s + ' ' + ((xb*uz-zbb*ux)/d).to_s + ' ' + ((xb-ux*eta*eta)/vx).to_s + ' ' + ((zb-uz*eta*eta)/vz).to_s)
#UI.messagebox(((xb*d/vx+zb*ux)/vx/uz).to_s + ' ' + ((zb*d/vx+zb*uz)/vz/uz).to_s+ ' ' + ((xb*uz-zbb*ux)/d).to_s + ' ' + (xb/vx).to_s)
                else
                    psi = m + (n - m)*g.x[6]
                    mm = [(zb-psi*vz)/uz, (xb-psi*vx)/ux, 0].max
                    nn = [(zbb-psi*vz)/uz, (xbb-psi*vx)/ux, vx/ux*(eta-psi), eta*eta].min
                    if mm > nn
                        UI.messagebox('Error generating shape_Error#_c1_02: Wrong range for phi')
                    end
                end
                flag = 2
            elsif ux<0 && uz>0 #case 3
                if vz >0
                    eta = [xb/vx, (xb*uz-zb*ux)/d, zb/vz].min*0.5
                    m = [(xbb*uz-zbb*ux)/d, xbb/vx, eta, (vx*uz*eta-zbb*ux)/d, (zbb-uz*eta*eta)/vz].max
                    n = [(xb*uz-zb*ux)/d, zb/vz, (xb-ux*eta*eta)/vx].min
                else
                    eta = [xb/vx, zbb/vz, (xbb*uz-zbb*ux)/d].min*0.5
                    m = [(xb*uz-zb*ux)/d, xbb/vx, eta].max
                    n = [(xbb*uz-zbb*ux)/d, (vx*uz*eta-zbb*ux)/d, (xb-ux*eta*eta)/vx, (zbb-uz*eta*eta)/vz].min
                end
                if m > n
                    UI.messagebox('Error generating shape_Error#_c1_22: Boundary condition not acceptable')
                else
                    psi = m +(n - m)*g.x[6]
                    mm = [(zbb-psi*vz)/uz, (xb-psi*vx)/ux, 0].max
                    nn = [(zb-psi*vz)/uz, (xbb-psi*vx)/ux, vx/ux*(eta-psi), eta*eta].min
                    if mm > nn
                        UI.messagebox('Error generating shape_Error#_c1_03: Wrong range for phi')
                    end
                end
                
                flag = 3
            elsif ux<0 && uz == 0 #case 4
                
                if vz<0
                    eta = [-zbb*ux/d, xb/vx, zbb/vz].min*0.5
                    m = [-zb*ux/d, xbb/vx, -zb*ux/d, zb/vz, eta].max
                    n = [-zbb*ux/d, zbb/vz, (xb-ux*eta*eta)/vx].min
                else
                    eta = [zb/vz, xb/vx,].min*0.5
                    m = [zbb/vz, xbb/vx, eta].max
                    n = [zb/vz, (xb-ux*eta*eta)/vx].min
                end
                
                if m > n
                    UI.messagebox('Error generating shape_Error#_c1_23: Boundary condition not acceptable')
                else
                    psi = m + (n - m)*g.x[6]
                    mm = [(xb-psi*vx)/ux, 0.0].max
                    nn = [(xbb-psi*vx)/ux, vx/ux*(eta-psi), eta*eta].min
                    if mm > nn
                        UI.messagebox('Error generating shape_Error#_c1_04: Wrong range for phi')
                    end
                end
                
                flag = 4
            else
                UI.messagebox('Error generating shape_Error#_c1_13: Shape not acceptable.')
            end
            
            phi = mm + (nn - mm)*g.x[7]
            @roof_end_pt = Geom::Point3d.new(@roof_start_pt.x + phi*ux + psi*vx, 0, @roof_start_pt.z + phi*uz + psi*vz)
            temp = Wireframe.link_cur(@hood_end_pt, profile1['fw_ctrl_pt'], @roof_start_pt, @roof_end_pt, 1, @numseg)
            profile1['roof'] = temp['all_pt']
            profile1['roof_ctrl_pt'] = temp['mid_pt']

            ux = @roof_start_pt.x - profile1['roof_ctrl_pt'].x
            uz = @roof_start_pt.z - profile1['roof_ctrl_pt'].z
            vx = @roof_end_pt.x - profile1['roof_ctrl_pt'].x
            vz = @roof_end_pt.z - profile1['roof_ctrl_pt'].z
            d = vx*uz-vz*ux
            xb = @bw_end_pt_x - @roof_end_pt.x
            xbb = xb*0.1
            zb = 1000
            zbb = @bw_end_pt_z - @roof_end_pt.z
            if ux<0 && uz<0 && vz<0
                xbb = [(xb*uz-zbb*ux)/d*vx, zbb/vz*vx, xb].min*0.1
            end
            if ux>0 && uz<0 #case 1
                if vz < 0
                    UI.messagebox('Error generating shape_Error#_c1_40: Shape not acceptable.')
                else
                    eta = xb/vx*0.5
                    m = [(xbb*uz-zbb*ux)/d, zbb/vz].max #lower bound for psi
                    n = [(xb*uz-zb*ux)/d, xb/vx].min
                    if m > n
                        UI.messagebox('Error generating shape_Error#_c1_50: Boundary condition not acceptable')
                    else
                        psi2 = m + (n - m)*g.x[8]
                        mm = [(zb-psi2*vz)/uz, (xbb-psi2*vx)/ux, 0, vx/ux*(eta-psi2)].max
                        nn = [(zbb-psi2*vz)/uz, (xb-psi2*vx)/ux].min
                        if mm > nn
                            UI.messagebox('Error generating shape_Error#_c1_31: Wrong range for phi')
                        end
                    end
                end
                flag = 1
            elsif ux<0 && uz<0 #case 2
                
                if vz<0
                    eta = [(xb*uz-zbb*ux)/d, xb/vx, zbb/vz].min*0.5
                    m = [(xbb*uz-zb*ux)/d, xbb/vx, (vx*uz*eta-zb*ux)/d, (zb-uz*eta*eta)/vz, eta].max
                    n = [(xb*uz-zbb*ux)/d, zbb/vz, (xb-ux*eta*eta)/vx].min
                    flag = 0
                elsif vz>0 && d<0
                    eta = [(xb*uz-zbb*ux)/d, xb/vx, (xb*d/vx+zb*ux)/vx/uz, (zb*d/vx+zb*uz)/vz/uz].min*0.5
                    m = [(xbb*uz-zb*ux)/d, xbb/vx, eta, (vx*uz*eta-zb*ux)/d].max
                    n = [(xb*uz-zbb*ux)/d, (xb-ux*eta*eta)/vx, (zb-uz*eta*eta)/vz].min
                    flag = 1
                else
                    eta = [(xbb*uz-zb*ux)/d, xb/vx].min*0.5
                    m = [(xb*uz-zbb*ux)/d, xbb/vx, eta].max
                    n = [(xbb*uz-zb*ux)/d, (xb-ux*eta*eta)/vx, (zb-uz*eta*eta)/vz, (vx*uz*eta-zb*ux)/d].min
                    flag = 2
                end
                
                if m > n
                    UI.messagebox('Error generating shape_Error#_c1_51: Boundary condition not acceptable')
#UI.messagebox(d.to_s + ' ' + ((xbb*uz-zb*ux)/d).to_s + ' ' + (xbb/vx).to_s + ' ' + ((vx*uz*eta-zb*ux)/d).to_s + ' ' + ((zb-uz*eta*eta)/vz).to_s + ' ' + (eta).to_s + ' ' + ((xb*uz-zbb*ux)/d).to_s + ' ' + (zbb/vz).to_s + ' ' + ((xb-ux*eta*eta)/vx).to_s)
#UI.messagebox(((xb*d/vx+zb*ux)/vx/uz).to_s + ' ' + ((zb*d/vx+zb*uz)/vz/uz).to_s+ ' ' + ((xb*uz-zbb*ux)/d).to_s + ' ' + (xb/vx).to_s)
                else
                    psi2 = m + (n - m)*g.x[8]
                    mm = [(zb-psi2*vz)/uz, (xb-psi2*vx)/ux, 0].max
                    nn = [(zbb-psi2*vz)/uz, (xbb-psi2*vx)/ux, vx/ux*(eta-psi2), eta*eta].min
                    if mm > nn
                        UI.messagebox('Error generating shape_Error#_c1_32: Wrong range for phi')
                    end
                end
                flag = 2
            elsif ux<0 && uz>0 #case 3
                
                if vz >0
                    eta = [xb/vx, (xb*uz-zb*ux)/d, zb/vz].min*0.5
                    m = [(xbb*uz-zbb*ux)/d, xbb/vx, eta, (vx*uz*eta-zbb*ux)/d, (zbb-uz*eta*eta)/vz].max
                    n = [(xb*uz-zb*ux)/d, zb/vz, (xb-ux*eta*eta)/vx].min
                else
                    eta = [xb/vx, zbb/vz, (xbb*uz-zbb*ux)/d].min*0.5
                    m = [(xb*uz-zb*ux)/d, xbb/vx, eta].max
                    n = [(xbb*uz-zbb*ux)/d, (vx*uz*eta-zbb*ux)/d, (xb-ux*eta*eta)/vx, (zbb-uz*eta*eta)/vz].min
                end
                if m > n
                    UI.messagebox('Error generating shape_Error#_c1_52: Boundary condition not acceptable')
                else
                    psi2 = m +(n - m)*g.x[8]
                    mm = [(zbb-psi2*vz)/uz, (xb-psi2*vx)/ux, 0].max
                    nn = [(zb-psi2*vz)/uz, (xbb-psi2*vx)/ux, vx/ux*(eta-psi2), eta*eta].min
                    if mm > nn
                        UI.messagebox('Error generating shape_Error#_c1_33: Wrong range for phi')
                    end
                end
                
                flag = 3
            elsif ux<0 && uz == 0 #case 4
                
                if vz<0
                    eta = [-zbb*ux/d, xb/vx, zbb/vz].min*0.5
                    m = [-zb*ux/d, xbb/vx, -zb*ux/d, zb/vz, eta].max
                    n = [-zbb*ux/d, zbb/vz, (xb-ux*eta*eta)/vx].min
                else
                    eta = [zb/vz, xb/vx,].min*0.5
                    m = [zbb/vz, xbb/vx, eta].max
                    n = [zb/vz, (xb-ux*eta*eta)/vx].min
                end
                
                if m > n
                    UI.messagebox('Error generating shape_Error#_c1_53: Boundary condition not acceptable')
                else
                    psi2 = m + (n - m)*g.x[8]
                    mm = [(xb-psi2*vx)/ux, 0.0].max
                    nn = [(xbb-psi2*vx)/ux, vx/ux*(eta-psi2), eta*eta].min
                    if mm > nn
                        UI.messagebox('Error generating shape_Error#_c1_34: Wrong range for phi')
                    end
                end
                
                flag = 4
            else
                UI.messagebox('Error generating shape_Error#_c1_43: Shape not acceptable.')
            end
            phi2 = mm + (nn - mm)*g.x[9]
            @bw_end_pt = Geom::Point3d.new(@roof_end_pt.x + phi2*ux + psi2*vx, 0, @roof_end_pt.z + phi2*uz + psi2*vz)
            #temp = Wireframe.link_cur(@roof_start_pt, profile1['roof_ctrl_pt'], @roof_end_pt, @bw_end_pt, 1, @numseg)
            temp = Geom::Point3d.new(@roof_end_pt.x + Math.sqrt(phi2)*vx, 0, @roof_end_pt.z + Math.sqrt(phi2)*vz)
            #profile1['bw'] = temp['all_pt']
            #profile1['bw_ctrl_pt'] = temp['mid_pt']
            profile1['bw_ctrl_pt'] = temp
#UI.messagebox(phi.to_s + ' ' + psi.to_s)
#--------------------------------------------------------------------------------------------------------------------------------------------------------------
            @c1_t = 0.8 + 0.2*g.x[10] #scale-copy the profile on xz plane to the side curve
            @hood_u_pt_x = (@bw_end_pt.x - @hood_end_pt.x)*(1-@c1_t)*(0.5 + 0.5*g.x[11]) #move side curve of component1 on the x axis
            @hood_u_pt_z = -5*g.x[12] #move side curve of component1 on the z axis
            @hood_u_pt = Geom::Point3d.new(@hood_end_pt.x + @hood_u_pt_x, 180+20*g.x[13], @hood_end_pt.z + @hood_u_pt_z)

            fw_v_hash_pt = Geom::Point3d.new(@hood_end_pt.x + (profile1['fw_ctrl_pt'].x - @hood_end_pt.x)*@c1_t + @hood_u_pt_x, @hood_u_pt.y, @hood_end_pt.z + (profile1['fw_ctrl_pt'].z - @hood_end_pt.z)*@c1_t + @hood_u_pt_z)
            @fw_u_pt = Geom::Point3d.new(@hood_end_pt.x + (@roof_start_pt.x - @hood_end_pt.x)*@c1_t + @hood_u_pt_x, @hood_u_pt.y, @hood_end_pt.z + (@roof_start_pt.z - @hood_end_pt.z)*@c1_t + @hood_u_pt_z)

            roof_v_hash_pt = Geom::Point3d.new(@hood_end_pt.x + (profile1['roof_ctrl_pt'].x - @hood_end_pt.x)*@c1_t + @hood_u_pt_x, @hood_u_pt.y, @hood_end_pt.z + (profile1['roof_ctrl_pt'].z - @hood_end_pt.z)*@c1_t + @hood_u_pt_z)
            @roof_pt = Geom::Point3d.new(@hood_end_pt.x + (@roof_end_pt.x - @hood_end_pt.x)*@c1_t + @hood_u_pt_x, @hood_u_pt.y, @hood_end_pt.z + (@roof_end_pt.z - @hood_end_pt.z)*@c1_t + @hood_u_pt_z)

            bw_v_hash_pt = Geom::Point3d.new(@hood_end_pt.x + (profile1['bw_ctrl_pt'].x - @hood_end_pt.x)*@c1_t + @hood_u_pt_x, @hood_u_pt.y, @hood_end_pt.z + (profile1['bw_ctrl_pt'].z - @hood_end_pt.z)*@c1_t + @hood_u_pt_z)
            @bw_pt = Geom::Point3d.new(@hood_end_pt.x + (@bw_end_pt.x - @hood_end_pt.x)*@c1_t + @hood_u_pt_x, @hood_u_pt.y, @hood_end_pt.z + (@bw_end_pt.z - @hood_end_pt.z)*@c1_t + @hood_u_pt_z)

            #@fw_v_n = @fw_n*@c1_t

            c1_r1 = Geom::Transformation.new(@hood_u_pt, @fw_vec, -0.2*g.x[14]) #Component1 rotation1
            [@fw_u_pt, @roof_pt, @bw_pt, fw_v_hash_pt, roof_v_hash_pt, bw_v_hash_pt].each {|pt| pt = pt.transform!(c1_r1)}
            #fw_v_hash = Wireframe.link_tan(@hood_u_pt, @fw_u_pt, @fw_vec, @fw_v_n, @numseg)
            fw_v_hash = Wireframe.link(@hood_u_pt, fw_v_hash_pt, @fw_u_pt, @numseg)

            c1_r2 = Geom::Transformation.new(@fw_u_pt, @fw_u_pt - fw_v_hash['mid_pt'] , 0.0*g.x[15]) #Component1 rotation2
            [@roof_pt, @bw_pt, roof_v_hash_pt, bw_v_hash_pt].each {|pt| pt = pt.transform!(c1_r2)}
            #roof_v_hash = Wireframe.link_cur(@hood_u_pt, fw_v_hash['mid_pt'], @fw_u_pt, @roof_pt, 1, @numseg)
            roof_v_hash = Wireframe.link(@fw_u_pt, roof_v_hash_pt, @roof_pt, @numseg)

            c1_r3 = Geom::Transformation.new(@roof_pt, @roof_pt - roof_v_hash['mid_pt'], 0.0*g.x[16]) #Component1 rotation3
            [@bw_pt, bw_v_hash_pt].each {|pt| pt.transform!(c1_r3)}
            bw_v_hash = Wireframe.link(@roof_pt, bw_v_hash_pt, @bw_pt, @numseg)
            #bw_v_hash = Wireframe.link_cur(@fw_u_pt, roof_v_hash['mid_pt'], @roof_pt, @bw_pt, 1, @numseg)

            # Surface
            hood_u_hash = Wireframe.link_tan(@hood_end_pt, @hood_u_pt, ey, @hood_u_n, @numseg)
            
            # To reduce the number of variables, we assume that the mid pts of hood_center, roof and hood_u curves have 
            # the same propotion to their total y length.
            k = hood_u_hash['mid_pt'].y / @hood_u_pt.y
            
            fw_center_n =  k * fw_v_hash['mid_pt'].y
            fw_center = Mid_point.surftan1(profile1['fw_ctrl_pt'], ey, fw_center_n)
            
            fw_u_n = k * @fw_u_pt.y
            fw_u_hash = Wireframe.link_tan(@roof_start_pt, @fw_u_pt, ey, fw_u_n, @numseg)
            
            pq = Mid_point.curvpqxz(@hood_end_pt, profile1['fw_ctrl_pt'], @roof_start_pt, @roof_end_pt)
            p = pq[0]
            q = pq[1]

            a = @roof_start_pt - profile1['fw_ctrl_pt'] + ey.transform(Geom::Transformation.new(fw_u_n - fw_center_n))
            b = @hood_end_pt - profile1['fw_ctrl_pt'] + ey.transform(Geom::Transformation.new(@hood_u_n - fw_center_n))
            
            mid_pt = Geom::Point3d.new
            mid_pt.x = a.x*psi + b.x*phi + fw_u_hash['mid_pt'].x
            mid_pt.y = a.y*psi + b.y*phi + fw_u_hash['mid_pt'].y
            mid_pt.z = a.z*psi + b.z*phi + fw_u_hash['mid_pt'].z
            #bc = Bezier_curve.new
            roof_u_hash = Hash.new
            roof_u_hash['mid_pt'] = mid_pt
            #roof_u_hash['all_pt'] = bc.curve([@roof_end_pt, mid_pt, @roof_pt], @numseg, nil)
            
            roof_center = Geom::Point3d.new
            roof_center.x = fw_u_hash['mid_pt'].x + a.x*Math.sqrt(phi.abs)
            roof_center.y = fw_u_hash['mid_pt'].y + a.y*Math.sqrt(phi.abs)
            roof_center.z = fw_u_hash['mid_pt'].z + a.z*Math.sqrt(phi.abs)

            roof_center_n = roof_center.y
            roof_u_n = roof_u_hash['mid_pt'].y
            #pq = Mid_point.curvpqxz(@roof_start_pt, profile1['roof_ctrl_pt'], @roof_end_pt, @bw_end_pt)
            #p = pq[0]
            #q = pq[1]
            
            a = @roof_end_pt - profile1['roof_ctrl_pt'] + ey.transform(Geom::Transformation.new(roof_u_n - roof_center_n))
            b = @roof_start_pt - profile1['roof_ctrl_pt'] + ey.transform(Geom::Transformation.new(fw_u_n - roof_center_n))
            
            mid_pt = Geom::Point3d.new
            mid_pt.x = a.x*psi2 + b.x*phi2 + roof_u_hash['mid_pt'].x
            mid_pt.y = a.y*psi2 + b.y*phi2 + roof_u_hash['mid_pt'].y
            mid_pt.z = a.z*psi2 + b.z*phi2 + roof_u_hash['mid_pt'].z
            bw_u_hash = Hash.new
            bw_u_hash['mid_pt'] = mid_pt
            
            bw_center = Geom::Point3d.new
            bw_center.x = roof_u_hash['mid_pt'].x + a.x*Math.sqrt(phi2.abs)
            bw_center.y = roof_u_hash['mid_pt'].y + a.y*Math.sqrt(phi2.abs)
            bw_center.z = roof_u_hash['mid_pt'].z + a.z*Math.sqrt(phi2.abs)

            data = Hash.new
            data['uOrder'] = 2
            data['vOrder'] = 2
            data['uSteps'] = @numseg
            data['vSteps'] = @numseg
            
            data['ctrlPts'] = [@roof_start_pt, fw_u_hash['mid_pt'], @fw_u_pt, profile1['fw_ctrl_pt'], fw_center, fw_v_hash['mid_pt'], @hood_end_pt, hood_u_hash['mid_pt'], @hood_u_pt]
            fw_surf = Bezier_surf.new(data)
            fw_surf.create_patch(c1.entities)
            
            data['ctrlPts'] = [@roof_end_pt, roof_u_hash['mid_pt'], @roof_pt, profile1['roof_ctrl_pt'], roof_center, roof_v_hash['mid_pt'], @roof_start_pt, fw_u_hash['mid_pt'], @fw_u_pt]
            roof_surf = Bezier_surf.new(data)
            roof_surf.create_patch(c1.entities)
            
            data['ctrlPts'] = [@bw_end_pt, bw_u_hash['mid_pt'], @bw_pt, profile1['bw_ctrl_pt'], bw_center, bw_v_hash['mid_pt'], @roof_end_pt, roof_u_hash['mid_pt'], @roof_pt]
            bw_surf = Bezier_surf.new(data)
            bw_surf.create_patch(c1.entities)
            
            #model.entities.add_curve([@hood_end_pt, profile1['fw_ctrl_pt']])
            #model.entities.add_curve([profile1['fw_ctrl_pt'], @roof_start_pt])
            #model.entities.add_curve([@roof_start_pt, profile1['roof_ctrl_pt']])
            #model.entities.add_curve([profile1['roof_ctrl_pt'], @roof_end_pt])
            #model.entities.add_curve([@roof_end_pt, profile1['bw_ctrl_pt']])
            #model.entities.add_curve([profile1['bw_ctrl_pt'], @bw_end_pt])
            #model.entities.add_curve([@hood_u_pt, fw_v_hash['mid_pt']])
            #model.entities.add_curve([fw_v_hash['mid_pt'], @fw_u_pt])
            #model.entities.add_curve([@fw_u_pt, roof_v_hash['mid_pt']])
            #model.entities.add_curve([roof_v_hash['mid_pt'], @roof_pt])
            #model.entities.add_curve([@roof_pt, bw_v_hash['mid_pt']])
            #model.entities.add_curve([bw_v_hash['mid_pt'], @bw_pt])
            #model.entities.add_curve([@bw_end_pt,bw_u_hash['mid_pt']])
            #model.entities.add_curve([bw_u_hash['mid_pt'], @bw_pt])
            #model.entities.add_curve([profile1['bw_ctrl_pt'],bw_center])
            #model.entities.add_curve([bw_center, bw_v_hash['mid_pt']])
            #model.entities.add_text('*', roof_center)
            #model.entities.add_text('*', @bw_end_pt)
#--------------------------------------------------------------------------------------------------------------------------------------------------------------
    # Component 2: Nose and Hood
    # 10 variables: Genotype 17 ~ 27
            Sketchup.set_status_text('Running Matchbox: Generating seed# ' + i.to_s + '_Component2')
            c2 = aCar.entities.add_group
            profile2 = Hash.new
            
            # Parameters
            @box_w = 240 #car width = wheel.y
            @nose_mid_pt = Geom::Point3d.new(-250, 0, 0)
            
            # Variables
            @hood_start_pt = Geom::Point3d.new(@nose_mid_pt.x  + 50*g.x[17] ,0,120 + 40*g.x[18])
            temp = (@hood_start_pt - @hood_end_pt).normalize.z * (0.6 + 0.2 * g.x[19])
            @hood_vec = Geom::Vector3d.new(-Math.sqrt(1.0-temp*temp), 0.0, temp)
            @hood_n = (@hood_start_pt.x - @hood_end_pt.x)*0.8/ @hood_vec.x +  (@hood_start_pt.x - @hood_end_pt.x) * 0.2 /  @hood_vec.x * g.x[20]
            
            
            temp = Wireframe.link_tan(@hood_end_pt, @hood_start_pt, @hood_vec, @hood_n, @numseg)
            profile2['hood'] = temp['all_pt']
            profile2['hood_ctrl_pt'] = temp['mid_pt']
            
            temp = Wireframe.link_cur(@hood_end_pt, profile2['hood_ctrl_pt'], @hood_start_pt, @nose_mid_pt, 1, @numseg)
            profile2['nose'] = temp['all_pt']
            profile2['nose_ctrl_pt'] = temp['mid_pt']
            
            @nose_u_pt = Geom::Point3d.new(@hood_start_pt.x + 5 + 50*g.x[21], @hood_u_pt.y - 10 - 60*g.x[22], @hood_start_pt.z)
            
            temp = (@nose_u_pt - @hood_u_pt).normalize.z * (0.6 + 0.2 * g.x[23])
            hood_v_vec = Geom::Vector3d.new((@nose_u_pt - @hood_u_pt).normalize.x, (@nose_u_pt - @hood_u_pt).normalize.y, temp)
            hood_v_vec = hood_v_vec.normalize
            @hood_v_n = (@nose_u_pt.x - @hood_u_pt.x)*0.8/ hood_v_vec.x +  (@nose_u_pt.x - @hood_u_pt.x)*0.2/ hood_v_vec.x*g.x[24]
            
            hood_v_hash = Wireframe.link_tan(@hood_u_pt, @nose_u_pt, hood_v_vec, @hood_v_n, @numseg)
            
            temp = hood_u_hash['mid_pt'].y/((hood_u_hash['mid_pt'] - @nose_mid_pt).length)
            hood_svec_x = -temp+temp*g.x[25]
            @hood_svec = Geom::Vector3d.new(hood_svec_x, Math.sqrt(1-hood_svec_x*hood_svec_x))
            hood_center = Geom.intersect_line_plane([profile2['hood_ctrl_pt'], Geom::Vector3d.new(0,1,0)], [hood_u_hash['mid_pt'], @hood_svec])
            mid_pt1 = Geom.intersect_line_plane([@hood_start_pt, Geom::Vector3d.new(0,1,0)], [hood_u_hash['mid_pt'], @hood_svec])
            mid_pt2 = Geom.intersect_line_plane([@nose_mid_pt, Geom::Vector3d.new(0,1,0)], [hood_u_hash['mid_pt'], @hood_svec])
            
            nose_u_hash = Hash.new
            nose_u_hash['mid_pt'] = mid_pt1
            
            @head_end_pt = Geom::Point3d.new(mid_pt2.x + 10 + 20*g.x[26], @nose_u_pt.y - (@nose_u_pt.y - mid_pt2.y)/2*g.x[27])
            head_u_hash = Hash.new
            head_u_hash['mid_pt'] = mid_pt2
            
            nose_v_hash = Wireframe.link_cur(@hood_u_pt, hood_v_hash['mid_pt'], @nose_u_pt, @head_end_pt, 1, @numseg)
            
            pq = Mid_point.curvpqxz(hood_u_hash['mid_pt'], hood_center, nose_u_hash['mid_pt'], head_u_hash['mid_pt'])
            q = pq[1]
            a = nose_u_hash['mid_pt'] - hood_center
            nose_center = Geom::Point3d.new
            nose_center.x = nose_u_hash['mid_pt'].x + a.x*Math.sqrt(q.abs)
            nose_center.y = nose_u_hash['mid_pt'].y + a.y*Math.sqrt(q.abs)
            nose_center.z = nose_u_hash['mid_pt'].z + a.z*Math.sqrt(q.abs)
            
            data['ctrlPts'] = [@hood_start_pt, nose_u_hash['mid_pt'], @nose_u_pt, profile2['nose_ctrl_pt'], nose_center, nose_v_hash['mid_pt'], @nose_mid_pt, head_u_hash['mid_pt'], @head_end_pt]
            nose_surf = Bezier_surf.new(data)
            nose_surf.create_patch(c2.entities)
            
            data['ctrlPts'] = [@hood_end_pt, hood_u_hash['mid_pt'], @hood_u_pt, profile2['hood_ctrl_pt'], hood_center, hood_v_hash['mid_pt'], @hood_start_pt, nose_u_hash['mid_pt'], @nose_u_pt]
            hood_surf = Bezier_surf.new(data)
            hood_surf.create_patch(c2.entities)
            
#--------------------------------------------------------------------------------------------------------------------------------------------------------------
    # Component 3: Wheel well
    # 9 variables: Genotype 28 ~ 36
            Sketchup.set_status_text('Running Matchbox: Generating seed# ' + i.to_s + '_Component3')
            c3 = aCar.entities.add_group
            
            # Variables
            @head_v_n = 80.0 # Parameter?
            @belt_cur_n = 20*g.x[28]
            
            # head_u1_pt
            @head_u1_pt_x = @hood_u_pt.x - 2.0*@r_wheel*@well_scale
            #@head_u1_pt_x = 100
            @head_u1_pt_y = @box_w - 10.0*@well_scale
            ux = @nose_mid_pt.y - head_u_hash['mid_pt'].y
            uz = - @nose_mid_pt.x + head_u_hash['mid_pt'].x
            vx = @head_end_pt.y - head_u_hash['mid_pt'].y
            vz = - @head_end_pt.x + head_u_hash['mid_pt'].x
            d = vx*uz-vz*ux
            xb = @head_u1_pt_y - @head_end_pt.y
            #xbb = (@head_u1_pt_y - @head_end_pt.y)*0.9
            xbb = [(-@head_u1_pt_x + @head_end_pt.x)*vx/vz/1.1*0.9, (xb - ux*eta*eta)*0.9, xb*0.9].min
            zb = 0.0
            zbb = [(xbb/vx*vz)*5.0, -@head_u1_pt_x + @head_end_pt.x].max
#UI.messagebox(((xbb/vx*vz)*5.0).to_s + ' ' + (-@head_u1_pt_x + @head_end_pt.x).to_s)
            
            if ux<0 #case 2
                if vz<0
                    eta = [-zbb*ux/d, xb/vx, zbb/vz].min*0.5
                    m = [xbb/vx, zb/vz, eta].max
                    n = [zbb/vz, (xb-ux*eta*eta)/vx].min
                else
                    UI.messagebox('Error generating shape_Error#_c3_10: Shape not acceptable.')
                end
                if m > n
                    UI.messagebox('Error generating shape_Error#_c3_20: Boundary condition not acceptable')
UI.messagebox(xb.to_s + ' ' + xbb.to_s + ' ' + ((xbb/vx*vz)*1.1).to_s + ' ' + (-@head_u1_pt_x + @head_end_pt.x).to_s + ' ' + (xbb/vx).to_s + ' ' + (zb/vz).to_s + ' ' + (eta).to_s + ' ' + (zbb/vz).to_s + ' ' + ((xb-ux*eta*eta)/vx).to_s)
                else
                    psi = m + (n - m)*g.x[29]
                    mm = [(xb-psi*vx)/ux, 0.0].max
                    nn = [(xbb-psi*vx)/ux, vx/ux*(eta-psi), eta*eta].min
                    if mm > nn
                        UI.messagebox('Error generating shape_Error#_c3_01: Wrong range for phi')
                    end
                end
                flag = 2
            else
                UI.messagebox('Error generating shape_Error#_c3_11: Shape not acceptable.')
            end
            phi = mm + (nn - mm)*g.x[30]
            @head_u1_pt = Geom::Point3d.new(@head_end_pt.x - psi*vz, @head_end_pt.y + phi*ux + psi*vx, 0)
            head_u1_hash = Wireframe.link_cur(@nose_mid_pt, head_u_hash['mid_pt'], @head_end_pt, @head_u1_pt, 2, @numseg)
            
            # Center line
            @head_u2_vec = (@nose_u_pt - nose_u_hash['mid_pt']).normalize
            
            @well_vec = Geom::Vector3d.new(0.0, 1.0, -1.0*g.x[31]).normalize
            temp_t = Geom::Transformation.new(0.5)
            head_center_vec = @head_u2_vec.transform!(temp_t) + (@head_end_pt - head_u_hash['mid_pt']).normalize.transform!(temp_t)
            
            temp1 = (@hood_u_pt.y - head_u1_hash['mid_pt'].y)/Math.sqrt((@hood_u_pt.y - head_u1_hash['mid_pt'].y)*(@hood_u_pt.y - head_u1_hash['mid_pt'].y)+(@hood_u_pt.x - head_u1_hash['mid_pt'].x)*(@hood_u_pt.x - head_u1_hash['mid_pt'].x)) # lower limit for well center plane
            temp = (@hood_u_pt.y + @box_w)*0.5
            temp2 = (temp - head_u1_hash['mid_pt'].y)/Math.sqrt((temp - head_u1_hash['mid_pt'].y)*(temp - head_u1_hash['mid_pt'].y)+(@hood_u_pt.x - head_u1_hash['mid_pt'].x)*(@hood_u_pt.x - head_u1_hash['mid_pt'].x)) # upper limit for well center plane
            
            temp = [temp1, temp2].min + 1.0*([temp1, temp2].max-[temp1, temp2].min)*g.x[32]
            well_v_vec = Geom::Vector3d.new(temp, -Math.sqrt(1-temp*temp), ((@hood_u_pt - @nose_u_pt)*(@nose_u_pt - @head_end_pt)).normalize.z*0.1)
            mid_pt1 = Geom.intersect_line_plane([@nose_u_pt, @head_u2_vec], [head_u1_hash['mid_pt'], well_v_vec]) #mid_pt of head_u2_hash
            mid_pt2 = Geom.intersect_line_plane([@hood_u_pt, @well_vec], [head_u1_hash['mid_pt'], well_v_vec]) #mid_pt of well_u_hash
            head_center = Geom.intersect_line_plane([nose_v_hash['mid_pt'], head_center_vec], [head_u1_hash['mid_pt'], well_v_vec]) #mid_pt of well_u_hash
            # Center line
            
            # Parameters
            @fwheel_x = @head_u1_pt.x + @well_scale*@r_wheel #wheel coordinates
            @fwheel_z = @nose_mid_pt.z
            
            pq = Mid_point.curvpqxy(@nose_mid_pt, head_u_hash['mid_pt'], @head_end_pt, @head_u1_pt)
            p = pq[0]
            q = pq[1]
            
            @head_u2_pt = Geom::Point3d.new(@fwheel_x - @r_wheel*@well_scale/2.0, @head_u1_pt.y, @r_wheel*@well_scale/2*Math.sqrt(3) + @fwheel_z) #30deg
            head_v_hash = Wireframe.link_tan(@head_u2_pt, @head_u1_pt, Geom::Vector3d.new(-Math.sqrt(3.0)/2.0, 0, -1.0/2.0), @head_v_n, @numseg)
            
            head_u2_hash = Hash.new
            head_u2_hash['mid_pt'] = mid_pt1
            
            # @well_pt
            ux = @head_u1_pt.x - head_v_hash['mid_pt'].x
            uz = @head_u1_pt.z - head_v_hash['mid_pt'].z
            vx = @head_u2_pt.x - head_v_hash['mid_pt'].x
            vz = @head_u2_pt.z - head_v_hash['mid_pt'].z
            d = vx*uz-vz*ux
            xb = (mid_pt2.x - @head_u2_pt.x)*1.2
            xbb = mid_pt2.x - @head_u2_pt.x
            zb = (mid_pt2.z - @head_u2_pt.z) # Constrained by well_mid_pt
            zbb = [xb/vx*vz, zb].min*0.5
            
            if ux>0 && uz<0 #case 1
                if vz < 0
                    UI.messagebox('Error generating shape_Error#_c3_30: Shape not acceptable.')
                else
                    eta = xb/vx*0.5
                    m = [(xbb*uz-zbb*ux)/d, zbb/vz, (xbb-eta*eta*ux)/vx, (vx*uz*eta-zbb*ux)/d].max #lower bound for psi
                    n = [(xb*uz-zb*ux)/d, xb/vx, (zb-eta*eta*uz)/vz].min
                    #UI.messagebox(d.to_s + ' ' + ((xbb*uz-zbb*ux)/d).to_s + ' ' + (zbb/vz).to_s + ' ' + ((xbb-eta*eta*ux)/vx).to_s + ' ' + ((vx*uz*eta-zbb*ux)/d).to_s + ' ' + ((xb*uz-zb*ux)/d).to_s + ' ' + (xb/vx).to_s + ' ' + ((zb-eta*eta*uz)/vz).to_s)
                    if m > n
                        UI.messagebox('Error generating shape_Error#_c3_40: Boundary condition not acceptable')
                    else
                        psi = m + (n - m)*g.x[33]
                        mm = [(zb-psi*vz)/uz, (xbb-psi*vx)/ux, 0.0, vx/ux*(eta-psi)].max
                        nn = [(zbb-psi*vz)/uz, (xb-psi*vx)/ux, eta*eta].min
                        if mm > nn
                            UI.messagebox('Error generating shape_Error#_c3_21: Wrong range for phi')
                        end
                    end
                end
                flag = 1
            elsif ux<0 && uz<0 #case 2
                
                if vz<0
                    eta = [(xb*uz-zbb*ux)/d, xb/vx, zbb/vz].min*0.5
                    m = [(xbb*uz-zb*ux)/d, xbb/vx, (vx*uz*eta-zb*ux)/d, (zb-uz*eta*eta)/vz, eta].max
                    n = [(xb*uz-zbb*ux)/d, zbb/vz, (xb-ux*eta*eta)/vx].min
                elsif vz>0 && d<0
                    eta = [(xb*uz-zbb*ux)/d, xb/vx].min*0.5
                    m = [(xbb*uz-zb*ux)/d, xbb/vx, eta, (vx*uz*eta-zb*ux)/d].max
                    n = [(xb*uz-zbb*ux)/d, (xb-ux*eta*eta)/vx, (zb-uz*eta*eta)/vz].min
                else
                    eta = [(xbb*uz-zb*ux)/d, xb/vx].min*0.5
                    m = [(xb*uz-zbb*ux)/d, xbb/vx, eta].max
                    n = [(xbb*uz-zb*ux)/d, (xb-ux*eta*eta)/vx, (zb-uz*eta*eta)/vz, (vx*uz*eta-zb*ux)/d].min
                end
                
                if m > n
                    UI.messagebox('Error generating shape_Error#_c3_41: Boundary condition not acceptable')
                else
                    psi = m + (n - m)*g.x[33]
                    mm = [(zb-psi*vz)/uz, (xb-psi*vx)/ux, 0.0].max
                    nn = [(zbb-psi*vz)/uz, (xbb-psi*vx)/ux, vx/ux*(eta-psi), eta*eta].min
                    if mm > nn
                        UI.messagebox('Error generating shape_Error#_c3_22: Wrong range for phi')
                    end
                end
                flag = 2
            elsif ux<0 && uz>0 #case 3
                
                if vz >0
                    eta = [xb/vx, (xb*uz-zb*ux)/d, zb/vz].min*0.5
                    m = [(xbb*uz-zbb*ux)/d, xbb/vx, eta, (vx*uz*eta-zbb*ux)/d, (zbb-uz*eta*eta)/vz].max
                    n = [(xb*uz-zb*ux)/d, zb/vz, (xb-ux*eta*eta)/vx].min
                else
                    eta = [xb/vx, zbb/vz, (xbb*uz-zbb*ux)/d].min*0.5
                    m = [(xb*uz-zb*ux)/d, xbb/vx, eta].max
                    n = [(xbb*uz-zbb*ux)/d, (vx*uz*eta-zbb*ux)/d, (xb-ux*eta*eta)/vx, (zbb-uz*eta*eta)/vz].min
                end
                if m > n
                    UI.messagebox('Error generating shape_Error#_c3_42: Boundary condition not acceptable')
                else
                    psi = m +(n - m)*g.x[33]
                    mm = [(zbb-psi*vz)/uz, (xb-psi*vx)/ux, 0.0].max
                    nn = [(zb-psi*vz)/uz, (xbb-psi*vx)/ux, vx/ux*(eta-psi), eta*eta].min
                    if mm > nn
                        UI.messagebox('Error generating shape_Error#_c3_23: Wrong range for phi')
                    end
                end
                
                flag = 3
            else
                UI.messagebox('Error generating shape_Error#_c3_32: Shape not acceptable.')
            end
            phi = mm + (nn - mm)*g.x[34]
            @well_pt = Geom::Point3d.new(@head_u2_pt.x + phi*ux + psi*vx, mid_pt2.y + 10, @head_u2_pt.z + phi*uz + psi*vz)
            well_v_hash = Wireframe.link_cur(@head_u1_pt, head_v_hash['mid_pt'], @head_u2_pt, @well_pt, 1, @numseg) #temporary
            
            well_u_hash = Hash.new
            well_u_hash['mid_pt'] = mid_pt2
            
            pq = Mid_point.curvpqxz(head_u1_hash['mid_pt'], head_center, head_u2_hash['mid_pt'], well_u_hash['mid_pt'])
            q = pq[1]
            a = head_u2_hash['mid_pt'] - head_center
            
            well_center = Geom::Point3d.new
            well_center.x = head_u2_hash['mid_pt'].x + a.x*Math.sqrt(q.abs)
            well_center.y = head_u2_hash['mid_pt'].y + a.y*Math.sqrt(q.abs)
            well_center.z = head_u2_hash['mid_pt'].z + a.z*Math.sqrt(q.abs)
            
            @front_well_pt1 = Geom::Point3d.new(@fwheel_x + @r_wheel*@well_scale, @head_u1_pt.y, 0.0)
            
            front_well_u1_hash = Wireframe.link_cur(@head_u1_pt, head_v_hash['mid_pt'], @head_u2_pt, @front_well_pt1, 1, @numseg)
            @fwell_vec = (@well_pt - well_u_hash['mid_pt']).normalize
            @fwell_vec = Geom::Vector3d.new(@fwell_vec.x, @fwell_vec.y-0.0*g.x[35], @fwell_vec.z)
            @fwell_vec = @fwell_vec.normalize
            
            @front_well_pt2 = Geom::Point3d.new(@well_pt.x - well_v_hash['mid_pt'].x + @front_well_pt1.x, @front_well_pt1.y - 10*g.x[36], @front_well_pt1.z)
            front_well_u2_hash = Wireframe.link_tan(@well_pt, @front_well_pt2, @fwell_vec, @belt_cur_n, @numseg)
            #front_well_center = Geom.intersect_line_plane([well_v_hash['mid_pt'], well_v_hash['mid_pt']-well_center], [@well_pt, Geom::Vector3d.new(0.0, 1.0, 0.0)])
            front_well_center = front_well_u2_hash['mid_pt'] + (front_well_u1_hash['mid_pt'] - front_well_u2_hash['mid_pt']).transform!(Geom::Transformation.new(0.9))
            front_well_v_hash = Wireframe.link_tan(@front_well_pt2, @front_well_pt1, Geom::Vector3d.new(-1.0, 0.0, 0.0), 0.9*(@front_well_pt2.x - @front_well_pt1.x), @numseg)
            
            # Front wheel extension
            fw1 = Geom::Point3d.new(@fwheel_x - @r_wheel*1.2, @box_w, 0.0)
            #fw2 = Geom::Point3d.new(@fwheel_x, @box_w, @r_wheel*1.2)
            fw3 = Geom::Point3d.new(@fwheel_x + @r_wheel*1.2, @box_w, 0.0)
            k = (fw1.x - fw3.x)/(@head_u1_pt.x - @front_well_pt1.x)
            fw2 = Geom::Point3d.new(fw1.x + (@head_u2_pt.x - @head_u1_pt.x)*k, fw1.y, fw1.z + (@head_u2_pt.z - @head_u1_pt.z)*k)
            mid_pt1 = Geom::Point3d.new(fw1.x + (head_v_hash['mid_pt'].x - @head_u1_pt.x)*k, fw1.y, fw1.z + (head_v_hash['mid_pt'].z - @head_u1_pt.z)*k)
            mid_pt2 = Geom::Point3d.new(fw1.x + (front_well_u1_hash['mid_pt'].x - @head_u1_pt.x)*k, fw1.y, fw1.z + (front_well_u1_hash['mid_pt'].z - @head_u1_pt.z)*k)
            #mid_pt2 = Mid_point.curvxz(fw1, mid_pt1, fw2, fw3)
            #fw12 = Wireframe.link(fw1, mid_pt1, fw2, @numseg)
            #fw23 = Wireframe.link(fw2, mid_pt2, fw3, @numseg)

            fw_mid2 = Geom.intersect_line_plane([@head_u2_pt, fw2 - @head_u2_pt], [Geom::Point3d.new(0.0, (@box_w*0.2+@head_u1_pt.y*0.8), 0.0), Geom::Vector3d.new(0.0, -1.0, 0.0)])
            fw_mid1 = Geom.intersect_line_plane([@head_u1_pt, @head_u1_pt - head_u1_hash['mid_pt']], [Geom::Point3d.new(0.0, (@box_w*0.2+@head_u1_pt.y*0.8), 0.0), Geom::Vector3d.new(0.0, -1.0, 0.0)])
            fw_mid3 = @front_well_pt1 + (fw_mid1-@head_u1_pt).transform!(Geom::Transformation.scaling(-1, 1, 1))
            k = (fw_mid1.x - fw_mid3.x)/(@head_u1_pt.x - @front_well_pt1.x)
            mid_pt3 = Geom::Point3d.new(fw_mid1.x + (head_v_hash['mid_pt'].x - @head_u1_pt.x)*k, fw_mid1.y, fw_mid1.z + (head_v_hash['mid_pt'].z - @head_u1_pt.z)*k)
            mid_pt4 = Geom::Point3d.new(fw_mid1.x + (front_well_u1_hash['mid_pt'].x - @head_u1_pt.x)*k, fw_mid1.y, fw_mid1.z + (front_well_u1_hash['mid_pt'].z - @head_u1_pt.z)*k)
            #mid_pt4 = Mid_point.curvxz(fw_mid1, mid_pt3, fw_mid2, fw_mid3)
            #fw_center1 = Wireframe.link(fw_mid1, mid_pt3, fw_mid2, @numseg)
            #fw_center2 = Wireframe.link(fw_mid2, mid_pt4, fw_mid3, @numseg)

            data['ctrlPts'] = [@nose_u_pt, head_u2_hash['mid_pt'], @head_u2_pt, nose_v_hash['mid_pt'], head_center, head_v_hash['mid_pt'], @head_end_pt, head_u1_hash['mid_pt'], @head_u1_pt]
            head_surf = Bezier_surf.new(data)
            head_surf.create_patch(c3.entities)
            
            data['ctrlPts'] = [@hood_u_pt, well_u_hash['mid_pt'], @well_pt, hood_v_hash['mid_pt'], well_center, well_v_hash['mid_pt'], @nose_u_pt, head_u2_hash['mid_pt'], @head_u2_pt]
            well_surf = Bezier_surf.new(data)
            well_surf.create_patch(c3.entities)

            data['ctrlPts'] = [@well_pt, front_well_u2_hash['mid_pt'], @front_well_pt2, well_v_hash['mid_pt'], front_well_center, front_well_v_hash['mid_pt'], @head_u2_pt, front_well_u1_hash['mid_pt'], @front_well_pt1]
            front_well_surf = Bezier_surf.new(data)
            front_well_surf.create_patch(c3.entities)
            
            c3_wheel = aCar.entities.add_group
            data['ctrlPts'] = [@head_u2_pt, fw_mid2, fw2, head_v_hash['mid_pt'], mid_pt3, mid_pt1, @head_u1_pt, fw_mid1, fw1]
            front_well_ext1_surf = Bezier_surf.new(data)
            front_well_ext1_surf.create_patch(c3_wheel.entities)
            
            data['ctrlPts'] = [@front_well_pt1, fw_mid3, fw3, front_well_u1_hash['mid_pt'], mid_pt4, mid_pt2, @head_u2_pt, fw_mid2, fw2]
            front_well_ext2_surf = Bezier_surf.new(data)
            front_well_ext2_surf.create_patch(c3_wheel.entities)

#--------------------------------------------------------------------------------------------------------------------------------------------------------------
    # Component 4: Beltline
    # 2 variables: Genotype 37 ~ 38
            Sketchup.set_status_text('Running Matchbox: Generating seed# ' + i.to_s + '_Component4')
            c4 = aCar.entities.add_group
            
            #@box_r = @bw_end_pt.x + 100
            @box_r = 1000.0
            temp_vec = (@bw_end_pt - profile1['bw_ctrl_pt']).normalize
            if temp_vec.z<0
                @wheelbase = [10.0*@r_wheel, (-@bw_end_pt.z + @head_u2_pt.z)/temp_vec.z*temp_vec.x+@bw_end_pt.x-@fwheel_x].min
            else
                @wheelbase = 10.0*@r_wheel
            end
            @clearance = 0.7*@r_wheel
            @wheel_scale = 1
            @box_l = @origin.x-2*@r_wheel
            @box_u = 4.5*@r_wheel
            @rear_well_pt = Geom::Point3d.new(@head_u2_pt.x+@r_wheel*(0.5+0.0*@wheel_scale)*@well_scale+@wheelbase, @front_well_pt1.y, @r_wheel*@well_scale*@wheel_scale + @fwheel_z)
            @rear_well_pt2 = Geom::Point3d.new(@head_u2_pt.x+@r_wheel*(0.5-1.0*@wheel_scale)*@well_scale+@wheelbase, @front_well_pt1.y, 0)
            @rear_pt = Geom::Point3d.new(@rear_well_pt2.x + @r_wheel*@well_scale*@wheel_scale*2, @head_u1_pt.y, 0)
            @rear_well_u2_n = 100
            rear_well_u2_hash = Wireframe.link_tan(@rear_well_pt, @rear_well_pt2, Geom::Vector3d.new(-1.0, 0.0, 0.0), @rear_well_u2_n, @numseg)
            rear_v_hash = Wireframe.link_cur(@rear_well_pt2, rear_well_u2_hash['mid_pt'], @rear_well_pt, @rear_pt, 1, @numseg)
            temp_vec = (@well_pt - well_v_hash['mid_pt']).normalize

            if temp_vec.z > 0
                #temp_pt = Geom.intersect_line_line([Geom::Point3d.new(@well_pt.x, 0, @well_pt.z), Geom::Vector3d.new(temp_vec.x, 0, temp_vec.z)], [Geom::Point3d.new(@rear_well_pt.x, 0, @rear_well_pt.z), Geom::Vector3d.new(-1.0, 0.0, 0.0)])
                #temp2 = (@fw_u_pt.x - @well_pt.x)/temp_vec.x # constraint on @rear_well_pt tangent
                temp1 = [(@rear_well_pt2.x - @well_pt.x)/temp_vec.x, (@fw_u_pt.z - @well_pt.z)/temp_vec.z].min
                #if temp1 > temp2
                    @belt_n = temp2 + (temp1 - temp2)*g.x[38]
#UI.messagebox(temp1.to_s + ' ' + temp2.to_s)
                #else
                #    UI.messagebox('Error generating shape_Error#_c4_10: Wrong range for belt line')
#UI.messagebox(temp1.to_s + ' ' + temp2.to_s)
                #end
            else
                #temp_pt = Geom.intersect_line_line([Geom::Point3d.new(@well_pt.x, 0, @well_pt.z), Geom::Vector3d.new(temp_vec.x, 0, temp_vec.z)], [Geom::Point3d.new(@rear_well_pt.x, 0, @rear_well_pt.z), Geom::Vector3d.new(1.0, 0, 0)])
                temp2 = (@fw_u_pt.x - @well_pt.x)/temp_vec.x # constraint on @rear_well_pt tangent
                temp1 = [(@rear_well_pt2.x - @well_pt.x)/temp_vec.x, (@rear_well_pt2.z - @well_pt.z)/temp_vec.z].min
                @belt_n = [temp1, temp2].min*g.x[38]
#UI.messagebox(temp1.to_s + ' ' + temp2.to_s)
#model.entities.add_curve([temp_pt, @well_pt])
            end
            
            belt_line_vec = Geom::Vector3d.new(temp_vec.x, (@box_w-@well_pt.y)/@belt_n*g.x[37], temp_vec.z)
            
            side_temp = Wireframe.link_tan(@well_pt, @rear_well_pt, belt_line_vec, @belt_n, @numseg*3)
            @side_low_pt = side_temp['all_pt'][@numseg]
            @side_high_pt = side_temp['all_pt'][@numseg*2]

            temp_vec1 = Geom::Vector3d.new()
            temp_vec1.x = @rear_well_pt.x*(2.0/3.0) - @well_pt.x*(4.0/3.0) + side_temp['mid_pt'].x*(2.0/3.0) # Tangent at center of side_temp, see notes
            temp_vec1.y = @rear_well_pt.y*(2.0/3.0) - @well_pt.y*(4.0/3.0) + side_temp['mid_pt'].y*(2.0/3.0)
            temp_vec1.z = @rear_well_pt.z*(2.0/3.0) - @well_pt.z*(4.0/3.0) + side_temp['mid_pt'].z*(2.0/3.0)
            temp_vec2 = Geom::Vector3d.new()
            temp_vec2.x = @rear_well_pt.x*(4.0/3.0) - @well_pt.x*(2.0/3.0) - side_temp['mid_pt'].x*(2.0/3.0)
            temp_vec2.y = @rear_well_pt.y*(4.0/3.0) - @well_pt.y*(2.0/3.0) - side_temp['mid_pt'].y*(2.0/3.0)
            temp_vec2.z = @rear_well_pt.z*(4.0/3.0) - @well_pt.z*(2.0/3.0) - side_temp['mid_pt'].z*(2.0/3.0)
            
            mid_pt1 = Geom.intersect_line_line([@well_pt, belt_line_vec], [@side_low_pt, temp_vec1])
            if mid_pt1.nil?
                mid_pt1 = @well_pt + (@side_low_pt - @well_pt).transform!(Geom::Transformation.new(0.5))
            end
            
            mid_pt2 = Geom.intersect_line_line([@side_high_pt, temp_vec2], [@side_low_pt, temp_vec1])
            if mid_pt2.nil?
                mid_pt2 = @side_high_pt + (@side_low_pt - @side_high_pt).transform!(Geom::Transformation.new(0.5))
            end
            
            mid_pt3 = Geom.intersect_line_line([@rear_well_pt, @rear_well_pt - side_temp['mid_pt']], [@side_high_pt, temp_vec2])
            if mid_pt3.nil?
                mid_pt3 = @rear_well_pt + (@side_high_pt - @rear_well_pt).transform!(Geom::Transformation.new(0.5))
            end
            
            side_low_v_hash = Hash.new
            side_low_v_hash['mid_pt'] = mid_pt1
            temp1 = (@fw_u_pt.y - well_u_hash['mid_pt'].y)/Math.sqrt((@fw_u_pt.y - well_u_hash['mid_pt'].y)*(@fw_u_pt.y - well_u_hash['mid_pt'].y)+(@fw_u_pt.x - well_u_hash['mid_pt'].x)*(@fw_u_pt.x - well_u_hash['mid_pt'].x)) # lower limit for well center plane
            temp = @box_w*0.2 + @fw_u_pt.y*0.8
            temp2 = (temp - well_u_hash['mid_pt'].y)/Math.sqrt((temp - well_u_hash['mid_pt'].y)*(temp - well_u_hash['mid_pt'].y)+(@side_low_pt.x - well_u_hash['mid_pt'].x)*(@side_low_pt.x - well_u_hash['mid_pt'].x)) # upper limit for well center plane
            temp = [temp1, temp2].max

            belt_v_vec = Geom::Vector3d.new(temp, -Math.sqrt(1-temp*temp), 0.0) # belt_v_vec_temp
            mid_pt = Geom.intersect_line_plane([@fw_u_pt, (@fw_u_pt - fw_u_hash['mid_pt'])],[well_u_hash['mid_pt'], belt_v_vec]) # side_low_u mid_pt
            side_low_u_hash = Hash.new
            side_low_u_hash['mid_pt'] = mid_pt

            side_high_v_hash = Hash.new
            side_high_v_hash['mid_pt'] = mid_pt2
            side_high_center = Geom.intersect_line_plane([roof_v_hash['mid_pt'], roof_v_hash['mid_pt']-roof_center],[side_high_v_hash['mid_pt'], (side_high_v_hash['mid_pt']-@side_low_pt)*(@side_low_pt-side_low_u_hash['mid_pt'])])

            belt_v_vec = (side_high_center - side_low_u_hash['mid_pt'])*(side_low_u_hash['mid_pt'] - well_u_hash['mid_pt'])

            side_low_center = Geom.intersect_line_plane([fw_v_hash['mid_pt'], fw_v_hash['mid_pt']-fw_center],[well_u_hash['mid_pt'], belt_v_vec])

            temp_vec = ((side_low_v_hash['mid_pt'] - side_low_center)).normalize
            temp_vec_n = (side_low_v_hash['mid_pt'].z - front_well_u2_hash['mid_pt'].z)/temp_vec.z
            rocker_center = side_low_v_hash['mid_pt'] + temp_vec.transform!(Geom::Transformation.new(-temp_vec_n))

            temp_vec = ((@side_low_pt - side_low_u_hash['mid_pt'])).normalize
            temp_pt = Geom.intersect_line_line([@side_low_pt, (@side_low_pt-side_low_u_hash['mid_pt'])], [side_high_v_hash['mid_pt'], (side_high_v_hash['mid_pt']-side_high_center)])

            temp_vec1 = (side_high_v_hash['mid_pt'] - rocker_center).normalize
            temp_vec2 = (@side_low_pt - side_low_u_hash['mid_pt']).normalize
            ux = temp_vec1.x
            uz = temp_vec1.z
            vx = temp_vec2.x
            vz = temp_vec2.z
            ax = @side_low_pt.x + temp_vec2.x - (rocker_center.x + temp_vec1.x)
            az = @side_low_pt.z + temp_vec2.z - (rocker_center.z + temp_vec1.z)
            phi = (ax*vz-az*vx)/(ux*vz-uz*vx)
            temp_pt2 = rocker_center + temp_vec1.transform!(Geom::Transformation.new(phi))
            temp = (temp_pt2.z - @side_low_pt.z)/temp_vec.z*1.1
            
            if (temp_pt.z - @side_low_pt.z)/temp_vec.z > 0
                if (temp_pt.z - @side_low_pt.z)/temp_vec.z*0.5 > temp
                    temp_vec_n = [temp, @belt_cur_n].max
                else
                    UI.messagebox('Error generating shape_Error#_c4_80: Side Error')
                end
            else
                temp_vec_n = [temp, @belt_cur_n].max
            end
            mid_pt = @side_low_pt + temp_vec.transform!(Geom::Transformation.new(temp_vec_n)) # rocker_u mid_pt
            
            rocker_u_hash = Hash.new
            rocker_u_hash['mid_pt'] = mid_pt
            
            @rocker_center_pt = Geom::Point3d.new(@front_well_pt2.x + (mid_pt.x - front_well_u2_hash['mid_pt'].x), @front_well_pt2.y, 0)
            mid_pt = Geom::Point3d.new(@front_well_pt2.x+(@rocker_center_pt.x-@front_well_pt2.x)*(side_low_v_hash['mid_pt'].x-@well_pt.x)/(@side_low_pt.x-@well_pt.x), @front_well_pt2.y, 0)
            
            rocker_v_hash = Hash.new
            rocker_v_hash['mid_pt'] = mid_pt
            
            ux = rocker_u_hash['mid_pt'].x - rocker_center.x
            uz = rocker_u_hash['mid_pt'].z - rocker_center.z
            vx = side_high_center.x - side_high_v_hash['mid_pt'].x
            vz = side_high_center.z - side_high_v_hash['mid_pt'].z
            ax = side_high_v_hash['mid_pt'].x - rocker_u_hash['mid_pt'].x
            az = side_high_v_hash['mid_pt'].z - rocker_u_hash['mid_pt'].z
            phi = (ax*vz-az*vx)/(ux*vz-uz*vx)
            rocker_end_center = rocker_u_hash['mid_pt'] + (rocker_u_hash['mid_pt'] - rocker_center).transform!(Geom::Transformation.new(phi))
            
            @rocker_end_pt = Geom::Point3d.new((@rear_well_pt2.x+@rocker_center_pt.x)*0.5, @rocker_center_pt.y, 0)
            mid_pt = Geom::Point3d.new(@rocker_center_pt.x+(@rocker_end_pt.x-@rocker_center_pt.x)*(side_high_v_hash['mid_pt'].x-@side_low_pt.x)/(@side_high_pt.x-@side_low_pt.x), @rocker_center_pt.y, 0)
            rocker_end_v_hash = Hash.new
            rocker_end_v_hash['mid_pt'] = mid_pt
            
            temp1 = (bw_v_hash['mid_pt'] - side_high_center).normalize
            temp2 = (bw_v_hash['mid_pt'] - bw_center).normalize
            temp3 = (@roof_pt - roof_u_hash['mid_pt']).normalize
            if temp2.x.abs > 1e-3
                temp = Geom::Vector3d.new(temp2.x, temp2.y, temp2.x*temp1.z/temp1.x*1.1)
            else
                temp = Geom::Vector3d.new(temp2.x, temp2.y, (-temp3.z*(-temp1.y*temp2.x+temp1.x*temp2.y)+temp3.x*temp1.z*temp2.y-temp3.y*temp1.z*temp2.x + 1e-3)/(temp3.x*temp1.y-temp3.y*temp1.x))
            end
            temp_vec = temp1*temp
            mid_pt = Geom.intersect_line_plane([@roof_pt, temp3],[side_high_center, temp_vec])
            side_high_u_hash = Hash.new
            side_high_u_hash['mid_pt'] = mid_pt
#model.entities.add_curve([roof_u_hash['mid_pt'], @roof_pt])
#model.entities.add_curve([side_high_center, side_high_center + temp_vec])

            ux = side_high_u_hash['mid_pt'].x - side_high_center.x
            uz = side_high_u_hash['mid_pt'].z - side_high_center.z

            #vx = temp2.x
            #vz = temp2.z
vx = temp.x
vz = temp.z
            #ax = bw_v_hash['mid_pt'].x + temp2.x - side_high_u_hash['mid_pt'].x
            #az = bw_v_hash['mid_pt'].z + temp2.z - side_high_u_hash['mid_pt'].z
ax = bw_v_hash['mid_pt'].x + temp.x - side_high_u_hash['mid_pt'].x
az = bw_v_hash['mid_pt'].z + temp.z - side_high_u_hash['mid_pt'].z
            phi = (ax*vz-az*vx)/(ux*vz-uz*vx)

            rear_well_center = side_high_u_hash['mid_pt'] + (side_high_u_hash['mid_pt'] - side_high_center).transform!(Geom::Transformation.new(phi))

            rear_well_u_hash = Hash.new
            rear_well_u_hash['mid_pt'] = @bw_pt

            mid_pt = @side_high_pt + (@side_high_pt - side_high_u_hash['mid_pt']).normalize.transform!(Geom::Transformation.new(@belt_cur_n))

            rocker_end_u_hash = Hash.new
            rocker_end_u_hash['mid_pt'] = mid_pt

            rear_well_v_hash = Wireframe.link(@side_high_pt, mid_pt3, @rear_well_pt, @numseg)

            rear_well_v2_hash = Wireframe.link_tan(@rocker_end_pt, @rear_well_pt2, @rocker_end_pt-rocker_end_v_hash['mid_pt'], (@rear_well_pt2.x-@rocker_end_pt.x)*0.5, @numseg)

            k = (@side_high_pt.x - rear_well_v_hash['mid_pt'].x)/(@side_high_pt.x - @rear_well_pt.x)
            rear_well_center2 = rocker_end_u_hash['mid_pt'] + (rear_well_u2_hash['mid_pt']-rocker_end_u_hash['mid_pt']).transform!(k)

            data['ctrlPts'] = [@fw_u_pt, side_low_u_hash['mid_pt'], @side_low_pt, fw_v_hash['mid_pt'], side_low_center, side_low_v_hash['mid_pt'], @hood_u_pt, well_u_hash['mid_pt'], @well_pt]
            side_low_surf = Bezier_surf.new(data)
            side_low_surf.create_patch(c3.entities)
            
            data['ctrlPts'] = [@side_low_pt, rocker_u_hash['mid_pt'], @rocker_center_pt, side_low_v_hash['mid_pt'], rocker_center, rocker_v_hash['mid_pt'], @well_pt, front_well_u2_hash['mid_pt'], @front_well_pt2]
            rocker_surf = Bezier_surf.new(data)
            rocker_surf.create_patch(c3.entities)
            
            data['ctrlPts'] = [@roof_pt, side_high_u_hash['mid_pt'], @side_high_pt, roof_v_hash['mid_pt'], side_high_center, side_high_v_hash['mid_pt'], @fw_u_pt, side_low_u_hash['mid_pt'], @side_low_pt]
            side_high_surf = Bezier_surf.new(data)
            side_high_surf.create_patch(c3.entities)
            
            data['ctrlPts'] = [@side_high_pt, rocker_end_u_hash['mid_pt'], @rocker_end_pt, side_high_v_hash['mid_pt'], rocker_end_center, rocker_end_v_hash['mid_pt'], @side_low_pt, rocker_u_hash['mid_pt'], @rocker_center_pt]
            rocker_end_surf = Bezier_surf.new(data)
            rocker_end_surf.create_patch(c3.entities)
            
            data['ctrlPts'] = [@bw_pt, rear_well_u_hash['mid_pt'], @rear_well_pt, bw_v_hash['mid_pt'], rear_well_center, rear_well_v_hash['mid_pt'], @roof_pt, side_high_u_hash['mid_pt'], @side_high_pt]
            rear_well_surf = Bezier_surf.new(data)
            rear_well_surf.create_patch(c3.entities)
            
            data['ctrlPts'] = [@rear_well_pt, rear_well_u2_hash['mid_pt'], @rear_well_pt2, rear_well_v_hash['mid_pt'], rear_well_center2, rear_well_v2_hash['mid_pt'], @side_high_pt, rocker_end_u_hash['mid_pt'], @rocker_end_pt]
            rear_well_surf2 = Bezier_surf.new(data)
            rear_well_surf2.create_patch(c3.entities)
            
            #model.entities.add_curve([side_low_center, side_low_u_hash['mid_pt']])
            #model.entities.add_curve([side_low_u_hash['mid_pt'], side_high_center])
            #model.entities.add_curve([side_low_v_hash['mid_pt'], @side_low_pt])
            #model.entities.add_curve([@side_low_pt, side_high_v_hash['mid_pt']])
            #model.entities.add_curve([rocker_center, rocker_u_hash['mid_pt']])
            #model.entities.add_curve([side_low_center, side_low_v_hash['mid_pt']])
            #model.entities.add_curve([side_low_v_hash['mid_pt'], rocker_center])
            #model.entities.add_curve([side_low_u_hash['mid_pt'], @side_low_pt])
            #model.entities.add_curve([@side_low_pt, rocker_u_hash['mid_pt']])
            #model.entities.add_curve([side_high_center, side_high_v_hash['mid_pt']])
            #model.entities.add_curve([side_high_v_hash['mid_pt'], rocker_end_center])
            #model.entities.add_curve([rocker_u_hash['mid_pt'], rocker_end_center])
            #model.entities.add_curve([@roof_pt, side_high_u_hash['mid_pt']])
            #model.entities.add_curve([bw_v_hash['mid_pt'], rear_well_center])
            #model.entities.add_curve([side_high_center, side_high_u_hash['mid_pt']])
            #model.entities.add_curve([side_high_u_hash['mid_pt'], rear_well_center])
            #model.entities.add_curve([@well_pt, side_low_v_hash['mid_pt']])
            #model.entities.add_curve([@fw_u_pt, side_low_u_hash['mid_pt']])
            #model.entities.add_curve([front_well_u2_hash['mid_pt'], rocker_center])
            #model.entities.add_curve([rocker_center, rocker_u_hash['mid_pt']])
            #model.entities.add_curve([side_high_v_hash['mid_pt'], @side_high_pt])
            #model.entities.add_curve([side_high_u_hash['mid_pt'], @side_high_pt])
            #model.entities.add_curve([@side_high_pt, rocker_end_u_hash['mid_pt']])
            #model.entities.add_curve([rocker_end_u_hash['mid_pt'], @rocker_end_pt])
            #model.entities.add_curve([@bw_pt, rear_well_u_hash['mid_pt']])
            #model.entities.add_curve([rear_well_u_hash['mid_pt'], @rear_well_pt])
            #model.entities.add_curve([@side_high_pt, rear_well_v_hash['mid_pt']])
            #model.entities.add_curve([rear_well_v_hash['mid_pt'], @rear_well_pt])
            #model.entities.add_curve([@rocker_end_pt, rear_well_v2_hash['mid_pt']])
            #model.entities.add_curve([rear_well_v2_hash['mid_pt'], @rear_well_pt2])
            #model.entities.add_curve([rear_well_v2_hash['mid_pt'], rear_well_center2])
            #model.entities.add_curve([rocker_end_center, rocker_end_u_hash['mid_pt']])
            #model.entities.add_curve([rocker_end_u_hash['mid_pt'], rear_well_center2])
            
#--------------------------------------------------------------------------------------------------------------------------------------------------------------
    # Component 5: Back
    # 2 variables: Genotype 39 ~ 40
            Sketchup.set_status_text('Running Matchbox: Generating seed# ' + i.to_s + '_Component5')
            c5 = aCar.entities.add_group

            #@hip_mid_pt = Geom::Point3d.new((@box_r+@wheelbase+2*(1+@wheel_scale)*@r_wheel*@well_scale+@head_u1_pt.x)*0.5 + (@box_r-(@wheelbase+2*(1+@wheel_scale)*@r_wheel*@well_scale+@head_u1_pt.x))*0.5*g.x[39], 0, 0)
            @hip_mid_pt = Geom::Point3d.new(@wheelbase+(1+@wheel_scale)*@r_wheel*@well_scale+@head_u1_pt.x + 10.0 + 100.0*g.x[39], 0, 0)
            hip_vec = (@bw_end_pt - profile1['bw_ctrl_pt']).normalize
            if hip_vec.z < 0 
              @hip_n = [(@hip_mid_pt.x-@bw_end_pt.x)/hip_vec.x, (@rear_well_pt.z-@bw_end_pt.z)/hip_vec.z].min*g.x[40]
            else
              @hip_n = (@hip_mid_pt.x-@bw_end_pt.x)/hip_vec.x*g.x[40]
            end
            temp = Wireframe.link_tan(@bw_end_pt, @hip_mid_pt, hip_vec, @hip_n, @numseg)
            profile1['hip'] = temp['all_pt']
            profile1['hip_ctrl_pt'] = temp['mid_pt']
            
            temp = (bw_center-roof_center)*(roof_center-fw_center)
            if temp.x <= @eps && temp.y <= @eps && temp.z <= @eps
                temp1 = temp.x/[temp.x.abs, temp.y.abs, temp.z.abs].min
                temp2 = temp.y/[temp.x.abs, temp.y.abs, temp.z.abs].min
                temp3 = temp.z/[temp.x.abs, temp.y.abs, temp.z.abs].min
                temp = Geom::Vector3d.new(temp1, temp2, temp3).normalize
            end

            hip_center = Geom.intersect_line_plane([profile1['hip_ctrl_pt'], ey], [bw_center, temp])
            @rear_n = (@rear_pt.y - @hip_mid_pt.y)*0.6
            hip_temp = Wireframe.link_tan(@hip_mid_pt, @rear_pt, ey, @rear_n, @numseg*2)

            @rear_start_pt = hip_temp['all_pt'][@numseg]
            temp_vec = @rear_pt - @hip_mid_pt
            mid_pt1 = Geom.intersect_line_line([@hip_mid_pt, ey], [@rear_start_pt, temp_vec])
            mid_pt2 = Geom.intersect_line_line([@rear_pt, @rear_pt - hip_temp['mid_pt']], [@rear_start_pt, temp_vec])

            rear_hash = Wireframe.link(@hip_mid_pt, mid_pt1, @rear_start_pt, @numseg)
            rear_u_hash = Wireframe.link(@rear_start_pt, mid_pt2, @rear_pt, @numseg)
            hip_u_vec = (@bw_pt - bw_v_hash['mid_pt']).normalize

            mid_pt = Geom.intersect_line_plane([@bw_pt, @bw_pt - bw_v_hash['mid_pt']], [hip_center, hip_u_vec])

            hip_v_hash = Hash.new
            hip_v_hash['mid_pt'] = mid_pt
            rear_center = Geom.intersect_line_plane([rear_well_u_hash['mid_pt'], rear_well_u_hash['mid_pt'] - rear_well_center], [hip_center, hip_u_vec])

            data['ctrlPts'] = [@hip_mid_pt, rear_hash['mid_pt'], @rear_start_pt, profile1['hip_ctrl_pt'], hip_center, hip_v_hash['mid_pt'], @bw_end_pt, bw_u_hash['mid_pt'], @bw_pt]
            hip_surf = Bezier_surf.new(data)
            hip_surf.create_patch(c3.entities)
            
            data['ctrlPts'] = [@rear_start_pt, rear_u_hash['mid_pt'], @rear_pt, hip_v_hash['mid_pt'], rear_center, rear_v_hash['mid_pt'], @bw_pt, rear_well_u_hash['mid_pt'], @rear_well_pt]
            rear_surf = Bezier_surf.new(data)
            rear_surf.create_patch(c3.entities)

            @rwheel_x = (@rear_pt.x + @rear_well_pt2.x)*0.5
            @rwheel_z = (@rear_pt.z + @rear_well_pt2.z)*0.5
            
            # Rear wheel extension
            rw3 = Geom::Point3d.new(@rwheel_x - @r_wheel*1.2, @box_w, 0.0)
            rw1 = Geom::Point3d.new(@rwheel_x + @r_wheel*1.2, @box_w, 0.0)
            k = (rw3.x - rw1.x)/(@rear_well_pt2.x - @rear_pt.x)
            rw2 = Geom::Point3d.new(rw3.x + (@rear_well_pt.x - @rear_well_pt2.x)*k, rw3.y, rw3.z + (@rear_well_pt.z - @rear_well_pt2.z)*k)
            mid_pt2 = Geom::Point3d.new(rw3.x + (rear_well_u2_hash['mid_pt'].x - @rear_well_pt2.x)*k, rw3.y, rw3.z + (rear_well_u2_hash['mid_pt'].z - @rear_well_pt2.z)*k)
            mid_pt1 = Geom::Point3d.new(rw3.x + (rear_v_hash['mid_pt'].x - @rear_well_pt2.x)*k, rw3.y, rw3.z + (rear_v_hash['mid_pt'].z - @rear_well_pt2.z)*k)
            
            rw_mid2 = Geom.intersect_line_plane([@rear_well_pt, rw2 - @rear_well_pt], [Geom::Point3d.new(0.0, (@box_w*0.2+@rear_pt.y*0.8), 0.0), Geom::Vector3d.new(0.0, -1.0, 0.0)])
            rw_mid1 = Geom.intersect_line_plane([@rear_pt, @rear_pt - rear_u_hash['mid_pt']], [Geom::Point3d.new(0.0, (@box_w*0.2+@rear_pt.y*0.8), 0.0), Geom::Vector3d.new(0.0, -1.0, 0.0)])
            rw_mid3 = @rear_well_pt2 + (rw_mid1-@rear_pt).transform!(Geom::Transformation.scaling(-1, 1, 1))
            k = (rw_mid3.x - rw_mid1.x)/(@rear_well_pt2.x - @rear_pt.x)
            mid_pt4 = Geom::Point3d.new(rw_mid3.x + (rear_well_u2_hash['mid_pt'].x - @rear_well_pt2.x)*k, rw_mid3.y, rw_mid3.z + (rear_well_u2_hash['mid_pt'].z - @rear_well_pt2.z)*k)
            mid_pt3 = Geom::Point3d.new(rw_mid3.x + (rear_v_hash['mid_pt'].x - @rear_well_pt2.x)*k, rw_mid3.y, rw_mid3.z + (rear_v_hash['mid_pt'].z - @rear_well_pt2.z)*k)

            c5_wheel = aCar.entities.add_group
            data['ctrlPts'] = [@rear_pt, rw_mid1, rw1, rear_v_hash['mid_pt'], mid_pt3, mid_pt1, @rear_well_pt, rw_mid2, rw2]
            rear_well_ext1_surf = Bezier_surf.new(data)
            rear_well_ext1_surf.create_patch(c5_wheel.entities)
            
            data['ctrlPts'] = [@rear_well_pt, rw_mid2, rw2, rear_well_u2_hash['mid_pt'], mid_pt4, mid_pt2, @rear_well_pt2, rw_mid3, rw3]
            rear_well_ext2_surf = Bezier_surf.new(data)
            rear_well_ext2_surf.create_patch(c5_wheel.entities)

            Sketchup.set_status_text('Running Matchbox: Generating seed# ' + i.to_s + '_softenCoplanarGrp')
            #-----------------------------------------------------------------------------
            Wireframe.softenCoplanarGrp(aCar, 100.0)
            #-----------------------------------------------------------------------------
            #lift_z = Geom::Transformation.new(Geom::Point3d.new(0, 0, @clearance))
            #aCar.transform!(lift_z)
            t_mirror = Geom::Transformation.scaling(1, -1, 1)
            aCar_mirror = aCar.copy
            aCar_mirror.transform!(t_mirror)
            
            scale = Geom::Transformation.new(@dimension_coef)
            @matchbox.transform!(scale)
            @matchbox.transform!(@origin)
    end
    
    def group
      return @matchbox
    end
end ##end of class
