require File.dirname(__FILE__) + '/Rational.rb'
require File.dirname(__FILE__) + '/Intersect.rb'
#require  'sketchup.rb' # Link Sketchup 6.0
class Mid_point < Geom::Point3d
# This class defines methods to determine the third/other control point/s
    @eps = 0.000001
# --------------------------------------------------Curve methods----------------------------------------------------------------------
    def Mid_point.start_tan_n(start_pt, end_pt, tan, n, numseg)
    # This method uses start tangent constraint (start means index 0) and some curvature degree n to determine the mid control point
        t = 1.0/numseg
        tan = tan.normalize
        x = tan.x*n + start_pt.x
        y = tan.y*n + start_pt.y
        z = tan.z*n + start_pt.z
        return Geom::Point3d.new(x, y, z)
    end
    
    def Mid_point.tan_n(start_pt, end_pt, tan_start, tan_end, n_start, n_end, numseg)
    # This method uses start and end tangent constraints. Four control points/ two mid points are needed.
    # start_pt is P0, end_pt is P3
        mid_pt_1 = Geom::Point3d.new # close to start_pt
        mid_pt_2 = Geom::Point3d.new # close to end_pt
        t = 1.0/numseg
        # x direction
        a = 3*Rational.pow((1-t),2)*t # coef for P1 at t
        b = 3*Rational.pow(t,2)*(1-t) # coef for P2 at t
        # coef for P1 at 1-t is b
        # coef for P2 at 1-t is a
        c = tan_start.x*n_start - (start_pt.x*Rational.pow((1-t),3) - start_pt.x) - end_pt.x*Rational.pow(t,3)
        d = tan_end.x*n_end - start_pt.x*Rational.pow(t,3) - (end_pt.x*Rational.pow((1-t),3) - end_pt.x)
        mid_pt_1.x = (a*c - b*d)/(a*a - b*b)
        mid_pt_2.x = (a*d - b*c)/(a*a - b*b)
        
        # y direction
        c = tan_start.y*n_start - (start_pt.y*Rational.pow((1-t),3) - start_pt.y) - end_pt.y*Rational.pow(t,3)
        d = tan_end.y*n_end - start_pt.y*Rational.pow(t,3) - (end_pt.y*Rational.pow((1-t),3) - end_pt.y)
        mid_pt_1.y = (a*c - b*d)/(a*a - b*b)
        mid_pt_2.y = (a*d - b*c)/(a*a - b*b)
        
        # z direction
        c = tan_start.z*n_start - (start_pt.z*Rational.pow((1-t),3) - start_pt.z) - end_pt.z*Rational.pow(t,3)
        d = tan_end.z*n_end - start_pt.z*Rational.pow(t,3) - (end_pt.z*Rational.pow((1-t),3) - end_pt.z)
        mid_pt_1.z = (a*c - b*d)/(a*a - b*b)
        mid_pt_2.z = (a*d - b*c)/(a*a - b*b)
      
        return [mid_pt_1, mid_pt_2]
    end
    
    def Mid_point.centerpoint(start_point, end_point, local_center, mod_point, n = 50)
    # This method finds a mid point using degree of curvature: n
    # start/end pts are the starting and ending points, local_center is to define a bending direction, mod_point is the point to modify
    # n is the step size. See 2d version for details
    # Only works with three points now!
        v = (mod_point - local_center).normalize
        temp = Geom::Point3d.new
        temp.x = mod_point.x + n * v.x
        temp.y = mod_point.y + n * v.y
        temp.z = mod_point.z + n * v.z
        return temp
    end
    
    def Mid_point.curvxz(pt1, pt2, pt3, pt4)
    # This method finds the mid_pt that gives C2 continuity or approximation (Since our curves only uses 3 ctrl pts, in cases that two 
    # curves are not in the same plane, we will only have continual curvature but in different directions, that comes the approximation)
    # pt1, pt2, pt3 forms the previous curve where pt3 is the conjoint pt. pt3 and pt4 are ctrl pts of the current curve. The output is
    # the mid pt between pt3 and pt4.
#UI.messagebox('hi')

        a = pt3 - pt2
        b = pt1 - pt2
        d = pt4 - pt3
#UI.messagebox(a.to_s + ' ' + b.to_s + ' ' + d.to_s)
        p = (d.x*b.z - d.z*b.x)/(a.x*b.z - a.z*b.x)
        q = (d.x*a.z - d.z*a.x)/(b.x*a.z - b.z*a.x)
        
        if d.y == p*a.y + q*b.y
            alpha = Math.sqrt(q.abs)
        else
            dd = d.transform(Geom::Transformation.new(a%a))
            aa = a.transform(Geom::Transformation.new(d%a))
            bb = b.transform(Geom::Transformation.new(a%a))
            ab = a.transform(Geom::Transformation.new(b%a))
            alpha = Math.sqrt((dd - aa).length / (bb - ab).length)
        end

        x = alpha*a.x + pt3.x
        y = alpha*a.y + pt3.y
        z = alpha*a.z + pt3.z
#UI.messagebox(q.to_s + ' ' + p.to_s + ' ' + alpha.to_s)
#model = Sketchup.active_model
#model.entities.add_curve([pt3, Geom::Point3d.new(x, y, z)])
        return Geom::Point3d.new(x, y, z)
    end
    
    def Mid_point.curvxy(pt1, pt2, pt3, pt4)
    # This method finds the mid_pt that gives C2 continuity or approximation (Since our curves only uses 3 ctrl pts, in cases that two 
    # curves are not in the same plane, we will only have continual curvature but in different directions, that comes the approximation)
    # pt1, pt2, pt3 forms the previous curve where pt3 is the conjoint pt. pt3 and pt4 are ctrl pts of the current curve. The output is
    # the mid pt between pt3 and pt4.
        a = pt3 - pt2
        b = pt1 - pt2
        d = pt4 - pt3
        
        p = (d.y*b.x - d.x*b.y)/(a.y*b.x - a.x*b.y)
        q = (d.y*a.x - d.x*a.y)/(b.y*a.x - b.x*a.y)
        
        if d.z == p*a.z + q*b.z
            alpha = Math.sqrt(q.abs)
        else
            dd = d.transform(Geom::Transformation.new(a%a))
            aa = a.transform(Geom::Transformation.new(d%a))
            bb = b.transform(Geom::Transformation.new(a%a))
            ab = a.transform(Geom::Transformation.new(b%a))
            alpha = Math.sqrt((dd - aa).length / (bb - ab).length)
        end
        x = alpha*a.x + pt3.x
        y = alpha*a.y + pt3.y
        z = alpha*a.z + pt3.z
        return Geom::Point3d.new(x, y, z)
    end
    
    def Mid_point.curvyz(pt1, pt2, pt3, pt4)
    # This method finds the mid_pt that gives C2 continuity or approximation (Since our curves only uses 3 ctrl pts, in cases that two 
    # curves are not in the same plane, we will only have continual curvature but in different directions, that comes the approximation)
    # pt1, pt2, pt3 forms the previous curve where pt3 is the conjoint pt. pt3 and pt4 are ctrl pts of the current curve. The output is
    # the mid pt between pt3 and pt4.
        a = pt3 - pt2
        b = pt1 - pt2
        d = pt4 - pt3
        
        p = (d.y*b.z - d.z*b.y)/(a.y*b.z - a.z*b.y)
        q = (d.y*a.z - d.z*a.y)/(b.y*a.z - b.z*a.y)
        
        if d.x == p*a.x + q*b.x
            alpha = Math.sqrt(q.abs)
        else
            dd = d.transform(Geom::Transformation.new(a%a))
            aa = a.transform(Geom::Transformation.new(d%a))
            bb = b.transform(Geom::Transformation.new(a%a))
            ab = a.transform(Geom::Transformation.new(b%a))
            alpha = Math.sqrt((dd - aa).length / (bb - ab).length)
        end
        x = alpha*a.x + pt3.x
        y = alpha*a.y + pt3.y
        z = alpha*a.z + pt3.z
        return Geom::Point3d.new(x, y, z)
    end
    
    def Mid_point.curvpqxz(pt1, pt2, pt3, pt4)
    # Get p, q
        a = pt3 - pt2
        b = pt1 - pt2
        d = pt4 - pt3
        
        p = (d.x*b.z - d.z*b.x)/(a.x*b.z - a.z*b.x)
        q = (d.x*a.z - d.z*a.x)/(b.x*a.z - b.z*a.x)
        return [p, q]
    end
    
    def Mid_point.curvpqxy(pt1, pt2, pt3, pt4)
    # Get p, q
        a = pt3 - pt2
        b = pt1 - pt2
        d = pt4 - pt3
        
        p = (d.y*b.x - d.x*b.y)/(a.y*b.x - a.x*b.y)
        q = (d.y*a.x - d.x*a.y)/(b.y*a.x - b.x*a.y)
        return [p, q]
    end
    
    def Mid_point.curvpqyz(pt1, pt2, pt3, pt4)
    # Get p, q
        a = pt3 - pt2
        b = pt1 - pt2
        d = pt4 - pt3
        
        p = (d.y*b.z - d.z*b.y)/(a.y*b.z - a.z*b.y)
        q = (d.y*a.z - d.z*a.y)/(b.y*a.z - b.z*a.y)
        return [p, q]
    end
# --------------------------------------------------Curve methods----------------------------------------------------------------------

# --------------------------------------------------Surf methods----------------------------------------------------------------------
# Only works for 3*3 grid now!

    def Mid_point.surfcenter(upts, vpts, n = 50)
        mid_pt_u = Rational.avg(upts)
        mid_pt_v = Rational.avg(vpts)
        mid_pt = Rational.avg([mid_pt_u, mid_pt_v])
        v = (mid_pt_u - mid_pt_v).normalize
        temp = Geom::Point3d.new()
        temp.x = mid_pt.x + v.x * n
        temp.y = mid_pt.y + v.y * n
        temp.z = mid_pt.z + v.z * n
        return temp
    end
    
    def Mid_point.surftan1(pt, v, n)
    # with one tangent constraint
        temp = Geom::Point3d.new()
        temp.x = pt.x + v.x * n
        temp.y = pt.y + v.y * n
        temp.z = pt.z + v.z * n
        return temp
    end
    
    def Mid_point.surftan2xz(a, b, c, d, e)
        return Intersect.xz(a, b, c, d, e)
    end
# --------------------------------------------------Surf methods----------------------------------------------------------------------

end
