require File.dirname(__FILE__) + '/Genotype.rb'
require  'sketchup.rb' # Link Sketchup 6.0

class Population
@@eps = 0.000001

  def initialize(population_size, genotype_length)
    @population_size = population_size
    @genotype_length = genotype_length
    @population = Array.new(@population_size)
    #@delta = 0.1 # mutation step size
    @c = 1.0 # self-adaptive coef
  end
  
  def randomize()
    # Generate a population
    for i in 0 ... @population_size
      @population[i] = Genotype.new(@genotype_length)
      @population[i].randomize()
    end
    save(0)
  end
  
  def [](n = nil)
    if n.kind_of?(Integer)
      return @population[n]
    else
      return @population
    end
  end
  
  def push(i, seed)
    @population[i] = seed
  end
  
  def rank(r)
    # Rank population fitness
    rank = Array.new()
    i = 0
    temp = []
    count = 0
    r.each {|n| if n == 1
                  temp[count] = i
                  count = count + 1
                end
                i = i + 1}
    temp.each {|index| r[index] = count/@population_size}
    return r
  end
  
  #def fitness(array)
  #  # Define fitness function
  #  n = 0
  #  array.each {|v| n = n - (v*v)+v}
  #  n
  #end
  
  def selection(rr)
    # Implement stochastic universal sampling (SUS)
    i = 0
    mating_pool = Array.new()
    mating_index = Array.new()
    prob = [0]
    @rank = rank(rr)
    rank_sum = 0
    @rank.each {|v| rank_sum = rank_sum + v}
    @rank.each{|v| prob.push(prob[prob.length - 1] + v/rank_sum)}
    prob.shift
    # set a random criterion r
    r = 1/@population_size * rand()
    while mating_pool.length <= (@population_size - 1)
      while r <= prob[i]
        mating_pool.push(@population[i])
        mating_index.push(i)
        r = r + 1/@population_size
      end
    i = i + 1
    end
    @population = mating_pool
  end
  
  def recombination()
    # Define recombination(cross-over) method
    # Whole Arithmetic Recombination
    offspring = Array.new(@population_size)
    alpha = rand() # Recomination coef
    for i in 0 ... @population_size - 2
      a = @population[i].x
      b = @population[i+2].x
      c = @population[i].delta
      d = @population[i+2].delta
      offspring[2*i] = Genotype.new(@genotype_length, (a.*alpha).+(b.*(1-alpha)), (c.*alpha).+(d.*(1-alpha)))
      offspring[2*i+1] = Genotype.new(@genotype_length, (b.*alpha).+(a.*(1-alpha)), (d.*alpha).+(c.*(1-alpha)))
    end
    @population = offspring
  end
  
  def mutation(evo_num)
    # Define mutation method
    f = File.new(File.dirname(__FILE__) + '/Genotype_list_' + evo_num.to_s + '.txt', 'w')
    for i in 0...@population_size
      temp = []
      @population[i].x.each {|n| temp.push([[n + @population[i].delta*(-0.5 + rand()), 1.0-@@eps].min, @@eps].max)}
      @population[i].x=temp
      @population[i].delta=@population[i].delta * Math.exp(@c/Math.sqrt(evo_num)*rand())
      @population[i].x.each {|n| f.write(n.to_s + "\n")}
    end
    f.close
    # apply 1/5 success rule of Rechenberg
    #rank = rank(population)
    #i = 0
    #count = 0.0
    #rank.each {|n| if n > @rank[i]
    #                population[i].delta=population[i].delta * Math.exp(@c/Math.sqrt(evo_num)*rand())
    #               elsif n < @rank[i]
    #                population[i].delta=population[i].delta / Math.exp(@c/Math.sqrt(evo_num)*rand())
    #               end
    #               i = i + 1}
    #p = count/@@population_size
    #if p < 0.2
    #  @delta = @delta / @c
    #elsif p > 0.2
    #  @delta = @delta * @c
    #end
  end
  
  def puts(s)
    $stdout.puts(s)
  end
  
  def max()
    @rank.max
  end
  
  def evolve(r, i) # i = evolution number
    Sketchup.set_status_text('Running Matchbox: Evolution# ' + i.to_s + ': Selection')
    selection(r)
    if @population_size > 1
      Sketchup.set_status_text('Running Matchbox: Evolution# ' + i.to_s + ': Recombination')
      recombination()
    end
    Sketchup.set_status_text('Running Matchbox: Evolution# ' + i.to_s + ': Mutation')
    mutation(i)
    #selection(r)
  end
  
  def save(evo_num)
  # save current population
    f = File.new(File.dirname(__FILE__) + '/Genotype_list_' + evo_num.to_s + '.txt', 'w')
    for i in 0...@population_size
      @population[i].x.each {|n| f.write(n.to_s + "\n")}
    end
    f.close
  end
  
end

class Array
  def * (n)
    temp = Array.new()
    i = 0
    if n.kind_of? Float
      each {|v| temp[i] = v*n
            i = i + 1}
    end
    return temp
  end
  
  def + (n)
    if n.kind_of? Array
      i = 0
      temp = Array.new()
      while i < [self.length, n.length].max
        temp.push(self[i] + n[i])
        i = i + 1
      end
    return temp
    elsif n.kind_of? Float
      each {|v| v = v + n}
    end
  end
end
