require File.dirname(__FILE__) + '/Mid_point.rb' #include mid_point methods
require File.dirname(__FILE__) + '/Bezier_curve.rb'

module Wireframe
# Wireframe class
    # Find starting and ending tangent

    #def Wireframe.start_tan(curvepts)
    #    return (curvepts[0] - curvepts[1]).normalize
    #end
    #def Wireframe.end_tan(curvepts, numseg)
    #    return (curvepts[numseg] - curvepts[numseg - 1]).normalize
    #end
    def Wireframe.link(start_pt, mid_pt, end_pt, numseg, entities = nil)
        bc = Bezier_curve.new
        bc_hash = Hash.new(0)
        bc_hash['mid_pt'] = mid_pt
        bc_hash['all_pt'] = bc.curve([start_pt, mid_pt, end_pt], numseg, entities)
        return bc_hash
    end
    
    def Wireframe.link_offset(start_pt, end_pt, local_center, n, numseg, entities = nil)
    # Create curve using mid point offset
        bc = Bezier_curve.new
        temp = Geom::Point3d.new
        temp.x = (start_pt.x + end_pt.x)/2
        temp.y = (start_pt.y + end_pt.y)/2
        temp.z = (start_pt.z + end_pt.z)/2
        mid_pt = Mid_point.centerpoint(start_pt, end_pt, local_center, temp, n)
        bc_hash = Hash.new(0)
        bc_hash['mid_pt'] = mid_pt
        bc_hash['all_pt'] = bc.curve([start_pt, mid_pt, end_pt], numseg, entities)
        return bc_hash
    end
    
    def Wireframe.link_tan(start_pt, end_pt, tan, n, numseg, entities = nil)
    # Create curve using one tangent constraint on start_pt
        mid_pt = Mid_point.start_tan_n(start_pt, end_pt, tan, n, numseg)
        bc = Bezier_curve.new
        bc_hash = Hash.new
        bc_hash['mid_pt'] = mid_pt
        bc_hash['all_pt'] = bc.curve([start_pt, mid_pt, end_pt], numseg, entities)
        return bc_hash
    end
    
    def Wireframe.link_tan2(start_pt, end_pt, tan1, tan2, n1, n2, numseg, entities = nil)
    # Create curve using two tangent constraint and two mid pts
        temp = Mid_point.tan_n(start_pt, end_pt, tan1, tan2, n1, n2, numseg)
        mid_pt_start = temp[0]
        mid_pt_end = temp[1]
        bc = Bezier_curve.new
        bc_hash = Hash.new
        bc_hash['mid_pt_start'] = mid_pt_start
        bc_hash['mid_pt_end'] = mid_pt_end
        bc_hash['all_pt'] = bc.curve([start_pt, mid_pt_start, mid_pt_end, end_pt], numseg, entities)
        return bc_hash
    end
    
    def Wireframe.link_cur(pt1, pt2, pt3, pt4, plane_index, numseg, entities = nil)
    # Create curve using one curvature constraint
        if plane_index == 1
            mid_pt = Mid_point.curvxz(pt1, pt2, pt3, pt4)
        elsif plane_index == 2
            mid_pt = Mid_point.curvxy(pt1, pt2, pt3, pt4)
        else
            mid_pt = Mid_point.curvyz(pt1, pt2, pt3, pt4)
        end
        bc = Bezier_curve.new
        bc_hash = Hash.new
        bc_hash['mid_pt'] = mid_pt
        bc_hash['all_pt'] = bc.curve([pt3, mid_pt, pt4], numseg, entities)
        return bc_hash
    end
    
    def Wireframe.softenCoplanarGrp(group, ang_tol)
    # Soften edge by gouldingken@gmail.com
            group.entities.each do |e|
                    if (e.kind_of? Sketchup::Group)
                            softenCoplanarGrp(e, ang_tol)
                    elsif (e.kind_of? Sketchup::Edge)
                            f1 = e.faces[0]
                            f2 = e.faces[1]
                            if (f1!=nil and f2!=nil)
                                    #if (f1.normal == f2.normal)
                                            #e.soft = true
                                            #e.smooth = true
                                    if (f1.normal.angle_between(f2.normal).radians < ang_tol)
                                            e.soft = true
                                            e.smooth = true
                                    end
                            end
                    end
            end
    end
end
