/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs;

import com.jp.gui.AboutDialog;
import com.jp.gui.AboutPanel;
import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseHost;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.LicenseHostPro;
import com.jp.protection.utils.LicenseUtils;
import dev.entities.Customer;
import dev.gui.UIUtils;
import dev.lang.BitTools;
import dev.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class LicenseAboutDialog
extends AboutDialog
implements PropertyChangeListener {
    static ResourceBundle res;
    protected static final DateFormat DATE_FORMAT;
    protected static final MessageFormat FMT_REQUIRES_ACTIVATION_IN;
    protected static final MessageFormat FMT_REQUIRES_LOCK_IN;
    protected ProductInfo fProductInfo;
    private static final /* synthetic */ String[] z;

    public LicenseAboutDialog() {
        this((Component)null);
    }

    public LicenseAboutDialog(Component component) {
        super(component);
        UIUtils.applyComponentOrientation(this);
    }

    public LicenseAboutDialog(Frame frame) {
        super(frame);
        UIUtils.applyComponentOrientation(this);
    }

    public LicenseAboutDialog(Dialog dialog) {
        super(dialog);
        UIUtils.applyComponentOrientation(this);
    }

    public static void execute(LicenseAboutDialog licenseAboutDialog, final LicenseHost licenseHost) {
        final License license = licenseHost.getLicense();
        LicenseAboutDialog.execute(licenseAboutDialog, license == null ? null : new AboutPanel.LicenseDelegate(){
            protected Customer fCustomer;
            private static final /* synthetic */ String[] z;

            public String getLicenseText() {
                return license.getLicenseText();
            }

            public boolean isLicenseAccepted() {
                return licenseHost.isLicenseAccepted();
            }

            public void acceptLicense() {
                licenseHost.setLicenseAccepted(true);
            }

            public String getLicenseNumber() {
                return license.getLicenseNumber();
            }

            protected Customer getCustomer() {
                if (this.fCustomer == null) {
                    this.fCustomer = new Customer();
                    LicenseUtils.fromLicense(license, this.fCustomer);
                    if (this.fCustomer.getFirstName() == null && this.fCustomer.getLastName() == null && this.fCustomer.getCompany() == null) {
                        this.fCustomer.fromPreferences(LicenseUtils.getCustomerPreferences(license.getProduct()));
                    }
                }
                return this.fCustomer;
            }

            public String getLicenseOwner() {
                StringBuffer stringBuffer = new StringBuffer();
                Customer customer = this.getCustomer();
                if (this.fCustomer.getFirstName() != null) {
                    stringBuffer.append(this.fCustomer.getFirstName());
                }
                if (this.fCustomer.getLastName() != null) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(this.fCustomer.getLastName());
                }
                if (this.fCustomer.getCompany() != null) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(z[4]);
                    }
                    stringBuffer.append(this.fCustomer.getCompany());
                }
                return stringBuffer.toString();
            }

            public String getLicenseIssueInfo() {
                return DATE_FORMAT.format(license.getLicenseIssueDate());
            }

            public String getLicenseExpireInfo() {
                return LicenseAboutDialog.getLicenseExpireInfo(license, licenseHost);
            }

            public String getLicenseType() {
                return license.getLicenseType() == 3 ? res.getString(z[5]) : res.getString(z[6]);
            }

            public boolean isLicenseAvailable() {
                return license.getLicenseState() != 4 && license.getLicenseState() != 1;
            }

            public boolean isLicenseOK() {
                return license.getLicenseState() == 2;
            }

            public String getLicenseState() {
                String string = null;
                switch (license.getLicenseState()) {
                    case 3: {
                        string = res.getString(z[1]);
                        break;
                    }
                    case 5: 
                    case 6: {
                        string = res.getString(z[3]);
                        break;
                    }
                    case 7: {
                        string = res.getString(z[0]);
                        break;
                    }
                    case 2: {
                        if (!(licenseHost instanceof LicenseHostPro)) break;
                        LicenseHostPro licenseHostPro = (LicenseHostPro)licenseHost;
                        if ((BitTools.checkBit(license.getLicenseOptions(), 1) || BitTools.checkBit(license.getLicenseOptions(), 2)) && !StringUtils.equals(license.getProperty(z[2], null), licenseHostPro.getActivationKey())) {
                            int n = licenseHostPro.getActivationDaysLeft(license);
                            string = n > 0 ? FMT_REQUIRES_ACTIVATION_IN.format(new Object[]{new Integer(n)}) : null;
                            break;
                        }
                        if (license.getUserLicensingModel() != 4 && license.getUserLicensingModel() != 5) break;
                        int n = licenseHostPro.getLockDaysLeft(license);
                        string = n > 0 ? FMT_REQUIRES_LOCK_IN.format(new Object[]{new Integer(n)}) : null;
                    }
                }
                return string;
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                char[] cArray;
                String[] stringArray;
                block76: {
                    int n;
                    int n2;
                    char[] cArray2;
                    int n3;
                    block75: {
                        char[] cArray3;
                        Object var0;
                        block74: {
                            int n4;
                            int n5;
                            char[] cArray4;
                            block73: {
                                char[] cArray5;
                                block72: {
                                    int n6;
                                    int n7;
                                    char[] cArray6;
                                    block71: {
                                        char[] cArray7;
                                        block70: {
                                            int n8;
                                            int n9;
                                            char[] cArray8;
                                            block69: {
                                                char[] cArray9;
                                                block68: {
                                                    int n10;
                                                    int n11;
                                                    char[] cArray10;
                                                    block67: {
                                                        char[] cArray11;
                                                        block66: {
                                                            int n12;
                                                            int n13;
                                                            char[] cArray12;
                                                            block65: {
                                                                char[] cArray13;
                                                                block64: {
                                                                    int n14;
                                                                    int n15;
                                                                    char[] cArray14;
                                                                    block63: {
                                                                        stringArray = new String[7];
                                                                        var0 = null;
                                                                        char[] cArray15 = "!s0T?-I>T\u0005>h2K?\u0016".toCharArray();
                                                                        n3 = 0;
                                                                        int n16 = cArray15.length;
                                                                        cArray14 = cArray15;
                                                                        n15 = n16;
                                                                        if (n16 <= 1) break block63;
                                                                        cArray13 = cArray14;
                                                                        n14 = n15;
                                                                        if (n15 <= n3) break block64;
                                                                    }
                                                                    do {
                                                                        char[] cArray16 = cArray14;
                                                                        char[] cArray17 = cArray14;
                                                                        int n17 = n3;
                                                                        while (true) {
                                                                            int n18;
                                                                            char c = cArray16[n17];
                                                                            switch (n3 % 5) {
                                                                                case 0: {
                                                                                    n18 = 114;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n18 = 7;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n18 = 81;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n18 = 32;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n18 = 90;
                                                                                }
                                                                            }
                                                                            cArray16[n17] = (char)(c ^ n18);
                                                                            ++n3;
                                                                            cArray14 = cArray17;
                                                                            n15 = n15;
                                                                            if (n15 != 0) break;
                                                                            cArray17 = cArray14;
                                                                            n14 = n15;
                                                                            n17 = n15;
                                                                            cArray16 = cArray14;
                                                                        }
                                                                        cArray13 = cArray14;
                                                                        n14 = n15;
                                                                    } while (n15 > n3);
                                                                }
                                                                stringArray[0] = new String(cArray13).intern();
                                                                var0 = null;
                                                                char[] cArray18 = "!s0T?-B)P3\u0000b5".toCharArray();
                                                                n3 = 0;
                                                                int n19 = cArray18.length;
                                                                cArray12 = cArray18;
                                                                n13 = n19;
                                                                if (n19 <= 1) break block65;
                                                                cArray11 = cArray12;
                                                                n12 = n13;
                                                                if (n13 <= n3) break block66;
                                                            }
                                                            do {
                                                                char[] cArray19 = cArray12;
                                                                char[] cArray20 = cArray12;
                                                                int n20 = n3;
                                                                while (true) {
                                                                    int n21;
                                                                    char c = cArray19[n20];
                                                                    switch (n3 % 5) {
                                                                        case 0: {
                                                                            n21 = 114;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n21 = 7;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n21 = 81;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n21 = 32;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n21 = 90;
                                                                        }
                                                                    }
                                                                    cArray19[n20] = (char)(c ^ n21);
                                                                    ++n3;
                                                                    cArray12 = cArray20;
                                                                    n13 = n13;
                                                                    if (n13 != 0) break;
                                                                    cArray20 = cArray12;
                                                                    n12 = n13;
                                                                    n20 = n13;
                                                                    cArray19 = cArray12;
                                                                }
                                                                cArray11 = cArray12;
                                                                n12 = n13;
                                                            } while (n13 > n3);
                                                        }
                                                        stringArray[1] = new String(cArray11).intern();
                                                        var0 = null;
                                                        char[] cArray21 = "\u0002u\u007fA1".toCharArray();
                                                        n3 = 0;
                                                        int n22 = cArray21.length;
                                                        cArray10 = cArray21;
                                                        n11 = n22;
                                                        if (n22 <= 1) break block67;
                                                        cArray9 = cArray10;
                                                        n10 = n11;
                                                        if (n11 <= n3) break block68;
                                                    }
                                                    do {
                                                        char[] cArray22 = cArray10;
                                                        char[] cArray23 = cArray10;
                                                        int n23 = n3;
                                                        while (true) {
                                                            int n24;
                                                            char c = cArray22[n23];
                                                            switch (n3 % 5) {
                                                                case 0: {
                                                                    n24 = 114;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n24 = 7;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n24 = 81;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n24 = 32;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n24 = 90;
                                                                }
                                                            }
                                                            cArray22[n23] = (char)(c ^ n24);
                                                            ++n3;
                                                            cArray10 = cArray23;
                                                            n11 = n11;
                                                            if (n11 != 0) break;
                                                            cArray23 = cArray10;
                                                            n10 = n11;
                                                            n23 = n11;
                                                            cArray22 = cArray10;
                                                        }
                                                        cArray9 = cArray10;
                                                        n10 = n11;
                                                    } while (n11 > n3);
                                                }
                                                stringArray[2] = new String(cArray9).intern();
                                                var0 = null;
                                                char[] cArray24 = "!s0T?-I>T\u00053d%I,\u0013s4D".toCharArray();
                                                n3 = 0;
                                                int n25 = cArray24.length;
                                                cArray8 = cArray24;
                                                n9 = n25;
                                                if (n25 <= 1) break block69;
                                                cArray7 = cArray8;
                                                n8 = n9;
                                                if (n9 <= n3) break block70;
                                            }
                                            do {
                                                char[] cArray25 = cArray8;
                                                char[] cArray26 = cArray8;
                                                int n26 = n3;
                                                while (true) {
                                                    int n27;
                                                    char c = cArray25[n26];
                                                    switch (n3 % 5) {
                                                        case 0: {
                                                            n27 = 114;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n27 = 7;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n27 = 81;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n27 = 32;
                                                            break;
                                                        }
                                                        default: {
                                                            n27 = 90;
                                                        }
                                                    }
                                                    cArray25[n26] = (char)(c ^ n27);
                                                    ++n3;
                                                    cArray8 = cArray26;
                                                    n9 = n9;
                                                    if (n9 != 0) break;
                                                    cArray26 = cArray8;
                                                    n8 = n9;
                                                    n26 = n9;
                                                    cArray25 = cArray8;
                                                }
                                                cArray7 = cArray8;
                                                n8 = n9;
                                            } while (n9 > n3);
                                        }
                                        stringArray[3] = new String(cArray7).intern();
                                        var0 = null;
                                        char[] cArray27 = "^'".toCharArray();
                                        n3 = 0;
                                        int n28 = cArray27.length;
                                        cArray6 = cArray27;
                                        n7 = n28;
                                        if (n28 <= 1) break block71;
                                        cArray5 = cArray6;
                                        n6 = n7;
                                        if (n7 <= n3) break block72;
                                    }
                                    do {
                                        char[] cArray28 = cArray6;
                                        char[] cArray29 = cArray6;
                                        int n29 = n3;
                                        while (true) {
                                            int n30;
                                            char c = cArray28[n29];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n30 = 114;
                                                    break;
                                                }
                                                case 1: {
                                                    n30 = 7;
                                                    break;
                                                }
                                                case 2: {
                                                    n30 = 81;
                                                    break;
                                                }
                                                case 3: {
                                                    n30 = 32;
                                                    break;
                                                }
                                                default: {
                                                    n30 = 90;
                                                }
                                            }
                                            cArray28[n29] = (char)(c ^ n30);
                                            ++n3;
                                            cArray6 = cArray29;
                                            n7 = n7;
                                            if (n7 != 0) break;
                                            cArray29 = cArray6;
                                            n6 = n7;
                                            n29 = n7;
                                            cArray28 = cArray6;
                                        }
                                        cArray5 = cArray6;
                                        n6 = n7;
                                    } while (n7 > n3);
                                }
                                stringArray[4] = new String(cArray5).intern();
                                var0 = null;
                                char[] cArray30 = "1h<M?\u0000d8A6".toCharArray();
                                n3 = 0;
                                int n31 = cArray30.length;
                                cArray4 = cArray30;
                                n5 = n31;
                                if (n31 <= 1) break block73;
                                cArray3 = cArray4;
                                n4 = n5;
                                if (n5 <= n3) break block74;
                            }
                            do {
                                char[] cArray31 = cArray4;
                                char[] cArray32 = cArray4;
                                int n32 = n3;
                                while (true) {
                                    int n33;
                                    char c = cArray31[n32];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n33 = 114;
                                            break;
                                        }
                                        case 1: {
                                            n33 = 7;
                                            break;
                                        }
                                        case 2: {
                                            n33 = 81;
                                            break;
                                        }
                                        case 3: {
                                            n33 = 32;
                                            break;
                                        }
                                        default: {
                                            n33 = 90;
                                        }
                                    }
                                    cArray31[n32] = (char)(c ^ n33);
                                    ++n3;
                                    cArray4 = cArray32;
                                    n5 = n5;
                                    if (n5 != 0) break;
                                    cArray32 = cArray4;
                                    n4 = n5;
                                    n32 = n5;
                                    cArray31 = cArray4;
                                }
                                cArray3 = cArray4;
                                n4 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[5] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray33 = "7q0L/\u0013s8O4".toCharArray();
                        n3 = 0;
                        int n34 = cArray33.length;
                        cArray2 = cArray33;
                        n2 = n34;
                        if (n34 <= 1) break block75;
                        cArray = cArray2;
                        n = n2;
                        if (n2 <= n3) break block76;
                    }
                    do {
                        char[] cArray34 = cArray2;
                        char[] cArray35 = cArray2;
                        int n35 = n3;
                        while (true) {
                            int n36;
                            char c = cArray34[n35];
                            switch (n3 % 5) {
                                case 0: {
                                    n36 = 114;
                                    break;
                                }
                                case 1: {
                                    n36 = 7;
                                    break;
                                }
                                case 2: {
                                    n36 = 81;
                                    break;
                                }
                                case 3: {
                                    n36 = 32;
                                    break;
                                }
                                default: {
                                    n36 = 90;
                                }
                            }
                            cArray34[n35] = (char)(c ^ n36);
                            ++n3;
                            cArray2 = cArray35;
                            n2 = n2;
                            if (n2 != 0) break;
                            cArray35 = cArray2;
                            n = n2;
                            n35 = n2;
                            cArray34 = cArray2;
                        }
                        cArray = cArray2;
                        n = n2;
                    } while (n2 > n3);
                }
                stringArray[6] = new String(cArray).intern();
                z = stringArray;
            }
        });
    }

    public static void execute(Component component, LicenseHost licenseHost) {
        LicenseAboutDialog.execute(new LicenseAboutDialog(), licenseHost);
    }

    public ProductInfo getProductInfo() {
        return this.fProductInfo;
    }

    public void setProductInfo(ProductInfo productInfo) {
        if (this.fProductInfo != null) {
            this.fProductInfo.removePropertyChangeListener(this);
        }
        this.fProductInfo = productInfo;
        if (this.fProductInfo != null) {
            this.fProductInfo.addPropertyChangeListener(this);
            this.setProductName(this.fProductInfo.getName());
            this.setSiteText(this.fProductInfo.getSiteText());
            this.setSiteTooltipText(this.fProductInfo.getSiteTooltipText());
            this.setSiteURL(this.fProductInfo.getSiteURL());
            this.setFeedbackText(this.fProductInfo.getFeedbackText());
            this.setFeedbackTooltipText(this.fProductInfo.getFeedbackTooltipText());
            this.assignFeedbackURL(this.fProductInfo.getFeedbackURL());
            this.setCopyright(this.fProductInfo.getCopyright());
        }
    }

    protected void assignFeedbackURL(String string) {
        AboutPanel.LicenseDelegate licenseDelegate = this.pnlAbout.getLicenseDelegate();
        this.setFeedbackURL(licenseDelegate != null && string != null ? new MessageFormat(string).format(new Object[]{licenseDelegate.getLicenseNumber()}) : string);
    }

    public void setLicenseDelegate(AboutPanel.LicenseDelegate licenseDelegate) {
        super.setLicenseDelegate(licenseDelegate);
        if (this.fProductInfo != null) {
            this.assignFeedbackURL(this.fProductInfo.getFeedbackURL());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof ProductInfo) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(z[1])) {
                this.setSiteText((String)propertyChangeEvent.getNewValue());
            } else if (string.equals(z[0])) {
                this.setSiteTooltipText((String)propertyChangeEvent.getNewValue());
            } else if (string.equals(z[2])) {
                this.setSiteURL((String)propertyChangeEvent.getNewValue());
            } else if (string.equals(z[5])) {
                this.setFeedbackText((String)propertyChangeEvent.getNewValue());
            } else if (string.equals(z[4])) {
                this.setFeedbackTooltipText((String)propertyChangeEvent.getNewValue());
            } else if (string.equals(z[3])) {
                this.assignFeedbackURL((String)propertyChangeEvent.getNewValue());
            }
        }
    }

    public static String getLicenseExpireInfo(License license, LicenseHost licenseHost) {
        return licenseHost.getLicenseExpireInfo(license);
    }

    static {
        String[] stringArray = new String[8];
        Object var0 = null;
        stringArray[0] = LicenseAboutDialog.z(LicenseAboutDialog.z(">\u0006lqb\"\u0000t`_=;}lB"));
        var0 = null;
        stringArray[1] = LicenseAboutDialog.z(LicenseAboutDialog.z(">\u0006lqb(\u0017l"));
        var0 = null;
        stringArray[2] = LicenseAboutDialog.z(LicenseAboutDialog.z(">\u0006lqc\u001f#"));
        var0 = null;
        stringArray[3] = LicenseAboutDialog.z(LicenseAboutDialog.z("+\n}pT,\fsAd\u0001"));
        var0 = null;
        stringArray[4] = LicenseAboutDialog.z(LicenseAboutDialog.z("+\n}pT,\fs@Y\"\u0003l}F\u0019\n``"));
        var0 = null;
        stringArray[5] = LicenseAboutDialog.z(LicenseAboutDialog.z("+\n}pT,\fs@S5\u001b"));
        var0 = null;
        stringArray[6] = LicenseAboutDialog.z(LicenseAboutDialog.z("\u001e\u001by`S\u0012!w`i\f\fl}@,\u001b}pi\u0004\u0001"));
        var0 = null;
        stringArray[7] = LicenseAboutDialog.z(LicenseAboutDialog.z("\u001e\u001by`S\u0012!w`i\u0001\u0000{\u007fS)0Qz"));
        z = stringArray;
        var0 = null;
        res = ResourceBundle.getBundle(LicenseAboutDialog.z(LicenseAboutDialog.z(".\u0000u:\\=AhfY9\n{`_\"\u00016sC$A|}W!\u0000\u007fg\u0018\u001f\nk")));
        DATE_FORMAT = DateFormat.getDateInstance(3);
        FMT_REQUIRES_ACTIVATION_IN = new MessageFormat(res.getString(z[6]));
        FMT_REQUIRES_LOCK_IN = new MessageFormat(res.getString(z[7]));
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n2 = cArray3.length;
                cArray = cArray4;
                n = n2;
                if (n2 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n == 0);
            cArray = cArray4;
            n = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x36);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n;
            int n2;
            char[] cArray3;
            int n3;
            block9: {
                n3 = 0;
                int n4 = cArray.length;
                cArray3 = cArray;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray2 = cArray3;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 77;
                            break;
                        }
                        case 1: {
                            n6 = 111;
                            break;
                        }
                        case 2: {
                            n6 = 24;
                            break;
                        }
                        case 3: {
                            n6 = 20;
                            break;
                        }
                        default: {
                            n6 = 54;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray3 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray3;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n = n2;
            } while (n2 > n3);
        }
        return new String(cArray2).intern();
    }
}

