/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseAcceptanceDelegate;
import com.jp.protection.pub.LicenseHostIssueResolver;
import com.jp.protection.pub.LicenseHostListener;
import com.jp.protection.pub.LicenseImpl;
import com.jp.protection.pub.LicenseOutdatedException;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.LicenseReaderListener;
import com.jp.protection.pub.SecretStorage;
import com.jp.protection.utils.LicenseUtils;
import dev.util.CalendarUtil;
import dev.util.StreamUtil;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class LicenseHost {
    protected LicenseReader fLicenseReader;
    protected List fSecretStorages = new ArrayList();
    protected LicenseAcceptanceDelegate fLicenseAcceptanceDelegate;
    protected String fLicenseTextCommercial;
    protected String fLicenseTextEvaluation;
    protected LicenseHostIssueResolver fIssueResolver;
    protected boolean fVerbose = false;
    public static final String PROPERTY_LICENSE_ACCEPTED;
    public static final String PROPERTY_ALREADY_EXPIRED;
    public static final String PROPERTY_PREVIOUS_EXPIRATION_DATE;
    public static final String PROPERTY_PREVIOUS_SHUTDOWN_DATE;
    public static final String LICENSE_HOST_HINT_CLEAR_PREVIOUS_SHUTDOWN_DATE;
    protected Vector fLicenseHostListeners;
    protected boolean fAllowFlexibleExpirationDate = false;
    protected static final String PROPERTY_FLEXIBLE_EXP_DATE_PROCESSED;
    protected static final DateFormat DATE_FORMAT;
    public static /* synthetic */ boolean z;
    private static final /* synthetic */ String[] A;

    public LicenseHostIssueResolver getIssueResolver() {
        return this.fIssueResolver;
    }

    public void setIssueResolver(LicenseHostIssueResolver licenseHostIssueResolver) {
        this.fIssueResolver = licenseHostIssueResolver;
    }

    public LicenseHost() {
        this(null, null);
    }

    public LicenseHost(LicenseReader licenseReader) {
        this(licenseReader, null);
    }

    public LicenseHost(LicenseReader licenseReader, LicenseHostListener licenseHostListener) {
        this.setLicenseReader(licenseReader);
        if (licenseHostListener != null) {
            this.addLicenseHostListener(licenseHostListener);
        }
    }

    public String getLicenseTextCommercial() {
        return this.fLicenseTextCommercial;
    }

    public void setLicenseTextCommercial(String string) {
        this.fLicenseTextCommercial = string;
    }

    public String getLicenseTextEvaluation() {
        return this.fLicenseTextEvaluation;
    }

    public void setLicenseTextEvaluation(String string) {
        this.fLicenseTextEvaluation = string;
    }

    public LicenseAcceptanceDelegate getLicenseAcceptanceDelegate() {
        return this.fLicenseAcceptanceDelegate;
    }

    public void setLicenseAcceptanceDelegate(LicenseAcceptanceDelegate licenseAcceptanceDelegate) {
        this.fLicenseAcceptanceDelegate = licenseAcceptanceDelegate;
    }

    public void addSecretStorage(SecretStorage secretStorage) {
        this.fSecretStorages.add(secretStorage);
    }

    public void removeSecretStorage(SecretStorage secretStorage) {
        this.fSecretStorages.remove(secretStorage);
    }

    public List getSecretStorages() {
        return this.fSecretStorages;
    }

    public LicenseReader getLicenseReader() {
        return this.fLicenseReader;
    }

    public void setLicenseReader(LicenseReader licenseReader) {
        this.fLicenseReader = licenseReader;
    }

    public void checkLicense(String string, int n, int n2) {
        this.checkLicense(string, n, n2, false);
    }

    public synchronized void checkLicense(String string, int n, int n2, boolean bl) {
        if (this.fLicenseReader == null) {
            throw new IllegalStateException(A[0]);
        }
        boolean bl2 = bl;
        while (true) {
            try {
                LicenseImpl licenseImpl;
                block9: {
                    block8: {
                        licenseImpl = (LicenseImpl)this.fLicenseReader.getLicense(bl2);
                        if (licenseImpl == null) break;
                        if (licenseImpl.getLicenseType() != 3) break block8;
                        this.checkCommercial(licenseImpl, string, n, n2);
                        if (!z) break block9;
                    }
                    this.checkEvaluation(licenseImpl, string, n, n2);
                }
                this.fireProductFeaturesSupported(licenseImpl);
            }
            catch (LicenseOutdatedException licenseOutdatedException) {
                bl2 = true;
                continue;
            }
            catch (Throwable throwable) {
                this.error(throwable);
            }
            break;
        }
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean bl) {
        this.fVerbose = bl;
    }

    protected void error(String string) {
        if (this.isVerbose()) {
            System.err.println(string);
        }
    }

    protected void error(Throwable throwable) {
        if (this.isVerbose()) {
            throwable.printStackTrace();
        }
    }

    protected void fireProductFeaturesSupported(License license) {
        boolean bl = z;
        Iterator iterator = license.getProductFeatureNames().iterator();
        while (iterator.hasNext()) {
            String string;
            this.fireFeatureChecked(this, license, string, license.isProductFeatureSupported(string = (String)iterator.next()) && license.getLicenseState() == 2);
            if (!bl) continue;
        }
    }

    private void saveSecretStorages() {
        boolean bl = z;
        Iterator iterator = this.fSecretStorages.iterator();
        while (iterator.hasNext()) {
            ((SecretStorage)iterator.next()).save();
            if (!bl) continue;
        }
    }

    protected void setLicenseState(LicenseImpl licenseImpl, int n) {
        boolean bl = z;
        licenseImpl.setLicenseState(n);
        switch (n) {
            case 3: {
                this.setAreadyExpired(true);
                if (this.getPreviousExpirationDate() == null) {
                    this.setPreviousExpirationDate(licenseImpl.getLicenseExpireDate());
                }
                this.fireLicenseExpired(this, licenseImpl);
                if (!bl) break;
            }
            case 4: {
                this.fireLicenseInvalid(this, licenseImpl);
                if (!bl) break;
            }
            case 2: {
                if ((licenseImpl.getLicenseType() == 1 || licenseImpl.getLicenseType() == 2) && this.getPreviousExpirationDate() == null) {
                    this.setPreviousExpirationDate(licenseImpl.getLicenseExpireDate());
                }
                this.fireLicenseOk(this, licenseImpl);
            }
        }
    }

    protected boolean checkProductImpl(LicenseImpl licenseImpl, String string, int n, int n2) {
        return licenseImpl.getProduct().equals(string);
    }

    protected boolean checkProduct(LicenseImpl licenseImpl, String string, int n, int n2) {
        boolean bl = this.checkProductImpl(licenseImpl, string, n, n2);
        if (!bl) {
            if (this.fIssueResolver != null && this.fIssueResolver.resolveLicenseInvalid(this)) {
                throw new LicenseOutdatedException();
            }
            this.setLicenseState(licenseImpl, 4);
        }
        return bl;
    }

    protected boolean checkProductVersionsImpl(LicenseImpl licenseImpl, String string, int n, int n2) {
        return licenseImpl.getProductMajorVersion() == n;
    }

    protected boolean checkProductVersions(LicenseImpl licenseImpl, String string, int n, int n2) {
        boolean bl = this.checkProductVersionsImpl(licenseImpl, string, n, n2);
        if (!bl) {
            if (this.fIssueResolver != null && this.fIssueResolver.resolveLicenseInvalid(this)) {
                throw new LicenseOutdatedException();
            }
            this.setLicenseState(licenseImpl, 4);
        }
        return bl;
    }

    protected boolean checkProductFeaturesImpl(LicenseImpl licenseImpl, String string, int n, int n2) {
        return true;
    }

    protected boolean checkProductFeatures(LicenseImpl licenseImpl, String string, int n, int n2) {
        boolean bl = this.checkProductFeaturesImpl(licenseImpl, string, n, n2);
        if (!bl) {
            this.setLicenseState(licenseImpl, 4);
        }
        return bl;
    }

    protected static boolean dateIn(Date date, Date date2, Date date3) {
        return date.getTime() >= date2.getTime() && date3.getTime() > date.getTime();
    }

    protected final boolean checkExpiration(LicenseImpl licenseImpl, String string, int n, int n2) {
        boolean bl = this.checkExpirationImpl(licenseImpl, string, n, n2);
        if (!bl) {
            if (this.fIssueResolver != null && this.fIssueResolver.resolveLicenseExpired(this)) {
                throw new LicenseOutdatedException();
            }
            this.setLicenseState(licenseImpl, 3);
        }
        return bl;
    }

    protected boolean checkExpirationImpl(LicenseImpl licenseImpl, String string, int n, int n2) {
        boolean bl = true;
        if (licenseImpl.getLicenseExpireDate() != null) {
            int n3 = CalendarUtil.getDaysDifference(licenseImpl.getLicenseIssueDate(), licenseImpl.getLicenseExpireDate());
            this.processFlexibleExpirationDate(licenseImpl);
            Date date = new Date();
            bl = LicenseHost.dateIn(date, licenseImpl.getLicenseIssueDate(), licenseImpl.getLicenseExpireDate());
            if (bl && licenseImpl.getLicenseType() == 1) {
                Date date2;
                boolean bl2 = bl = !this.isAlreadyExpired();
                if (bl && (date2 = this.getPreviousExpirationDate()) != null) {
                    Date date3 = LicenseUtils.getLicenseIssueDate(CalendarUtil.incDay(date2, n3));
                    bl = LicenseHost.dateIn(date, date3, date2);
                }
            }
        }
        return bl;
    }

    protected void checkLicenseAcceptance(License license) {
        boolean bl = this.isLicenseAccepted();
        if (!bl && this.fLicenseAcceptanceDelegate != null) {
            bl = this.fLicenseAcceptanceDelegate.acceptLicense(this);
        }
        this.setLicenseAccepted(bl);
    }

    protected void checkCommercial(LicenseImpl licenseImpl, String string, int n, int n2) {
        if (licenseImpl.getLicenseText() == null) {
            licenseImpl.setLicenseText(this.fLicenseTextCommercial);
        }
        this.checkLicenseAcceptance(licenseImpl);
        if (!this.checkProduct(licenseImpl, string, n, n2)) {
            return;
        }
        if (!this.checkProductVersions(licenseImpl, string, n, n2)) {
            return;
        }
        if (!this.checkExpiration(licenseImpl, string, n, n2)) {
            return;
        }
        if (!this.checkProductFeatures(licenseImpl, string, n, n2)) {
            return;
        }
        if (!this.checkActivation(licenseImpl)) {
            return;
        }
        if (!this.checkLicenseLock(licenseImpl)) {
            return;
        }
        this.setLicenseState(licenseImpl, 2);
    }

    protected boolean checkActivation(LicenseImpl licenseImpl) {
        return true;
    }

    protected boolean checkLicenseLock(LicenseImpl licenseImpl) {
        return true;
    }

    protected void checkEvaluation(LicenseImpl licenseImpl, String string, int n, int n2) {
        if (licenseImpl.getLicenseText() == null) {
            licenseImpl.setLicenseText(this.fLicenseTextEvaluation);
        }
        this.checkLicenseAcceptance(licenseImpl);
        if (!this.checkProduct(licenseImpl, string, n, n2)) {
            return;
        }
        if (!this.checkProductVersions(licenseImpl, string, n, n2)) {
            return;
        }
        if (licenseImpl.getLicenseExpireDate() != null && !this.checkExpiration(licenseImpl, string, n, n2)) {
            return;
        }
        if (!this.checkProductFeatures(licenseImpl, string, n, n2)) {
            return;
        }
        if (!this.checkActivation(licenseImpl)) {
            return;
        }
        if (!this.checkLicenseLock(licenseImpl)) {
            return;
        }
        this.setLicenseState(licenseImpl, 2);
    }

    public Date getLicenseExpirationDate(boolean bl) {
        Date date = null;
        License license = this.getLicense();
        if (license.getLicenseType() == 1) {
            date = this.getPreviousExpirationDate();
        }
        if (date == null) {
            date = license.getLicenseExpireDate();
        }
        if (bl && date != null && license.getGracePeriod() != -1) {
            date = CalendarUtil.incDay(date, -license.getGracePeriod());
        }
        return date;
    }

    protected String getPreviousExpirationDatePropertyName() {
        License license = this.getLicense();
        return license != null ? A[1] + String.valueOf(license.getProductMajorVersion()) + "]" : PROPERTY_PREVIOUS_EXPIRATION_DATE;
    }

    public Date getPreviousExpirationDate() {
        return this.loadSecretStorageDateProperty(this.getPreviousExpirationDatePropertyName(), true, null, false);
    }

    protected void setPreviousExpirationDate(Date date) {
        this.saveSecretStorageProperty(this.getPreviousExpirationDatePropertyName(), String.valueOf(date.getTime()));
    }

    public Date loadSecretStorageDateProperty(String string, boolean bl, Date date, boolean bl2) {
        boolean bl3 = z;
        Date date2 = null;
        Iterator iterator = this.fSecretStorages.iterator();
        while (iterator.hasNext()) {
            block9: {
                String string2;
                SecretStorage secretStorage = (SecretStorage)iterator.next();
                if (bl2) {
                    secretStorage.load();
                }
                if ((string2 = secretStorage.getProperty(string)) != null) {
                    try {
                        Date date3 = new Date(Long.parseLong(string2));
                        if (date2 == null) {
                            date2 = date3;
                            if (!bl3) break block9;
                        }
                        if (date2.getTime() >= date3.getTime() && bl) {
                            date2 = date3;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (!bl3) continue;
        }
        if (date2 == null) {
            date2 = date;
        }
        return date2;
    }

    public int loadSecretStorageIntProperty(String string, boolean bl, long l, boolean bl2) {
        return (int)this.loadSecretStorageLongProperty(string, bl, l, bl2);
    }

    public long loadSecretStorageLongProperty(String string, boolean bl, long l, boolean bl2) {
        boolean bl3 = z;
        boolean bl4 = false;
        long l2 = l;
        Iterator iterator = this.fSecretStorages.iterator();
        while (iterator.hasNext()) {
            block7: {
                String string2;
                SecretStorage secretStorage = (SecretStorage)iterator.next();
                if (bl2) {
                    secretStorage.load();
                }
                if ((string2 = secretStorage.getProperty(string)) != null) {
                    try {
                        long l3 = Long.parseLong(string2);
                        if (!bl4) {
                            l2 = l3;
                            bl4 = true;
                            if (!bl3) break block7;
                        }
                        l2 = bl ? Math.max(l2, l3) : Math.min(l2, l3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (!bl3) continue;
        }
        return l2;
    }

    public boolean loadSecretStorageBooleanProperty(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = z;
        boolean bl5 = false;
        boolean bl6 = bl2;
        Iterator iterator = this.fSecretStorages.iterator();
        while (iterator.hasNext()) {
            block6: {
                String string2;
                SecretStorage secretStorage = (SecretStorage)iterator.next();
                if (bl3) {
                    secretStorage.load();
                }
                if ((string2 = secretStorage.getProperty(string)) != null) {
                    try {
                        boolean bl7 = string2.equals(Boolean.TRUE.toString());
                        if (!bl5) {
                            bl6 = bl7;
                            bl5 = true;
                            if (!bl4) break block6;
                        }
                        bl6 = bl ? bl6 || bl7 : bl6 && bl7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (!bl4) continue;
        }
        return bl6;
    }

    public void saveSecretStorageProperty(String string, String string2) {
        boolean bl = z;
        Iterator iterator = this.fSecretStorages.iterator();
        while (iterator.hasNext()) {
            SecretStorage secretStorage = (SecretStorage)iterator.next();
            secretStorage.setProperty(string, string2);
            secretStorage.save();
            if (!bl) continue;
        }
    }

    public String loadSecretStorageProperty(String string, String string2) {
        boolean bl = z;
        String string3 = string2;
        Iterator iterator = this.fSecretStorages.iterator();
        while (iterator.hasNext()) {
            SecretStorage secretStorage = (SecretStorage)iterator.next();
            String string4 = secretStorage.getProperty(string, null);
            if (string4 != null) {
                string3 = string4;
                if (!bl) break;
            }
            if (!bl) continue;
        }
        return string3;
    }

    protected String getAlreadyExpiredPropertyName() {
        License license = this.getLicense();
        return license != null ? A[2] + String.valueOf(license.getProductMajorVersion()) + "]" : PROPERTY_ALREADY_EXPIRED;
    }

    protected boolean isAlreadyExpired() {
        return this.loadSecretStorageBooleanProperty(this.getAlreadyExpiredPropertyName(), true, false, false);
    }

    protected void setAreadyExpired(boolean bl) {
        this.saveSecretStorageProperty(this.getAlreadyExpiredPropertyName(), (bl ? Boolean.TRUE : Boolean.FALSE).toString());
    }

    public void setLicenseAccepted(boolean bl) {
        boolean bl2 = z;
        Iterator iterator = this.fSecretStorages.iterator();
        while (iterator.hasNext()) {
            SecretStorage secretStorage = (SecretStorage)iterator.next();
            secretStorage.setProperty(PROPERTY_LICENSE_ACCEPTED, new Boolean(bl).toString());
            secretStorage.save();
            if (!bl2) continue;
        }
        this.fireLicenseAccepted(this, this.getLicense(), bl);
    }

    public boolean isLicenseAccepted() {
        SecretStorage secretStorage;
        boolean bl = z;
        boolean bl2 = false;
        Iterator iterator = this.fSecretStorages.iterator();
        while (iterator.hasNext() && (!(bl2 = (secretStorage = (SecretStorage)iterator.next()).getProperty(PROPERTY_LICENSE_ACCEPTED, Boolean.FALSE.toString()).equals(Boolean.TRUE.toString())) || bl) && !bl) {
        }
        return bl2;
    }

    public synchronized void addLicenseHostListener(LicenseHostListener licenseHostListener) {
        Vector vector;
        Vector vector2 = vector = this.fLicenseHostListeners == null ? new Vector(2) : (Vector)this.fLicenseHostListeners.clone();
        if (!vector.contains(licenseHostListener)) {
            vector.addElement(licenseHostListener);
            this.fLicenseHostListeners = vector;
        }
        if (this.fLicenseReader != null && licenseHostListener instanceof LicenseReaderListener) {
            this.fLicenseReader.addLicenseReaderListener((LicenseReaderListener)((Object)licenseHostListener));
        }
    }

    public synchronized void removeLicenseHostListener(LicenseHostListener licenseHostListener) {
        if (this.fLicenseHostListeners != null && this.fLicenseHostListeners.contains(licenseHostListener)) {
            Vector vector = (Vector)this.fLicenseHostListeners.clone();
            vector.removeElement(licenseHostListener);
            this.fLicenseHostListeners = vector;
        }
        if (this.fLicenseReader != null && licenseHostListener instanceof LicenseReaderListener) {
            this.fLicenseReader.removeLicenseReaderListener((LicenseReaderListener)((Object)licenseHostListener));
        }
    }

    protected void fireLicenseAccepted(LicenseHost licenseHost, License license, boolean bl) {
        boolean bl2 = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseHostListener)vector.elementAt(i)).licenseAccepted(licenseHost, license, bl);
                if (!bl2) continue;
            }
        }
    }

    protected void fireLicenseExpired(LicenseHost licenseHost, License license) {
        boolean bl = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseHostListener)vector.elementAt(i)).licenseExpired(licenseHost, license);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseOk(LicenseHost licenseHost, License license) {
        boolean bl = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseHostListener)vector.elementAt(i)).licenseOk(licenseHost, license);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseInvalid(LicenseHost licenseHost, License license) {
        boolean bl = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseHostListener)vector.elementAt(i)).licenseInvalid(licenseHost, license);
                if (!bl) continue;
            }
        }
    }

    protected void fireFeatureChecked(LicenseHost licenseHost, License license, String string, boolean bl) {
        boolean bl2 = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseHostListener)vector.elementAt(i)).featureChecked(licenseHost, license, string, bl);
                if (!bl2) continue;
            }
        }
    }

    public License getLicense() {
        return this.fLicenseReader.getLicense();
    }

    public License getLicense(boolean bl) {
        return this.fLicenseReader.getLicense(bl);
    }

    public boolean isAllowFlexibleExpirationDate() {
        return this.fAllowFlexibleExpirationDate;
    }

    public void setAllowFlexibleExpirationDate(boolean bl) {
        this.fAllowFlexibleExpirationDate = bl;
    }

    protected boolean isFlexibleExpirationDateProcessed(LicenseImpl licenseImpl) {
        return licenseImpl.getProperty(PROPERTY_FLEXIBLE_EXP_DATE_PROCESSED, null) != null;
    }

    protected void setFlexibleExpirationDateProcessed(LicenseImpl licenseImpl, boolean bl) {
        licenseImpl.putProperty(PROPERTY_FLEXIBLE_EXP_DATE_PROCESSED, bl ? Boolean.TRUE.toString() : null);
    }

    protected void processFlexibleExpirationDate(LicenseImpl licenseImpl) {
        if (licenseImpl.getLicenseType() == 1 && this.isAllowFlexibleExpirationDate() && !this.isFlexibleExpirationDateProcessed(licenseImpl)) {
            Date date = LicenseUtils.getLicenseIssueDate(new Date());
            date.setTime(date.getTime() + licenseImpl.getLicenseExpireDate().getTime() - licenseImpl.getLicenseIssueDate().getTime());
            licenseImpl.setLicenseExpireDate(date);
            this.setFlexibleExpirationDateProcessed(licenseImpl, true);
        }
    }

    public void release() {
    }

    public static String loadText(Class clazz, String string) {
        return StreamUtil.loadText(string, clazz);
    }

    public String getLicenseExpireInfo(License license) {
        Date date;
        String string = null;
        if (license.getLicenseState() != 3 && (date = this.getLicenseExpirationDate(true)) != null) {
            string = DATE_FORMAT.format(date);
        }
        return string;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block98: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block97: {
                char[] cArray3;
                Object var0;
                block96: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block95: {
                        char[] cArray5;
                        block94: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block93: {
                                char[] cArray7;
                                block92: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block91: {
                                        char[] cArray9;
                                        block90: {
                                            int n10;
                                            int n11;
                                            char[] cArray10;
                                            block89: {
                                                char[] cArray11;
                                                block88: {
                                                    int n12;
                                                    int n13;
                                                    char[] cArray12;
                                                    block87: {
                                                        char[] cArray13;
                                                        block86: {
                                                            int n14;
                                                            int n15;
                                                            char[] cArray14;
                                                            block85: {
                                                                char[] cArray15;
                                                                block84: {
                                                                    int n16;
                                                                    int n17;
                                                                    char[] cArray16;
                                                                    block83: {
                                                                        char[] cArray17;
                                                                        block82: {
                                                                            int n18;
                                                                            int n19;
                                                                            char[] cArray18;
                                                                            block81: {
                                                                                stringArray = new String[3];
                                                                                var0 = null;
                                                                                char[] cArray19 = "Z\u0011a\u0007FE\u001dC\u0001KS\bv\u0007L".toCharArray();
                                                                                n3 = 0;
                                                                                int n20 = cArray19.length;
                                                                                cArray18 = cArray19;
                                                                                n19 = n20;
                                                                                if (n20 <= 1) break block81;
                                                                                cArray17 = cArray18;
                                                                                n18 = n19;
                                                                                if (n19 <= n3) break block82;
                                                                            }
                                                                            do {
                                                                                char[] cArray20 = cArray18;
                                                                                char[] cArray21 = cArray18;
                                                                                int n21 = n3;
                                                                                while (true) {
                                                                                    int n22;
                                                                                    char c = cArray20[n21];
                                                                                    switch (n3 % 5) {
                                                                                        case 0: {
                                                                                            n22 = 54;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n22 = 120;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n22 = 2;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n22 = 98;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n22 = 40;
                                                                                        }
                                                                                    }
                                                                                    cArray20[n21] = (char)(c ^ n22);
                                                                                    ++n3;
                                                                                    cArray18 = cArray21;
                                                                                    n19 = n19;
                                                                                    if (n19 != 0) break;
                                                                                    cArray21 = cArray18;
                                                                                    n18 = n19;
                                                                                    n21 = n19;
                                                                                    cArray20 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n18 = n19;
                                                                            } while (n19 > n3);
                                                                        }
                                                                        PROPERTY_LICENSE_ACCEPTED = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray22 = "W\u0014p\u0007IR\u0001G\u001aX_\ng\u0006".toCharArray();
                                                                        n3 = 0;
                                                                        int n23 = cArray22.length;
                                                                        cArray16 = cArray22;
                                                                        n17 = n23;
                                                                        if (n23 <= 1) break block83;
                                                                        cArray15 = cArray16;
                                                                        n16 = n17;
                                                                        if (n17 <= n3) break block84;
                                                                    }
                                                                    do {
                                                                        char[] cArray23 = cArray16;
                                                                        char[] cArray24 = cArray16;
                                                                        int n24 = n3;
                                                                        while (true) {
                                                                            int n25;
                                                                            char c = cArray23[n24];
                                                                            switch (n3 % 5) {
                                                                                case 0: {
                                                                                    n25 = 54;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n25 = 120;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n25 = 2;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n25 = 98;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n25 = 40;
                                                                                }
                                                                            }
                                                                            cArray23[n24] = (char)(c ^ n25);
                                                                            ++n3;
                                                                            cArray16 = cArray24;
                                                                            n17 = n17;
                                                                            if (n17 != 0) break;
                                                                            cArray24 = cArray16;
                                                                            n16 = n17;
                                                                            n24 = n17;
                                                                            cArray23 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n16 = n17;
                                                                    } while (n17 > n3);
                                                                }
                                                                PROPERTY_ALREADY_EXPIRED = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray25 = "F\ng\u0014AY\rq'PF\u0011p\u0003\\_\u0017l&IB\u001d".toCharArray();
                                                                n3 = 0;
                                                                int n26 = cArray25.length;
                                                                cArray14 = cArray25;
                                                                n15 = n26;
                                                                if (n26 <= 1) break block85;
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                                if (n15 <= n3) break block86;
                                                            }
                                                            do {
                                                                char[] cArray26 = cArray14;
                                                                char[] cArray27 = cArray14;
                                                                int n27 = n3;
                                                                while (true) {
                                                                    int n28;
                                                                    char c = cArray26[n27];
                                                                    switch (n3 % 5) {
                                                                        case 0: {
                                                                            n28 = 54;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n28 = 120;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n28 = 2;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n28 = 98;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n28 = 40;
                                                                        }
                                                                    }
                                                                    cArray26[n27] = (char)(c ^ n28);
                                                                    ++n3;
                                                                    cArray14 = cArray27;
                                                                    n15 = n15;
                                                                    if (n15 != 0) break;
                                                                    cArray27 = cArray14;
                                                                    n14 = n15;
                                                                    n27 = n15;
                                                                    cArray26 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                            } while (n15 > n3);
                                                        }
                                                        PROPERTY_PREVIOUS_EXPIRATION_DATE = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray28 = "\u0012\\n\u0012Zi\u001en\u0007Pi\u001dz\u0012wR\u0019v\u0007wF\nm\u0001ME\u000bg\u0006\f\u0012".toCharArray();
                                                        n3 = 0;
                                                        int n29 = cArray28.length;
                                                        cArray12 = cArray28;
                                                        n13 = n29;
                                                        if (n29 <= 1) break block87;
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                        if (n13 <= n3) break block88;
                                                    }
                                                    do {
                                                        char[] cArray29 = cArray12;
                                                        char[] cArray30 = cArray12;
                                                        int n30 = n3;
                                                        while (true) {
                                                            int n31;
                                                            char c = cArray29[n30];
                                                            switch (n3 % 5) {
                                                                case 0: {
                                                                    n31 = 54;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n31 = 120;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n31 = 2;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n31 = 98;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n31 = 40;
                                                                }
                                                            }
                                                            cArray29[n30] = (char)(c ^ n31);
                                                            ++n3;
                                                            cArray12 = cArray30;
                                                            n13 = n13;
                                                            if (n13 != 0) break;
                                                            cArray30 = cArray12;
                                                            n12 = n13;
                                                            n30 = n13;
                                                            cArray29 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                    } while (n13 > n3);
                                                }
                                                PROPERTY_FLEXIBLE_EXP_DATE_PROCESSED = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray31 = "Z\u0011a\u0007FE\u001dJ\r[B0k\f\\\u001b\u001bn\u0007ID(p\u0007^_\u0017w\u0011{^\rv\u0006GA\u0016F\u0003\\S".toCharArray();
                                                n3 = 0;
                                                int n32 = cArray31.length;
                                                cArray10 = cArray31;
                                                n11 = n32;
                                                if (n32 <= 1) break block89;
                                                cArray9 = cArray10;
                                                n10 = n11;
                                                if (n11 <= n3) break block90;
                                            }
                                            do {
                                                char[] cArray32 = cArray10;
                                                char[] cArray33 = cArray10;
                                                int n33 = n3;
                                                while (true) {
                                                    int n34;
                                                    char c = cArray32[n33];
                                                    switch (n3 % 5) {
                                                        case 0: {
                                                            n34 = 54;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n34 = 120;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n34 = 2;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n34 = 98;
                                                            break;
                                                        }
                                                        default: {
                                                            n34 = 40;
                                                        }
                                                    }
                                                    cArray32[n33] = (char)(c ^ n34);
                                                    ++n3;
                                                    cArray10 = cArray33;
                                                    n11 = n11;
                                                    if (n11 != 0) break;
                                                    cArray33 = cArray10;
                                                    n10 = n11;
                                                    n33 = n11;
                                                    cArray32 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n10 = n11;
                                            } while (n11 > n3);
                                        }
                                        LICENSE_HOST_HINT_CLEAR_PREVIOUS_SHUTDOWN_DATE = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray34 = "F\ng\u0014AY\rq1@C\ff\r_X<c\u0016M".toCharArray();
                                        n3 = 0;
                                        int n35 = cArray34.length;
                                        cArray8 = cArray34;
                                        n9 = n35;
                                        if (n35 <= 1) break block91;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block92;
                                    }
                                    do {
                                        char[] cArray35 = cArray8;
                                        char[] cArray36 = cArray8;
                                        int n36 = n3;
                                        while (true) {
                                            int n37;
                                            char c = cArray35[n36];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n37 = 54;
                                                    break;
                                                }
                                                case 1: {
                                                    n37 = 120;
                                                    break;
                                                }
                                                case 2: {
                                                    n37 = 2;
                                                    break;
                                                }
                                                case 3: {
                                                    n37 = 98;
                                                    break;
                                                }
                                                default: {
                                                    n37 = 40;
                                                }
                                            }
                                            cArray35[n36] = (char)(c ^ n37);
                                            ++n3;
                                            cArray8 = cArray36;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray36 = cArray8;
                                            n8 = n9;
                                            n36 = n9;
                                            cArray35 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                PROPERTY_PREVIOUS_SHUTDOWN_DATE = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray37 = "z\u0011a\u0007FE\u001d\"\u0010MW\u001cg\u0010\b_\u000b\"\fGBXq\u0012MU\u0011d\u000bMR".toCharArray();
                                n3 = 0;
                                int n38 = cArray37.length;
                                cArray6 = cArray37;
                                n7 = n38;
                                if (n38 <= 1) break block93;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block94;
                            }
                            do {
                                char[] cArray38 = cArray6;
                                char[] cArray39 = cArray6;
                                int n39 = n3;
                                while (true) {
                                    int n40;
                                    char c = cArray38[n39];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n40 = 54;
                                            break;
                                        }
                                        case 1: {
                                            n40 = 120;
                                            break;
                                        }
                                        case 2: {
                                            n40 = 2;
                                            break;
                                        }
                                        case 3: {
                                            n40 = 98;
                                            break;
                                        }
                                        default: {
                                            n40 = 40;
                                        }
                                    }
                                    cArray38[n39] = (char)(c ^ n40);
                                    ++n3;
                                    cArray6 = cArray39;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray39 = cArray6;
                                    n6 = n7;
                                    n39 = n7;
                                    cArray38 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[0] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray40 = "F\ng\u0014AY\rq'PF\u0011p\u0003\\_\u0017l&IB\u001dY".toCharArray();
                        n3 = 0;
                        int n41 = cArray40.length;
                        cArray4 = cArray40;
                        n5 = n41;
                        if (n41 <= 1) break block95;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block96;
                    }
                    do {
                        char[] cArray41 = cArray4;
                        char[] cArray42 = cArray4;
                        int n42 = n3;
                        while (true) {
                            int n43;
                            char c = cArray41[n42];
                            switch (n3 % 5) {
                                case 0: {
                                    n43 = 54;
                                    break;
                                }
                                case 1: {
                                    n43 = 120;
                                    break;
                                }
                                case 2: {
                                    n43 = 2;
                                    break;
                                }
                                case 3: {
                                    n43 = 98;
                                    break;
                                }
                                default: {
                                    n43 = 40;
                                }
                            }
                            cArray41[n42] = (char)(c ^ n43);
                            ++n3;
                            cArray4 = cArray42;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray42 = cArray4;
                            n4 = n5;
                            n42 = n5;
                            cArray41 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[1] = new String(cArray3).intern();
                var0 = null;
                char[] cArray43 = "W\u0014p\u0007IR\u0001G\u001aX_\ng\u0006s".toCharArray();
                n3 = 0;
                int n44 = cArray43.length;
                cArray2 = cArray43;
                n2 = n44;
                if (n44 <= 1) break block97;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block98;
            }
            do {
                char[] cArray44 = cArray2;
                char[] cArray45 = cArray2;
                int n45 = n3;
                while (true) {
                    int n46;
                    char c = cArray44[n45];
                    switch (n3 % 5) {
                        case 0: {
                            n46 = 54;
                            break;
                        }
                        case 1: {
                            n46 = 120;
                            break;
                        }
                        case 2: {
                            n46 = 2;
                            break;
                        }
                        case 3: {
                            n46 = 98;
                            break;
                        }
                        default: {
                            n46 = 40;
                        }
                    }
                    cArray44[n45] = (char)(c ^ n46);
                    ++n3;
                    cArray2 = cArray45;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray45 = cArray2;
                    n = n2;
                    n45 = n2;
                    cArray44 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[2] = new String(cArray).intern();
        A = stringArray;
        DATE_FORMAT = DateFormat.getDateInstance(3);
    }
}

