/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseHost;
import com.jp.protection.pub.LicenseImpl;
import com.jp.protection.pub.LicenseOutdatedException;
import com.jp.protection.pub.LicenseReaderIssueResolver;
import com.jp.protection.pub.LicenseReaderListener;
import com.jp.protection.security.SecurityProvider;
import com.jp.protection.security.SecurityProviderFactory;
import com.jp.protection.utils.CustomCRC32;
import com.jp.protection.utils.LicenseUtils;
import dev.util.StreamUtil;
import dev.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Properties;
import java.util.Vector;

public class LicenseReader {
    private transient Vector fLicenseReaderListeners;
    protected License fLicense;
    protected String fLicenseFileName = A[1];
    protected boolean fUserHomeRelative = true;
    protected String fLicenseFolder = "";
    protected String fLicenseResourceFolder = "";
    protected boolean fLicenseRead = false;
    protected boolean fVerbose = false;
    protected boolean fSkipEncryption = true;
    protected byte[] fDecryptKeyBytes;
    protected LicenseReaderIssueResolver fLicenseReaderIssueResolver;
    protected boolean fSearchLicenseInFile = true;
    protected SecurityProvider fSecurityProvider;
    protected String fSecurityAlgorithm = A[2];
    protected Class fClassForLoadLicenseResource;
    static /* synthetic */ Class class$com$jp$protection$pub$LicenseReader;
    public static /* synthetic */ int z;
    private static final /* synthetic */ String[] A;

    public String getLicenseResourceFolder() {
        return this.fLicenseResourceFolder;
    }

    public void setLicenseResourceFolder(String string) {
        this.fLicenseResourceFolder = string;
    }

    public byte[] getDecryptKeyBytes() {
        return this.fDecryptKeyBytes;
    }

    public void setDecryptKeyBytes(byte[] byArray) {
        this.fDecryptKeyBytes = byArray;
    }

    public void setDecryptKeyBytes(String string) {
        boolean bl = LicenseHost.z;
        String[] stringArray = string.split(",");
        this.fDecryptKeyBytes = new byte[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.fDecryptKeyBytes[i] = Byte.parseByte(stringArray[i].trim());
            if (!bl) continue;
        }
    }

    public byte[] getPrivateKeyBytes() {
        return this.getDecryptKeyBytes();
    }

    public void setPrivateKeyBytes(byte[] byArray) {
        this.setDecryptKeyBytes(byArray);
    }

    public void setPrivateKeyBytes(String string) {
        this.setDecryptKeyBytes(string);
    }

    public boolean isLicenseRead() {
        return this.fLicenseRead;
    }

    public boolean isSkipEncryption() {
        return this.fSkipEncryption;
    }

    public void setSkipEncryption(boolean bl) {
        this.fSkipEncryption = bl;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean bl) {
        this.fVerbose = bl;
    }

    protected void error(String string) {
        if (this.isVerbose()) {
            System.err.println(string);
        }
    }

    protected void error(Throwable throwable) {
        if (this.isVerbose()) {
            throwable.printStackTrace();
        }
    }

    public boolean isUserHomeRelative() {
        return this.fUserHomeRelative;
    }

    public void setUserHomeRelative(boolean bl) {
        this.fUserHomeRelative = bl;
    }

    public String getLicenseFileName() {
        return this.fLicenseFileName;
    }

    public void setLicenseFileName(String string) {
        this.fLicenseFileName = string;
    }

    public String getLicenseFolder() {
        return this.fLicenseFolder;
    }

    public void setLicenseFolder(String string) {
        this.fLicenseFolder = string;
    }

    public License getLicense() {
        return this.getLicense(false);
    }

    public License getLicense(boolean bl) {
        if (!this.isLicenseRead() || bl) {
            this.readLicense();
        }
        return this.fLicense;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void readLicense() {
        boolean bl = LicenseHost.z;
        this.fLicenseRead = true;
        this.fLicense = null;
        try {
            InputStream inputStream = this.getLicenseInputStream();
            while (true) {
                try {
                    while (true) {
                        block8: {
                            block9: {
                                if (inputStream != null) break block8;
                                if (this.fLicenseReaderIssueResolver == null || !this.fLicenseReaderIssueResolver.resolveLicenseMissing(this)) break block9;
                                inputStream = this.getLicenseFileInputStream();
                                if (!bl) break block8;
                            }
                            this.fireLicenseMissing(this, this.getLicenseFileLocation());
                            if (!bl) return;
                        }
                        if (inputStream == null) continue;
                        this.readLicense(inputStream, inputStream instanceof FileInputStream ? this.getLicenseFileLocation() : this.getLicenseResourceLocation());
                        if (!bl) return;
                    }
                }
                catch (LicenseOutdatedException licenseOutdatedException) {
                    inputStream = this.getLicenseFileInputStream();
                    if (!bl) continue;
                    return;
                }
                break;
            }
        }
        catch (IOException iOException) {
            this.error(iOException);
        }
    }

    public boolean isSearchLicenseInFile() {
        return this.fSearchLicenseInFile;
    }

    public void setSearchLicenseInFile(boolean bl) {
        this.fSearchLicenseInFile = bl;
    }

    public InputStream getLicenseInputStream() {
        InputStream inputStream;
        InputStream inputStream2 = inputStream = this.fSearchLicenseInFile ? this.getLicenseFileInputStream() : this.getLicenseResourceInputStream();
        if (inputStream == null) {
            inputStream = this.fSearchLicenseInFile ? this.getLicenseResourceInputStream() : this.getLicenseFileInputStream();
        }
        return inputStream;
    }

    public OutputStream getLicenseOutputStream() {
        this.checkLicenseFile();
        FileOutputStream fileOutputStream = null;
        if (this.fLicenseFolder != null) {
            try {
                File file = this.getLicenseFile();
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists() || file.canWrite()) {
                    fileOutputStream = new FileOutputStream(file);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error(fileNotFoundException);
            }
        }
        return fileOutputStream;
    }

    private void checkLicenseFile() throws IllegalStateException {
        if (this.fLicenseFileName == null) {
            throw new IllegalStateException(A[3]);
        }
        if (this.fLicenseFolder == null && this.fLicenseResourceFolder == null) {
            throw new IllegalStateException(A[4]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readLicense(InputStream inputStream, String string) throws IOException {
        block7: {
            block9: {
                byte[] byArray;
                boolean bl;
                block8: {
                    block6: {
                        bl = LicenseHost.z;
                        this.fLicenseRead = true;
                        this.fLicense = null;
                        byArray = null;
                        try {
                            byArray = this.smartGetLicenseBytes(inputStream);
                        }
                        finally {
                            inputStream.close();
                        }
                        if (byArray != null) break block6;
                        this.fireLicenseCorrupted(this, string);
                        if (!bl) break block7;
                    }
                    if ((byArray = this.smartDecodeLicense(byArray)) != null) break block8;
                    this.fireLicenseCorrupted(this, string);
                    if (!bl) break block7;
                }
                this.smartReadLicense(byArray);
                if (this.fLicense == null) break block9;
                ((LicenseImpl)this.fLicense).setLicenseLocation(string);
                this.fireLicenseAvailable(this, string);
                if (!bl) break block7;
            }
            this.fireLicenseCorrupted(this, string);
        }
    }

    protected byte[] smartDecodeLicense(byte[] byArray) {
        byte[] byArray2 = this.decodeLicense(byArray);
        if (byArray2 == null && this.fLicenseReaderIssueResolver != null && this.fLicenseReaderIssueResolver.resolveLicenseCorrupted(this)) {
            throw new LicenseOutdatedException();
        }
        return byArray2;
    }

    protected byte[] decodeLicense(byte[] byArray) {
        byte[] byArray2 = byArray;
        if (!this.isSkipEncryption()) {
            try {
                SecurityProvider securityProvider = this.getSecurityProvider();
                PublicKey publicKey = securityProvider.getPublicKey(this.fDecryptKeyBytes);
                byArray2 = securityProvider.decode(byArray, publicKey);
            }
            catch (Exception exception) {
                byArray2 = null;
                this.error(exception);
            }
        }
        return byArray2;
    }

    public String getSecurityAlgorithm() {
        return this.fSecurityAlgorithm;
    }

    public void setSecurityAlgorithm(String string) {
        if (string == null) {
            throw new IllegalArgumentException(A[5]);
        }
        this.fSecurityAlgorithm = string;
        this.fSecurityProvider = null;
    }

    protected SecurityProvider getSecurityProvider() {
        if (this.fSecurityProvider == null) {
            this.fSecurityProvider = SecurityProviderFactory.getSecurityProvider(this.fSecurityAlgorithm);
        }
        return this.fSecurityProvider;
    }

    protected void smartReadLicense(byte[] byArray) {
        this.readLicense(byArray);
        if (this.fLicense == null && this.fLicenseReaderIssueResolver != null && this.fLicenseReaderIssueResolver.resolveLicenseCorrupted(this)) {
            throw new LicenseOutdatedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readLicense(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                Properties properties = new Properties();
                properties.load(byteArrayInputStream);
                this.fLicense = new LicenseImpl();
                LicenseUtils.load(this.fLicense, properties);
            }
            finally {
                ((InputStream)byteArrayInputStream).close();
            }
        }
        catch (Exception exception) {
            this.fLicense = null;
            this.error(exception);
        }
    }

    public String getLicenseProduct(InputStream inputStream) {
        String string = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            string = dataInputStream.readUTF();
        }
        catch (Exception exception) {
            this.error(exception);
        }
        return string;
    }

    protected byte[] smartGetLicenseBytes(InputStream inputStream) {
        byte[] byArray = this.getLicenseBytes(inputStream);
        if (byArray == null && this.fLicenseReaderIssueResolver != null && this.fLicenseReaderIssueResolver.resolveLicenseCorrupted(this)) {
            throw new LicenseOutdatedException();
        }
        return byArray;
    }

    protected byte[] getLicenseBytes(InputStream inputStream) {
        byte[] byArray = null;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            int n;
            String string = dataInputStream.readUTF();
            this.fireLicenseAboutToRead(this, string);
            long l = dataInputStream.readLong();
            int n2 = dataInputStream.available();
            byArray = new byte[n2];
            int n3 = 0;
            do {
                n = dataInputStream.read(byArray, n3, n2);
                n3 += n;
            } while (n != -1 && (n2 -= n) > 0);
            CustomCRC32 customCRC32 = new CustomCRC32();
            customCRC32.proceed(byArray);
            if (l != customCRC32.getCRC() && inputStream instanceof FileInputStream) {
                byArray = null;
            }
        }
        catch (IOException iOException) {
            this.error(iOException);
            byArray = null;
        }
        return byArray;
    }

    public String getLicenseFileLocation() {
        return this.getLicenseFile().toString();
    }

    public String getLicenseResourceLocation() {
        String string = this.fLicenseFileName;
        if (!StringUtils.noValue(this.fLicenseResourceFolder)) {
            string = this.fLicenseResourceFolder.endsWith("/") ? this.fLicenseResourceFolder + string : this.fLicenseResourceFolder + "/" + string;
        }
        return string;
    }

    public InputStream getLicenseFileInputStream() {
        this.checkLicenseFile();
        FileInputStream fileInputStream = null;
        if (this.fLicenseFolder != null) {
            try {
                File file = this.getLicenseFile();
                if (file.canRead()) {
                    fileInputStream = new FileInputStream(file);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error(fileNotFoundException);
            }
        }
        return fileInputStream;
    }

    public InputStream getLicenseResourceInputStream() {
        return (this.fClassForLoadLicenseResource != null ? this.fClassForLoadLicenseResource : (class$com$jp$protection$pub$LicenseReader == null ? (class$com$jp$protection$pub$LicenseReader = LicenseReader.class$(A[6])) : class$com$jp$protection$pub$LicenseReader)).getResourceAsStream(this.getLicenseResourceLocation());
    }

    public Class getClassForLoadLicenseResource() {
        return this.fClassForLoadLicenseResource;
    }

    public void setClassForLoadLicenseResource(Class clazz) {
        this.fClassForLoadLicenseResource = clazz;
    }

    public File getLicenseFile() {
        File file = null;
        file = this.isUserHomeRelative() ? new File(new File(System.getProperties().getProperty(A[0]), this.fLicenseFolder), this.fLicenseFileName) : (!StringUtils.noValue(this.fLicenseFolder) ? new File(this.fLicenseFolder, this.fLicenseFileName) : new File(this.fLicenseFileName));
        return file;
    }

    public synchronized void addLicenseReaderListener(LicenseReaderListener licenseReaderListener) {
        Vector vector;
        Vector vector2 = vector = this.fLicenseReaderListeners == null ? new Vector(2) : (Vector)this.fLicenseReaderListeners.clone();
        if (!vector.contains(licenseReaderListener)) {
            vector.addElement(licenseReaderListener);
            this.fLicenseReaderListeners = vector;
        }
    }

    public synchronized void removeLicenseReaderListener(LicenseReaderListener licenseReaderListener) {
        if (this.fLicenseReaderListeners != null && this.fLicenseReaderListeners.contains(licenseReaderListener)) {
            Vector vector = (Vector)this.fLicenseReaderListeners.clone();
            vector.removeElement(licenseReaderListener);
            this.fLicenseReaderListeners = vector;
        }
    }

    protected void fireLicenseMissing(LicenseReader licenseReader, String string) {
        boolean bl = LicenseHost.z;
        if (this.fLicenseReaderListeners != null) {
            Vector vector = this.fLicenseReaderListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseReaderListener)vector.elementAt(i)).licenseMissing(licenseReader, string);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseCorrupted(LicenseReader licenseReader, String string) {
        boolean bl = LicenseHost.z;
        if (this.fLicenseReaderListeners != null) {
            Vector vector = this.fLicenseReaderListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseReaderListener)vector.elementAt(i)).licenseCorrupted(licenseReader, string);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseAvailable(LicenseReader licenseReader, String string) {
        boolean bl = LicenseHost.z;
        if (this.fLicenseReaderListeners != null) {
            Vector vector = this.fLicenseReaderListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseReaderListener)vector.elementAt(i)).licenseAvailable(licenseReader, string);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseAboutToRead(LicenseReader licenseReader, String string) {
        boolean bl = LicenseHost.z;
        if (this.fLicenseReaderListeners != null) {
            Vector vector = this.fLicenseReaderListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseReaderListener)vector.elementAt(i)).licenseAboutToRead(licenseReader, string);
                if (!bl) continue;
            }
        }
    }

    public LicenseReaderIssueResolver getIssueResolver() {
        return this.fLicenseReaderIssueResolver;
    }

    public void setIssueResolver(LicenseReaderIssueResolver licenseReaderIssueResolver) {
        this.fLicenseReaderIssueResolver = licenseReaderIssueResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getLicenseBytes() {
        byte[] byArray = null;
        InputStream inputStream = this.getLicenseInputStream();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                StreamUtil.copy(inputStream, byteArrayOutputStream);
                byteArrayOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block76: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block75: {
                char[] cArray3;
                Object var0;
                block74: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block73: {
                        char[] cArray5;
                        block72: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block71: {
                                char[] cArray7;
                                block70: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block69: {
                                        char[] cArray9;
                                        block68: {
                                            int n10;
                                            int n11;
                                            char[] cArray10;
                                            block67: {
                                                char[] cArray11;
                                                block66: {
                                                    int n12;
                                                    int n13;
                                                    char[] cArray12;
                                                    block65: {
                                                        char[] cArray13;
                                                        block64: {
                                                            int n14;
                                                            int n15;
                                                            char[] cArray14;
                                                            block63: {
                                                                stringArray = new String[7];
                                                                var0 = null;
                                                                char[] cArray15 = "\u0006{:F`\u001bg2Q".toCharArray();
                                                                n3 = 0;
                                                                int n16 = cArray15.length;
                                                                cArray14 = cArray15;
                                                                n15 = n16;
                                                                if (n16 <= 1) break block63;
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                                if (n15 <= n3) break block64;
                                                            }
                                                            do {
                                                                char[] cArray16 = cArray14;
                                                                char[] cArray17 = cArray14;
                                                                int n17 = n3;
                                                                while (true) {
                                                                    int n18;
                                                                    char c = cArray16[n17];
                                                                    switch (n3 % 5) {
                                                                        case 0: {
                                                                            n18 = 115;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n18 = 8;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n18 = 95;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n18 = 52;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n18 = 78;
                                                                        }
                                                                    }
                                                                    cArray16[n17] = (char)(c ^ n18);
                                                                    ++n3;
                                                                    cArray14 = cArray17;
                                                                    n15 = n15;
                                                                    if (n15 != 0) break;
                                                                    cArray17 = cArray14;
                                                                    n14 = n15;
                                                                    n17 = n15;
                                                                    cArray16 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                            } while (n15 > n3);
                                                        }
                                                        stringArray[0] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray18 = "\u001fa<Q \u0000mq_+\n".toCharArray();
                                                        n3 = 0;
                                                        int n19 = cArray18.length;
                                                        cArray12 = cArray18;
                                                        n13 = n19;
                                                        if (n19 <= 1) break block65;
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                        if (n13 <= n3) break block66;
                                                    }
                                                    do {
                                                        char[] cArray19 = cArray12;
                                                        char[] cArray20 = cArray12;
                                                        int n20 = n3;
                                                        while (true) {
                                                            int n21;
                                                            char c = cArray19[n20];
                                                            switch (n3 % 5) {
                                                                case 0: {
                                                                    n21 = 115;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n21 = 8;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n21 = 95;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n21 = 52;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n21 = 78;
                                                                }
                                                            }
                                                            cArray19[n20] = (char)(c ^ n21);
                                                            ++n3;
                                                            cArray12 = cArray20;
                                                            n13 = n13;
                                                            if (n13 != 0) break;
                                                            cArray20 = cArray12;
                                                            n12 = n13;
                                                            n20 = n13;
                                                            cArray19 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                    } while (n13 > n3);
                                                }
                                                stringArray[1] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray21 = "![\u001e".toCharArray();
                                                n3 = 0;
                                                int n22 = cArray21.length;
                                                cArray10 = cArray21;
                                                n11 = n22;
                                                if (n22 <= 1) break block67;
                                                cArray9 = cArray10;
                                                n10 = n11;
                                                if (n11 <= n3) break block68;
                                            }
                                            do {
                                                char[] cArray22 = cArray10;
                                                char[] cArray23 = cArray10;
                                                int n23 = n3;
                                                while (true) {
                                                    int n24;
                                                    char c = cArray22[n23];
                                                    switch (n3 % 5) {
                                                        case 0: {
                                                            n24 = 115;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n24 = 8;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n24 = 95;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n24 = 52;
                                                            break;
                                                        }
                                                        default: {
                                                            n24 = 78;
                                                        }
                                                    }
                                                    cArray22[n23] = (char)(c ^ n24);
                                                    ++n3;
                                                    cArray10 = cArray23;
                                                    n11 = n11;
                                                    if (n11 != 0) break;
                                                    cArray23 = cArray10;
                                                    n10 = n11;
                                                    n23 = n11;
                                                    cArray22 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n10 = n11;
                                            } while (n11 > n3);
                                        }
                                        stringArray[2] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray24 = "?a<Q \u0000m\u007fR'\u001fm\u007fZ/\u001em\u007f]=Sf0@n\u0000x:W'\u0015a:P".toCharArray();
                                        n3 = 0;
                                        int n25 = cArray24.length;
                                        cArray8 = cArray24;
                                        n9 = n25;
                                        if (n25 <= 1) break block69;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block70;
                                    }
                                    do {
                                        char[] cArray25 = cArray8;
                                        char[] cArray26 = cArray8;
                                        int n26 = n3;
                                        while (true) {
                                            int n27;
                                            char c = cArray25[n26];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n27 = 115;
                                                    break;
                                                }
                                                case 1: {
                                                    n27 = 8;
                                                    break;
                                                }
                                                case 2: {
                                                    n27 = 95;
                                                    break;
                                                }
                                                case 3: {
                                                    n27 = 52;
                                                    break;
                                                }
                                                default: {
                                                    n27 = 78;
                                                }
                                            }
                                            cArray25[n26] = (char)(c ^ n27);
                                            ++n3;
                                            cArray8 = cArray26;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray26 = cArray8;
                                            n8 = n9;
                                            n26 = n9;
                                            cArray25 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                stringArray[3] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray27 = "?a<Q \u0000m\u007fX!\u0010i+]!\u001d(6Gn\u001dg+\u0014=\u0003m<](\u001am;".toCharArray();
                                n3 = 0;
                                int n28 = cArray27.length;
                                cArray6 = cArray27;
                                n7 = n28;
                                if (n28 <= 1) break block71;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block72;
                            }
                            do {
                                char[] cArray28 = cArray6;
                                char[] cArray29 = cArray6;
                                int n29 = n3;
                                while (true) {
                                    int n30;
                                    char c = cArray28[n29];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n30 = 115;
                                            break;
                                        }
                                        case 1: {
                                            n30 = 8;
                                            break;
                                        }
                                        case 2: {
                                            n30 = 95;
                                            break;
                                        }
                                        case 3: {
                                            n30 = 52;
                                            break;
                                        }
                                        default: {
                                            n30 = 78;
                                        }
                                    }
                                    cArray28[n29] = (char)(c ^ n30);
                                    ++n3;
                                    cArray6 = cArray29;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray29 = cArray6;
                                    n6 = n7;
                                    n29 = n7;
                                    cArray28 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[4] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray30 = " m<A<\u001a|&\u0014/\u001fo0F'\u0007`2\u0014=\u001bg*X*Sj:\u0014=\u0003m<](\u001am;".toCharArray();
                        n3 = 0;
                        int n31 = cArray30.length;
                        cArray4 = cArray30;
                        n5 = n31;
                        if (n31 <= 1) break block73;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block74;
                    }
                    do {
                        char[] cArray31 = cArray4;
                        char[] cArray32 = cArray4;
                        int n32 = n3;
                        while (true) {
                            int n33;
                            char c = cArray31[n32];
                            switch (n3 % 5) {
                                case 0: {
                                    n33 = 115;
                                    break;
                                }
                                case 1: {
                                    n33 = 8;
                                    break;
                                }
                                case 2: {
                                    n33 = 95;
                                    break;
                                }
                                case 3: {
                                    n33 = 52;
                                    break;
                                }
                                default: {
                                    n33 = 78;
                                }
                            }
                            cArray31[n32] = (char)(c ^ n33);
                            ++n3;
                            cArray4 = cArray32;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray32 = cArray4;
                            n4 = n5;
                            n32 = n5;
                            cArray31 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[5] = new String(cArray3).intern();
                var0 = null;
                char[] cArray33 = "\u0010g2\u001a$\u0003&/F!\u0007m<@'\u001cfqD;\u0011&\u0013]-\u0016f,Q\u001c\u0016i;Q<".toCharArray();
                n3 = 0;
                int n34 = cArray33.length;
                cArray2 = cArray33;
                n2 = n34;
                if (n34 <= 1) break block75;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block76;
            }
            do {
                char[] cArray34 = cArray2;
                char[] cArray35 = cArray2;
                int n35 = n3;
                while (true) {
                    int n36;
                    char c = cArray34[n35];
                    switch (n3 % 5) {
                        case 0: {
                            n36 = 115;
                            break;
                        }
                        case 1: {
                            n36 = 8;
                            break;
                        }
                        case 2: {
                            n36 = 95;
                            break;
                        }
                        case 3: {
                            n36 = 52;
                            break;
                        }
                        default: {
                            n36 = 78;
                        }
                    }
                    cArray34[n35] = (char)(c ^ n36);
                    ++n3;
                    cArray2 = cArray35;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray35 = cArray2;
                    n = n2;
                    n35 = n2;
                    cArray34 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[6] = new String(cArray).intern();
        A = stringArray;
    }
}

