/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.launch;

import com.jp.protection.pub.HeadlessProtectionFactory;
import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseAcceptanceDelegate;
import com.jp.protection.pub.LicenseAdapter;
import com.jp.protection.pub.LicenseHost;
import com.jp.protection.pub.LicenseHostIssueResolver;
import com.jp.protection.pub.LicenseListener;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.LicenseReaderIssueResolver;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.SecretStorage;
import com.jp.protection.pub.SimpleLicenseAcceptanceDelegate;
import com.jp.protection.pub.launch.FacadeConnectionConfig;
import com.jp.protection.pub.launch.LicensingServerConnectionConfig;
import com.jp.protection.pub.launch.ProtectionLauncherConfig;
import com.jp.protection.pub.launch.ProtectionLauncherConfigReader;
import com.jp.protection.pub.pro.LicenseHostPro;
import com.jp.protection.pub.pro.integration.LicensingFacadeProvider;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderFactory;
import dev.util.StringUtils;
import java.io.IOException;
import java.util.prefs.Preferences;

public class HeadlessProtectionLauncher {
    protected ProtectionLauncherConfig fLauncherConfig;
    protected LicenseReader fLicenseReader;
    protected LicenseHost fLicenseHost;
    protected LicenseListener fLicenseListener;
    protected boolean fVerbose = false;

    public HeadlessProtectionLauncher(ProtectionLauncherConfig protectionLauncherConfig) {
        this(protectionLauncherConfig, null);
    }

    public HeadlessProtectionLauncher(ProtectionLauncherConfig protectionLauncherConfig, LicenseReader licenseReader) {
        this.fLauncherConfig = protectionLauncherConfig;
        this.fLicenseReader = licenseReader;
    }

    public ProductInfo getProductInfo() {
        return this.fLauncherConfig.getProductInfo();
    }

    public ProtectionLauncherConfig getLauncherConfig() {
        return this.fLauncherConfig;
    }

    protected String getProductEditionName(License license) {
        return this.getProductInfo().getProductEditionName(license.getProductEdition());
    }

    public LicenseHost getLicenseHost() {
        return this.fLicenseHost;
    }

    public LicenseReader getLicenseReader() {
        return this.fLicenseHost.getLicenseReader();
    }

    protected void initLicenseReader() {
        ProtectionLauncherConfig protectionLauncherConfig = this.getLauncherConfig();
        if (this.fLicenseReader == null) {
            this.fLicenseReader = this.createLicenseReader();
        }
        this.fLicenseReader.setIssueResolver(this.createLicenseReaderIssueResolver());
        this.fLicenseReader.setLicenseResourceFolder(protectionLauncherConfig.getLicenseResourceFolder());
        this.fLicenseReader.setLicenseFileName(protectionLauncherConfig.getLicenseFileName());
        this.fLicenseReader.setLicenseFolder(protectionLauncherConfig.getLicenseFolder());
        this.fLicenseReader.setUserHomeRelative(protectionLauncherConfig.isLicenseUserHomeRelative());
        this.fLicenseReader.setDecryptKeyBytes(protectionLauncherConfig.getDecryptKeyBytes());
        this.fLicenseReader.setSecurityAlgorithm(protectionLauncherConfig.getSecurityAlgorithm());
    }

    protected LicenseReaderIssueResolver createLicenseReaderIssueResolver() {
        return null;
    }

    protected LicenseReader createLicenseReader() {
        return HeadlessProtectionFactory.createLicenseReader();
    }

    protected void initLicenseListener() {
        this.fLicenseListener = new LicenseAdapter();
    }

    protected void initLicenseHost() {
        boolean bl = FacadeConnectionConfig.z;
        ProtectionLauncherConfig protectionLauncherConfig = this.getLauncherConfig();
        this.fLicenseHost = this.createLicenseHost();
        this.fLicenseHost.setLicenseAcceptanceDelegate(this.createLicenseAcceptanceDelegate());
        this.fLicenseHost.setLicenseTextCommercial(!StringUtils.noValue(protectionLauncherConfig.getLicenseTextCommercialRes()) ? LicenseHost.loadText(this.getClass(), protectionLauncherConfig.getLicenseTextCommercialRes()) : protectionLauncherConfig.getLicenseTextCommercial());
        this.fLicenseHost.setLicenseTextEvaluation(!StringUtils.noValue(protectionLauncherConfig.getLicenseTextEvaluationRes()) ? LicenseHost.loadText(this.getClass(), protectionLauncherConfig.getLicenseTextEvaluationRes()) : protectionLauncherConfig.getLicenseTextEvaluation());
        this.fLicenseHost.setIssueResolver(this.createLicenseHostIssueResolver());
        this.fLicenseHost.setLicenseAcceptanceDelegate(this.createLicenseAcceptanceDelegate());
        this.fLicenseHost.setAllowFlexibleExpirationDate(protectionLauncherConfig.isAllowFlexibleExpirationDate());
        if (protectionLauncherConfig.isProfessional()) {
            LicenseHostPro licenseHostPro = (LicenseHostPro)this.fLicenseHost;
            licenseHostPro.setActivationLockOptions(protectionLauncherConfig.getActivationLockOptions());
            licenseHostPro.setUseStrippedActivationKeyChars(protectionLauncherConfig.isUseStrippedActivationKeyChars());
            licenseHostPro.setCheckPreviousShutdownDate(protectionLauncherConfig.isCheckPreviousShutdownDate());
            licenseHostPro.getLicensingServiceSupport().setPreferences(this.getPreferences());
        }
        if (StringUtils.z) {
            FacadeConnectionConfig.z = !bl;
        }
    }

    protected LicenseHostIssueResolver createLicenseHostIssueResolver() {
        return null;
    }

    protected LicenseAcceptanceDelegate createLicenseAcceptanceDelegate() {
        return new SimpleLicenseAcceptanceDelegate();
    }

    protected LicenseHost createLicenseHost() {
        return HeadlessProtectionFactory.createLicenseHost(this.fLicenseReader, this.fLicenseListener);
    }

    public void init() {
        ProtectionLauncherConfig protectionLauncherConfig = this.getLauncherConfig();
        this.initProfessional(protectionLauncherConfig);
        this.initLicenseReader();
        this.initLicenseListener();
        this.initLicenseHost();
        this.initSecretStorages();
        this.initLicensingFacades();
        this.initLicensingServerConnections();
        this.setVerbose(protectionLauncherConfig.isVerbose());
    }

    protected void initProfessional(ProtectionLauncherConfig protectionLauncherConfig) {
        if (protectionLauncherConfig.isProfessional()) {
            HeadlessProtectionFactory.initProfessional();
        }
    }

    protected void initSecretStorages() {
        boolean bl = FacadeConnectionConfig.z;
        SecretStorage.Provider[] providerArray = this.getLauncherConfig().getSecretStorageProviders();
        for (int i = 0; providerArray != null && i < providerArray.length; ++i) {
            this.fLicenseHost.addSecretStorage(providerArray[i].create());
            if (!bl) continue;
        }
    }

    protected void initLicensingFacades() {
        boolean bl = FacadeConnectionConfig.z;
        FacadeConnectionConfig[] facadeConnectionConfigArray = this.getLauncherConfig().getFacadeConnectionConfigs();
        for (int i = 0; facadeConnectionConfigArray != null && i < facadeConnectionConfigArray.length; ++i) {
            LicensingFacadeProvider.addProvider(facadeConnectionConfigArray[i].getID(), facadeConnectionConfigArray[i].createProvider());
            if (!bl) continue;
        }
    }

    protected void initLicensingServerConnections() {
        boolean bl = FacadeConnectionConfig.z;
        LicensingServerConnectionConfig[] licensingServerConnectionConfigArray = this.getLauncherConfig().getLicensingServerConnectionConfigs();
        for (int i = 0; licensingServerConnectionConfigArray != null && i < licensingServerConnectionConfigArray.length; ++i) {
            LicensingServiceProviderFactory.getInstance().registerProvider(licensingServerConnectionConfigArray[i].getName(), licensingServerConnectionConfigArray[i].getProviderClass(), licensingServerConnectionConfigArray[i].getAddress(), licensingServerConnectionConfigArray[i].getLogin(), licensingServerConnectionConfigArray[i].getPassword(), licensingServerConnectionConfigArray[i].isDefault());
            if (!bl) continue;
        }
    }

    public boolean checkLicense(boolean bl) {
        ProductInfo productInfo = this.getProductInfo();
        this.fLicenseHost.checkLicense(productInfo.getID(), productInfo.getMajorVersion(), productInfo.getMinorVersion(), bl);
        License license = this.fLicenseHost.getLicense();
        return license != null && license.getLicenseState() == 2;
    }

    public boolean checkLicense() {
        return this.checkLicense(false);
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean bl) {
        if (this.fVerbose != bl) {
            this.fVerbose = bl;
            if (this.fLicenseListener instanceof LicenseAdapter) {
                ((LicenseAdapter)this.fLicenseListener).setVerbose(this.fVerbose);
            }
            this.fLicenseReader.setVerbose(this.fVerbose);
            this.fLicenseHost.setVerbose(this.fVerbose);
        }
    }

    public static HeadlessProtectionLauncher getHeadlessProtectionLauncher(ProtectionLauncherConfigReader protectionLauncherConfigReader, Class clazz, String string, LicenseReader licenseReader) throws IOException {
        HeadlessProtectionLauncher headlessProtectionLauncher = new HeadlessProtectionLauncher(protectionLauncherConfigReader.read(clazz, string), licenseReader);
        headlessProtectionLauncher.init();
        return headlessProtectionLauncher;
    }

    public static HeadlessProtectionLauncher getHeadlessProtectionLauncher(ProtectionLauncherConfigReader protectionLauncherConfigReader, Class clazz, String string) throws IOException {
        return HeadlessProtectionLauncher.getHeadlessProtectionLauncher(protectionLauncherConfigReader, clazz, string, null);
    }

    public void replaceDefaultLicenseListener(LicenseListener licenseListener) {
        if (this.fLicenseListener != null) {
            this.fLicenseReader.removeLicenseReaderListener(this.fLicenseListener);
            this.fLicenseHost.removeLicenseHostListener(this.fLicenseListener);
        }
        this.fLicenseListener = licenseListener;
        if (this.fLicenseListener != null) {
            this.fLicenseReader.addLicenseReaderListener(this.fLicenseListener);
            this.fLicenseHost.addLicenseHostListener(this.fLicenseListener);
            if (this.fLicenseListener instanceof LicenseAdapter) {
                ((LicenseAdapter)this.fLicenseListener).setVerbose(this.isVerbose());
            }
        }
    }

    protected Preferences getPreferences() {
        String string = this.getProductInfo().getShortName();
        if (string == null) {
            string = this.getProductInfo().getName();
        }
        Preferences preferences = Preferences.userRoot().node(string);
        return preferences;
    }
}

