/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.launch;

import com.jp.protection.gui.dialogs.DefaultLicenseAdapter;
import com.jp.protection.gui.dialogs.DefaultLicenseReaderIssueResolver;
import com.jp.protection.gui.dialogs.LicenseAboutDialog;
import com.jp.protection.gui.dialogs.LicensingWizard;
import com.jp.protection.gui.dialogs.pro.DefaultLicenseHostIssueResolver;
import com.jp.protection.gui.dialogs.pro.DefaultLicenseReaderIssueResolverPro;
import com.jp.protection.gui.dialogs.pro.LicenseDeactivationWizard;
import com.jp.protection.gui.dialogs.pro.LicensingWizardPro;
import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseAcceptanceDelegate;
import com.jp.protection.pub.LicenseAdapter;
import com.jp.protection.pub.LicenseHost;
import com.jp.protection.pub.LicenseHostIssueResolver;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.LicenseReaderIssueResolver;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.ProtectionFactory;
import com.jp.protection.pub.SimpleLicenseAcceptanceDelegate;
import com.jp.protection.pub.launch.FacadeConnectionConfig;
import com.jp.protection.pub.launch.HeadlessProtectionLauncher;
import com.jp.protection.pub.launch.ProtectionLauncherConfig;
import com.jp.protection.pub.launch.ProtectionLauncherConfigReader;
import com.jp.protection.pub.pro.LicenseHostPro;
import dev.gui.ResourceUtils;
import dev.util.StringUtils;
import java.awt.Component;
import java.io.IOException;
import javax.swing.ImageIcon;

public class ProtectionLauncher
extends HeadlessProtectionLauncher {
    protected Component fOwner;
    protected ImageIcon fLicensingWizardLogo;
    protected ImageIcon fActivationWizardLogo;
    protected int fLicensingWizardOptions = 0;
    protected int fActivationWizardOptions = 0;
    protected ImageIcon fDeactivationWizardLogo;
    protected int fDeactivationWizardOptions = 0;
    protected ImageIcon fLicenseLockWizardLogo;
    protected int fLicenseLockWizardOptions = 0;
    private static final /* synthetic */ String z;

    public ProtectionLauncher(ProtectionLauncherConfig protectionLauncherConfig) {
        this(protectionLauncherConfig, null, null);
    }

    public ProtectionLauncher(ProtectionLauncherConfig protectionLauncherConfig, Component component) {
        this(protectionLauncherConfig, component, null);
    }

    public ProtectionLauncher(ProtectionLauncherConfig protectionLauncherConfig, Component component, LicenseReader licenseReader) {
        super(protectionLauncherConfig, licenseReader);
        this.fOwner = component;
    }

    public void showAboutDialog() {
        ProductInfo productInfo = this.getProductInfo();
        LicenseAboutDialog licenseAboutDialog = ProtectionFactory.createLicenseAboutDialog(this.fOwner, productInfo);
        ProtectionLauncherConfig protectionLauncherConfig = this.getLauncherConfig();
        licenseAboutDialog.setLogoIcon(this.loadIcon(protectionLauncherConfig.getCompanyLogo(), protectionLauncherConfig.getCompanyLogoRes()));
        License license = this.fLicenseHost.getLicense();
        if (license != null) {
            String string = productInfo.getName();
            if (license.getProductEdition() != null) {
                string = string + " " + this.getProductEditionName(license);
            }
            licenseAboutDialog.setProductName(string);
        }
        LicenseAboutDialog.execute(licenseAboutDialog, this.fLicenseHost);
    }

    protected void initLicenseReader() {
        ProtectionLauncherConfig protectionLauncherConfig = this.getLauncherConfig();
        if (this.fLicenseReader == null) {
            this.fLicenseReader = this.createLicenseReader();
        }
        this.fLicenseReader.setIssueResolver(this.createLicenseReaderIssueResolver());
        this.fLicenseReader.setLicenseResourceFolder(protectionLauncherConfig.getLicenseResourceFolder());
        this.fLicenseReader.setLicenseFileName(protectionLauncherConfig.getLicenseFileName());
        this.fLicenseReader.setLicenseFolder(protectionLauncherConfig.getLicenseFolder());
        this.fLicenseReader.setUserHomeRelative(protectionLauncherConfig.isLicenseUserHomeRelative());
        this.fLicenseReader.setDecryptKeyBytes(protectionLauncherConfig.getDecryptKeyBytes());
        this.fLicenseReader.setSecurityAlgorithm(protectionLauncherConfig.getSecurityAlgorithm());
    }

    public void init() {
        super.init();
        this.initWizards();
    }

    protected LicenseReaderIssueResolver createLicenseReaderIssueResolver() {
        return this.getLauncherConfig().isGUI() ? ProtectionFactory.createLicenseReaderIssueResolver(this.fLicenseReader, this.fOwner, this.getProductInfo()) : null;
    }

    protected void initLicenseListener() {
        block3: {
            block2: {
                if (!this.getLauncherConfig().isGUI()) break block2;
                DefaultLicenseAdapter defaultLicenseAdapter = new DefaultLicenseAdapter(this.fOwner);
                defaultLicenseAdapter.setProductInfo(this.getProductInfo());
                this.fLicenseListener = defaultLicenseAdapter;
                if (!FacadeConnectionConfig.z) break block3;
            }
            this.fLicenseListener = new LicenseAdapter();
        }
    }

    protected void initLicenseHost() {
        super.initLicenseHost();
        if (this.fLicenseReader.getIssueResolver() instanceof DefaultLicenseReaderIssueResolverPro) {
            ((DefaultLicenseReaderIssueResolverPro)this.fLicenseReader.getIssueResolver()).setLicenseHost((LicenseHostPro)this.fLicenseHost);
        }
        if (this.fLicenseHost.getIssueResolver() instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)this.fLicenseHost.getIssueResolver()).setLicensingWizardOptions(this.fLicensingWizardOptions);
        }
    }

    protected LicenseHostIssueResolver createLicenseHostIssueResolver() {
        LicenseHostIssueResolver licenseHostIssueResolver = null;
        if (this.fLauncherConfig.isGUI() && (licenseHostIssueResolver = ProtectionFactory.createLicenseHostIssueResolver(this.fLicenseHost, this.fOwner, this.getProductInfo())) instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)licenseHostIssueResolver).setSilentActivation(this.getLauncherConfig().isSilentActivation());
        }
        return licenseHostIssueResolver;
    }

    protected LicenseAcceptanceDelegate createLicenseAcceptanceDelegate() {
        LicenseAcceptanceDelegate licenseAcceptanceDelegate = null;
        licenseAcceptanceDelegate = this.getLauncherConfig().isGUI() && this.getLauncherConfig().isAcceptLicenseAgreement() ? ProtectionFactory.createLicenseAcceptanceDelegate(this.fOwner, this.getProductInfo().getShortName() + z) : new SimpleLicenseAcceptanceDelegate();
        return licenseAcceptanceDelegate;
    }

    protected LicenseHost createLicenseHost() {
        return ProtectionFactory.createLicenseHost(this.fLicenseReader, this.fLicenseListener);
    }

    protected void initProfessional(ProtectionLauncherConfig protectionLauncherConfig) {
        if (protectionLauncherConfig.isProfessional()) {
            ProtectionFactory.initProfessional();
        }
    }

    private void initWizards() {
        ProtectionLauncherConfig protectionLauncherConfig = this.getLauncherConfig();
        this.setLicensingWizardOptions(protectionLauncherConfig.getLicensingWizardOptions());
        ImageIcon imageIcon = this.loadIcon(protectionLauncherConfig.getLicensingWizardLogo(), protectionLauncherConfig.getLicensingWizardLogoRes());
        if (imageIcon != null) {
            this.setLicensingWizardLogo(imageIcon);
        }
        this.setActivationWizardOptions(protectionLauncherConfig.getActivationWizardOptions());
        imageIcon = this.loadIcon(protectionLauncherConfig.getActivationWizardLogo(), protectionLauncherConfig.getActivationWizardLogoRes());
        if (imageIcon != null) {
            this.setActivationWizardLogo(imageIcon);
        }
        this.setDeactivationWizardOptions(protectionLauncherConfig.getDeactivationWizardOptions());
        imageIcon = this.loadIcon(protectionLauncherConfig.getDeactivationWizardLogo(), protectionLauncherConfig.getDeactivationWizardLogoRes());
        if (imageIcon != null) {
            this.setDeactivationWizardLogo(imageIcon);
        }
        this.setLicenseLockWizardOptions(protectionLauncherConfig.getLicenseLockWizardOptions());
        imageIcon = this.loadIcon(protectionLauncherConfig.getLicenseLockWizardLogo(), protectionLauncherConfig.getLicenseLockWizardLogoRes());
        if (imageIcon != null) {
            this.setLicenseLockWizardLogo(imageIcon);
        }
    }

    protected ImageIcon loadIcon(String string, String string2) {
        ImageIcon imageIcon = null;
        if (!StringUtils.noValue(string2)) {
            imageIcon = ResourceUtils.loadImageIcon(this.getClass(), string2);
        } else if (!StringUtils.noValue(string)) {
            imageIcon = new ImageIcon(string);
        }
        return imageIcon;
    }

    public void setLicensingWizardLogo(ImageIcon imageIcon) {
        this.fLicensingWizardLogo = imageIcon;
        if (this.fLicensingWizardLogo != null) {
            LicenseHostIssueResolver licenseHostIssueResolver;
            LicenseReaderIssueResolver licenseReaderIssueResolver = this.fLicenseReader.getIssueResolver();
            if (licenseReaderIssueResolver instanceof DefaultLicenseReaderIssueResolver) {
                ((DefaultLicenseReaderIssueResolver)licenseReaderIssueResolver).setLicensingWizardLogo(this.fLicensingWizardLogo);
            }
            if ((licenseHostIssueResolver = this.fLicenseHost.getIssueResolver()) instanceof DefaultLicenseHostIssueResolver) {
                ((DefaultLicenseHostIssueResolver)licenseHostIssueResolver).setLicensingWizardLogo(this.fLicensingWizardLogo);
            }
        }
    }

    public void setActivationWizardLogo(ImageIcon imageIcon) {
        LicenseHostIssueResolver licenseHostIssueResolver;
        this.fActivationWizardLogo = imageIcon;
        if (this.fActivationWizardLogo != null && (licenseHostIssueResolver = this.fLicenseHost.getIssueResolver()) instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)licenseHostIssueResolver).setActivationWizardLogo(this.fActivationWizardLogo);
        }
    }

    protected void setLicensingWizardOptions(int n) {
        LicenseHostIssueResolver licenseHostIssueResolver;
        this.fLicensingWizardOptions = n;
        LicenseReaderIssueResolver licenseReaderIssueResolver = this.fLicenseReader.getIssueResolver();
        if (licenseReaderIssueResolver instanceof DefaultLicenseReaderIssueResolver) {
            ((DefaultLicenseReaderIssueResolver)licenseReaderIssueResolver).setLicensingWizardOptions(this.fLicensingWizardOptions);
        }
        if ((licenseHostIssueResolver = this.fLicenseHost.getIssueResolver()) instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)licenseHostIssueResolver).setLicensingWizardOptions(this.fLicensingWizardOptions);
        }
    }

    protected void setActivationWizardOptions(int n) {
        this.fActivationWizardOptions = n;
        LicenseHostIssueResolver licenseHostIssueResolver = this.fLicenseHost.getIssueResolver();
        if (licenseHostIssueResolver instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)licenseHostIssueResolver).setActivationWizardOptions(this.fActivationWizardOptions);
        }
    }

    protected void setDeactivationWizardLogo(ImageIcon imageIcon) {
        this.fDeactivationWizardLogo = imageIcon;
    }

    protected void setDeactivationWizardOptions(int n) {
        this.fDeactivationWizardOptions = n;
    }

    protected void setLicenseLockWizardLogo(ImageIcon imageIcon) {
        LicenseHostIssueResolver licenseHostIssueResolver;
        this.fLicenseLockWizardLogo = imageIcon;
        if (this.fLicenseLockWizardLogo != null && (licenseHostIssueResolver = this.fLicenseHost.getIssueResolver()) instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)licenseHostIssueResolver).setLicenseLockWizardLogo(this.fLicenseLockWizardLogo);
        }
    }

    protected void setLicenseLockWizardOptions(int n) {
        this.fLicenseLockWizardOptions = n;
        LicenseHostIssueResolver licenseHostIssueResolver = this.fLicenseHost.getIssueResolver();
        if (licenseHostIssueResolver instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)licenseHostIssueResolver).setLicenseLockWizardOptions(this.fLicenseLockWizardOptions);
        }
    }

    public boolean upgradeLicense(Component component) {
        boolean bl = false;
        LicensingWizard licensingWizard = this.createLicensingWizard(component);
        licensingWizard.setOptions(this.fLicensingWizardOptions);
        if (this.fLicensingWizardLogo != null) {
            licensingWizard.setWizardIcon(this.fLicensingWizardLogo);
        }
        ((LicensingWizardPro)licensingWizard).setLicenseHost((LicenseHostPro)this.fLicenseHost);
        if (licensingWizard.executeModal()) {
            ((LicenseHostPro)this.fLicenseHost).setAutoIncUseCount(true);
            bl = this.checkLicense(true);
        }
        return bl;
    }

    protected LicensingWizard createLicensingWizard(Component component) {
        return ProtectionFactory.createLicensingWizard(this.fLicenseHost.getLicenseReader(), component, this.getProductInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deactivateLicense(Component component) {
        int n = 0;
        if (this.getLauncherConfig().isProfessional()) {
            LicenseDeactivationWizard licenseDeactivationWizard = this.createLicenseDeactivationWizard(component);
            try {
                licenseDeactivationWizard.setLicenseHost((LicenseHostPro)this.fLicenseHost);
                licenseDeactivationWizard.setProductInfo(this.getProductInfo());
                licenseDeactivationWizard.setOptions(this.fDeactivationWizardOptions);
                if (this.fDeactivationWizardLogo != null) {
                    licenseDeactivationWizard.setWizardIcon(this.fDeactivationWizardLogo);
                }
                n = licenseDeactivationWizard.execute();
            }
            finally {
                licenseDeactivationWizard.dispose();
            }
        }
        return n;
    }

    protected LicenseDeactivationWizard createLicenseDeactivationWizard(Component component) {
        return new LicenseDeactivationWizard(component);
    }

    public static ProtectionLauncher getProtectionLauncher(ProtectionLauncherConfigReader protectionLauncherConfigReader, Class clazz, String string, Component component, LicenseReader licenseReader) throws IOException {
        ProtectionLauncher protectionLauncher = new ProtectionLauncher(protectionLauncherConfigReader.read(clazz, string), component, licenseReader);
        protectionLauncher.init();
        return protectionLauncher;
    }

    public static ProtectionLauncher getProtectionLauncher(ProtectionLauncherConfigReader protectionLauncherConfigReader, Class clazz, String string, Component component) throws IOException {
        return ProtectionLauncher.getProtectionLauncher(protectionLauncherConfigReader, clazz, string, component, null);
    }

    public static ProtectionLauncher getProtectionLauncher(ProtectionLauncherConfigReader protectionLauncherConfigReader, Class clazz, String string) throws IOException {
        return ProtectionLauncher.getProtectionLauncher(protectionLauncherConfigReader, clazz, string, null, null);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                Object var0 = null;
                char[] cArray3 = "\u0004p\u0013o\u007fJO\u001f,[CN\u001fiwAR\u000e".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 36;
                            break;
                        }
                        case 1: {
                            n6 = 60;
                            break;
                        }
                        case 2: {
                            n6 = 122;
                            break;
                        }
                        case 3: {
                            n6 = 12;
                            break;
                        }
                        default: {
                            n6 = 26;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        z = new String(cArray).intern();
    }
}

