/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.launch;

import com.jp.protection.pub.launch.ProtectionLauncherConfig;
import com.jp.protection.security.SecurityProvider;
import com.jp.protection.security.SecurityProviderFactory;
import com.jp.protection.utils.LicenseUtils;
import dev.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.PublicKey;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ProtectionLauncherConfigReader {
    protected boolean fVerbose = false;
    protected boolean fSkipEncryption = false;
    protected String fSecurityAlgorithm = z[0];
    protected byte[] fDecryptKeyBytes;
    protected SecurityProvider fSecurityProvider;
    private static final /* synthetic */ String[] z;

    protected SecurityProvider getSecurityProvider() {
        if (this.fSecurityProvider == null || !this.fSecurityProvider.getID().equals(this.fSecurityAlgorithm)) {
            this.fSecurityProvider = SecurityProviderFactory.getSecurityProvider(this.fSecurityAlgorithm);
        }
        return this.fSecurityProvider;
    }

    public ProtectionLauncherConfigReader() {
    }

    public ProtectionLauncherConfigReader(String string, byte[] byArray) {
        this.fSecurityAlgorithm = string;
        this.fDecryptKeyBytes = byArray;
    }

    public String getSecurityAlgorithm() {
        return this.fSecurityAlgorithm;
    }

    public void setSecurityAlgorithm(String string) {
        this.fSecurityAlgorithm = string;
    }

    public byte[] getDecryptKeyBytes() {
        return this.fDecryptKeyBytes;
    }

    public void setDecryptKeyBytes(byte[] byArray) {
        this.fDecryptKeyBytes = byArray;
    }

    public void setDecryptKeyBytes(String string) {
        this.fDecryptKeyBytes = LicenseUtils.toBytes(string);
    }

    public boolean isSkipEncryption() {
        return this.fSkipEncryption;
    }

    public void setSkipEncryption(boolean bl) {
        this.fSkipEncryption = bl;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean bl) {
        this.fVerbose = bl;
    }

    protected void error(Throwable throwable) {
        if (this.isVerbose()) {
            throwable.printStackTrace();
        }
    }

    private byte[] decode(byte[] byArray) {
        byte[] byArray2 = byArray;
        if (!this.isSkipEncryption()) {
            try {
                SecurityProvider securityProvider = this.getSecurityProvider();
                PublicKey publicKey = securityProvider.getPublicKey(this.fDecryptKeyBytes);
                byArray2 = securityProvider.decode(byArray, publicKey);
            }
            catch (Exception exception) {
                byArray2 = null;
                this.error(exception);
            }
        }
        return byArray2;
    }

    public ProtectionLauncherConfig read(InputStream inputStream) throws IOException {
        return this.read(StreamUtil.readB(inputStream));
    }

    public ProtectionLauncherConfig read(Class clazz, String string) throws IOException {
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IllegalArgumentException(z[2] + clazz.getName() + z[3] + string);
        }
        return this.read(inputStream);
    }

    protected ProtectionLauncherConfig read(byte[] byArray) throws IOException {
        ProtectionLauncherConfig protectionLauncherConfig = null;
        if ((byArray = this.decode(byArray)) == null) {
            throw new IOException(z[1]);
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        try {
            protectionLauncherConfig = (ProtectionLauncherConfig)objectInputStream.readObject();
            protectionLauncherConfig.setUseEncryption(!this.isSkipEncryption());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getMessage());
        }
        finally {
            objectInputStream.close();
        }
        return protectionLauncherConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectionLauncherConfig read(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            ProtectionLauncherConfig protectionLauncherConfig = this.read(fileInputStream);
            return protectionLauncherConfig;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectionLauncherConfig read(File file, String string) throws IOException {
        JarFile jarFile = new JarFile(file);
        try {
            ProtectionLauncherConfig protectionLauncherConfig;
            JarEntry jarEntry = jarFile.getJarEntry(string);
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            try {
                protectionLauncherConfig = this.read(inputStream);
            }
            catch (Throwable throwable) {
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return protectionLauncherConfig;
        }
        finally {
            jarFile.close();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block43: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block42: {
                char[] cArray3;
                Object var0;
                block41: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block40: {
                        char[] cArray5;
                        block39: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block38: {
                                char[] cArray7;
                                block37: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block36: {
                                        stringArray = new String[4];
                                        var0 = null;
                                        char[] cArray9 = "Sb\u0003".toCharArray();
                                        n3 = 0;
                                        int n10 = cArray9.length;
                                        cArray8 = cArray9;
                                        n9 = n10;
                                        if (n10 <= 1) break block36;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block37;
                                    }
                                    do {
                                        char[] cArray10 = cArray8;
                                        char[] cArray11 = cArray8;
                                        int n11 = n3;
                                        while (true) {
                                            int n12;
                                            char c = cArray10[n11];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n12 = 1;
                                                    break;
                                                }
                                                case 1: {
                                                    n12 = 49;
                                                    break;
                                                }
                                                case 2: {
                                                    n12 = 66;
                                                    break;
                                                }
                                                case 3: {
                                                    n12 = 31;
                                                    break;
                                                }
                                                default: {
                                                    n12 = 105;
                                                }
                                            }
                                            cArray10[n11] = (char)(c ^ n12);
                                            ++n3;
                                            cArray8 = cArray11;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray11 = cArray8;
                                            n8 = n9;
                                            n11 = n9;
                                            cArray10 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                stringArray[0] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray12 = "T_#}\u0005d\u00116pIeT!p\rd\u0011\u000e~\u001coR*z\u001b".toCharArray();
                                n3 = 0;
                                int n13 = cArray12.length;
                                cArray6 = cArray12;
                                n7 = n13;
                                if (n13 <= 1) break block38;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block39;
                            }
                            do {
                                char[] cArray13 = cArray6;
                                char[] cArray14 = cArray6;
                                int n14 = n3;
                                while (true) {
                                    int n15;
                                    char c = cArray13[n14];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n15 = 1;
                                            break;
                                        }
                                        case 1: {
                                            n15 = 49;
                                            break;
                                        }
                                        case 2: {
                                            n15 = 66;
                                            break;
                                        }
                                        case 3: {
                                            n15 = 31;
                                            break;
                                        }
                                        default: {
                                            n15 = 105;
                                        }
                                    }
                                    cArray13[n14] = (char)(c ^ n15);
                                    ++n3;
                                    cArray6 = cArray14;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray14 = cArray6;
                                    n6 = n7;
                                    n14 = n7;
                                    cArray13 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[1] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray15 = "T_#}\u0005d\u00116pIm^#{ImP7q\niT0%I".toCharArray();
                        n3 = 0;
                        int n16 = cArray15.length;
                        cArray4 = cArray15;
                        n5 = n16;
                        if (n16 <= 1) break block40;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block41;
                    }
                    do {
                        char[] cArray16 = cArray4;
                        char[] cArray17 = cArray4;
                        int n17 = n3;
                        while (true) {
                            int n18;
                            char c = cArray16[n17];
                            switch (n3 % 5) {
                                case 0: {
                                    n18 = 1;
                                    break;
                                }
                                case 1: {
                                    n18 = 49;
                                    break;
                                }
                                case 2: {
                                    n18 = 66;
                                    break;
                                }
                                case 3: {
                                    n18 = 31;
                                    break;
                                }
                                default: {
                                    n18 = 105;
                                }
                            }
                            cArray16[n17] = (char)(c ^ n18);
                            ++n3;
                            cArray4 = cArray17;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray17 = cArray4;
                            n4 = n5;
                            n17 = n5;
                            cArray16 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[2] = new String(cArray3).intern();
                var0 = null;
                char[] cArray18 = "!\u001cb".toCharArray();
                n3 = 0;
                int n19 = cArray18.length;
                cArray2 = cArray18;
                n2 = n19;
                if (n19 <= 1) break block42;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block43;
            }
            do {
                char[] cArray19 = cArray2;
                char[] cArray20 = cArray2;
                int n20 = n3;
                while (true) {
                    int n21;
                    char c = cArray19[n20];
                    switch (n3 % 5) {
                        case 0: {
                            n21 = 1;
                            break;
                        }
                        case 1: {
                            n21 = 49;
                            break;
                        }
                        case 2: {
                            n21 = 66;
                            break;
                        }
                        case 3: {
                            n21 = 31;
                            break;
                        }
                        default: {
                            n21 = 105;
                        }
                    }
                    cArray19[n20] = (char)(c ^ n21);
                    ++n3;
                    cArray2 = cArray20;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray20 = cArray2;
                    n = n2;
                    n20 = n2;
                    cArray19 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[3] = new String(cArray).intern();
        z = stringArray;
    }
}

