/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseAdapter;
import com.jp.protection.pub.LicenseHost;
import com.jp.protection.pub.LicenseHostListener;
import com.jp.protection.pub.LicenseImpl;
import com.jp.protection.pub.LicenseOutdatedException;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.LicenseReaderListener;
import com.jp.protection.pub.pro.Java6LicenseHostProContext;
import com.jp.protection.pub.pro.LicenseHostProContext;
import com.jp.protection.pub.pro.LicensingServiceSupport;
import com.jp.protection.pub.pro.network.NetworkCheck;
import com.jp.protection.pub.pro.network.NetworkCheckListener;
import dev.lang.BitTools;
import dev.util.CalendarUtil;
import dev.util.StringUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;

public class LicenseHostPro
extends LicenseHost
implements NetworkCheckListener {
    static ResourceBundle res;
    public static final String PROPERTY_CLEAR_PREVIOUS_SHUTDOWN_DATE;
    protected boolean fNetworkCheckEnabled;
    protected String fSignature;
    protected NetworkCheck fNetworkCheck;
    protected boolean fAutoIncUseCount;
    public static final int LOCK_MAC_ADDRESS = 1;
    public static final int LOCK_USER = 2;
    public static final int LOCK_IP_ADDRESS = 4;
    public static final int LOCK_HOST = 8;
    public static final int LOCK_CPU_NUMBER = 16;
    public static final int LOCK_INSTALL_ID = 32;
    public static final int LOCK_ALL = 63;
    protected int fActivationLockOptions;
    protected static final char[] ACTIVATION_KEY_CHARS_STRIPPED;
    protected static final char[] ACTIVATION_KEY_CHARS;
    protected boolean fUseStrippedActivationKeyChars;
    public static final String ACTIVATION_KEY_PATTERN;
    public static final char ACTIVATION_KEY_PATTERN_CHAR = '#';
    protected LicensingServiceSupport fLicensingServiceSupport;
    protected boolean fMaintainPreviousShutdownDate;
    protected Thread fShutdownHook;
    protected boolean fCheckPreviousShutdownDate;
    public static final String PROPERTY_USE_COUNT;
    public static final String PROPERTY_LICENSING_SERVER_ADDRESS;
    public static final String PROPERTY_FIRST_LAUNCH_DATE;
    public static final String PROPERTY_ACTIVATION_NUMBER;
    public static final String PROPERTY_INSTALL_ID;
    protected static int fJavaVersion;
    protected LicenseHostProContext fContext;
    public static final String USE_JAVA6_CONTEXT;
    protected static boolean fUseJava6Context;
    protected static final MessageFormat FMT_OR_USAGES_LEFT;
    protected static final MessageFormat FMT_USAGES_LEFT;
    protected LicenseReaderListener fLicenseReaderListener;
    public static final String PROPERTY_LATEST_DEACTIVATION_KEY;
    public static final String PROPERTY_LATEST_ACTIVATION_KEY;
    public static /* synthetic */ boolean z;
    private static final /* synthetic */ String[] A;

    public LicenseHostPro() {
        this.fNetworkCheckEnabled = true;
        this.fAutoIncUseCount = true;
        this.fActivationLockOptions = 1;
        this.fUseStrippedActivationKeyChars = false;
        this.fLicensingServiceSupport = new LicensingServiceSupport(this);
        this.fMaintainPreviousShutdownDate = false;
        this.fShutdownHook = new Thread(){

            public void run() {
                Date date = LicenseHostPro.this.getPreviousShutdownDate();
                Date date2 = new Date();
                if (date == null || date2.getTime() > date.getTime()) {
                    LicenseHostPro.this.setPreviousShutdownDate(date2);
                }
            }
        };
        this.fCheckPreviousShutdownDate = false;
        this.fContext = this.createContext();
    }

    public LicenseHostPro(LicenseReader licenseReader) {
        super(licenseReader);
        this.fNetworkCheckEnabled = true;
        this.fAutoIncUseCount = true;
        this.fActivationLockOptions = 1;
        this.fUseStrippedActivationKeyChars = false;
        this.fLicensingServiceSupport = new LicensingServiceSupport(this);
        this.fMaintainPreviousShutdownDate = false;
        this.fShutdownHook = new /* invalid duplicate definition of identical inner class */;
        this.fCheckPreviousShutdownDate = false;
        this.fContext = this.createContext();
    }

    public LicenseHostPro(LicenseReader licenseReader, LicenseHostListener licenseHostListener) {
        boolean bl = z;
        super(licenseReader, licenseHostListener);
        this.fNetworkCheckEnabled = true;
        this.fAutoIncUseCount = true;
        this.fActivationLockOptions = 1;
        this.fUseStrippedActivationKeyChars = false;
        this.fLicensingServiceSupport = new LicensingServiceSupport(this);
        this.fMaintainPreviousShutdownDate = false;
        this.fShutdownHook = new /* invalid duplicate definition of identical inner class */;
        this.fCheckPreviousShutdownDate = false;
        this.fContext = this.createContext();
        if (StringUtils.z) {
            z = !bl;
        }
    }

    protected boolean checkExpirationImpl(LicenseImpl licenseImpl, String string, int n, int n2) {
        boolean bl = super.checkExpirationImpl(licenseImpl, string, n, n2);
        if (licenseImpl.getLicenseExpireDate() != null) {
            if (bl && licenseImpl.getGracePeriod() != -1) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, licenseImpl.getGracePeriod());
                Date date = this.getLicenseExpirationDate(true);
                if (calendar.getTimeInMillis() > date.getTime()) {
                    this.fireLicenseAboutToExpire(this, licenseImpl, 1 + CalendarUtil.getDaysDifference(this.getLicenseExpirationDate(false), new Date()));
                }
            }
            if (bl) {
                bl = this.checkPreviousShutdownDate();
            }
        }
        if (bl) {
            bl = this.checkUseCount(licenseImpl);
        }
        return bl;
    }

    public int getExpireDaysLeft(License license) {
        int n = -1;
        if (license.getLicenseExpireDate() != null) {
            n = 1 + CalendarUtil.getDaysDifference(this.getLicenseExpirationDate(true), new Date());
        }
        return n;
    }

    public int getUseCountLeft(License license) {
        int n = -1;
        String string = license.getProperty(A[1], null);
        if (!StringUtils.noValue(string)) {
            n = 0;
            int n2 = Integer.parseInt(string);
            int n3 = 0;
            String string2 = license.getProperty(A[2], null);
            if (!StringUtils.noValue(string2)) {
                n3 = Integer.parseInt(string2);
            }
            int n4 = this.getUseCount(license);
            n = n2 + n3 - n4;
        }
        return n;
    }

    protected boolean checkUseCount(License license) {
        boolean bl = true;
        String string = license.getProperty(A[1], null);
        if (!StringUtils.noValue(string)) {
            int n;
            int n2;
            int n3 = Integer.parseInt(string);
            int n4 = 0;
            String string2 = license.getProperty(A[2], null);
            if (!StringUtils.noValue(string2)) {
                n4 = Integer.parseInt(string2);
            }
            if ((n2 = n3 + n4 - (n = this.getUseCount(license))) > 0 && n2 <= n4) {
                this.fireLicenseUseLimitAboutReach(this, license, n2);
            }
            bl = n2 > 0;
        }
        return bl;
    }

    protected void checkCommercial(LicenseImpl licenseImpl, String string, int n, int n2) {
        this.saveFirstLaunchDate();
        super.checkCommercial(licenseImpl, string, n, n2);
    }

    protected void saveFirstLaunchDate() {
        License license = this.getLicense();
        if (license != null && this.getFirstLaunchDate(license) == null) {
            this.setFirstLaunchDate(license, new Date());
        }
    }

    protected void checkEvaluation(LicenseImpl licenseImpl, String string, int n, int n2) {
        this.saveFirstLaunchDate();
        super.checkEvaluation(licenseImpl, string, n, n2);
    }

    protected void clearPreviousShutdownDate() {
        String string;
        License license = this.getLicense();
        if (license != null && !StringUtils.noValue(string = license.getProperty(A[13], null))) {
            try {
                int n = Integer.parseInt(string);
                int n2 = this.loadSecretStorageIntProperty(PROPERTY_CLEAR_PREVIOUS_SHUTDOWN_DATE, true, 0L, false);
                if (n > n2) {
                    this.setPreviousShutdownDate(null);
                    this.saveSecretStorageProperty(PROPERTY_CLEAR_PREVIOUS_SHUTDOWN_DATE, String.valueOf(n2 + 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void checkLicense(String string, int n, int n2, boolean bl) {
        block4: {
            License license;
            block5: {
                this.clearPreviousShutdownDate();
                super.checkLicense(string, n, n2, bl);
                license = this.getLicense();
                if (license == null || license.getLicenseState() != 2 || !this.isCheckNumberOfCopies()) break block4;
                if (!BitTools.checkBit(license.getLicenseOptions(), 8) || license.getUserLicensingModel() != 2 && license.getUserLicensingModel() != 0) break block5;
                this.checkNumberOfCopies(license);
                if (!z) break block4;
            }
            if (BitTools.checkBit(license.getLicenseOptions(), 64) && license.getUserLicensingModel() == 3) {
                this.disallowSeveralInstances(license);
            }
        }
    }

    public boolean isCheckNumberOfCopies() {
        return this.fNetworkCheckEnabled;
    }

    public void setCheckNumberOfCopies(boolean bl) {
        this.fNetworkCheckEnabled = bl;
    }

    public boolean isNetworkCheckEnabled() {
        return this.fNetworkCheckEnabled;
    }

    public void setNetworkCheckEnabled(boolean bl) {
        this.fNetworkCheckEnabled = bl;
    }

    protected void fireProductFeaturesSupported(License license) {
        boolean bl = z;
        Iterator iterator = license.getProductFeatureNames().iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            String string;
            block7: {
                block5: {
                    block6: {
                        string = (String)iterator.next();
                        bl2 = false;
                        if (license.getLicenseState() != 2 && license.getLicenseState() != 3) break block5;
                        if (license.getLicenseType() != 3) break block6;
                        bl2 = license.isProductFeatureSupported(string, license.getLicenseState() == 2 ? 0 : 2);
                        if (!bl) break block7;
                    }
                    if (license.getLicenseType() != 1 && license.getLicenseType() != 2) break block7;
                    bl2 = license.isProductFeatureSupported(string, license.getLicenseState() == 2 ? 1 : 3);
                    if (!bl) break block7;
                }
                if (license.getLicenseState() == 4) {
                    bl2 = license.isProductFeatureSupported(string, 4);
                }
            }
            this.fireFeatureChecked(this, license, string, bl2);
            if (!bl) continue;
        }
    }

    public String getSignature() {
        return this.fSignature;
    }

    public void setSignature(String string) {
        this.fSignature = string;
    }

    protected void checkNumberOfCopies(License license) {
        NetworkCheck networkCheck;
        block3: {
            block4: {
                boolean bl;
                block2: {
                    bl = z;
                    networkCheck = this.getNetworkCheck();
                    networkCheck.setProductID(license.getProduct());
                    networkCheck.setLicenseNumber(license.getLicenseNumber());
                    networkCheck.setNumberCopies(license.getNumberCopies());
                    networkCheck.setSignature(this.getSignature() != null ? this.getSignature() : license.getLicenseNumber());
                    if (!BitTools.checkBit(license.getLicenseOptions(), 16)) break block2;
                    networkCheck.setCheckHostPolicy(3);
                    if (!bl) break block3;
                }
                if (!BitTools.checkBit(license.getLicenseOptions(), 32)) break block4;
                networkCheck.setCheckHostPolicy(2);
                if (!bl) break block3;
            }
            networkCheck.setCheckHostPolicy(networkCheck.getDefaultCheckHostPolicy());
        }
        networkCheck.check();
    }

    protected void disallowSeveralInstances(License license) {
        NetworkCheck networkCheck = this.getNetworkCheck();
        networkCheck.setProductID(license.getProduct());
        networkCheck.setLicenseNumber(license.getLicenseNumber());
        networkCheck.setNumberCopies(1);
        networkCheck.setSignature(this.getSignature() != null ? this.getSignature() : license.getLicenseNumber());
        networkCheck.setCheckHostPolicy(1);
        networkCheck.check();
    }

    public void stopNetworkCheck() {
        if (this.fNetworkCheck != null) {
            this.fNetworkCheck.stop();
        }
    }

    public int getNetworkCheckHostPolicy() {
        return this.getNetworkCheck().getCheckHostPolicy();
    }

    public void setNetworkCheckHostPolicy(int n) {
        this.getNetworkCheck().setCheckHostPolicy(n);
    }

    public NetworkCheck getNetworkCheck() {
        if (this.fNetworkCheck == null) {
            this.fNetworkCheck = new NetworkCheck();
            this.fNetworkCheck.addNetworkCheckListener(this);
        }
        return this.fNetworkCheck;
    }

    protected void fireNumberCopiesViolation(LicenseHost licenseHost, License license, int n) {
        boolean bl = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                LicenseHostListener licenseHostListener = (LicenseHostListener)vector.elementAt(i);
                licenseHostListener.numberCopiesViolation(licenseHost, license, n);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseAboutToExpire(LicenseHost licenseHost, License license, int n) {
        boolean bl = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                LicenseHostListener licenseHostListener = (LicenseHostListener)vector.elementAt(i);
                licenseHostListener.licenseAboutToExpire(licenseHost, license, n);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseNeedLock(LicenseHost licenseHost, License license, int n) {
        boolean bl = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                LicenseHostListener licenseHostListener = (LicenseHostListener)vector.elementAt(i);
                licenseHostListener.licenseNeedLock(licenseHost, license, n);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseLockExpired(LicenseHost licenseHost, License license, String string) {
        boolean bl = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                LicenseHostListener licenseHostListener = (LicenseHostListener)vector.elementAt(i);
                licenseHostListener.licenseLockExpired(licenseHost, license, string);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseLockRevoked(LicenseHost licenseHost, License license, String string) {
        boolean bl = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                LicenseHostListener licenseHostListener = (LicenseHostListener)vector.elementAt(i);
                licenseHostListener.licenseLockRevoked(licenseHost, license, string);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseUseLimitAboutReach(LicenseHost licenseHost, License license, int n) {
        boolean bl = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                LicenseHostListener licenseHostListener = (LicenseHostListener)vector.elementAt(i);
                licenseHostListener.licenseUseLimitAboutReach(licenseHost, license, n);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseLockViolation(LicenseHost licenseHost, License license) {
        boolean bl = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                LicenseHostListener licenseHostListener = (LicenseHostListener)vector.elementAt(i);
                licenseHostListener.licenseLockViolation(licenseHost, license);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseNotActivated(LicenseHost licenseHost, License license) {
        boolean bl = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseHostListener)vector.elementAt(i)).licenseNotActivated(licenseHost, license);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseNotLocked(LicenseHost licenseHost, License license, String string) {
        boolean bl = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseHostListener)vector.elementAt(i)).licenseNotLocked(licenseHost, license, string);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseNeedActivation(LicenseHost licenseHost, License license, int n) {
        boolean bl = z;
        if (this.fLicenseHostListeners != null) {
            Vector vector = this.fLicenseHostListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                ((LicenseHostListener)vector.elementAt(i)).licenseNeedActivation(licenseHost, license, n);
                if (!bl) continue;
            }
        }
    }

    public boolean isAutoIncUseCount() {
        return this.fAutoIncUseCount;
    }

    public void setAutoIncUseCount(boolean bl) {
        this.fAutoIncUseCount = bl;
    }

    protected void setLicenseState(LicenseImpl licenseImpl, int n) {
        boolean bl = z;
        super.setLicenseState(licenseImpl, n);
        switch (n) {
            case 7: {
                this.fireLicenseNotLocked(this, licenseImpl, this.fLicensingServiceSupport.getLockResult().getMessage());
                if (!bl) break;
            }
            case 5: {
                this.fireLicenseNotActivated(this, licenseImpl);
                if (!bl) break;
            }
            case 6: {
                this.fireLicenseLockViolation(this, licenseImpl);
                if (!bl) break;
            }
            case 2: {
                if (!this.isAutoIncUseCount()) break;
                this.setUseCount(licenseImpl, this.getUseCount(licenseImpl) + 1);
                this.setAutoIncUseCount(false);
            }
        }
    }

    public void numberCopiesViolation(NetworkCheck networkCheck, int n) {
        this.fireNumberCopiesViolation(this, this.getLicense(), n);
    }

    public String getActivationKey() {
        String string;
        block5: {
            block6: {
                LicenseImpl licenseImpl;
                boolean bl;
                block4: {
                    bl = z;
                    licenseImpl = (LicenseImpl)this.getLicense();
                    if (licenseImpl == null) {
                        throw new IllegalStateException(A[21]);
                    }
                    if (!BitTools.checkBit(licenseImpl.getLicenseOptions(), 1)) break block4;
                    string = this.getActivationKey(licenseImpl);
                    if (!bl) break block5;
                }
                if (!BitTools.checkBit(licenseImpl.getLicenseOptions(), 2)) break block6;
                string = this.getActivationLockKey(licenseImpl);
                if (!bl) break block5;
            }
            throw new IllegalStateException(A[20]);
        }
        return string;
    }

    public String getActivationKey(LicenseImpl licenseImpl) {
        return this.getActivationKey(licenseImpl.getLicenseNumber());
    }

    public String getActivationKey(String string) {
        return LicenseHostPro.getActivationKey(this.composeActivationKey(string), this.getActivationKeyChars());
    }

    protected long composeActivationKey(String string) {
        return string.hashCode() + this.getActivationNumber(string);
    }

    public int getActivationLockOptions() {
        return this.fActivationLockOptions;
    }

    public void setActivationLockOptions(int n) {
        if (n < 1 || n > 63) {
            throw new IllegalArgumentException(A[15] + n);
        }
        this.fActivationLockOptions = n;
    }

    public String getActivationLockKey(LicenseImpl licenseImpl) {
        return this.getActivationLockKey(licenseImpl.getLicenseNumber());
    }

    protected String[] getActivationLockKeys(LicenseImpl licenseImpl) {
        return this.getActivationLockKeys(licenseImpl.getLicenseNumber());
    }

    public String getActivationLockKey(String string) {
        return LicenseHostPro.getActivationKey(this.composeActivationLockKey(string, this.getActivationLockKey()), this.getActivationKeyChars());
    }

    protected String[] getActivationLockKeys(String string) {
        boolean bl = z;
        long[] lArray = this.getActivationLockKeys();
        String[] stringArray = new String[lArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = LicenseHostPro.getActivationKey(this.composeActivationLockKey(string, lArray[i]), this.getActivationKeyChars());
            if (!bl) continue;
        }
        return stringArray;
    }

    protected long composeActivationLockKey(String string, long l) {
        return (long)string.hashCode() + l + (long)this.getActivationNumber(string);
    }

    protected char[] getActivationKeyChars() {
        return LicenseHostPro.getActivationKeyChars(this.isUseStrippedActivationKeyChars());
    }

    public static char[] getActivationKeyChars(boolean bl) {
        return bl ? ACTIVATION_KEY_CHARS_STRIPPED : ACTIVATION_KEY_CHARS;
    }

    protected long[] getActivationLockKeys() {
        long[] lArray;
        boolean bl;
        block4: {
            block3: {
                bl = z;
                if (!BitTools.checkBit(this.fActivationLockOptions, 1)) break block3;
                lArray = this.getContext().getMACAddresses();
                if (!bl) break block4;
            }
            lArray = new long[1];
        }
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.applyGeneralLockAttributes(lArray[i]);
            if (!bl) continue;
        }
        return lArray;
    }

    private long applyGeneralLockAttributes(long l) {
        if (BitTools.checkBit(this.fActivationLockOptions, 2)) {
            l += (long)this.getContext().getUserName().hashCode();
        }
        if (BitTools.checkBit(this.fActivationLockOptions, 16)) {
            l += (long)this.getContext().getAvailableProcessors();
        }
        if (BitTools.checkBit(this.fActivationLockOptions, 32)) {
            l += (long)this.getContext().getInstallID();
        }
        try {
            if (BitTools.checkBit(this.fActivationLockOptions, 4)) {
                l += (long)this.getContext().getIPAddress().hashCode();
            }
            if (BitTools.checkBit(this.fActivationLockOptions, 8)) {
                l += (long)this.getContext().getHostName().hashCode();
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
        return l;
    }

    protected long getActivationLockKey() {
        long[] lArray = this.getActivationLockKeys();
        return lArray != null && lArray.length > 0 ? lArray[0] : 0L;
    }

    protected boolean checkSystemDateTrick() {
        Date date;
        boolean bl = true;
        if (this.isCheckPreviousShutdownDate() && (date = this.getPreviousShutdownDate()) != null) {
            bl = CalendarUtil.getHoursDifferenceInt(new Date(), date) >= 0;
        }
        return bl;
    }

    public int getActivationDaysLeft(License license) {
        return this.getDaysLeft(license, license.getActivationGracePeriod());
    }

    protected int getDaysLeft(License license, int n) {
        int n2 = 0;
        int n3 = n;
        if (n3 != -1) {
            try {
                Date date = this.getFirstLaunchDate(license);
                if (date != null && this.checkSystemDateTrick()) {
                    n2 = n3 - CalendarUtil.getDaysDifferenceInt(new Date(), date);
                }
            }
            catch (Exception exception) {
                this.error(exception);
            }
        }
        return n2;
    }

    public int getLockDaysLeft(License license) {
        return this.getDaysLeft(license, license.getLockGracePeriod());
    }

    protected boolean checkActivationGracePeriod(LicenseImpl licenseImpl) {
        boolean bl;
        int n = this.getActivationDaysLeft(licenseImpl);
        boolean bl2 = bl = n > 0;
        if (bl) {
            this.fireLicenseNeedActivation(this, licenseImpl, n);
        }
        return bl;
    }

    protected boolean checkLockGracePeriod(LicenseImpl licenseImpl) {
        boolean bl;
        int n = this.getLockDaysLeft(licenseImpl);
        boolean bl2 = bl = n > 0;
        if (bl) {
            this.fireLicenseNeedLock(this, licenseImpl, n);
        }
        return bl;
    }

    protected boolean checkActivation(LicenseImpl licenseImpl) {
        boolean bl;
        block4: {
            block5: {
                bl = true;
                if (licenseImpl.getUserLicensingModel() != 3 && licenseImpl.getUserLicensingModel() != 0) break block4;
                if (!BitTools.checkBit(licenseImpl.getLicenseOptions(), 1)) break block5;
                bl = this.checkActivationImpl(licenseImpl, bl);
                if (!z) break block4;
            }
            if (BitTools.checkBit(licenseImpl.getLicenseOptions(), 2)) {
                bl = this.checkActivationLockImpl(licenseImpl, bl);
            }
        }
        return bl;
    }

    protected boolean checkActivationLockImpl(LicenseImpl licenseImpl, boolean bl) throws LicenseOutdatedException {
        block9: {
            String[] stringArray;
            String string;
            boolean bl2;
            block8: {
                bl2 = z;
                string = licenseImpl.getProperty(A[10], "");
                if (!string.equals("")) break block8;
                stringArray = this.getActivationLockKey(licenseImpl);
                if (this.fIssueResolver != null && this.fIssueResolver.resolveLicenseMissingActivation(this, (String)stringArray)) {
                    throw new LicenseOutdatedException();
                }
                bl = this.checkActivationGracePeriod(licenseImpl);
                if (!bl) {
                    this.setLicenseState(licenseImpl, 5);
                }
                if (!bl2) break block9;
            }
            stringArray = this.getActivationLockKeys(licenseImpl);
            boolean bl3 = false;
            for (int i = 0; !bl3 && i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                bl3 = true;
                if (!bl2) continue;
            }
            if (!bl3) {
                if (this.fIssueResolver != null && this.fIssueResolver.resolveLicenseActivationLockViolation(this)) {
                    throw new LicenseOutdatedException();
                }
                bl = false;
                this.setLicenseState(licenseImpl, 6);
            }
        }
        return bl;
    }

    protected boolean checkActivationImpl(LicenseImpl licenseImpl, boolean bl) throws LicenseOutdatedException {
        String string = this.getActivationKey(licenseImpl);
        if (!string.equals(licenseImpl.getProperty(A[10], null))) {
            if (this.fIssueResolver != null && this.fIssueResolver.resolveLicenseMissingActivation(this, string)) {
                throw new LicenseOutdatedException();
            }
            bl = this.checkActivationGracePeriod(licenseImpl);
            if (!bl) {
                this.setLicenseState(licenseImpl, 5);
            }
        }
        return bl;
    }

    protected boolean checkLicenseLock(LicenseImpl licenseImpl) {
        boolean bl;
        block4: {
            block5: {
                bl = true;
                if (licenseImpl.getUserLicensingModel() != 4 && licenseImpl.getUserLicensingModel() != 5 || (bl = this.checkLicenseLockImpl(licenseImpl))) break block4;
                if (this.fIssueResolver != null) {
                    bl = this.fIssueResolver.resolveLicenseNotLocked(this);
                }
                if (bl || this.checkLockGracePeriod(licenseImpl)) break block5;
                this.setLicenseState(licenseImpl, 7);
                if (!z) break block4;
            }
            bl = true;
        }
        return bl;
    }

    protected boolean checkLicenseLockImpl(License license) {
        return this.lockLicense();
    }

    public LicensingServiceSupport getLicensingServiceSupport() {
        return this.fLicensingServiceSupport;
    }

    public boolean lockLicense() {
        return this.fLicensingServiceSupport.lockLicense(false);
    }

    public boolean unlockLicense() {
        return this.fLicensingServiceSupport.unlockLicense();
    }

    protected long getMACAddress() {
        return this.getContext().getMACAddress();
    }

    protected long[] getMACAddresses() {
        return this.getContext().getMACAddresses();
    }

    public static void setNativeLibFolder(File file) {
        LicenseHostProContext.setNativeLibFolder(file);
    }

    public boolean isUseStrippedActivationKeyChars() {
        return this.fUseStrippedActivationKeyChars;
    }

    public void setUseStrippedActivationKeyChars(boolean bl) {
        this.fUseStrippedActivationKeyChars = bl;
    }

    protected static String getActivationKey(long l) {
        return LicenseHostPro.getActivationKey(l, ACTIVATION_KEY_CHARS);
    }

    protected static String getActivationKey(long l, char[] cArray) {
        return LicenseHostPro.getActivationKey(String.valueOf(l).getBytes(), cArray);
    }

    public static String getActivationKey(byte[] byArray, char[] cArray) {
        boolean bl = z;
        StringBuffer stringBuffer = new StringBuffer(ACTIVATION_KEY_PATTERN);
        int n = stringBuffer.length();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; n3 < byArray.length && i < n; ++n3, ++i) {
            n2 += Math.abs(byArray[n3]);
            while (n2 >= cArray.length) {
                n2 -= cArray.length;
                if (!bl) continue;
            }
            while (stringBuffer.charAt(i) != '#' && i < n) {
                ++i;
                if (!bl) continue;
            }
            stringBuffer.setCharAt(i, cArray[n2]);
            if (n3 != byArray.length - 1) continue;
            n3 = -1;
            if (!bl) continue;
        }
        return stringBuffer.toString();
    }

    public Date getPreviousShutdownDate() {
        return this.loadSecretStorageDateProperty(A[0], false, null, false);
    }

    protected void setPreviousShutdownDate(Date date) {
        this.saveSecretStorageProperty(A[0], date != null ? String.valueOf(date.getTime()) : null);
    }

    public boolean isCheckPreviousShutdownDate() {
        return this.fCheckPreviousShutdownDate;
    }

    public void setCheckPreviousShutdownDate(boolean bl) {
        if (this.fCheckPreviousShutdownDate != bl) {
            this.fCheckPreviousShutdownDate = bl;
            if (this.fCheckPreviousShutdownDate && !this.isMaintainPreviousShutdownDate()) {
                this.setMaintainPreviousShutdownDate(true);
            }
        }
    }

    public boolean isMaintainPreviousShutdownDate() {
        return this.fMaintainPreviousShutdownDate;
    }

    public void setMaintainPreviousShutdownDate(boolean bl) {
        try {
            if (this.fMaintainPreviousShutdownDate != bl) {
                if (this.fMaintainPreviousShutdownDate) {
                    Runtime.getRuntime().removeShutdownHook(this.fShutdownHook);
                }
                this.fMaintainPreviousShutdownDate = bl;
                if (this.fMaintainPreviousShutdownDate) {
                    Runtime.getRuntime().addShutdownHook(this.fShutdownHook);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void release() {
        super.release();
        this.fLicensingServiceSupport.release();
        this.stopNetworkCheck();
        this.setMaintainPreviousShutdownDate(false);
    }

    protected boolean checkPreviousShutdownDate() {
        Date date;
        boolean bl = true;
        if (this.isCheckPreviousShutdownDate() && (date = this.getPreviousShutdownDate()) != null) {
            bl = System.currentTimeMillis() > date.getTime();
        }
        return bl;
    }

    protected static String getUseCountPropertyName(License license) {
        return A[6] + license.getLicenseNumber() + "]";
    }

    protected int getUseCount(License license) {
        return this.loadSecretStorageIntProperty(LicenseHostPro.getUseCountPropertyName(license), true, 0L, false);
    }

    protected void setUseCount(License license, int n) {
        this.saveSecretStorageProperty(LicenseHostPro.getUseCountPropertyName(license), String.valueOf(n));
    }

    public void incUseCount() {
        License license = this.getLicense();
        this.setUseCount(license, this.getUseCount(license) + 1);
    }

    protected static String getFirstLaunchDatePropertyName(License license) {
        return A[14] + license.getLicenseNumber() + "]";
    }

    protected Date getFirstLaunchDate(License license) {
        return this.loadSecretStorageDateProperty(LicenseHostPro.getFirstLaunchDatePropertyName(license), true, null, false);
    }

    protected void setFirstLaunchDate(License license, Date date) {
        this.saveSecretStorageProperty(LicenseHostPro.getFirstLaunchDatePropertyName(license), String.valueOf(date.getTime()));
    }

    protected static String getActivationNumberPropertyName(String string) {
        return A[19] + string + "]";
    }

    protected int getActivationNumber(String string) {
        return this.getContext().getActivationNumber(string);
    }

    protected void setActivationNumber(String string, int n) {
        this.getContext().setActivationNumber(string, n);
    }

    private final String getDeactivationKey(License license, boolean bl) {
        boolean bl2 = z;
        byte[] byArray = this.getLicenseReader().getDecryptKeyBytes();
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            l += (long)byArray[i];
            if (!bl2) continue;
        }
        String string = (bl ? A[9] : A[8]) + String.valueOf(l + (long)license.getProperty(A[10], "").hashCode());
        return LicenseHostPro.getActivationKey(string.getBytes(), LicenseHostPro.getActivationKeyChars(true));
    }

    public boolean canDeactivateLicense() {
        License license = this.getLicense(false);
        return license != null && license.getLicenseType() == 3 && license.getLicenseState() == 2 && (BitTools.checkBit(license.getLicenseOptions(), 1) || BitTools.checkBit(license.getLicenseOptions(), 2)) && !StringUtils.noValue(license.getProperty(A[10], null));
    }

    public String deactivateLicense() {
        boolean bl;
        LicenseImpl licenseImpl = (LicenseImpl)this.getLicense(false);
        String string = licenseImpl.getLicenseNumber();
        int n = this.getActivationNumber(string) + 1;
        this.setActivationNumber(string, n);
        boolean bl2 = bl = n == this.getActivationNumber(string);
        if (bl) {
            licenseImpl.setLicenseState(5);
        }
        String string2 = this.getDeactivationKey(licenseImpl, bl);
        if (bl) {
            this.setLatestDeactivationKey(licenseImpl, string2);
            this.setLatestActivationKey(licenseImpl, licenseImpl.getActivationKey());
        }
        return string2;
    }

    protected int getInstallID() {
        return this.getContext().getInstallID();
    }

    public LicenseHostProContext getContext() {
        return this.fContext;
    }

    public void setContext(LicenseHostProContext licenseHostProContext) {
        if (licenseHostProContext == null) {
            throw new IllegalArgumentException(A[16]);
        }
        this.fContext = licenseHostProContext;
    }

    public void setVerbose(boolean bl) {
        super.setVerbose(bl);
        this.fContext.setVerbose(bl);
    }

    public static int getJavaVersion() {
        if (fJavaVersion == -1) {
            try {
                String[] stringArray = System.getProperty(A[5]).split(A[4]);
                fJavaVersion = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fJavaVersion;
    }

    public static void setUseJava6Context(boolean bl) {
        fUseJava6Context = bl;
    }

    public static boolean isUseJava6Context() {
        return fUseJava6Context || System.getProperty(USE_JAVA6_CONTEXT, A[11]).equals(A[12]);
    }

    protected LicenseHostProContext createContext() {
        if (LicenseHostPro.isUseJava6Context()) {
            if (LicenseHostPro.getJavaVersion() >= 6) {
                return new Java6LicenseHostProContext(this);
            }
            return new LicenseHostProContext(this);
        }
        return new LicenseHostProContext(this);
    }

    public String getLicenseExpireInfo(License license) {
        String string;
        block4: {
            int n;
            block7: {
                boolean bl;
                block5: {
                    block6: {
                        bl = z;
                        string = null;
                        if (license.getLicenseState() == 3) break block4;
                        Date date = this.getLicenseExpirationDate(true);
                        if (date != null) {
                            string = DATE_FORMAT.format(date);
                        }
                        if ((n = this.getUseCountLeft(license)) < 0) break block4;
                        if (n != 0) break block5;
                        if (string == null) break block6;
                        string = string + res.getString(A[18]);
                        if (!bl) break block4;
                    }
                    string = res.getString(A[17]);
                    if (!bl) break block4;
                }
                if (string == null) break block7;
                string = string + FMT_OR_USAGES_LEFT.format(new Object[]{new Integer(n)});
                if (!bl) break block4;
            }
            string = FMT_USAGES_LEFT.format(new Object[]{new Integer(n)});
        }
        return string;
    }

    public void setLicenseReader(LicenseReader licenseReader) {
        if (this.fLicenseReader != null) {
            this.fLicenseReader.removeLicenseReaderListener(this.getLicenseReaderListener());
        }
        super.setLicenseReader(licenseReader);
        if (this.fLicenseReader != null) {
            this.fLicenseReader.addLicenseReaderListener(this.getLicenseReaderListener());
        }
    }

    protected LicenseReaderListener getLicenseReaderListener() {
        if (this.fLicenseReaderListener == null) {
            this.fLicenseReaderListener = new LicenseAdapter(false){

                public void licenseAboutToRead(LicenseReader licenseReader, String string) {
                    LicenseHostPro.this.stopNetworkCheck();
                }
            };
        }
        return this.fLicenseReaderListener;
    }

    protected static String getLatestDeactivationKeyPropertyName(License license) {
        return A[3] + license.getLicenseNumber() + "]";
    }

    public String getLatestDeactivationKey() {
        License license = this.getLicense();
        return license != null ? this.getLatestDeactivationKey(license) : null;
    }

    protected String getLatestDeactivationKey(License license) {
        return this.loadSecretStorageProperty(LicenseHostPro.getLatestDeactivationKeyPropertyName(license), null);
    }

    protected void setLatestDeactivationKey(License license, String string) {
        this.saveSecretStorageProperty(LicenseHostPro.getLatestDeactivationKeyPropertyName(license), string);
    }

    protected static String getLatestActivationKeyPropertyName(License license) {
        return A[7] + license.getLicenseNumber() + "]";
    }

    public String getLatestActivationKey() {
        License license = this.getLicense();
        return license != null ? this.getLatestActivationKey(license) : null;
    }

    protected String getLatestActivationKey(License license) {
        return this.loadSecretStorageProperty(LicenseHostPro.getLatestActivationKeyPropertyName(license), null);
    }

    protected void setLatestActivationKey(License license, String string) {
        this.saveSecretStorageProperty(LicenseHostPro.getLatestActivationKeyPropertyName(license), string);
    }

    static {
        String[] stringArray = new String[24];
        Object var0 = null;
        USE_JAVA6_CONTEXT = LicenseHostPro.z(LicenseHostPro.z("Gr\u001eN7T3\u0003\u00122Px\u0010\u00144Ks]\u0010(F3\u0003\u00122\nQ\u001a\u00038Jn\u0016(2Wi#\u00122\nh\u0000\u0005\u0017Ek\u0012V\u001eKs\u0007\u0005%P"));
        var0 = null;
        ACTIVATION_KEY_PATTERN = LicenseHostPro.z(LicenseHostPro.z("\u0007>PC~\t>PC~\u00070PC~\u0007>^C~\u0007>PM~\u0007>PC"));
        var0 = null;
        PROPERTY_LICENSING_SERVER_ADDRESS = LicenseHostPro.z(LicenseHostPro.z("Ht\u0010\u00053Wt\u001d\u0007\u000eAo\u0005\u0005/ey\u0017\u00128Wn"));
        var0 = null;
        PROPERTY_FIRST_LAUNCH_DATE = LicenseHostPro.z(LicenseHostPro.z("Bt\u0001\u0013)h|\u0006\u000e>LY\u0012\u00148"));
        var0 = null;
        PROPERTY_INSTALL_ID = LicenseHostPro.z(LicenseHostPro.z("Ms\u0000\u0014<Hq:$"));
        var0 = null;
        PROPERTY_ACTIVATION_NUMBER = LicenseHostPro.z(LicenseHostPro.z("E~\u0007\t+Ei\u001a\u000f3jh\u001e\u00028V"));
        var0 = null;
        PROPERTY_CLEAR_PREVIOUS_SHUTDOWN_DATE = LicenseHostPro.z(LicenseHostPro.z("Gq\u0016\u0001/to\u0016\u00164Kh\u000035Qi\u0017\u000f*JY\u0012\u00148"));
        var0 = null;
        PROPERTY_LATEST_DEACTIVATION_KEY = LicenseHostPro.z(LicenseHostPro.z("H|\u0007\u0005.PY\u0016\u0001>Pt\u0005\u0001)Mr\u001d+8]"));
        var0 = null;
        PROPERTY_USE_COUNT = LicenseHostPro.z(LicenseHostPro.z("Qn\u0016#2Qs\u0007"));
        var0 = null;
        PROPERTY_LATEST_ACTIVATION_KEY = LicenseHostPro.z(LicenseHostPro.z("H|\u0007\u0005.P\\\u0010\u00144R|\u0007\t2JV\u0016\u0019"));
        var0 = null;
        stringArray[0] = LicenseHostPro.z(LicenseHostPro.z("To\u0016\u00164Kh\u000035Qi\u0017\u000f*JY\u0012\u00148"));
        var0 = null;
        stringArray[1] = LicenseHostPro.z(LicenseHostPro.z("To]\u0015.H"));
        var0 = null;
        stringArray[2] = LicenseHostPro.z(LicenseHostPro.z("To]\u0015:T"));
        var0 = null;
        stringArray[3] = LicenseHostPro.z(LicenseHostPro.z("H|\u0007\u0005.PY\u0016\u0001>Pt\u0005\u0001)Mr\u001d+8]F"));
        var0 = null;
        stringArray[4] = LicenseHostPro.z(LicenseHostPro.z("\u007f3."));
        var0 = null;
        stringArray[5] = LicenseHostPro.z(LicenseHostPro.z("N|\u0005\u0001sRx\u0001\u00134Ks"));
        var0 = null;
        stringArray[6] = LicenseHostPro.z(LicenseHostPro.z("Qn\u0016#2Qs\u0007;"));
        var0 = null;
        stringArray[7] = LicenseHostPro.z(LicenseHostPro.z("H|\u0007\u0005.P\\\u0010\u00144R|\u0007\t2JV\u0016\u0019\u0006"));
        var0 = null;
        stringArray[8] = LicenseHostPro.z(LicenseHostPro.z("\u0015/"));
        var0 = null;
        stringArray[9] = LicenseHostPro.z(LicenseHostPro.z("\u0015*"));
        var0 = null;
        stringArray[10] = LicenseHostPro.z(LicenseHostPro.z("To]\u00016"));
        var0 = null;
        stringArray[11] = LicenseHostPro.z(LicenseHostPro.z("B|\u001f\u00138"));
        var0 = null;
        stringArray[12] = LicenseHostPro.z(LicenseHostPro.z("Po\u0006\u0005"));
        var0 = null;
        stringArray[13] = LicenseHostPro.z(LicenseHostPro.z("Ht\u0010\u00053Wx;\u000f.PU\u001a\u000e)\t~\u001f\u0005<VM\u0001\u0005+Mr\u0006\u0013\u000eLh\u0007\u00042Ss7\u0001)A"));
        var0 = null;
        stringArray[14] = LicenseHostPro.z(LicenseHostPro.z("Bt\u0001\u0013)h|\u0006\u000e>LY\u0012\u00148\u007f"));
        var0 = null;
        stringArray[15] = LicenseHostPro.z(LicenseHostPro.z("mq\u001f\u0005:EqS\f2GvS\u000f-Pt\u001c\u000e.\u0004k\u0012\f(A'S"));
        var0 = null;
        stringArray[16] = LicenseHostPro.z(LicenseHostPro.z("gr\u001d\u00148\\iS\u00135Kh\u001f\u0004}Jr\u0007@?A=\u001d\u00151H"));
        var0 = null;
        stringArray[17] = LicenseHostPro.z(LicenseHostPro.z("jx\u000b\u0014\u0002vh\u001d"));
        var0 = null;
        stringArray[18] = LicenseHostPro.z(LicenseHostPro.z("ko,.8\\i,2(J"));
        var0 = null;
        stringArray[19] = LicenseHostPro.z(LicenseHostPro.z("E~\u0007\t+Ei\u001a\u000f3jh\u001e\u00028VF"));
        var0 = null;
        stringArray[20] = LicenseHostPro.z(LicenseHostPro.z("ht\u0010\u00053WxS\t.\u0004s\u001c\u0014}Vx\u0002\u00154VxS\u0001>Pt\u0005\u0001)Mr\u001d"));
        var0 = null;
        stringArray[21] = LicenseHostPro.z(LicenseHostPro.z("ht\u0010\u00053WxS\t.\u0004s\u001c\u0014}Vx\u0012\u0004}]x\u0007"));
        var0 = null;
        stringArray[22] = LicenseHostPro.z(LicenseHostPro.z("qn\u0012\u00078WB?\u0005;P"));
        var0 = null;
        stringArray[23] = LicenseHostPro.z(LicenseHostPro.z("ko,5.Ez\u0016\u0013\u0002hx\u0015\u0014"));
        A = stringArray;
        var0 = null;
        res = ResourceBundle.getBundle(LicenseHostPro.z(LicenseHostPro.z("Gr\u001eN7T3\u0003\u00122Px\u0010\u00144Ks]\u0010(F3\u0003\u00122\nO\u0016\u0013")));
        ACTIVATION_KEY_CHARS_STRIPPED = new char[]{'W', 'Y', 'V', 'J', 'N', 'X', 'R', 'H', '3', 'G', '5', 'C', '4', 'P', '6', 'A', 'L', '7', 'U', 'F', '8', 'E', 'D', '9', 'T', 'B', 'Q', 'K', 'M'};
        ACTIVATION_KEY_CHARS = new char[]{'1', 'W', 'Y', 'Z', 'V', '2', 'J', 'N', 'X', 'R', 'H', '3', 'O', 'I', 'G', '5', 'C', '4', 'P', '6', 'A', 'L', '7', 'U', 'F', '8', 'S', 'E', 'D', '9', 'T', 'B', '0', 'Q', 'K', 'M'};
        fJavaVersion = -1;
        fUseJava6Context = false;
        FMT_OR_USAGES_LEFT = new MessageFormat(res.getString(A[23]));
        FMT_USAGES_LEFT = new MessageFormat(res.getString(A[22]));
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n2 = cArray3.length;
                cArray = cArray4;
                n = n2;
                if (n2 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n == 0);
            cArray = cArray4;
            n = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x5D);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n;
            int n2;
            char[] cArray3;
            int n3;
            block9: {
                n3 = 0;
                int n4 = cArray.length;
                cArray3 = cArray;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray2 = cArray3;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 36;
                            break;
                        }
                        case 1: {
                            n6 = 29;
                            break;
                        }
                        case 2: {
                            n6 = 115;
                            break;
                        }
                        case 3: {
                            n6 = 96;
                            break;
                        }
                        default: {
                            n6 = 93;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray3 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray3;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n = n2;
            } while (n2 > n3);
        }
        return new String(cArray2).intern();
    }
}

