/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.ls;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.launch.ProtectionLauncher;
import com.jp.protection.pub.launch.ProtectionLauncherConfig;
import com.jp.protection.pub.pro.ls.BasicLicenseStorage;
import com.jp.protection.pub.pro.ls.LauncherConfigStorage;
import com.jp.protection.pub.pro.ls.LauncherConfigStorageListener;
import com.jp.protection.pub.pro.ls.LicenseStorage;
import dev.util.HashedListStrategy;
import dev.util.collections.ContainerAdapter;
import dev.util.collections.HashedBoundList;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class BasicLauncherConfigStorage
implements LauncherConfigStorage {
    protected HashedBoundList fLauncherConfigs = new HashedBoundList(new ArrayList(), new HashedListStrategy(){

        public Object getKeyForObject(Object object) {
            return ((ProtectionLauncherConfig)object).getProductInfo().getID();
        }
    }, new ContainerAdapter(){

        public void elementAdded(Object object, Object object2) {
            BasicLauncherConfigStorage.this.setModified(true);
            BasicLauncherConfigStorage.this.fireLauncherConfigAdded((ProtectionLauncherConfig)object);
        }

        public void elementRemoved(Object object, Object object2) {
            BasicLauncherConfigStorage.this.setModified(true);
            BasicLauncherConfigStorage.this.fireLauncherConfigRemoved((ProtectionLauncherConfig)object);
        }
    });
    protected boolean fModified = false;
    transient Vector fLauncherConfigStorageListeners;
    private static final /* synthetic */ String z;

    public ProtectionLauncher getLauncher(LicenseStorage.LicenseEntry licenseEntry, Component component, boolean bl) {
        ProtectionLauncherConfig protectionLauncherConfig = this.getLauncherConfig(licenseEntry, bl);
        if (protectionLauncherConfig == null) {
            throw new IllegalStateException(z);
        }
        return this.createLauncher(licenseEntry, protectionLauncherConfig, component);
    }

    public ProtectionLauncherConfig getLauncherConfig(LicenseStorage.LicenseEntry licenseEntry, boolean bl) {
        ProtectionLauncherConfig protectionLauncherConfig = this.getLauncherConfig(licenseEntry.getProduct(), licenseEntry.getProductEdition(), licenseEntry.getMajorVersion(), licenseEntry.getMinorVersion());
        if (protectionLauncherConfig == null && !bl) {
            protectionLauncherConfig = this.getLauncherConfig(licenseEntry.getProduct(), licenseEntry.getProductEdition(), licenseEntry.getMajorVersion(), -1);
            if (protectionLauncherConfig == null) {
                protectionLauncherConfig = this.getLauncherConfig(licenseEntry.getProduct(), licenseEntry.getProductEdition(), -1, -1);
            }
            if (protectionLauncherConfig == null) {
                protectionLauncherConfig = this.getLauncherConfig(licenseEntry.getProduct(), LicenseStorage.ANY_PRODUCT_EDITION, -1, -1);
            }
        }
        return protectionLauncherConfig;
    }

    public ProtectionLauncherConfig getLauncherConfig(String string, String string2, int n, int n2) {
        boolean bl = BasicLicenseStorage.z;
        ProtectionLauncherConfig protectionLauncherConfig = null;
        Iterator iterator = this.getLauncherConfigs().iterator();
        while (protectionLauncherConfig == null && iterator.hasNext()) {
            protectionLauncherConfig = (ProtectionLauncherConfig)iterator.next();
            ProductInfo productInfo = protectionLauncherConfig.getProductInfo();
            if (string != LicenseStorage.ANY_PRODUCT && !string.equals(productInfo.getID())) {
                protectionLauncherConfig = null;
            } else if (string2 != LicenseStorage.ANY_PRODUCT_EDITION && !string2.equals(productInfo.getEdition())) {
                protectionLauncherConfig = null;
            } else if (n > -1 && n != productInfo.getMajorVersion()) {
                protectionLauncherConfig = null;
            } else if (n2 > -1 && n2 != productInfo.getMinorVersion()) {
                protectionLauncherConfig = null;
            }
            if (!bl) continue;
        }
        return protectionLauncherConfig;
    }

    protected ProtectionLauncher createLauncher(LicenseStorage.LicenseEntry licenseEntry, ProtectionLauncherConfig protectionLauncherConfig, Component component) {
        EntryProtectionLauncher entryProtectionLauncher = new EntryProtectionLauncher(licenseEntry, protectionLauncherConfig, component);
        entryProtectionLauncher.init();
        return entryProtectionLauncher;
    }

    public void addLauncherConfig(ProtectionLauncherConfig protectionLauncherConfig) {
        this.getLauncherConfigs().add(protectionLauncherConfig);
    }

    public ProtectionLauncherConfig getLauncherConfig(String string) {
        return (ProtectionLauncherConfig)this.fLauncherConfigs.get(string);
    }

    public Collection getLauncherConfigs() {
        return this.fLauncherConfigs;
    }

    public LicenseReader getLicenseReader(LicenseStorage.LicenseEntry licenseEntry, boolean bl) {
        ProtectionLauncherConfig protectionLauncherConfig = this.getLauncherConfig(licenseEntry, bl);
        if (protectionLauncherConfig == null) {
            throw new IllegalStateException(z);
        }
        EntryLicenseReader entryLicenseReader = new EntryLicenseReader(this, licenseEntry);
        entryLicenseReader.setDecryptKeyBytes(protectionLauncherConfig.getDecryptKeyBytes());
        entryLicenseReader.setSecurityAlgorithm(protectionLauncherConfig.getSecurityAlgorithm());
        return entryLicenseReader;
    }

    public void setModified(boolean bl) {
        this.fModified = bl;
    }

    protected String getLicenseFileLocation(LicenseStorage.LicenseEntry licenseEntry, LicenseReader licenseReader) {
        return licenseReader.getLicenseFileName();
    }

    protected void updateLicenseEntryProperties(LicenseStorage.LicenseEntry licenseEntry) {
        License license = this.getLicenseReader(licenseEntry, false).getLicense();
        if (license != null) {
            BasicLicenseStorage.updateLicenseEntryProperties(license, licenseEntry);
        }
    }

    public synchronized void addLauncherConfigStorageListener(LauncherConfigStorageListener launcherConfigStorageListener) {
        Vector vector;
        Vector vector2 = vector = this.fLauncherConfigStorageListeners == null ? new Vector(2) : (Vector)this.fLauncherConfigStorageListeners.clone();
        if (!vector.contains(launcherConfigStorageListener)) {
            vector.addElement(launcherConfigStorageListener);
            this.fLauncherConfigStorageListeners = vector;
        }
    }

    public synchronized void removeLauncherConfigStorageListener(LauncherConfigStorageListener launcherConfigStorageListener) {
        if (this.fLauncherConfigStorageListeners != null && this.fLauncherConfigStorageListeners.contains(launcherConfigStorageListener)) {
            Vector vector = (Vector)this.fLauncherConfigStorageListeners.clone();
            vector.removeElement(launcherConfigStorageListener);
            this.fLauncherConfigStorageListeners = vector;
        }
    }

    protected void fireLauncherConfigAdded(ProtectionLauncherConfig protectionLauncherConfig) {
        boolean bl = BasicLicenseStorage.z;
        if (this.fLauncherConfigStorageListeners != null) {
            Vector vector = this.fLauncherConfigStorageListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LauncherConfigStorageListener)vector.elementAt(i)).launcherConfigAdded(this, protectionLauncherConfig);
                if (!bl) continue;
            }
        }
    }

    protected void fireLauncherConfigRemoved(ProtectionLauncherConfig protectionLauncherConfig) {
        boolean bl = BasicLicenseStorage.z;
        if (this.fLauncherConfigStorageListeners != null) {
            Vector vector = this.fLauncherConfigStorageListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LauncherConfigStorageListener)vector.elementAt(i)).launcherConfigRemoved(this, protectionLauncherConfig);
                if (!bl) continue;
            }
        }
    }

    protected void fireLauncherConfigStorageLoaded() {
        boolean bl = BasicLicenseStorage.z;
        if (this.fLauncherConfigStorageListeners != null) {
            Vector vector = this.fLauncherConfigStorageListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LauncherConfigStorageListener)vector.elementAt(i)).launcherConfigStorageLoaded(this);
                if (!bl) continue;
            }
        }
    }

    protected void fireLauncherConfigStorageSaved() {
        boolean bl = BasicLicenseStorage.z;
        if (this.fLauncherConfigStorageListeners != null) {
            Vector vector = this.fLauncherConfigStorageListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LauncherConfigStorageListener)vector.elementAt(i)).launcherConfigStorageSaved(this);
                if (!bl) continue;
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                Object var0 = null;
                char[] cArray3 = "{\"\n[M_&\r\u0015MX-\u0019\\IB1\u001eAGX-_\\]\u0017-\u0010A\u000eQ,\n[J".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 55;
                            break;
                        }
                        case 1: {
                            n6 = 67;
                            break;
                        }
                        case 2: {
                            n6 = 127;
                            break;
                        }
                        case 3: {
                            n6 = 53;
                            break;
                        }
                        default: {
                            n6 = 46;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        z = new String(cArray).intern();
    }

    protected class EntryProtectionLauncher
    extends ProtectionLauncher {
        protected LicenseStorage.LicenseEntry fEntry;

        public EntryProtectionLauncher(LicenseStorage.LicenseEntry licenseEntry, ProtectionLauncherConfig protectionLauncherConfig, Component component) {
            super(protectionLauncherConfig, component);
            this.fEntry = licenseEntry;
        }

        protected LicenseReader createLicenseReader() {
            return new EntryLicenseReader(BasicLauncherConfigStorage.this, this.fEntry);
        }
    }

    public static class EntryLicenseReader
    extends LicenseReader {
        protected LicenseStorage.LicenseEntry fEntry;
        protected BasicLauncherConfigStorage fLauncherConfigStorage;

        public EntryLicenseReader(BasicLauncherConfigStorage basicLauncherConfigStorage, LicenseStorage.LicenseEntry licenseEntry) {
            this.fLauncherConfigStorage = basicLauncherConfigStorage;
            this.fEntry = licenseEntry;
        }

        public EntryLicenseReader(LicenseStorage.LicenseEntry licenseEntry) {
            this.fEntry = licenseEntry;
        }

        public InputStream getLicenseInputStream() {
            return this.fEntry.getLicenseBytes() != null ? new ByteArrayInputStream(this.fEntry.getLicenseBytes()) : null;
        }

        public InputStream getLicenseFileInputStream() {
            return this.getLicenseInputStream();
        }

        public InputStream getLicenseResourceInputStream() {
            return this.getLicenseInputStream();
        }

        public String getLicenseFileLocation() {
            return this.fLauncherConfigStorage != null ? this.fLauncherConfigStorage.getLicenseFileLocation(this.fEntry, this) : this.getLicenseFileName();
        }

        public OutputStream getLicenseOutputStream() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

                public void close() throws IOException {
                    super.close();
                    EntryLicenseReader.this.fEntry.setLicenseBytes(this.toByteArray());
                    if (EntryLicenseReader.this.fLauncherConfigStorage != null) {
                        EntryLicenseReader.this.fLauncherConfigStorage.updateLicenseEntryProperties(EntryLicenseReader.this.fEntry);
                    }
                }
            };
            return byteArrayOutputStream;
        }
    }
}

