/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.lserver;

import com.jp.protection.pub.pro.lserver.LicenseData;
import com.jp.protection.pub.pro.lserver.LicenseDataImpl;
import com.jp.protection.pub.pro.lserver.LicensingService;
import com.jp.protection.pub.pro.lserver.LicensingServiceProvider;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderFactory;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderListener;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderListenerSupport;
import com.jp.protection.pub.pro.lserver.LicensingServiceResult;
import com.jp.protection.pub.pro.lserver.LicensingServiceResultImpl;
import com.jp.protection.pub.pro.lserver.TimeoutHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BasicLicensingServiceProvider
implements LicensingServiceProvider {
    protected String fAddress;
    protected Map fAttributes;
    protected Map fProxyLicensingServiceMap = new HashMap();
    protected boolean fConfirmLicenseLocks = false;
    protected Thread fConfirmLicenseLocksThread;
    protected List fLicensingServices = new ArrayList();
    protected HashMap fTicketMap = new HashMap();
    protected HashMap fTicketLicenseDataMap = new HashMap();
    protected boolean fDefault = false;
    protected transient LicensingServiceProviderListenerSupport fListenerSupport = new LicensingServiceProviderListenerSupport();
    private static final /* synthetic */ String z;

    protected LicensingService createLicensingServiceProxy(LicensingService licensingService) {
        return new LicensingServiceProxy(licensingService);
    }

    public void init(String string, Map map) {
        this.fAddress = string;
        this.fAttributes = map;
    }

    public LicensingService createLicensingService(Map map) {
        map.putAll(this.fAttributes);
        LicensingService licensingService = this.createLicensingServiceImpl(map);
        LicensingService licensingService2 = this.createLicensingServiceProxy(licensingService);
        this.fProxyLicensingServiceMap.put(licensingService2, licensingService);
        this.fLicensingServices.add(licensingService2);
        this.fListenerSupport.fireLicensingServiceObtained(this, licensingService2);
        return licensingService2;
    }

    protected abstract LicensingService createLicensingServiceImpl(Map var1);

    protected abstract void releaseLicensingServiceImpl(LicensingService var1);

    public void releaseLicensingService(LicensingService licensingService) {
        int n = LicenseDataImpl.z;
        Iterator iterator = new HashSet(this.getTickets(licensingService)).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                licensingService.unlockLicense(string, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.removeTicket(licensingService, string);
            if (n == 0) continue;
        }
        try {
            this.releaseLicensingServiceImpl((LicensingService)this.fProxyLicensingServiceMap.get(licensingService));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fProxyLicensingServiceMap.remove(licensingService);
        this.fLicensingServices.remove(licensingService);
        this.fListenerSupport.fireLicensingServiceReleased(this, licensingService);
    }

    public void release() {
        int n = LicenseDataImpl.z;
        this.setConfirmLicenseLocks(false);
        Iterator iterator = new ArrayList(this.fLicensingServices).iterator();
        while (iterator.hasNext()) {
            this.releaseLicensingService((LicensingService)iterator.next());
            if (n == 0) continue;
        }
    }

    protected boolean confirmLicenseLocks(Map map) {
        int n = LicenseDataImpl.z;
        boolean bl = true;
        Iterator iterator = this.fLicensingServices.iterator();
        while (iterator.hasNext()) {
            if (this.confirmLicenseLocks((LicensingService)iterator.next(), map)) continue;
            bl = false;
            if (n == 0) continue;
        }
        return bl;
    }

    protected boolean confirmLicenseLocks(LicensingService licensingService, Map map) {
        int n = LicenseDataImpl.z;
        boolean bl = true;
        LicensingServiceProxy licensingServiceProxy = (LicensingServiceProxy)licensingService;
        Iterator iterator = this.getTickets(licensingServiceProxy).iterator();
        while (iterator.hasNext()) {
            String string;
            boolean bl2;
            String string2;
            block5: {
                string2 = (String)iterator.next();
                bl2 = false;
                string = null;
                if (!licensingServiceProxy.isExpired(string2)) {
                    try {
                        licensingServiceProxy.confirmLicenseLock(string2, map);
                        break block5;
                    }
                    catch (Throwable throwable) {
                        bl = false;
                        bl2 = licensingServiceProxy.isExpired(string2) && licensingServiceProxy.isNeedNotify(string2);
                        licensingServiceProxy.setErrorMessage(string2, BasicLicensingServiceProvider.getMessage(throwable));
                        if (n == 0) break block5;
                    }
                }
                bl = false;
                bl2 = licensingServiceProxy.isNeedNotify(string2);
                string = licensingServiceProxy.getErrorMessage(string2);
            }
            if (bl2) {
                this.fListenerSupport.fireLicenseLockConfirmed(this, licensingServiceProxy, string2, new LicensingServiceResultImpl(5, string, string2));
                licensingServiceProxy.setNeedNotify(string2, false);
            }
            if (n == 0) continue;
        }
        return bl;
    }

    public boolean isConfirmLicenseLocks() {
        return this.fConfirmLicenseLocks;
    }

    public void setConfirmLicenseLocks(boolean bl) {
        this.setConfirmLicenseLocks(bl, null);
    }

    protected long getLicenseLockConfirmPeriod() {
        long l = -1L;
        if (!this.fLicensingServices.isEmpty()) {
            l = ((LicensingServiceProxy)this.fLicensingServices.get(0)).getTimeout() / 5L;
        }
        if (l < 0L) {
            l = LicensingServiceProviderFactory.getLicenseLockConfirmPeriod();
        }
        return l;
    }

    public void setConfirmLicenseLocks(boolean bl, final Map map) {
        block2: {
            block3: {
                if (this.fConfirmLicenseLocks == bl) break block2;
                this.fConfirmLicenseLocks = bl;
                if (!this.fConfirmLicenseLocks) break block3;
                this.fConfirmLicenseLocksThread = new Thread(new Runnable(){
                    private Map fAttributes;
                    {
                        this.fAttributes = new HashMap(map != null ? map : Collections.EMPTY_MAP);
                    }

                    public void run() {
                        while (BasicLicensingServiceProvider.this.isConfirmLicenseLocks()) {
                            BasicLicensingServiceProvider.this.confirmLicenseLocks(this.fAttributes);
                            try {
                                Thread.currentThread();
                                Thread.sleep(BasicLicensingServiceProvider.this.getLicenseLockConfirmPeriod());
                            }
                            catch (Exception exception) {
                                // empty catch block
                                break;
                            }
                        }
                        BasicLicensingServiceProvider.this.fConfirmLicenseLocksThread = null;
                    }
                }, z);
                this.fConfirmLicenseLocksThread.setPriority(3);
                this.fConfirmLicenseLocksThread.start();
                if (LicenseDataImpl.z == 0) break block2;
            }
            this.fConfirmLicenseLocksThread = null;
        }
    }

    protected Set getTickets(LicensingService licensingService) {
        Set set = (Set)this.fTicketMap.get(licensingService);
        return set != null ? set : Collections.EMPTY_SET;
    }

    protected LicenseData getLicenseData(String string) {
        return (LicenseData)this.fTicketLicenseDataMap.get(string);
    }

    protected void addTicket(LicensingService licensingService, String string, LicenseData licenseData) {
        HashSet<String> hashSet = (HashSet<String>)this.fTicketMap.get(licensingService);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            this.fTicketMap.put(licensingService, hashSet);
        }
        hashSet.add(string);
        if (licenseData != null) {
            this.fTicketLicenseDataMap.put(string, licenseData);
        }
    }

    protected void removeTicket(LicensingService licensingService, String string) {
        Set set = (Set)this.fTicketMap.get(licensingService);
        if (set != null) {
            set.remove(string);
            this.fTicketLicenseDataMap.remove(string);
            if (set.isEmpty()) {
                this.fTicketMap.remove(licensingService);
            }
        }
    }

    public boolean isDefault() {
        return this.fDefault;
    }

    public void setDefault(boolean bl) {
        this.fDefault = bl;
    }

    public synchronized void addLicensingServiceProviderListener(LicensingServiceProviderListener licensingServiceProviderListener) {
        this.fListenerSupport.addLicensingServiceProviderListener(licensingServiceProviderListener);
    }

    public synchronized void removeLicensingServiceProviderListener(LicensingServiceProviderListener licensingServiceProviderListener) {
        this.fListenerSupport.removeLicensingServiceProviderListener(licensingServiceProviderListener);
    }

    public static String getMessage(Throwable throwable) {
        Throwable throwable2;
        int n;
        String string = null;
        if (throwable.getCause() != null && throwable.getCause() instanceof IOException && (n = (string = (throwable2 = throwable.getCause()).getMessage()).indexOf(";")) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                Object var0 = null;
                char[] cArray3 = "(E+1{9G\t>q.D62^$I.$F#X 6v".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 75;
                            break;
                        }
                        case 1: {
                            n6 = 42;
                            break;
                        }
                        case 2: {
                            n6 = 69;
                            break;
                        }
                        case 3: {
                            n6 = 87;
                            break;
                        }
                        default: {
                            n6 = 18;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        z = new String(cArray).intern();
    }

    protected class LicensingServiceProxy
    implements LicensingService,
    TimeoutHolder {
        protected LicensingService fLicensingService;
        protected long fTimeout = -1L;
        protected Map fConfirmLicenseLockTimeMap = new HashMap();
        protected Map fErrorMessageMap = new HashMap();
        protected Set fNeedNotifySet = new HashSet();

        public LicensingServiceProxy(LicensingService licensingService) {
            this.fLicensingService = licensingService;
        }

        public LicensingService getLicensingService() {
            return this.fLicensingService;
        }

        public LicensingServiceResult.LicenseResult getLicense(LicenseData.Request request, Map map) {
            LicensingServiceResult.LicenseResult licenseResult = this.fLicensingService.getLicense(request, map);
            if (licenseResult.getResult() == 1 && licenseResult.getTicket() != null) {
                BasicLicensingServiceProvider.this.addTicket(this.fLicensingService, licenseResult.getTicket(), licenseResult.getResponse());
            }
            BasicLicensingServiceProvider.this.fListenerSupport.fireLicenseGot(BasicLicensingServiceProvider.this, this.fLicensingService, request, licenseResult);
            return licenseResult;
        }

        public LicensingServiceResult lockLicense(LicenseData.Request request, Map map) {
            LicensingServiceResult licensingServiceResult = this.fLicensingService.lockLicense(request, map);
            if (licensingServiceResult.getResult() == 1 && licensingServiceResult.getTicket() != null) {
                BasicLicensingServiceProvider.this.addTicket(this, licensingServiceResult.getTicket(), request);
                this.licenseLockConfirmed(licensingServiceResult.getTicket());
            }
            BasicLicensingServiceProvider.this.fListenerSupport.fireLicenseLocked(BasicLicensingServiceProvider.this, this, request, licensingServiceResult);
            if (this.fTimeout < 0L) {
                this.fTimeout = this.fLicensingService instanceof TimeoutHolder ? ((TimeoutHolder)((Object)this.fLicensingService)).getTimeout() : -1L;
            }
            return licensingServiceResult;
        }

        public LicensingServiceResult canLockLicense(LicenseData.Request request, Map map) {
            LicensingServiceResult licensingServiceResult = this.fLicensingService.canLockLicense(request, map);
            if (licensingServiceResult.getResult() == 1) {
                BasicLicensingServiceProvider.this.fListenerSupport.fireLicenseCanLocked(BasicLicensingServiceProvider.this, this, request, licensingServiceResult);
            }
            return licensingServiceResult;
        }

        public boolean isExpired(String string) {
            Long l = (Long)this.fConfirmLicenseLockTimeMap.get(string);
            return l != null ? System.currentTimeMillis() - l > this.fTimeout : true;
        }

        protected void licenseLockConfirmed(String string) {
            this.fConfirmLicenseLockTimeMap.put(string, new Long(System.currentTimeMillis()));
        }

        public LicensingServiceResult confirmLicenseLock(String string, Map map) {
            LicensingServiceResult licensingServiceResult = this.fLicensingService.confirmLicenseLock(string, map);
            if (licensingServiceResult.getResult() == 1) {
                this.licenseLockConfirmed(string);
            }
            BasicLicensingServiceProvider.this.fListenerSupport.fireLicenseLockConfirmed(BasicLicensingServiceProvider.this, this, string, licensingServiceResult);
            return licensingServiceResult;
        }

        public LicensingServiceResult unlockLicense(String string, Map map) {
            LicensingServiceResult licensingServiceResult = this.fLicensingService.unlockLicense(string, map);
            if (licensingServiceResult.getResult() == 1 && licensingServiceResult.getTicket() != null) {
                BasicLicensingServiceProvider.this.removeTicket(this, string);
                this.fConfirmLicenseLockTimeMap.remove(string);
                this.setErrorMessage(string, null);
                this.setNeedNotify(string, true);
            }
            BasicLicensingServiceProvider.this.fListenerSupport.fireLicenseUnlocked(BasicLicensingServiceProvider.this, this, string, licensingServiceResult);
            return licensingServiceResult;
        }

        public long getTimeout() {
            return this.fTimeout;
        }

        public String getErrorMessage(String string) {
            return (String)this.fErrorMessageMap.get(string);
        }

        public void setErrorMessage(String string, String string2) {
            block3: {
                block2: {
                    if (string2 == null) break block2;
                    this.fErrorMessageMap.put(string, string2);
                    if (LicenseDataImpl.z == 0) break block3;
                }
                this.fErrorMessageMap.remove(string);
            }
        }

        public void setNeedNotify(String string, boolean bl) {
            block3: {
                block2: {
                    if (!bl) break block2;
                    this.fNeedNotifySet.remove(string);
                    if (LicenseDataImpl.z == 0) break block3;
                }
                this.fNeedNotifySet.add(string);
            }
        }

        public boolean isNeedNotify(String string) {
            return !this.fNeedNotifySet.contains(string);
        }
    }
}

