/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.security;

import com.jp.protection.security.SecurityProvider;
import dev.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;

class RSASecurityProvider
implements SecurityProvider {
    public static final String NAME;
    public static final String ID;
    private KeyPairGeneratorRSA fKeyPairGenerator;
    private static final int[] SUPPORTED_KEY_LENGTHS;

    RSASecurityProvider() {
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encode(byte[] byArray, PrivateKey privateKey) {
        boolean bl = BasicKey.z;
        byte[] byArray2 = null;
        try {
            BigInteger[] bigIntegerArray = RSASecurityProvider.encode(byArray, (BasicKey)((Object)privateKey));
            int n = 0;
            for (int i = 0; i < bigIntegerArray.length; ++i) {
                BigInteger bigInteger = bigIntegerArray[i];
                n += bigInteger.bitLength() / 8 + 1 + 4;
                if (!bl) continue;
            }
            byte[][] byArrayArray = new byte[bigIntegerArray.length][];
            for (int i = 0; i < bigIntegerArray.length; ++i) {
                byArrayArray[i] = bigIntegerArray[i].toByteArray();
                if (!bl) continue;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                try {
                    objectOutputStream.writeObject(byArrayArray);
                }
                finally {
                    objectOutputStream.close();
                }
                byArray2 = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    private static BigInteger[] encode(byte[] byArray, BasicKey basicKey) throws ArithmeticException {
        boolean bl = BasicKey.z;
        byte[] byArray2 = basicKey.getKey().toByteArray();
        byte[] byArray3 = basicKey.getModulo().toByteArray();
        BigInteger[] bigIntegerArray = new BigInteger[byArray.length];
        for (int i = 0; i < bigIntegerArray.length; ++i) {
            byte[] byArray4 = new byte[]{byArray[i]};
            bigIntegerArray[i] = new BigInteger(byArray4);
            if (!bl) continue;
        }
        BigInteger[] bigIntegerArray2 = new BigInteger[bigIntegerArray.length];
        BigInteger bigInteger = new BigInteger(byArray2);
        BigInteger bigInteger2 = new BigInteger(byArray3);
        for (int i = 0; i < bigIntegerArray.length; ++i) {
            bigIntegerArray2[i] = bigIntegerArray[i].modPow(bigInteger, bigInteger2);
            if (!bl) continue;
        }
        return bigIntegerArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decode(byte[] byArray, PublicKey publicKey) {
        boolean bl = BasicKey.z;
        byte[] byArray2 = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                byte[][] byArray3 = (byte[][])objectInputStream.readObject();
                BigInteger[] bigIntegerArray = new BigInteger[byArray3.length];
                for (int i = 0; i < byArray3.length; ++i) {
                    bigIntegerArray[i] = new BigInteger(byArray3[i]);
                    if (!bl) continue;
                }
                byArray2 = RSASecurityProvider.decrypt(bigIntegerArray, (BasicKey)((Object)publicKey));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                objectInputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray2;
    }

    private static byte[] decrypt(BigInteger[] bigIntegerArray, BasicKey basicKey) throws ArithmeticException {
        boolean bl = BasicKey.z;
        BigInteger[] bigIntegerArray2 = new BigInteger[bigIntegerArray.length];
        for (int i = 0; i < bigIntegerArray2.length; ++i) {
            bigIntegerArray2[i] = new BigInteger(bigIntegerArray[i].toString()).modPow(basicKey.getKey(), basicKey.getModulo());
            if (!bl) continue;
        }
        byte[] byArray = new byte[bigIntegerArray2.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = bigIntegerArray2[i].byteValue();
            if (!bl) continue;
        }
        return byArray;
    }

    public KeyPair generateKeyPair() {
        if (this.fKeyPairGenerator == null) {
            this.fKeyPairGenerator = new KeyPairGeneratorRSA(128);
        }
        return this.fKeyPairGenerator.generateKeyPair();
    }

    public byte[] getPrivateKeyData(PrivateKey privateKey) {
        return this.getKeyData((BasicKey)((Object)privateKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey getPrivateKey(byte[] byArray) {
        PrivateKeyRSA privateKeyRSA = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                BigInteger bigInteger = (BigInteger)objectInputStream.readObject();
                BigInteger bigInteger2 = (BigInteger)objectInputStream.readObject();
                privateKeyRSA = new PrivateKeyRSA(bigInteger, bigInteger2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                objectInputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return privateKeyRSA;
    }

    public byte[] getPublicKeyData(PublicKey publicKey) {
        return this.getKeyData((BasicKey)((Object)publicKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getKeyData(BasicKey basicKey) {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                objectOutputStream.writeObject(basicKey.getKey());
                objectOutputStream.writeObject(basicKey.getModulo());
            }
            finally {
                objectOutputStream.close();
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey getPublicKey(byte[] byArray) {
        PublicKeyRSA publicKeyRSA = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                BigInteger bigInteger = (BigInteger)objectInputStream.readObject();
                BigInteger bigInteger2 = (BigInteger)objectInputStream.readObject();
                publicKeyRSA = new PublicKeyRSA(bigInteger, bigInteger2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                objectInputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return publicKeyRSA;
    }

    public int[] getSupportedKeyLengths() {
        return SUPPORTED_KEY_LENGTHS;
    }

    public int getKeyLength() {
        return 128;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block21: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block20: {
                char[] cArray3;
                Object var0;
                block19: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block18: {
                        var0 = null;
                        char[] cArray5 = "]=x\u0004\u0007d6*F".toCharArray();
                        n3 = 0;
                        int n6 = cArray5.length;
                        cArray4 = cArray5;
                        n5 = n6;
                        if (n6 <= 1) break block18;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block19;
                    }
                    do {
                        char[] cArray6 = cArray4;
                        char[] cArray7 = cArray4;
                        int n7 = n3;
                        while (true) {
                            int n8;
                            char c = cArray6[n7];
                            switch (n3 % 5) {
                                case 0: {
                                    n8 = 11;
                                    break;
                                }
                                case 1: {
                                    n8 = 88;
                                    break;
                                }
                                case 2: {
                                    n8 = 10;
                                    break;
                                }
                                case 3: {
                                    n8 = 119;
                                    break;
                                }
                                default: {
                                    n8 = 110;
                                }
                            }
                            cArray6[n7] = (char)(c ^ n8);
                            ++n3;
                            cArray4 = cArray7;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray7 = cArray4;
                            n4 = n5;
                            n7 = n5;
                            cArray6 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                NAME = new String(cArray3).intern();
                var0 = null;
                char[] cArray8 = "Y\u000bK".toCharArray();
                n3 = 0;
                int n9 = cArray8.length;
                cArray2 = cArray8;
                n2 = n9;
                if (n9 <= 1) break block20;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block21;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n10 = n3;
                while (true) {
                    int n11;
                    char c = cArray9[n10];
                    switch (n3 % 5) {
                        case 0: {
                            n11 = 11;
                            break;
                        }
                        case 1: {
                            n11 = 88;
                            break;
                        }
                        case 2: {
                            n11 = 10;
                            break;
                        }
                        case 3: {
                            n11 = 119;
                            break;
                        }
                        default: {
                            n11 = 110;
                        }
                    }
                    cArray9[n10] = (char)(c ^ n11);
                    ++n3;
                    cArray2 = cArray10;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray10 = cArray2;
                    n = n2;
                    n10 = n2;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        ID = new String(cArray).intern();
        SUPPORTED_KEY_LENGTHS = new int[]{64, 128, 256};
    }

    private static class KeyPairGeneratorRSA
    extends KeyPairGenerator {
        private static final BigInteger ONE;
        private BigInteger N;
        private BigInteger x;
        private BigInteger y;
        private int strength;
        private SecureRandom random;
        private static final /* synthetic */ String z;

        public KeyPairGeneratorRSA() {
            this(512);
        }

        public KeyPairGeneratorRSA(int n) {
            this(n, null, null);
        }

        public KeyPairGeneratorRSA(int n, BigInteger bigInteger, BigInteger bigInteger2) {
            boolean bl = BasicKey.z;
            super(z);
            this.initialize(n);
            if (bigInteger == null || bigInteger2 == null) {
                bigInteger = new BigInteger(n, 99, this.random);
                bigInteger2 = new BigInteger(n, 99, this.random);
                while (!bigInteger.isProbablePrime(100)) {
                    bigInteger = new BigInteger(n, 99, this.random);
                    if (!bl) continue;
                }
                while (!bigInteger2.isProbablePrime(100)) {
                    bigInteger2 = new BigInteger(n, 99, this.random);
                    if (!bl) continue;
                }
            }
            this.x = bigInteger;
            this.y = bigInteger2;
            this.N = bigInteger.multiply(bigInteger2);
        }

        public void initialize(int n) {
            this.initialize(n, null);
        }

        public void initialize(int n, SecureRandom secureRandom) {
            this.setStrength(n);
            if (secureRandom == null) {
                secureRandom = new SecureRandom();
            }
            this.random = secureRandom;
        }

        public KeyPair generateKeyPair() {
            boolean bl = BasicKey.z;
            BigInteger bigInteger = new BigInteger(this.strength, 99, this.random);
            while (!bigInteger.isProbablePrime(100)) {
                bigInteger = new BigInteger(this.strength, 99, this.random);
                if (!bl) continue;
                StringUtils.z = !StringUtils.z;
                break;
            }
            BigInteger bigInteger2 = bigInteger.modInverse(this.x.subtract(ONE).multiply(this.y.subtract(ONE)));
            return new KeyPair(new PublicKeyRSA(bigInteger2, this.N, this.getAlgorithm()), new PrivateKeyRSA(bigInteger, this.N, this.getAlgorithm()));
        }

        public int getStrength() {
            return this.strength;
        }

        public void setStrength(int n) {
            this.strength = n;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n;
                int n2;
                char[] cArray2;
                int n3;
                block9: {
                    Object var0 = null;
                    char[] cArray3 = "\u001bm8".toCharArray();
                    n3 = 0;
                    int n4 = cArray3.length;
                    cArray2 = cArray3;
                    n2 = n4;
                    if (n4 <= 1) break block9;
                    cArray = cArray2;
                    n = n2;
                    if (n2 <= n3) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n5 = n3;
                    while (true) {
                        int n6;
                        char c = cArray4[n5];
                        switch (n3 % 5) {
                            case 0: {
                                n6 = 73;
                                break;
                            }
                            case 1: {
                                n6 = 62;
                                break;
                            }
                            case 2: {
                                n6 = 121;
                                break;
                            }
                            case 3: {
                                n6 = 115;
                                break;
                            }
                            default: {
                                n6 = 96;
                            }
                        }
                        cArray4[n5] = (char)(c ^ n6);
                        ++n3;
                        cArray2 = cArray5;
                        n2 = n2;
                        if (n2 != 0) break;
                        cArray5 = cArray2;
                        n = n2;
                        n5 = n2;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n = n2;
                } while (n2 > n3);
            }
            z = new String(cArray).intern();
            ONE = new BigInteger("1");
        }
    }

    private static class PrivateKeyRSA
    extends BasicKey
    implements PrivateKey {
        private static final /* synthetic */ String A;

        public PrivateKeyRSA(BigInteger bigInteger, BigInteger bigInteger2) {
            this(bigInteger, bigInteger2, A);
        }

        public PrivateKeyRSA(BigInteger bigInteger, BigInteger bigInteger2, String string) {
            super(bigInteger, bigInteger2, string);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n;
                int n2;
                char[] cArray2;
                int n3;
                block9: {
                    Object var0 = null;
                    char[] cArray3 = "L\u001a\u0015".toCharArray();
                    n3 = 0;
                    int n4 = cArray3.length;
                    cArray2 = cArray3;
                    n2 = n4;
                    if (n4 <= 1) break block9;
                    cArray = cArray2;
                    n = n2;
                    if (n2 <= n3) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n5 = n3;
                    while (true) {
                        int n6;
                        char c = cArray4[n5];
                        switch (n3 % 5) {
                            case 0: {
                                n6 = 30;
                                break;
                            }
                            case 1: {
                                n6 = 73;
                                break;
                            }
                            case 2: {
                                n6 = 84;
                                break;
                            }
                            case 3: {
                                n6 = 51;
                                break;
                            }
                            default: {
                                n6 = 5;
                            }
                        }
                        cArray4[n5] = (char)(c ^ n6);
                        ++n3;
                        cArray2 = cArray5;
                        n2 = n2;
                        if (n2 != 0) break;
                        cArray5 = cArray2;
                        n = n2;
                        n5 = n2;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n = n2;
                } while (n2 > n3);
            }
            A = new String(cArray).intern();
        }
    }

    public static class PublicKeyRSA
    extends BasicKey
    implements PublicKey {
        private static final /* synthetic */ String A;

        private PublicKeyRSA(BigInteger bigInteger, BigInteger bigInteger2) {
            this(bigInteger, bigInteger2, A);
        }

        private PublicKeyRSA(BigInteger bigInteger, BigInteger bigInteger2, String string) {
            super(bigInteger, bigInteger2, string);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n;
                int n2;
                char[] cArray2;
                int n3;
                block9: {
                    Object var0 = null;
                    char[] cArray3 = "WV\u0001".toCharArray();
                    n3 = 0;
                    int n4 = cArray3.length;
                    cArray2 = cArray3;
                    n2 = n4;
                    if (n4 <= 1) break block9;
                    cArray = cArray2;
                    n = n2;
                    if (n2 <= n3) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n5 = n3;
                    while (true) {
                        int n6;
                        char c = cArray4[n5];
                        switch (n3 % 5) {
                            case 0: {
                                n6 = 5;
                                break;
                            }
                            case 1: {
                                n6 = 5;
                                break;
                            }
                            case 2: {
                                n6 = 64;
                                break;
                            }
                            case 3: {
                                n6 = 18;
                                break;
                            }
                            default: {
                                n6 = 94;
                            }
                        }
                        cArray4[n5] = (char)(c ^ n6);
                        ++n3;
                        cArray2 = cArray5;
                        n2 = n2;
                        if (n2 != 0) break;
                        cArray5 = cArray2;
                        n = n2;
                        n5 = n2;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n = n2;
                } while (n2 > n3);
            }
            A = new String(cArray).intern();
        }
    }

    public static class BasicKey {
        private BigInteger fKey;
        private BigInteger fModulo;
        private String fAlgorithm;
        public static /* synthetic */ boolean z;

        private BasicKey(BigInteger bigInteger, BigInteger bigInteger2, String string) {
            this.fKey = bigInteger;
            this.fModulo = bigInteger2;
            this.fAlgorithm = string;
        }

        public BigInteger getKey() {
            return this.fKey;
        }

        public BigInteger getModulo() {
            return this.fModulo;
        }

        public String getAlgorithm() {
            return this.fAlgorithm;
        }

        public String getFormat() {
            return null;
        }

        public byte[] getEncoded() {
            return null;
        }

        public String toString() {
            return this.toString(16);
        }

        public String toString(int n) {
            return this.fKey.toString(n);
        }
    }
}

