/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.ComponentPainter;
import dev.gui.IconComponentPainter;
import dev.gui.JCDialog;
import dev.gui.JTextFieldEx;
import dev.gui.ResourceUtils;
import dev.gui.TooltipProvider;
import dev.lang.BitTools;
import dev.util.collections.HashedBoundList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class BasicComponentPainter
implements ComponentPainter,
TooltipProvider {
    protected int fWidth;
    protected int fHeight;
    protected int fAlignment = 16;
    protected boolean fRespectInsets = true;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 4;
    public static final int RIGHT = 8;
    public static final int CENTER = 16;
    private static Insets NO_INSETS;
    protected String fTooltipText;
    private static final /* synthetic */ String z;

    public BasicComponentPainter() {
    }

    public BasicComponentPainter(int n, int n2) {
        this(n, n2, 16, true);
    }

    public BasicComponentPainter(int n, int n2, int n3) {
        this(n, n2, n3, true);
    }

    public BasicComponentPainter(int n, int n2, int n3, boolean bl) {
        this.fWidth = n;
        this.fHeight = n2;
        this.fAlignment = n3;
        this.fRespectInsets = bl;
    }

    public int getHeight(Graphics graphics, Component component) {
        return this.fHeight;
    }

    public int getWidth(Graphics graphics, Component component) {
        return this.fWidth;
    }

    public int getAlignment() {
        return this.fAlignment;
    }

    public boolean isRespectInsets() {
        return this.fRespectInsets;
    }

    public Rectangle getBounds(Graphics graphics, Component component) {
        Point point = this.getOrigin(graphics, component);
        return new Rectangle(point.x, point.y, this.getWidth(graphics, component), this.getHeight(graphics, component));
    }

    public Point getOrigin(Graphics graphics, Component component) {
        Point point;
        block8: {
            int n;
            int n2;
            Insets insets;
            block9: {
                int n3;
                boolean bl;
                block7: {
                    block5: {
                        int n4;
                        int n5;
                        block6: {
                            block4: {
                                bl = HashedBoundList.z;
                                point = new Point(0, 0);
                                insets = this.isRespectInsets() && component instanceof JComponent ? ((JComponent)component).getInsets() : NO_INSETS;
                                n3 = this.getAlignment();
                                n5 = this.getWidth(graphics, component);
                                n2 = this.getHeight(graphics, component);
                                n4 = component.getWidth() - insets.left - insets.right;
                                n = component.getHeight() - insets.top - insets.bottom;
                                if (!BitTools.checkBit(n3, 2)) break block4;
                                point.x = insets.left;
                                if (!bl) break block5;
                            }
                            if (!BitTools.checkBit(n3, 8)) break block6;
                            point.x = insets.left + n4 - n5 - 1;
                            if (!bl) break block5;
                        }
                        point.x = insets.left + (n4 - n5) / 2;
                    }
                    if (!BitTools.checkBit(n3, 1)) break block7;
                    point.y = insets.top;
                    if (!bl) break block8;
                }
                if (!BitTools.checkBit(n3, 4)) break block9;
                point.y = insets.top + n - n2 - 1;
                if (!bl) break block8;
            }
            point.y = insets.top + (n - n2) / 2;
        }
        return point;
    }

    public void paint(Graphics graphics, Component component) {
        Point point = this.getOrigin(graphics, component);
        graphics.translate(point.x, point.y);
        this.paintImpl(graphics, component);
        graphics.translate(-point.x, -point.y);
    }

    protected void paintImpl(Graphics graphics, Component component) {
        graphics.setColor(Color.red);
        graphics.drawRect(0, 0, this.getWidth(graphics, component), this.getHeight(graphics, component));
    }

    public static void main(String[] stringArray) {
        JTextFieldEx jTextFieldEx = new JTextFieldEx();
        jTextFieldEx.setPreferredWidth(150);
        jTextFieldEx.addComponentPainter(new IconComponentPainter(ResourceUtils.loadImageIcon(z), 2));
        JCDialog.executeModal(null, "", (JComponent)jTextFieldEx);
        System.exit(0);
    }

    public String getTooltipText() {
        return this.fTooltipText;
    }

    public void setTooltipText(String string) {
        this.fTooltipText = string;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        if (this.fTooltipText != null && this.getBounds(mouseEvent.getComponent().getGraphics(), mouseEvent.getComponent()).contains(mouseEvent.getPoint())) {
            string = this.fTooltipText;
        }
        return string;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                Object var0 = null;
                char[] cArray3 = "A\u0007\u0002\\\"\t\u0016\u000e\u0005z\u0007\u0019\u0006XiA\u0011\u0002Y\"\u001a\u000b\u0015Eo\f\u0006\u0015\u0004j\u0007\u0005".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 110;
                            break;
                        }
                        case 1: {
                            n6 = 99;
                            break;
                        }
                        case 2: {
                            n6 = 103;
                            break;
                        }
                        case 3: {
                            n6 = 42;
                            break;
                        }
                        default: {
                            n6 = 13;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        z = new String(cArray).intern();
        NO_INSETS = new Insets(0, 0, 0, 0);
    }
}

