/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.util.StringUtils;
import dev.util.collections.HashedBoundList;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.HTML;

public class HyperlinkSupport
extends MouseAdapter
implements MouseMotionListener {
    protected String fCurrentHref;
    protected Cursor fSavedCursor;
    private static Position.Bias[] fSharedBiasReturn;
    private static Rectangle paintIconR;
    private static Rectangle paintTextR;
    private static Rectangle paintViewR;
    private static Insets paintViewInsets;
    protected String fHREFDescription;
    private transient Vector fHyperlinkListeners;
    private static final /* synthetic */ String z;

    public HyperlinkSupport() {
        this(null, null);
    }

    public HyperlinkSupport(JComponent jComponent) {
        this(jComponent, null);
    }

    public HyperlinkSupport(JComponent jComponent, HyperlinkListener hyperlinkListener) {
        if (jComponent != null) {
            jComponent.addMouseListener(this);
            jComponent.addMouseMotionListener(this);
        }
        if (hyperlinkListener != null) {
            this.addHyperlinkListener(hyperlinkListener);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.setCurrentHref((JComponent)mouseEvent.getSource(), this.getHref(mouseEvent));
    }

    protected boolean isHandCursor(JComponent jComponent) {
        return jComponent.getCursor() == Cursor.getPredefinedCursor(12);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.fCurrentHref != null && ((JComponent)mouseEvent.getSource()).isEnabled()) {
            this.activateHref((JComponent)mouseEvent.getSource());
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCurrentHref((JComponent)mouseEvent.getSource(), null);
    }

    public String getCurrentHref() {
        return this.fCurrentHref;
    }

    public void setCurrentHref(JComponent jComponent, String string) {
        if (!StringUtils.equals(this.fCurrentHref, string)) {
            if (this.fCurrentHref != null) {
                this.leaveHref(jComponent);
            }
            this.fCurrentHref = string;
            if (this.fCurrentHref != null) {
                this.enterHref(jComponent);
            }
            this.setHandCursor(jComponent, this.fCurrentHref != null);
        }
    }

    protected HyperlinkEvent createHyperlinkEvent(JComponent jComponent, HyperlinkEvent.EventType eventType) {
        URL uRL = null;
        try {
            uRL = new URL(this.fCurrentHref);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new HyperlinkEvent(jComponent, eventType, uRL, this.fHREFDescription != null ? this.fHREFDescription : this.fCurrentHref);
    }

    protected void enterHref(JComponent jComponent) {
        this.fireHyperlinkUpdate(this.createHyperlinkEvent(jComponent, HyperlinkEvent.EventType.ENTERED));
    }

    protected void leaveHref(JComponent jComponent) {
        this.fireHyperlinkUpdate(this.createHyperlinkEvent(jComponent, HyperlinkEvent.EventType.EXITED));
    }

    protected void activateHref(JComponent jComponent) {
        this.fireHyperlinkUpdate(this.createHyperlinkEvent(jComponent, HyperlinkEvent.EventType.ACTIVATED));
        this.setCurrentHref(jComponent, null);
    }

    protected void setHandCursor(JComponent jComponent, boolean bl) {
        block2: {
            block3: {
                if (this.isHandCursor(jComponent) == bl) break block2;
                if (!bl) break block3;
                this.fSavedCursor = jComponent.getCursor();
                jComponent.setCursor(Cursor.getPredefinedCursor(12));
                if (!HashedBoundList.z) break block2;
            }
            jComponent.setCursor(this.fSavedCursor);
        }
    }

    protected Rectangle getPaintTextRect(JComponent jComponent) {
        if (jComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)jComponent;
            FontMetrics fontMetrics = jLabel.getGraphics().getFontMetrics();
            Insets insets = jLabel.getInsets(paintViewInsets);
            HyperlinkSupport.paintViewR.x = insets.left;
            HyperlinkSupport.paintViewR.y = insets.top;
            HyperlinkSupport.paintViewR.width = jLabel.getWidth() - (insets.left + insets.right);
            HyperlinkSupport.paintViewR.height = jLabel.getHeight() - (insets.top + insets.bottom);
            HyperlinkSupport.paintIconR.height = 0;
            HyperlinkSupport.paintIconR.width = 0;
            HyperlinkSupport.paintIconR.y = 0;
            HyperlinkSupport.paintIconR.x = 0;
            HyperlinkSupport.paintTextR.height = 0;
            HyperlinkSupport.paintTextR.width = 0;
            HyperlinkSupport.paintTextR.y = 0;
            HyperlinkSupport.paintTextR.x = 0;
            this.layoutCL(jLabel, fontMetrics, jLabel.getText(), jLabel.getIcon(), paintViewR, paintIconR, paintTextR);
            return paintTextR;
        }
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = jComponent.getBounds();
        Rectangle rectangle2 = new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
        return rectangle2;
    }

    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        return SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
    }

    protected String getHref(MouseEvent mouseEvent) {
        Document document;
        boolean bl = HashedBoundList.z;
        String string = null;
        View view = (View)((JLabel)mouseEvent.getSource()).getClientProperty(z);
        if (view != null && (document = view.getDocument()) != null) {
            Element element;
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            int n = view.viewToModel(mouseEvent.getX(), mouseEvent.getY(), this.getPaintTextRect(jComponent), fSharedBiasReturn);
            ElementIterator elementIterator = new ElementIterator(document);
            while ((element = elementIterator.next()) != null || bl) {
                if (element == null || !element.isLeaf() || element.getStartOffset() > n || n >= element.getEndOffset()) continue;
                AttributeSet attributeSet = element.getAttributes();
                AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                if (attributeSet2 != null) {
                    string = (String)attributeSet2.getAttribute(HTML.Attribute.HREF);
                    if (string != null) {
                        this.fHREFDescription = (String)attributeSet2.getAttribute(HTML.Attribute.TITLE);
                        if (this.fHREFDescription != null) break;
                        this.fHREFDescription = (String)attributeSet2.getAttribute(HTML.Attribute.ALT);
                        if (!bl) break;
                    }
                    this.fHREFDescription = null;
                    break;
                }
                string = null;
                if (bl) continue;
            }
        }
        return string;
    }

    public synchronized void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        if (this.fHyperlinkListeners != null && this.fHyperlinkListeners.contains(hyperlinkListener)) {
            Vector vector = (Vector)this.fHyperlinkListeners.clone();
            vector.removeElement(hyperlinkListener);
            this.fHyperlinkListeners = vector;
        }
    }

    public synchronized void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        Vector vector;
        Vector vector2 = vector = this.fHyperlinkListeners == null ? new Vector(2) : (Vector)this.fHyperlinkListeners.clone();
        if (!vector.contains(hyperlinkListener)) {
            vector.addElement(hyperlinkListener);
            this.fHyperlinkListeners = vector;
        }
    }

    protected void fireHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        boolean bl = HashedBoundList.z;
        if (this.fHyperlinkListeners != null) {
            Vector vector = this.fHyperlinkListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((HyperlinkListener)vector.elementAt(i)).hyperlinkUpdate(hyperlinkEvent);
                if (!bl) continue;
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                Object var0 = null;
                char[] cArray3 = "pX\fi".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 24;
                            break;
                        }
                        case 1: {
                            n6 = 44;
                            break;
                        }
                        case 2: {
                            n6 = 97;
                            break;
                        }
                        case 3: {
                            n6 = 5;
                            break;
                        }
                        default: {
                            n6 = 102;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        z = new String(cArray).intern();
        fSharedBiasReturn = new Position.Bias[]{Position.Bias.Forward};
        paintIconR = new Rectangle();
        paintTextR = new Rectangle();
        paintViewR = new Rectangle();
        paintViewInsets = new Insets(0, 0, 0, 0);
    }
}

