/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.ComponentFontSupport;
import dev.gui.ComponentPainter;
import dev.gui.ComponentPainterHolder;
import dev.gui.ComponentPainterSupport;
import dev.gui.DelegateListCellRenderer;
import dev.gui.IndicatorHolder;
import dev.gui.JTextFieldEx;
import dev.gui.border.IndicatorBorder;
import dev.util.StringUtils;
import dev.util.collections.HashedBoundList;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class JComboBoxEx
extends JComboBox
implements FocusListener,
IndicatorHolder,
ComponentPainterHolder {
    protected boolean fSelectAllOnFocusGain = true;
    protected IndicatorBorder fIndicatorBorder;
    protected Border fOriginalBorder;
    protected int fMinimumHeight = -1;
    protected int fMinimumWidth = -1;
    protected int fPreferredHeight = -1;
    protected int fPreferredWidth = -1;
    protected ComponentPainterSupport fComponentPainterSupport;
    protected JTextFieldEx.PromptTextComponentPainter fPromptTextComponentPainter;
    protected String fPromptText;
    protected ComponentFontSupport fComponentFontSupport = new ComponentFontSupport(this);
    protected DelegateListCellRenderer fDelegateRenderer;

    public JComboBoxEx(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
    }

    public JComboBoxEx(Object[] objectArray) {
        super(objectArray);
    }

    public JComboBoxEx(Vector vector) {
        super(vector);
    }

    public JComboBoxEx() {
    }

    public void setEditor(ComboBoxEditor comboBoxEditor) {
        String string = this.getPromptText();
        if (this.getEditor() != null) {
            this.getEditor().getEditorComponent().removeFocusListener(this);
            this.setPromptText(null);
        }
        super.setEditor(comboBoxEditor);
        if (this.getEditor() != null) {
            this.getEditor().getEditorComponent().addFocusListener(this);
            if (string != null) {
                this.setPromptText(string);
            }
        }
    }

    public boolean isSelectAllOnFocusGain() {
        return this.fSelectAllOnFocusGain;
    }

    public void setSelectAllOnFocusGain(boolean bl) {
        this.fSelectAllOnFocusGain = bl;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.isSelectAllOnFocusGain()) {
            this.getEditor().selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void updateUI() {
        super.updateUI();
        if (!(this.getBorder() instanceof IndicatorBorder.CompoundBorder)) {
            this.fOriginalBorder = this.getBorder();
        }
        this.updateBorder();
        if (this.fDelegateRenderer != null) {
            this.fDelegateRenderer.setDelegate(this.getRenderer());
            this.setRenderer(this.fDelegateRenderer);
        }
    }

    private void updateBorder() {
        block3: {
            block2: {
                if (StringUtils.noValue(this.getIndicator())) break block2;
                this.setBorder(new IndicatorBorder.CompoundBorder(this.fIndicatorBorder, this.fOriginalBorder));
                if (!HashedBoundList.z) break block3;
            }
            this.setBorder(this.fOriginalBorder);
        }
    }

    public String getIndicator() {
        return this.getIndicatorBorder().getIndicator();
    }

    public void setIndicator(String string) {
        if (string != this.getIndicator()) {
            this.getIndicatorBorder().setIndicator(string);
            this.updateBorder();
        }
    }

    protected IndicatorBorder getIndicatorBorder() {
        if (this.fIndicatorBorder == null) {
            this.fIndicatorBorder = new IndicatorBorder(null);
        }
        return this.fIndicatorBorder;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (this.fMinimumWidth != -1) {
            dimension.width = this.fMinimumWidth;
        }
        if (this.fMinimumHeight != -1) {
            dimension.height = this.fMinimumHeight;
        }
        return dimension;
    }

    public int getMinimumHeight() {
        return this.fMinimumHeight;
    }

    public void setMinimumHeight(int n) {
        this.fMinimumHeight = n;
    }

    public int getMinimumWidth() {
        return this.fMinimumWidth;
    }

    public void setMinimumWidth(int n) {
        this.fMinimumWidth = n;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.fPreferredWidth != -1) {
            dimension.width = this.fPreferredWidth;
        }
        if (this.fPreferredHeight != -1) {
            dimension.height = this.fPreferredHeight;
        }
        return dimension;
    }

    public int getPreferredHeight() {
        return this.fPreferredHeight;
    }

    public void setPreferredHeight(int n) {
        this.fPreferredHeight = n;
    }

    public int getPreferredWidth() {
        return this.fPreferredWidth;
    }

    public void setPreferredWidth(int n) {
        this.fPreferredWidth = n;
    }

    protected ComponentPainterSupport getComponentPainterSupport() {
        if (this.fComponentPainterSupport == null) {
            this.fComponentPainterSupport = new ComponentPainterSupport(this);
        }
        return this.fComponentPainterSupport;
    }

    public void addComponentPainter(ComponentPainter componentPainter) {
        this.getComponentPainterSupport().addComponentPainter(componentPainter);
    }

    public void removeComponentPainter(ComponentPainter componentPainter) {
        this.getComponentPainterSupport().removeComponentPainter(componentPainter);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.fComponentPainterSupport != null) {
            this.fComponentPainterSupport.paintComponent(graphics);
        }
    }

    public String getPromptText() {
        return this.fPromptText;
    }

    public void setPromptText(String string) {
        block6: {
            block4: {
                boolean bl;
                block5: {
                    bl = HashedBoundList.z;
                    if (StringUtils.noValue(string)) break block4;
                    this.fPromptText = string;
                    if (this.fPromptTextComponentPainter != null) break block5;
                    this.fPromptTextComponentPainter = new JTextFieldEx.PromptTextComponentPainter((JTextComponent)this.getEditor().getEditorComponent(), string, false, 2);
                    this.addComponentPainter(this.fPromptTextComponentPainter);
                    if (!bl) break block6;
                }
                this.fPromptTextComponentPainter.setText(string);
                if (!this.isShowing()) break block6;
                this.fPromptTextComponentPainter.updateTextVisibility();
                if (!bl) break block6;
            }
            if (this.fPromptTextComponentPainter != null) {
                this.removeComponentPainter(this.fPromptTextComponentPainter);
                this.fPromptTextComponentPainter = null;
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(this.fComponentFontSupport != null ? this.fComponentFontSupport.getFont(font) : font);
    }

    public int getFontStyle() {
        return this.fComponentFontSupport.getFontStyle();
    }

    public void setFontStyle(int n) {
        this.fComponentFontSupport.setFontStyle(n);
    }

    public int getFontIncrement() {
        return this.fComponentFontSupport.getFontIncrement();
    }

    public void setFontIncrement(int n) {
        this.fComponentFontSupport.setFontIncrement(n);
    }

    public float getFontSize() {
        return this.fComponentFontSupport.getFontSize();
    }

    public void setFontSize(float f) {
        this.fComponentFontSupport.setFontSize(f);
    }

    public DelegateListCellRenderer getDelegateRenderer() {
        return this.fDelegateRenderer;
    }

    public void setDelegateRenderer(DelegateListCellRenderer delegateListCellRenderer) {
        if (this.fDelegateRenderer != delegateListCellRenderer) {
            this.fDelegateRenderer = delegateListCellRenderer;
            this.fDelegateRenderer.setDelegate(this.getRenderer());
            this.setRenderer(this.fDelegateRenderer);
        }
    }

    public static class DummyKeySelectionManager
    implements JComboBox.KeySelectionManager {
        public int selectionForKey(char c, ComboBoxModel comboBoxModel) {
            return -1;
        }
    }
}

