/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.ComponentPainter;
import dev.gui.IndicatorHolder;
import dev.gui.border.IndicatorBorder;
import dev.util.StringUtils;
import dev.util.collections.HashedBoundList;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.Format;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.MaskFormatter;

public class JFormattedTextFieldEx
extends JFormattedTextField
implements FocusListener,
IndicatorHolder {
    protected int fPreferredHeight = -1;
    protected int fPreferredWidth = -1;
    protected int fMinimumHeight = -1;
    protected int fMinimumWidth = -1;
    protected IndicatorBorder fIndicatorBorder;
    protected Border fOriginalBorder;
    protected boolean fReturnEmptyText = true;
    protected ComponentPainter fComponentPainter;
    private static final /* synthetic */ String z;

    public JFormattedTextFieldEx(String string) {
        this(string, ' ');
    }

    public JFormattedTextFieldEx(String string, char c) {
        super(JFormattedTextFieldEx.createFormatter(string, c));
        this.init();
    }

    private static JFormattedTextField.AbstractFormatter createFormatter(String string, char c) {
        try {
            MaskFormatter maskFormatter = new MaskFormatter(string);
            maskFormatter.setPlaceholderCharacter(c);
            return maskFormatter;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(z + string);
        }
    }

    public JFormattedTextFieldEx(Object object) {
        super(object);
        this.init();
    }

    public JFormattedTextFieldEx(Format format) {
        super(format);
        this.init();
    }

    public JFormattedTextFieldEx(JFormattedTextField.AbstractFormatter abstractFormatter) {
        super(abstractFormatter);
        this.init();
    }

    public JFormattedTextFieldEx(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory) {
        super(abstractFormatterFactory);
        this.init();
    }

    public JFormattedTextFieldEx(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, Object object) {
        super(abstractFormatterFactory, object);
        this.init();
    }

    public JFormattedTextFieldEx() {
        this.init();
    }

    private void init() {
        this.addFocusListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFormattedTextFieldEx.this.selectAll();
            }
        });
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.fPreferredWidth != -1) {
            dimension.width = this.fPreferredWidth;
        }
        if (this.fPreferredHeight != -1) {
            dimension.height = this.fPreferredHeight;
        }
        return dimension;
    }

    public int getPreferredHeight() {
        return this.fPreferredHeight;
    }

    public void setPreferredHeight(int n) {
        this.fPreferredHeight = n;
    }

    public int getPreferredWidth() {
        return this.fPreferredWidth;
    }

    public void setPreferredWidth(int n) {
        this.fPreferredWidth = n;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        Insets insets = this.getInsets();
        dimension.height = this.getFontMetrics(this.getFont()).getHeight() + insets.top + insets.bottom;
        if (this.fMinimumWidth != -1) {
            dimension.width = this.fMinimumWidth;
        }
        if (this.fMinimumHeight != -1) {
            dimension.height = this.fMinimumHeight;
        }
        return dimension;
    }

    public int getMinimumHeight() {
        return this.fMinimumHeight;
    }

    public void setMinimumHeight(int n) {
        this.fMinimumHeight = n;
    }

    public int getMinimumWidth() {
        return this.fMinimumWidth;
    }

    public void setMinimumWidth(int n) {
        this.fMinimumWidth = n;
    }

    public void updateUI() {
        super.updateUI();
        if (!(this.getBorder() instanceof IndicatorBorder.CompoundBorder)) {
            this.fOriginalBorder = this.getBorder();
        }
        this.updateBorder();
    }

    private void updateBorder() {
        block3: {
            block2: {
                if (StringUtils.noValue(this.getIndicator())) break block2;
                this.setBorder(new IndicatorBorder.CompoundBorder(this.fIndicatorBorder, this.fOriginalBorder));
                if (!HashedBoundList.z) break block3;
            }
            this.setBorder(this.fOriginalBorder);
        }
    }

    public String getIndicator() {
        return this.getIndicatorBorder().getIndicator();
    }

    public void setIndicator(String string) {
        if (string != this.getIndicator()) {
            this.getIndicatorBorder().setIndicator(string);
            this.updateBorder();
        }
    }

    protected IndicatorBorder getIndicatorBorder() {
        if (this.fIndicatorBorder == null) {
            this.fIndicatorBorder = new IndicatorBorder(null);
        }
        return this.fIndicatorBorder;
    }

    public boolean isReturnEmptyText() {
        return this.fReturnEmptyText;
    }

    public void setReturnEmptyText(boolean bl) {
        this.fReturnEmptyText = bl;
    }

    public String getText() {
        String string = super.getText();
        return this.isReturnEmptyText() ? string : (StringUtils.noValue(string) ? null : string);
    }

    public ComponentPainter getComponentPainter() {
        return this.fComponentPainter;
    }

    public void setComponentPainter(ComponentPainter componentPainter) {
        if (this.fComponentPainter != componentPainter) {
            this.fComponentPainter = componentPainter;
            this.repaint();
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.fComponentPainter != null) {
            this.fComponentPainter.paint(graphics, this);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                Object var0 = null;
                char[] cArray3 = "_WPnS{E\u0003l\u001ddWOl\u0017(\u0016".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 18;
                            break;
                        }
                        case 1: {
                            n6 = 54;
                            break;
                        }
                        case 2: {
                            n6 = 35;
                            break;
                        }
                        case 3: {
                            n6 = 5;
                            break;
                        }
                        default: {
                            n6 = 115;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        z = new String(cArray).intern();
    }
}

