/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.BasicComponentPainter;
import dev.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;

public class TextComponentPainter
extends BasicComponentPainter {
    protected String fText;
    protected Color fColor;

    public String getText() {
        return this.fText;
    }

    public void setText(String string) {
        this.fText = string;
    }

    public TextComponentPainter() {
    }

    public TextComponentPainter(String string) {
        this(string, 16);
    }

    public TextComponentPainter(String string, int n) {
        super(0, 0, n, true);
        this.fText = string;
    }

    public int getHeight(Graphics graphics, Component component) {
        int n = 0;
        String string = this.getText();
        if (!StringUtils.noValue(string)) {
            n = graphics.getFontMetrics(this.getFont(component)).getHeight();
        }
        return n;
    }

    protected Font getFont(Component component) {
        return component.getFont();
    }

    public int getWidth(Graphics graphics, Component component) {
        int n = 0;
        String string = this.getText();
        if (!StringUtils.noValue(string)) {
            n = graphics.getFontMetrics(this.getFont(component)).charsWidth(string.toCharArray(), 0, string.length());
        }
        return n;
    }

    public Color getColor() {
        return this.fColor;
    }

    public void setColor(Color color) {
        this.fColor = color;
    }

    protected void paintImpl(Graphics graphics, Component component) {
        if (this.fColor != null) {
            graphics.setColor(this.fColor);
        }
        if (!StringUtils.noValue(this.getText())) {
            graphics.drawString(this.getText(), 0, graphics.getFontMetrics(graphics.getFont()).getAscent());
        }
    }
}

