/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import dev.gui.LafColor;
import dev.util.StringUtils;
import dev.util.collections.HashedBoundList;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.RoundRectangle2D;
import java.security.AccessController;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import sun.security.action.GetPropertyAction;

public class UIUtils {
    public static Color BUTTON_SHADOW;
    public static Color BUTTON_DARK_SHADOW;
    public static Color BUTTON_HIGHLIGHT;
    public static Color BUTTON_LIGHT_HIGHLIGHT;
    public static Color BUTTON_SELECTED;
    public static Color BUTTON_ROLLOVER_BG;
    public static Color BUTTON_SELECTED_BG;
    public static Color BUTTON_PRESSED_BG;
    public static Color HYPERLINK;
    public static Color HYPERLINK_ROLLOVER;
    public static final double TOOLBAR_FACTOR_DARK = 0.9;
    public static final double TOOLBAR_FACTOR_LIGHT = 0.97;
    public static final double SEPARATOR_FACTOR_LIGHT = 0.4;
    public static final double HEADER_FACTOR_DARK = 0.97;
    public static final double HEADER_FACTOR_LIGHT = 0.99;
    public static final double HEADER_3D_FACTOR_DARK = 0.97;
    public static final double HEADER_3D_FACTOR_LIGHT = 0.995;
    public static final double BUTTON_FACTOR_DARK = 0.97;
    public static final double BUTTON_FACTOR_LIGHT = 0.97;
    private static final /* synthetic */ String[] z;

    public static String colorToHexString(Color color) {
        return Integer.toHexString(color.getRed()) + Integer.toHexString(color.getGreen()) + Integer.toHexString(color.getBlue());
    }

    public static Color getDarker(Color color, double d) {
        return new Color(Math.max((int)((double)color.getRed() * d), 0), Math.max((int)((double)color.getGreen() * d), 0), Math.max((int)((double)color.getBlue() * d), 0), color.getAlpha());
    }

    public static Color getBrighter(Color color, double d) {
        if (d == 1.0) {
            return color;
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = (int)(1.0 / (1.0 - d));
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(n4, n4, n4, color.getAlpha());
        }
        if (n > 0 && n < n4) {
            n = n4;
        }
        if (n2 > 0 && n2 < n4) {
            n2 = n4;
        }
        if (n3 > 0 && n3 < n4) {
            n3 = n4;
        }
        return new Color(Math.min((int)((double)n / d), 255), Math.min((int)((double)n2 / d), 255), Math.min((int)((double)n3 / d), 255), color.getAlpha());
    }

    public static Paint getHorisontalPaint(Color color, Color color2, Dimension dimension) {
        float f = 0.45f * (float)dimension.height;
        float f2 = dimension.width / 2;
        float f3 = (float)(dimension.height / 2) - f;
        float f4 = dimension.width / 2;
        float f5 = (float)(dimension.height / 2) + f;
        return new GradientPaint(f2, f3, color, f4, f5, color2);
    }

    public static Paint getGradientPanelPaint(Color color, Dimension dimension) {
        return UIUtils.getHeaderPaint(color, dimension);
    }

    public static Paint getToolbarPaint(Color color, Dimension dimension) {
        return UIUtils.isMac() || UIUtils.getPixelSize() < 16 ? color : UIUtils.getHorisontalPaint(UIUtils.getBrighter(color, 0.97), UIUtils.getDarker(color, 0.9), dimension);
    }

    public static Paint getStatusBarPaint(Color color, Dimension dimension) {
        return UIUtils.isMac() || UIUtils.getPixelSize() < 16 ? color : UIUtils.getHorisontalPaint(UIUtils.getBrighter(color, 0.97), UIUtils.getDarker(color, 0.9), dimension);
    }

    public static Paint getHeader3dPaint(Color color, Dimension dimension) {
        return UIUtils.isMac() || UIUtils.getPixelSize() < 16 ? color : UIUtils.getHorisontalPaint(UIUtils.getBrighter(color, 0.97), UIUtils.getDarker(color, 0.9), dimension);
    }

    public static Paint getSeparatorPaint(Color color, Dimension dimension) {
        if (UIUtils.isMac() || UIUtils.getPixelSize() < 16) {
            return color;
        }
        float f = dimension.width / 2;
        float f2 = 0.0f;
        float f3 = dimension.width / 2;
        float f4 = dimension.height / 2;
        return new GradientPaint(f, f2, UIUtils.getBrighter(color, 0.4), f3, f4, color, true);
    }

    public static Paint getButtonPaint(Color color, Dimension dimension) {
        return UIUtils.isMac() || UIUtils.getPixelSize() < 16 ? color : UIUtils.getHorisontalPaint(UIUtils.getDarker(color, 0.97), UIUtils.getBrighter(color, 0.97), dimension);
    }

    public static Paint getHeader3DPaint(Color color, Dimension dimension) {
        return UIUtils.isMac() || UIUtils.getPixelSize() < 16 ? color : UIUtils.getHorisontalPaint(UIUtils.getBrighter(color, 0.995), UIUtils.getDarker(color, 0.97), dimension);
    }

    public static Paint getHeaderPaint(Color color, Dimension dimension) {
        return UIUtils.getHeaderPaint(null, color, dimension);
    }

    public static Paint getHeaderPaint(Component component, Color color, Dimension dimension) {
        ComponentOrientation componentOrientation;
        Color color2 = color;
        if (UIUtils.isMac()) {
            color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 96);
        }
        Color color3 = UIUtils.getDarker(color2, 0.9f);
        Color color4 = color2;
        ComponentOrientation componentOrientation2 = componentOrientation = component != null ? component.getComponentOrientation() : ComponentOrientation.UNKNOWN;
        return UIUtils.getPixelSize() < 16 ? UIUtils.getDarker(color2, 0.95f) : new GradientPaint(0.0f, dimension.height / 2, componentOrientation != ComponentOrientation.RIGHT_TO_LEFT ? color3 : color4, dimension.width, dimension.height / 2, componentOrientation != ComponentOrientation.RIGHT_TO_LEFT ? color4 : color3);
    }

    public static Paint getHeaderPaintV(Color color, Dimension dimension) {
        Color color2 = color;
        if (UIUtils.isMac()) {
            color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 96);
        }
        return UIUtils.getPixelSize() < 16 ? UIUtils.getDarker(color2, 0.95f) : new GradientPaint(dimension.width / 2, 0.0f, UIUtils.getDarker(color2, 0.92f), dimension.width / 2, dimension.height, color2);
    }

    public static boolean isWinXPLookFeel() {
        boolean bl = false;
        if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel) {
            Boolean bl2 = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty(z[3]);
            if (bl2 == null) {
                bl2 = Boolean.FALSE;
            }
            bl = bl2 != false && AccessController.doPrivileged(new GetPropertyAction(z[4])) == null && !z[2].equals(UIManager.getLookAndFeel().getClass().getName());
        }
        return bl;
    }

    public static boolean isMac() {
        try {
            return System.getProperty(z[6]) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int getPixelSize() {
        return Toolkit.getDefaultToolkit().getColorModel().getPixelSize();
    }

    public static void fillGlassRect(Graphics2D graphics2D, Color color, Rectangle rectangle, int n) {
        boolean bl = HashedBoundList.z;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Shape shape = graphics2D.getClip();
        if (n > 0) {
            graphics2D.clip(new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 2 * n, 2 * n));
        }
        Color color2 = UIUtils.getBrighter(color, 0.92);
        Color color3 = UIUtils.getDarker(color, 0.95);
        Dimension dimension = rectangle.getSize();
        graphics2D.setPaint(UIUtils.getHorisontalPaint(UIUtils.getDarker(color3, 0.8), Color.WHITE, rectangle.getSize()));
        graphics2D.fillRect(rectangle.x, rectangle.y + rectangle.height / 2 - 4, rectangle.width, rectangle.height);
        graphics2D.setPaint(UIUtils.getHorisontalPaint(Color.WHITE, UIUtils.getDarker(color2, 0.8), rectangle.getSize()));
        graphics2D.fillRoundRect(rectangle.x, rectangle.y - 10, rectangle.width + 1, rectangle.y + rectangle.height / 2 + 10, 10, 10);
        graphics2D.setClip(shape);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, object2);
        if (StringUtils.z) {
            HashedBoundList.z = !bl;
        }
    }

    public static void fillGlossyRect(Graphics2D graphics2D, Color color, Rectangle rectangle, int n) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Shape shape = graphics2D.getClip();
        if (n > 0) {
            graphics2D.clip(new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 2 * n, 2 * n));
        }
        Color color2 = UIUtils.getDarker(color, 0.99);
        graphics2D.setPaint(UIUtils.getHorisontalPaint(UIUtils.getBrighter(color2, 0.35), UIUtils.getDarker(color2, 0.85), rectangle.getSize()));
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setPaint(new Color(250, 255, 255, 24));
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height / 2);
        graphics2D.setPaint(new Color(250, 255, 255, 4));
        graphics2D.fillRect(rectangle.x, rectangle.height / 2 - 1, rectangle.width, 2);
        graphics2D.setClip(shape);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, object2);
    }

    public static void fillGlossyRect(Graphics2D graphics2D, Color color, Color color2, Rectangle rectangle, int n) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Shape shape = graphics2D.getClip();
        if (n > 0) {
            graphics2D.clip(new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 2 * n, 2 * n));
        }
        graphics2D.setPaint(UIUtils.getHorisontalPaint(color2, color, rectangle.getSize()));
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setPaint(new Color(255, 255, 255, 32));
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height / 2);
        graphics2D.setClip(shape);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, object2);
    }

    public static void fill3DRect(Graphics2D graphics2D, Color color, Rectangle rectangle, int n) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Shape shape = graphics2D.getClip();
        if (n > 0) {
            graphics2D.clip(new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 2 * n, 2 * n));
        }
        graphics2D.setPaint(UIUtils.getHorisontalPaint(UIUtils.getBrighter(color, 0.97), UIUtils.getDarker(color, 0.9), rectangle.getSize()));
        graphics2D.fill(rectangle);
        graphics2D.setClip(shape);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, object2);
    }

    public static void registerActionBinding(JComponent jComponent, KeyStroke keyStroke, Action action) {
        String string = (String)action.getValue(z[5]);
        InputMap inputMap = jComponent.getInputMap(jComponent instanceof JTable ? 1 : 0);
        inputMap.put(keyStroke, string);
        jComponent.getActionMap().put(string, action);
    }

    public static void unRregisterActionBinding(JComponent jComponent, KeyStroke keyStroke, Action action) {
        String string = (String)action.getValue(z[5]);
        InputMap inputMap = jComponent.getInputMap(jComponent instanceof JTable ? 1 : 0);
        inputMap.remove(keyStroke);
        jComponent.getActionMap().remove(string);
    }

    public static boolean applyComponentOrientation(Container container) {
        boolean bl = false;
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        if (componentOrientation == ComponentOrientation.RIGHT_TO_LEFT && !z[0].equals(System.getProperty(z[1], null))) {
            container.applyComponentOrientation(componentOrientation);
            bl = true;
        }
        return bl;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block87: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block86: {
                char[] cArray3;
                Object var0;
                block85: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block84: {
                        char[] cArray5;
                        block83: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block82: {
                                char[] cArray7;
                                block81: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block80: {
                                        char[] cArray9;
                                        block79: {
                                            int n10;
                                            int n11;
                                            char[] cArray10;
                                            block78: {
                                                char[] cArray11;
                                                block77: {
                                                    int n12;
                                                    int n13;
                                                    char[] cArray12;
                                                    block76: {
                                                        char[] cArray13;
                                                        block75: {
                                                            int n14;
                                                            int n15;
                                                            char[] cArray14;
                                                            block74: {
                                                                char[] cArray15;
                                                                block73: {
                                                                    int n16;
                                                                    int n17;
                                                                    char[] cArray16;
                                                                    block72: {
                                                                        stringArray = new String[8];
                                                                        var0 = null;
                                                                        char[] cArray17 = "GR\f\u001f".toCharArray();
                                                                        n3 = 0;
                                                                        int n18 = cArray17.length;
                                                                        cArray16 = cArray17;
                                                                        n17 = n18;
                                                                        if (n18 <= 1) break block72;
                                                                        cArray15 = cArray16;
                                                                        n16 = n17;
                                                                        if (n17 <= n3) break block73;
                                                                    }
                                                                    do {
                                                                        char[] cArray18 = cArray16;
                                                                        char[] cArray19 = cArray16;
                                                                        int n19 = n3;
                                                                        while (true) {
                                                                            int n20;
                                                                            char c = cArray18[n19];
                                                                            switch (n3 % 5) {
                                                                                case 0: {
                                                                                    n20 = 51;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n20 = 32;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n20 = 121;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n20 = 122;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n20 = 120;
                                                                                }
                                                                            }
                                                                            cArray18[n19] = (char)(c ^ n20);
                                                                            ++n3;
                                                                            cArray16 = cArray19;
                                                                            n17 = n17;
                                                                            if (n17 != 0) break;
                                                                            cArray19 = cArray16;
                                                                            n16 = n17;
                                                                            n19 = n17;
                                                                            cArray18 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n16 = n17;
                                                                    } while (n17 > n3);
                                                                }
                                                                stringArray[0] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray20 = "WE\u000fT\u001fFIW\u0013\u001f]O\u000b\u001f;\\M\t\u0015\u0016VN\r5\nZE\u0017\u000e\u0019GI\u0016\u0014".toCharArray();
                                                                n3 = 0;
                                                                int n21 = cArray20.length;
                                                                cArray14 = cArray20;
                                                                n15 = n21;
                                                                if (n21 <= 1) break block74;
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                                if (n15 <= n3) break block75;
                                                            }
                                                            do {
                                                                char[] cArray21 = cArray14;
                                                                char[] cArray22 = cArray14;
                                                                int n22 = n3;
                                                                while (true) {
                                                                    int n23;
                                                                    char c = cArray21[n22];
                                                                    switch (n3 % 5) {
                                                                        case 0: {
                                                                            n23 = 51;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n23 = 32;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n23 = 121;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n23 = 122;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n23 = 120;
                                                                        }
                                                                    }
                                                                    cArray21[n22] = (char)(c ^ n23);
                                                                    ++n3;
                                                                    cArray14 = cArray22;
                                                                    n15 = n15;
                                                                    if (n15 != 0) break;
                                                                    cArray22 = cArray14;
                                                                    n14 = n15;
                                                                    n22 = n15;
                                                                    cArray21 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                            } while (n15 > n3);
                                                        }
                                                        stringArray[1] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray23 = "PO\u0014T\u000bFNW\u0010\u0019EAW\t\u000fZN\u001eT\b_A\u001fT\u000fZN\u001d\u0015\u000f@\u000e.\u0013\u0016WO\u000e\t;_A\n\t\u0011Pl\u0016\u0015\u0013rN\u001d<\u001dVL".toCharArray();
                                                        n3 = 0;
                                                        int n24 = cArray23.length;
                                                        cArray12 = cArray23;
                                                        n13 = n24;
                                                        if (n24 <= 1) break block76;
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                        if (n13 <= n3) break block77;
                                                    }
                                                    do {
                                                        char[] cArray24 = cArray12;
                                                        char[] cArray25 = cArray12;
                                                        int n25 = n3;
                                                        while (true) {
                                                            int n26;
                                                            char c = cArray24[n25];
                                                            switch (n3 % 5) {
                                                                case 0: {
                                                                    n26 = 51;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n26 = 32;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n26 = 121;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n26 = 122;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n26 = 120;
                                                                }
                                                            }
                                                            cArray24[n25] = (char)(c ^ n26);
                                                            ++n3;
                                                            cArray12 = cArray25;
                                                            n13 = n13;
                                                            if (n13 != 0) break;
                                                            cArray25 = cArray12;
                                                            n12 = n13;
                                                            n25 = n13;
                                                            cArray24 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                    } while (n13 > n3);
                                                }
                                                stringArray[2] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray26 = "DI\u0017T\u0000CS\r\u0003\u0014V\u000e\r\u0012\u001d^E8\u0019\fZV\u001c".toCharArray();
                                                n3 = 0;
                                                int n27 = cArray26.length;
                                                cArray10 = cArray26;
                                                n11 = n27;
                                                if (n27 <= 1) break block78;
                                                cArray9 = cArray10;
                                                n10 = n11;
                                                if (n11 <= n3) break block79;
                                            }
                                            do {
                                                char[] cArray27 = cArray10;
                                                char[] cArray28 = cArray10;
                                                int n28 = n3;
                                                while (true) {
                                                    int n29;
                                                    char c = cArray27[n28];
                                                    switch (n3 % 5) {
                                                        case 0: {
                                                            n29 = 51;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n29 = 32;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n29 = 121;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n29 = 122;
                                                            break;
                                                        }
                                                        default: {
                                                            n29 = 120;
                                                        }
                                                    }
                                                    cArray27[n28] = (char)(c ^ n29);
                                                    ++n3;
                                                    cArray10 = cArray28;
                                                    n11 = n11;
                                                    if (n11 != 0) break;
                                                    cArray28 = cArray10;
                                                    n10 = n11;
                                                    n28 = n11;
                                                    cArray27 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n10 = n11;
                                            } while (n11 > n3);
                                        }
                                        stringArray[3] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray29 = "@W\u0010\u0014\u001f\u001dN\u0016\u0002\b".toCharArray();
                                        n3 = 0;
                                        int n30 = cArray29.length;
                                        cArray8 = cArray29;
                                        n9 = n30;
                                        if (n30 <= 1) break block80;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block81;
                                    }
                                    do {
                                        char[] cArray30 = cArray8;
                                        char[] cArray31 = cArray8;
                                        int n31 = n3;
                                        while (true) {
                                            int n32;
                                            char c = cArray30[n31];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n32 = 51;
                                                    break;
                                                }
                                                case 1: {
                                                    n32 = 32;
                                                    break;
                                                }
                                                case 2: {
                                                    n32 = 121;
                                                    break;
                                                }
                                                case 3: {
                                                    n32 = 122;
                                                    break;
                                                }
                                                default: {
                                                    n32 = 120;
                                                }
                                            }
                                            cArray30[n31] = (char)(c ^ n32);
                                            ++n3;
                                            cArray8 = cArray31;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray31 = cArray8;
                                            n8 = n9;
                                            n31 = n9;
                                            cArray30 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                stringArray[4] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray32 = "}A\u0014\u001f".toCharArray();
                                n3 = 0;
                                int n33 = cArray32.length;
                                cArray6 = cArray32;
                                n7 = n33;
                                if (n33 <= 1) break block82;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block83;
                            }
                            do {
                                char[] cArray33 = cArray6;
                                char[] cArray34 = cArray6;
                                int n34 = n3;
                                while (true) {
                                    int n35;
                                    char c = cArray33[n34];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n35 = 51;
                                            break;
                                        }
                                        case 1: {
                                            n35 = 32;
                                            break;
                                        }
                                        case 2: {
                                            n35 = 121;
                                            break;
                                        }
                                        case 3: {
                                            n35 = 122;
                                            break;
                                        }
                                        default: {
                                            n35 = 120;
                                        }
                                    }
                                    cArray33[n34] = (char)(c ^ n35);
                                    ++n3;
                                    cArray6 = cArray34;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray34 = cArray6;
                                    n6 = n7;
                                    n34 = n7;
                                    cArray33 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[5] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray35 = "^R\u0013T\u000eVR\n\u0013\u0017]".toCharArray();
                        n3 = 0;
                        int n36 = cArray35.length;
                        cArray4 = cArray35;
                        n5 = n36;
                        if (n36 <= 1) break block84;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block85;
                    }
                    do {
                        char[] cArray36 = cArray4;
                        char[] cArray37 = cArray4;
                        int n37 = n3;
                        while (true) {
                            int n38;
                            char c = cArray36[n37];
                            switch (n3 % 5) {
                                case 0: {
                                    n38 = 51;
                                    break;
                                }
                                case 1: {
                                    n38 = 32;
                                    break;
                                }
                                case 2: {
                                    n38 = 121;
                                    break;
                                }
                                case 3: {
                                    n38 = 122;
                                    break;
                                }
                                default: {
                                    n38 = 120;
                                }
                            }
                            cArray36[n37] = (char)(c ^ n38);
                            ++n3;
                            cArray4 = cArray37;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray37 = cArray4;
                            n4 = n5;
                            n37 = n5;
                            cArray36 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[6] = new String(cArray3).intern();
                var0 = null;
                char[] cArray38 = "qU\r\u000e\u0017]\u000e\u001b\u001b\u001bXG\u000b\u0015\r]D".toCharArray();
                n3 = 0;
                int n39 = cArray38.length;
                cArray2 = cArray38;
                n2 = n39;
                if (n39 <= 1) break block86;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block87;
            }
            do {
                char[] cArray39 = cArray2;
                char[] cArray40 = cArray2;
                int n40 = n3;
                while (true) {
                    int n41;
                    char c = cArray39[n40];
                    switch (n3 % 5) {
                        case 0: {
                            n41 = 51;
                            break;
                        }
                        case 1: {
                            n41 = 32;
                            break;
                        }
                        case 2: {
                            n41 = 121;
                            break;
                        }
                        case 3: {
                            n41 = 122;
                            break;
                        }
                        default: {
                            n41 = 120;
                        }
                    }
                    cArray39[n40] = (char)(c ^ n41);
                    ++n3;
                    cArray2 = cArray40;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray40 = cArray2;
                    n = n2;
                    n40 = n2;
                    cArray39 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[7] = new String(cArray).intern();
        z = stringArray;
        BUTTON_SHADOW = new Color(29, 86, 177);
        BUTTON_DARK_SHADOW = new Color(9, 66, 157);
        BUTTON_HIGHLIGHT = new Color(49, 106, 197);
        BUTTON_LIGHT_HIGHLIGHT = new Color(59, 116, 207);
        BUTTON_SELECTED = new LafColor(z[7], -0.75f);
        BUTTON_ROLLOVER_BG = new Color(198, 215, 243);
        BUTTON_SELECTED_BG = new LafColor(z[7], -0.9f, new Color(208, 225, 225));
        BUTTON_PRESSED_BG = new Color(178, 195, 223);
        HYPERLINK = new Color(0, 0, 128);
        HYPERLINK_ROLLOVER = Color.BLUE;
    }

    public static class ScrollPaneBorder
    extends AbstractBorder {
        private static final /* synthetic */ String[] z;

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(UIManager.getColor(z[1]));
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(UIManager.getColor(z[0]));
            graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 1;
            insets.left = 1;
            insets.bottom = 2;
            insets.right = 2;
            return insets;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            String[] stringArray;
            block21: {
                int n;
                int n2;
                char[] cArray2;
                int n3;
                block20: {
                    char[] cArray3;
                    Object var0;
                    block19: {
                        int n4;
                        int n5;
                        char[] cArray4;
                        block18: {
                            stringArray = new String[2];
                            var0 = null;
                            char[] cArray5 = "|-Mzsp.kgfw.Jiik".toCharArray();
                            n3 = 0;
                            int n6 = cArray5.length;
                            cArray4 = cArray5;
                            n5 = n6;
                            if (n6 <= 1) break block18;
                            cArray3 = cArray4;
                            n4 = n5;
                            if (n5 <= n3) break block19;
                        }
                        do {
                            char[] cArray6 = cArray4;
                            char[] cArray7 = cArray4;
                            int n7 = n3;
                            while (true) {
                                int n8;
                                char c = cArray6[n7];
                                switch (n3 % 5) {
                                    case 0: {
                                        n8 = 31;
                                        break;
                                    }
                                    case 1: {
                                        n8 = 66;
                                        break;
                                    }
                                    case 2: {
                                        n8 = 35;
                                        break;
                                    }
                                    case 3: {
                                        n8 = 14;
                                        break;
                                    }
                                    default: {
                                        n8 = 1;
                                    }
                                }
                                cArray6[n7] = (char)(c ^ n8);
                                ++n3;
                                cArray4 = cArray7;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray7 = cArray4;
                                n4 = n5;
                                n7 = n5;
                                cArray6 = cArray4;
                            }
                            cArray3 = cArray4;
                            n4 = n5;
                        } while (n5 > n3);
                    }
                    stringArray[0] = new String(cArray3).intern();
                    var0 = null;
                    char[] cArray8 = "|-Mzsp.pf`{-T".toCharArray();
                    n3 = 0;
                    int n9 = cArray8.length;
                    cArray2 = cArray8;
                    n2 = n9;
                    if (n9 <= 1) break block20;
                    cArray = cArray2;
                    n = n2;
                    if (n2 <= n3) break block21;
                }
                do {
                    char[] cArray9 = cArray2;
                    char[] cArray10 = cArray2;
                    int n10 = n3;
                    while (true) {
                        int n11;
                        char c = cArray9[n10];
                        switch (n3 % 5) {
                            case 0: {
                                n11 = 31;
                                break;
                            }
                            case 1: {
                                n11 = 66;
                                break;
                            }
                            case 2: {
                                n11 = 35;
                                break;
                            }
                            case 3: {
                                n11 = 14;
                                break;
                            }
                            default: {
                                n11 = 1;
                            }
                        }
                        cArray9[n10] = (char)(c ^ n11);
                        ++n3;
                        cArray2 = cArray10;
                        n2 = n2;
                        if (n2 != 0) break;
                        cArray10 = cArray2;
                        n = n2;
                        n10 = n2;
                        cArray9 = cArray2;
                    }
                    cArray = cArray2;
                    n = n2;
                } while (n2 > n3);
            }
            stringArray[1] = new String(cArray).intern();
            z = stringArray;
        }
    }
}

