/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.field;

import dev.gui.GenericFileFilter;
import dev.gui.JTextFieldEx;
import dev.gui.field.ButtonField;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class FileChooserField
extends ButtonField
implements DocumentListener {
    public static final String PROPERTY_DEFAULT_FOLDER;
    public static final String PROPERTY_VALUE;
    protected String fDefaultFolder;
    protected JFileChooser fFileChooser;
    protected FileFilter[] fChoosableFileFilters;
    protected FileFilter fDefaultChoosableFileFilter;
    public boolean fUseNativeFileChooser = false;
    protected FileDialog fFileDialog;
    protected String fTitle;
    protected Timer fUpdateTimer = new Timer(1000, this);
    private static final /* synthetic */ String z;

    public FileChooserField() {
        this(new JTextFieldEx());
    }

    public void requestFocus() {
        if (this.fField != null) {
            this.fField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.fField != null) {
            return this.fField.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public FileChooserField(JComponent jComponent) {
        super(jComponent);
        this.addActionListener(this);
        this.fUpdateTimer.setRepeats(false);
    }

    protected void chooseFile() {
        String string = this.chooseFile(this.getValue());
        if (string != null) {
            this.setValue(string);
        }
    }

    public void setField(JComponent jComponent) {
        if (this.fField != null && this.fField instanceof JTextComponent) {
            ((JTextComponent)this.fField).getDocument().removeDocumentListener(this);
        }
        super.setField(jComponent);
        if (this.fField != null && this.fField instanceof JTextComponent) {
            ((JTextComponent)this.fField).getDocument().addDocumentListener(this);
        }
    }

    public File getFile() {
        String string = this.getValue();
        return string != null ? new File(string) : null;
    }

    public String getValue() {
        return ((JTextField)this.fField).getText();
    }

    public void setValue(String string) {
        JTextField jTextField = (JTextField)this.fField;
        String string2 = jTextField.getText();
        jTextField.setText(string);
        this.firePropertyChange(PROPERTY_VALUE, string2, string);
    }

    public String getDefaultFolder() {
        return this.fDefaultFolder;
    }

    public void setDefaultFolder(String string) {
        String string2 = this.fDefaultFolder;
        this.fDefaultFolder = string;
        this.firePropertyChange(PROPERTY_DEFAULT_FOLDER, string2, string);
    }

    public void setFile(File file) {
        this.setValue(file != null ? file.getPath() : null);
    }

    public FileFilter getDefaultChoosableFileFilter() {
        return this.fDefaultChoosableFileFilter;
    }

    public void setDefaultChoosableFileFilter(FileFilter fileFilter) {
        this.fDefaultChoosableFileFilter = fileFilter;
    }

    public FileFilter[] getChoosableFileFilters() {
        return this.fChoosableFileFilters;
    }

    public void setChoosableFileFilters(String[][] stringArray) {
        FileFilter[] fileFilterArray = new FileFilter[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileFilterArray[i] = new GenericFileFilter(stringArray[i][0], stringArray[i][1]);
        }
        this.setChoosableFileFilters(fileFilterArray);
    }

    public void setChoosableFileFilters(FileFilter[] fileFilterArray) {
        this.fChoosableFileFilters = fileFilterArray;
        if (this.fFileChooser != null) {
            this.fFileChooser.resetChoosableFileFilters();
            for (int i = 0; this.fChoosableFileFilters != null && i < this.fChoosableFileFilters.length; ++i) {
                this.fFileChooser.addChoosableFileFilter(this.fChoosableFileFilters[i]);
            }
        }
    }

    public JFileChooser getFileChooser() {
        if (this.fFileChooser == null) {
            this.fFileChooser = new JFileChooser();
            for (int i = 0; this.fChoosableFileFilters != null && i < this.fChoosableFileFilters.length; ++i) {
                this.fFileChooser.addChoosableFileFilter(this.fChoosableFileFilters[i]);
            }
        }
        return this.fFileChooser;
    }

    public boolean isUseNativeFileChooser() {
        return this.fUseNativeFileChooser;
    }

    public void setUseNativeFileChooser(boolean bl) {
        if (this.fUseNativeFileChooser != bl) {
            this.fUseNativeFileChooser = bl;
            this.fFileChooser = null;
            if (this.fFileDialog != null) {
                this.fFileDialog.dispose();
                this.fFileDialog = null;
            }
        }
    }

    public FileDialog getFileDialog() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (this.fFileDialog == null || this.fFileDialog.getOwner() != window) {
            if (this.fFileDialog != null) {
                this.fFileDialog.dispose();
                this.fFileDialog = null;
            }
            this.fFileDialog = window instanceof Frame ? new FileDialog((Frame)window, this.getTitle(), 0) : new FileDialog((Dialog)window, this.getTitle(), 0);
        }
        return this.fFileDialog;
    }

    protected boolean isAcceptAllFileFilter(FileFilter fileFilter) {
        boolean bl = true;
        for (int i = 0; i < this.fChoosableFileFilters.length; ++i) {
            if (!this.fChoosableFileFilters[i].equals(fileFilter)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public String chooseFile(String string) {
        return this.isUseNativeFileChooser() ? this.chooseFile_FileDialog(string) : this.chooseFile_FileChooser(string);
    }

    protected String chooseFile_FileDialog(String string) {
        String string2 = null;
        FileDialog fileDialog = this.getFileDialog();
        fileDialog.applyComponentOrientation(this.getComponentOrientation());
        if (this.getChoosableFileFilters() != null && this.getChoosableFileFilters().length > 0 && this.getChoosableFileFilters()[0] instanceof FilenameFilter) {
            fileDialog.setFilenameFilter((FilenameFilter)((Object)this.getChoosableFileFilters()[0]));
        }
        if (string == null || "".equals(string)) {
            fileDialog.setFile(null);
            if (this.getDefaultFolder() != null) {
                fileDialog.setDirectory(this.getDefaultFolder());
            }
        } else {
            fileDialog.setFile(new File(string).getName());
            fileDialog.setDirectory(new File(string).getParent());
        }
        if (this.getTitle() != null) {
            fileDialog.setTitle(this.getTitle());
        }
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            string2 = new File(fileDialog.getDirectory(), fileDialog.getFile()).getAbsolutePath();
            this.setDefaultFolder(fileDialog.getDirectory());
        }
        return string2;
    }

    protected String chooseFile_FileChooser(String string) throws HeadlessException {
        String string2 = null;
        JFileChooser jFileChooser = this.getFileChooser();
        jFileChooser.updateUI();
        jFileChooser.applyComponentOrientation(this.getComponentOrientation());
        if (this.getDefaultChoosableFileFilter() != null) {
            jFileChooser.setFileFilter(this.getDefaultChoosableFileFilter());
        } else if (this.getChoosableFileFilters() != null && this.getChoosableFileFilters().length > 0) {
            jFileChooser.setFileFilter(this.getChoosableFileFilters()[0]);
        }
        if (string == null || "".equals(string)) {
            jFileChooser.setSelectedFile(null);
            if (this.getDefaultFolder() != null) {
                jFileChooser.setCurrentDirectory(new File(this.getDefaultFolder()));
            }
        } else {
            jFileChooser.setSelectedFile(new File(string));
        }
        if (this.getTitle() != null) {
            jFileChooser.setDialogTitle(this.getTitle());
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            string2 = this.appendDefaultExtension(jFileChooser.getSelectedFile(), jFileChooser.getFileFilter()).getAbsolutePath();
            this.setDefaultFolder(jFileChooser.getSelectedFile().getParent());
        }
        return string2;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public void setTitle(String string) {
        this.fTitle = string;
    }

    protected File appendDefaultExtension(File file, FileFilter fileFilter) {
        File file2 = file;
        if (!file2.isDirectory() && fileFilter instanceof GenericFileFilter && file2.getAbsolutePath().indexOf(".") == -1 && !this.isAcceptAllFileFilter(fileFilter)) {
            file2 = new File(file2.getAbsolutePath() + "." + ((GenericFileFilter)fileFilter).getAcceptableExtensions()[0]);
        }
        return file2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this && actionEvent.getActionCommand().equals(z)) {
            this.chooseFile();
        } else if (actionEvent.getSource() == this.fUpdateTimer) {
            this.firePropertyChange(PROPERTY_VALUE, null, this.getValue());
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void removeNotify() {
        this.fUpdateTimer.stop();
        super.removeNotify();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fUpdateTimer.restart();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fUpdateTimer.restart();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fUpdateTimer.restart();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block32: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block31: {
                char[] cArray3;
                Object var0;
                block30: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block29: {
                        char[] cArray5;
                        block28: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block27: {
                                var0 = null;
                                char[] cArray7 = "h+\u0003Ohd\u0018\u001e^kn".toCharArray();
                                n3 = 0;
                                int n8 = cArray7.length;
                                cArray6 = cArray7;
                                n7 = n8;
                                if (n8 <= 1) break block27;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block28;
                            }
                            do {
                                char[] cArray8 = cArray6;
                                char[] cArray9 = cArray6;
                                int n9 = n3;
                                while (true) {
                                    int n10;
                                    char c = cArray8[n9];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n10 = 10;
                                            break;
                                        }
                                        case 1: {
                                            n10 = 94;
                                            break;
                                        }
                                        case 2: {
                                            n10 = 119;
                                            break;
                                        }
                                        case 3: {
                                            n10 = 59;
                                            break;
                                        }
                                        default: {
                                            n10 = 7;
                                        }
                                    }
                                    cArray8[n9] = (char)(c ^ n10);
                                    ++n3;
                                    cArray6 = cArray9;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray9 = cArray6;
                                    n6 = n7;
                                    n9 = n7;
                                    cArray8 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        z = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray10 = "|?\u001bNb".toCharArray();
                        n3 = 0;
                        int n11 = cArray10.length;
                        cArray4 = cArray10;
                        n5 = n11;
                        if (n11 <= 1) break block29;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block30;
                    }
                    do {
                        char[] cArray11 = cArray4;
                        char[] cArray12 = cArray4;
                        int n12 = n3;
                        while (true) {
                            int n13;
                            char c = cArray11[n12];
                            switch (n3 % 5) {
                                case 0: {
                                    n13 = 10;
                                    break;
                                }
                                case 1: {
                                    n13 = 94;
                                    break;
                                }
                                case 2: {
                                    n13 = 119;
                                    break;
                                }
                                case 3: {
                                    n13 = 59;
                                    break;
                                }
                                default: {
                                    n13 = 7;
                                }
                            }
                            cArray11[n12] = (char)(c ^ n13);
                            ++n3;
                            cArray4 = cArray12;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray12 = cArray4;
                            n4 = n5;
                            n12 = n5;
                            cArray11 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                PROPERTY_VALUE = new String(cArray3).intern();
                var0 = null;
                char[] cArray13 = "n;\u0011Zrf*1Tkn;\u0005".toCharArray();
                n3 = 0;
                int n14 = cArray13.length;
                cArray2 = cArray13;
                n2 = n14;
                if (n14 <= 1) break block31;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block32;
            }
            do {
                char[] cArray14 = cArray2;
                char[] cArray15 = cArray2;
                int n15 = n3;
                while (true) {
                    int n16;
                    char c = cArray14[n15];
                    switch (n3 % 5) {
                        case 0: {
                            n16 = 10;
                            break;
                        }
                        case 1: {
                            n16 = 94;
                            break;
                        }
                        case 2: {
                            n16 = 119;
                            break;
                        }
                        case 3: {
                            n16 = 59;
                            break;
                        }
                        default: {
                            n16 = 7;
                        }
                    }
                    cArray14[n15] = (char)(c ^ n16);
                    ++n3;
                    cArray2 = cArray15;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray15 = cArray2;
                    n = n2;
                    n15 = n2;
                    cArray14 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        PROPERTY_DEFAULT_FOLDER = new String(cArray).intern();
    }
}

