/*
 * Decompiled with CFR 0.152.
 */
package dev.util;

import dev.util.StreamUtil;
import dev.util.StringUtils;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class CalendarUtil {
    public static final int FIRST_DAY_OF_WEEK;
    public static final DateFormat DATE_TIME_FORMAT;
    public static final DateFormat DATE_FORMAT;
    public static final DateFormat TIME_FORMAT;
    protected static HashMap fMonthNamesMap;
    protected static HashMap fWeekNamesMap;
    protected static HashMap fWeekDaysMap;
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    public static final long MILLISECONDS_PER_HOUR = 3600000L;
    public static final long MILLISECONDS_PER_MIN = 60000L;
    public static final long MILLISECONDS_PER_SEC = 1000L;
    public static final MessageFormat FORMAT_SEC;
    public static final MessageFormat FORMAT_MIN_SEC;
    public static final MessageFormat FORMAT_HOUR_MIN;
    public static final MessageFormat FORMAT_DAYS_HOUR_MIN;
    private static final /* synthetic */ String[] z;

    public static String getMonthName(int n) {
        return CalendarUtil.getMonthName(n, Locale.getDefault());
    }

    public static String getMonthName(int n, Locale locale) {
        boolean bl = StreamUtil.z;
        String[] stringArray = (String[])fMonthNamesMap.get(locale);
        if (stringArray == null) {
            stringArray = new String[12];
            fMonthNamesMap.put(locale, stringArray);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(z[1], locale);
            Calendar calendar = Calendar.getInstance(locale);
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            for (int i = 0; i < 12; ++i) {
                stringBuffer.setLength(0);
                calendar.set(2, i);
                calendar.set(5, 1);
                simpleDateFormat.format(calendar.getTime(), stringBuffer, fieldPosition);
                stringArray[i] = stringBuffer.toString();
                if (!bl) continue;
            }
        }
        return stringArray[n];
    }

    public static String getWeekName(int n) {
        return CalendarUtil.getWeekName(n, Locale.getDefault());
    }

    public static String getWeekName(int n, Locale locale) {
        boolean bl = StreamUtil.z;
        String[] stringArray = (String[])fWeekNamesMap.get(locale);
        if (stringArray == null) {
            stringArray = new String[8];
            fWeekNamesMap.put(locale, stringArray);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(z[2], locale);
            Calendar calendar = Calendar.getInstance(locale);
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            for (int i = 1; i <= 7; ++i) {
                stringBuffer.setLength(0);
                calendar.set(7, i);
                simpleDateFormat.format(calendar.getTime(), stringBuffer, fieldPosition);
                stringArray[i] = stringBuffer.toString();
                if (!bl) continue;
            }
        }
        return stringArray[n];
    }

    public static int[] getWeekDaysList() {
        return CalendarUtil.getWeekDaysList(Locale.getDefault());
    }

    public static int[] getWeekDaysList(Locale locale) {
        int[] nArray = (int[])fWeekDaysMap.get(locale);
        if (nArray == null) {
            nArray = new int[7];
            fWeekDaysMap.put(locale, nArray);
            int n = 0;
            if (FIRST_DAY_OF_WEEK == 1) {
                nArray[n++] = 1;
            }
            nArray[n++] = 2;
            nArray[n++] = 3;
            nArray[n++] = 4;
            nArray[n++] = 5;
            nArray[n++] = 6;
            nArray[n++] = 7;
            if (FIRST_DAY_OF_WEEK == 2) {
                nArray[n++] = 1;
            }
        }
        return nArray;
    }

    public static int getDaysInMonth(Date date) {
        int n;
        boolean bl = StreamUtil.z;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, n);
        for (n = 1; calendar.get(5) == n; ++n) {
            calendar.add(5, 1);
            if (!bl) continue;
        }
        return n - 1;
    }

    public static Date getNextMonth(Date date) {
        Calendar calendar;
        block7: {
            int n;
            block6: {
                boolean bl;
                block5: {
                    block4: {
                        bl = StreamUtil.z;
                        calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        n = calendar.get(5);
                        int n2 = calendar.get(2);
                        calendar.set(5, 1);
                        if (n2 >= 11) break block4;
                        calendar.set(2, n2 + 1);
                        if (!bl) break block5;
                    }
                    int n3 = calendar.get(1);
                    calendar.set(1, n3 + 1);
                    calendar.set(2, 0);
                }
                if (n <= CalendarUtil.getDaysInMonth(calendar.getTime())) break block6;
                calendar.set(5, CalendarUtil.getDaysInMonth(calendar.getTime()));
                if (!bl) break block7;
            }
            calendar.set(5, n);
        }
        return calendar.getTime();
    }

    public static Date getPreviousMonth(Date date) {
        Calendar calendar;
        block7: {
            int n;
            block6: {
                boolean bl;
                block5: {
                    block4: {
                        bl = StreamUtil.z;
                        calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        n = calendar.get(5);
                        int n2 = calendar.get(2);
                        calendar.set(5, 1);
                        if (n2 <= 0) break block4;
                        calendar.set(2, n2 - 1);
                        if (!bl) break block5;
                    }
                    int n3 = calendar.get(1);
                    calendar.set(1, n3 - 1);
                    calendar.set(2, 11);
                }
                if (n <= CalendarUtil.getDaysInMonth(calendar.getTime())) break block6;
                calendar.set(5, CalendarUtil.getDaysInMonth(calendar.getTime()));
                if (!bl) break block7;
            }
            calendar.set(5, n);
        }
        return calendar.getTime();
    }

    public static boolean isEqual(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        int n = calendar.get(5);
        int n2 = calendar.get(2);
        int n3 = calendar.get(1);
        int n4 = calendar2.get(5);
        int n5 = calendar2.get(2);
        int n6 = calendar2.get(1);
        return n == n4 && n2 == n5 && n3 == n6;
    }

    public static boolean isBetweenIgnoreTime(Date date, Date date2, Date date3) {
        Date date4 = CalendarUtil.clearTime(date);
        Date date5 = CalendarUtil.clearTime(date2);
        Date date6 = CalendarUtil.clearTime(date3);
        return CalendarUtil.isBetween(date4, date5, date6);
    }

    public static boolean isBetween(Date date, Date date2, Date date3) {
        return !(!date2.equals(date) && !date2.before(date) || !date3.equals(date) && !date3.after(date));
    }

    public static boolean isBetween(Date date, Date date2, Date date3, Date date4) {
        return !(!date2.equals(date3) && !date2.after(date3) || !date.equals(date4) && !date.before(date4));
    }

    public static int compareDates(Date date, Date date2) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        Calendar calendar2 = CalendarUtil.createCalendar(date2);
        CalendarUtil.clearTime(calendar);
        CalendarUtil.clearTime(calendar2);
        return calendar.equals(calendar2) ? 0 : (calendar.after(calendar2) ? 1 : -1);
    }

    public static Date[] getWeekRange(Date date) {
        Date[] dateArray = new Date[2];
        Calendar calendar = CalendarUtil.createCalendar(date);
        CalendarUtil.clearTime(calendar);
        int n = calendar.get(7);
        int n2 = calendar.getFirstDayOfWeek();
        calendar.add(5, -(n - n2));
        dateArray[0] = calendar.getTime();
        calendar.add(5, 6);
        dateArray[1] = calendar.getTime();
        return dateArray;
    }

    public static Date[] getMonthRange(Date date) {
        Date[] dateArray = new Date[2];
        Calendar calendar = CalendarUtil.createCalendar(date);
        CalendarUtil.clearTime(calendar);
        calendar.set(5, 1);
        dateArray[0] = calendar.getTime();
        calendar.add(5, CalendarUtil.getDaysInMonth(calendar.getTime()) - 1);
        dateArray[1] = calendar.getTime();
        return dateArray;
    }

    public static Date[] getYearRange(Date date) {
        Date[] dateArray = new Date[2];
        Calendar calendar = CalendarUtil.createCalendar(date);
        CalendarUtil.clearTime(calendar);
        calendar.set(5, 1);
        calendar.set(2, 0);
        dateArray[0] = calendar.getTime();
        calendar.set(5, 31);
        calendar.set(2, 11);
        dateArray[1] = calendar.getTime();
        return dateArray;
    }

    public static int getEndQuarterMonthsAmount(int n) {
        int n2;
        block5: {
            block6: {
                boolean bl;
                block4: {
                    bl = StreamUtil.z;
                    n2 = 3;
                    if (n != 2) break block4;
                    n2 = 6;
                    if (!bl) break block5;
                }
                if (n != 3) break block6;
                n2 = 9;
                if (!bl) break block5;
            }
            if (n == 4) {
                n2 = 12;
            }
        }
        return n2;
    }

    public static Date incDay(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, n);
        return calendar.getTime();
    }

    public static Date incWeek(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(3, n);
        return calendar.getTime();
    }

    public static int getDaysDifference(Date date, Date date2) {
        float f = (float)(date.getTime() - date2.getTime()) / 8.64E7f;
        return Math.round(f);
    }

    public static int getHoursDifference(Date date, Date date2) {
        float f = (float)(date.getTime() - date2.getTime()) / 3600000.0f;
        return Math.round(f);
    }

    public static int getMinutesDifference(Date date, Date date2) {
        float f = (float)(date.getTime() - date2.getTime()) / 60000.0f;
        return Math.round(f);
    }

    public static int getSecondsDifference(Date date, Date date2) {
        float f = (float)(date.getTime() - date2.getTime()) / 1000.0f;
        return Math.round(f);
    }

    protected static Date clearHMSM(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    protected static Date clearMSM(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int getDaysDifferenceInt(Date date, Date date2) {
        return CalendarUtil.getDaysDifference(CalendarUtil.clearHMSM(date), CalendarUtil.clearHMSM(date2));
    }

    public static int getHoursDifferenceInt(Date date, Date date2) {
        return CalendarUtil.getHoursDifference(CalendarUtil.clearMSM(date), CalendarUtil.clearMSM(date2));
    }

    public static String formatDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_TIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        if (date == null) {
            return null;
        }
        return TIME_FORMAT.format(date);
    }

    public static String formatTimeHumanReadable(long l) {
        String string;
        block3: {
            long l2;
            long l3;
            long l4;
            block5: {
                boolean bl;
                block4: {
                    long l5;
                    block2: {
                        bl = StreamUtil.z;
                        l5 = l / 1000L;
                        l4 = l / 60000L;
                        l3 = l / 3600000L;
                        l2 = l / 86400000L;
                        if (l >= 60000L) break block2;
                        string = FORMAT_SEC.format(new Object[]{new Long(l5)});
                        if (!bl) break block3;
                    }
                    if (l >= 3600000L) break block4;
                    string = FORMAT_MIN_SEC.format(new Object[]{new Long(l4), new Long(l5 - l4 * 60000L / 1000L)});
                    if (!bl) break block3;
                }
                if (l >= 86400000L) break block5;
                string = FORMAT_HOUR_MIN.format(new Object[]{new Long(l3), new Long(l4 - l3 * 3600000L / 60000L)});
                if (!bl) break block3;
            }
            string = FORMAT_DAYS_HOUR_MIN.format(new Object[]{new Long(l2), new Long(l3 - l2 * 86400000L / 3600000L), new Long(l4 - l3 * 3600000L / 60000L)});
        }
        return string;
    }

    public static Date getQuarterStartDate(Date date) {
        boolean bl = StreamUtil.z;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        while (calendar.get(2) != 9 && calendar.get(2) != 6 && calendar.get(2) != 3 && calendar.get(2) != 0) {
            calendar.add(2, -1);
            if (!bl) continue;
        }
        return calendar.getTime();
    }

    public static Calendar createCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static int getDayOfWeekdayEntry(Date date, int n) {
        boolean bl = StreamUtil.z;
        Calendar calendar = CalendarUtil.createCalendar(date);
        int n2 = calendar.get(1) + calendar.get(2);
        calendar.set(5, 0);
        block0: for (int i = 1; i <= n; ++i) {
            calendar.add(5, 1);
            while (calendar.get(7) == 7 || calendar.get(7) == 1) {
                calendar.add(5, 1);
                if (!bl) continue;
            }
            if (n2 >= calendar.get(1) + calendar.get(2)) continue;
            calendar.add(5, -1);
            while (calendar.get(7) == 7 || calendar.get(7) == 1) {
                calendar.add(5, -1);
                if (!bl) continue;
                if (!bl) continue block0;
            }
            break block0;
        }
        return calendar.get(5);
    }

    public static int getLastDayOfWeekdayEntry(Date date) {
        boolean bl = StreamUtil.z;
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.set(5, CalendarUtil.getDaysInMonth(date));
        while (calendar.get(7) == 7 || calendar.get(7) == 1) {
            calendar.add(5, -1);
            if (!bl) continue;
        }
        return calendar.get(5);
    }

    public static int getDayOfWeekendEntry(Date date, int n) {
        boolean bl = StreamUtil.z;
        Calendar calendar = CalendarUtil.createCalendar(date);
        int n2 = calendar.get(1) + calendar.get(2);
        calendar.set(5, 0);
        block0: for (int i = 1; i <= n; ++i) {
            calendar.add(5, 1);
            while (calendar.get(7) != 7 && calendar.get(7) != 1) {
                calendar.add(5, 1);
                if (!bl) continue;
            }
            if (n2 >= calendar.get(1) + calendar.get(2)) continue;
            calendar.add(5, -1);
            while (calendar.get(7) != 7 && calendar.get(7) != 1) {
                calendar.add(5, -1);
                if (!bl) continue;
                if (!bl) continue block0;
            }
            break block0;
        }
        return calendar.get(5);
    }

    public static int getLastDayOfWeekendEntry(Date date) {
        boolean bl = StreamUtil.z;
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.set(5, CalendarUtil.getDaysInMonth(date));
        while (calendar.get(7) != 1) {
            calendar.add(5, -1);
            if (!bl) continue;
        }
        return calendar.get(5);
    }

    public static int getDayOfWeekEntry(Date date, int n, int n2) {
        boolean bl = StreamUtil.z;
        Calendar calendar = CalendarUtil.createCalendar(date);
        int n3 = calendar.get(1) + calendar.get(2);
        calendar.set(5, 0);
        block0: for (int i = 1; i <= n2; ++i) {
            calendar.add(5, 1);
            while (calendar.get(7) != n) {
                calendar.add(5, 1);
                if (!bl) continue;
            }
            if (n3 >= calendar.get(1) + calendar.get(2)) continue;
            calendar.add(5, -1);
            while (calendar.get(7) != n) {
                calendar.add(5, -1);
                if (!bl) continue;
                if (!bl) continue block0;
            }
            break block0;
        }
        return calendar.get(5);
    }

    public static int getLastDayOfWeekEntry(Date date, int n) {
        boolean bl = StreamUtil.z;
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.set(5, CalendarUtil.getDaysInMonth(date));
        while (calendar.get(7) != n) {
            calendar.add(5, -1);
            if (!bl) continue;
        }
        return calendar.get(5);
    }

    public static void fillTime(Calendar calendar, Calendar calendar2) {
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
    }

    public static Calendar fillTime(Date date, Date date2) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        CalendarUtil.fillTime(calendar, CalendarUtil.createCalendar(date2));
        return calendar;
    }

    public static Calendar getWithoutTime(Calendar calendar) {
        CalendarUtil.clearTime(calendar);
        return calendar;
    }

    public static Date clearTime(Date date) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        CalendarUtil.clearTime(calendar);
        return calendar.getTime();
    }

    public static void clearTime(Calendar calendar) {
        calendar.set(9, 0);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.set(10, 0);
    }

    public static Date getCurrentDate() {
        Calendar calendar = CalendarUtil.createCalendar(new Date());
        CalendarUtil.clearTime(calendar);
        return calendar.getTime();
    }

    public static Calendar getWeekStart(Calendar calendar) {
        boolean bl = StreamUtil.z;
        Calendar calendar2 = (Calendar)calendar.clone();
        int n = calendar.getFirstDayOfWeek();
        while (calendar2.get(7) != n) {
            calendar2.add(7, -1);
            if (!bl) continue;
        }
        return calendar2;
    }

    public static Calendar getFirstDateOfWeekWithinMonth(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        int n = calendar2.getFirstDayOfWeek();
        int n2 = calendar2.get(2);
        while (n != calendar2.get(7)) {
            calendar2.add(5, -1);
            if (n2 == calendar2.get(2)) continue;
            calendar2.add(5, 1);
            break;
        }
        return calendar2;
    }

    public static Calendar getLastDateOfWeekWithinMonth(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        int n = calendar2.get(3);
        int n2 = calendar2.get(2);
        do {
            calendar2.add(5, 1);
        } while (n2 == calendar2.get(2) && n == calendar2.get(3));
        calendar2.add(5, -1);
        return calendar2;
    }

    public static Calendar getFirstDayOfMonth(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(5, 1);
        return calendar2;
    }

    public static Calendar getLastDayOfMonth(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(5, CalendarUtil.getDaysInMonth(calendar.getTime()));
        return calendar2;
    }

    public static Calendar[] getMonthPeriod(int n, int n2) {
        Calendar[] calendarArray = new Calendar[2];
        calendarArray[0] = Calendar.getInstance();
        calendarArray[0].set(1, n2);
        calendarArray[0].set(5, 1);
        calendarArray[0].set(2, n);
        calendarArray[1] = CalendarUtil.getLastDayOfMonth(calendarArray[0]);
        CalendarUtil.clearTime(calendarArray[0]);
        CalendarUtil.clearTime(calendarArray[1]);
        return calendarArray;
    }

    public static int getQuarter(Calendar calendar) {
        int n;
        block5: {
            int n2;
            block6: {
                boolean bl;
                block4: {
                    bl = StreamUtil.z;
                    n = 1;
                    n2 = calendar.get(2);
                    if (n2 != 3 && n2 != 4 && n2 != 5) break block4;
                    n = 2;
                    if (!bl) break block5;
                }
                if (n2 != 6 && n2 != 7 && n2 != 8) break block6;
                n = 3;
                if (!bl) break block5;
            }
            if (n2 == 9 || n2 == 10 || n2 == 11) {
                n = 4;
            }
        }
        return n;
    }

    public static Calendar[] getQuarterPeriod(int n, int n2) {
        boolean bl = StreamUtil.z;
        Calendar[] calendarArray = new Calendar[]{Calendar.getInstance(), Calendar.getInstance()};
        calendarArray[0].set(1, n2);
        calendarArray[0].set(5, 1);
        calendarArray[1].set(1, n2);
        calendarArray[1].set(5, 1);
        switch (n) {
            case 1: {
                calendarArray[0].set(2, 0);
                calendarArray[1].set(2, 2);
                if (!bl) break;
                StringUtils.z = !StringUtils.z;
            }
            case 2: {
                calendarArray[0].set(2, 3);
                calendarArray[1].set(2, 5);
                if (!bl) break;
            }
            case 3: {
                calendarArray[0].set(2, 6);
                calendarArray[1].set(2, 8);
                if (!bl) break;
            }
            case 4: {
                calendarArray[0].set(2, 9);
                calendarArray[1].set(2, 11);
            }
        }
        calendarArray[1].set(5, CalendarUtil.getDaysInMonth(calendarArray[1].getTime()));
        CalendarUtil.clearTime(calendarArray[0]);
        CalendarUtil.clearTime(calendarArray[1]);
        return calendarArray;
    }

    public static void updateTime(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        calendar2.set(9, calendar.get(9));
        calendar2.set(14, 0);
        calendar2.set(13, 0);
        calendar2.set(12, calendar.get(12));
        calendar2.set(10, calendar.get(10));
        date2.setTime(calendar2.getTimeInMillis());
    }

    public static void updateTimeWSeconds(Date date, Date date2) {
        boolean bl = StreamUtil.z;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        calendar2.set(9, calendar.get(9));
        calendar2.set(14, calendar.get(14));
        calendar2.set(13, calendar.get(13));
        calendar2.set(12, calendar.get(12));
        calendar2.set(10, calendar.get(10));
        date2.setTime(calendar2.getTimeInMillis());
        if (StringUtils.z) {
            StreamUtil.z = !bl;
        }
    }

    public static long getTimeOffset(Calendar calendar) {
        return (calendar.get(15) + calendar.get(16)) / 60000;
    }

    public static Date changeTimeZone(Date date, String string) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getTimeZone(string));
        calendar.add(14, calendar.get(15));
        return calendar.getTime();
    }

    public static Date changeTimeZone(Date date, String string, String string2) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(string));
        calendar.setTime(date);
        calendar.add(14, calendar.get(15));
        calendar.setTimeZone(TimeZone.getTimeZone(string2));
        calendar.add(14, calendar.get(15));
        return calendar.getTime();
    }

    public static Date fromGMT0(Date date) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.add(14, calendar.get(15));
        return calendar.getTime();
    }

    public static Date toGMT0(Date date) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.add(14, -calendar.get(15));
        return calendar.getTime();
    }

    public static void main(String[] stringArray) {
        System.out.println(CalendarUtil.changeTimeZone(new Date(), z[0]));
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block76: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block75: {
                char[] cArray3;
                Object var0;
                block74: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block73: {
                        char[] cArray5;
                        block72: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block71: {
                                char[] cArray7;
                                block70: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block69: {
                                        char[] cArray9;
                                        block68: {
                                            int n10;
                                            int n11;
                                            char[] cArray10;
                                            block67: {
                                                char[] cArray11;
                                                block66: {
                                                    int n12;
                                                    int n13;
                                                    char[] cArray12;
                                                    block65: {
                                                        char[] cArray13;
                                                        block64: {
                                                            int n14;
                                                            int n15;
                                                            char[] cArray14;
                                                            block63: {
                                                                stringArray = new String[7];
                                                                var0 = null;
                                                                char[] cArray15 = "IO\u0015\\?".toCharArray();
                                                                n3 = 0;
                                                                int n16 = cArray15.length;
                                                                cArray14 = cArray15;
                                                                n15 = n16;
                                                                if (n16 <= 1) break block63;
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                                if (n15 <= n3) break block64;
                                                            }
                                                            do {
                                                                char[] cArray16 = cArray14;
                                                                char[] cArray17 = cArray14;
                                                                int n17 = n3;
                                                                while (true) {
                                                                    int n18;
                                                                    char c = cArray16[n17];
                                                                    switch (n3 % 5) {
                                                                        case 0: {
                                                                            n18 = 14;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n18 = 2;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n18 = 65;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n18 = 119;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n18 = 11;
                                                                        }
                                                                    }
                                                                    cArray16[n17] = (char)(c ^ n18);
                                                                    ++n3;
                                                                    cArray14 = cArray17;
                                                                    n15 = n15;
                                                                    if (n15 != 0) break;
                                                                    cArray17 = cArray14;
                                                                    n14 = n15;
                                                                    n17 = n15;
                                                                    cArray16 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                            } while (n15 > n3);
                                                        }
                                                        stringArray[0] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray18 = "CO\f:".toCharArray();
                                                        n3 = 0;
                                                        int n19 = cArray18.length;
                                                        cArray12 = cArray18;
                                                        n13 = n19;
                                                        if (n19 <= 1) break block65;
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                        if (n13 <= n3) break block66;
                                                    }
                                                    do {
                                                        char[] cArray19 = cArray12;
                                                        char[] cArray20 = cArray12;
                                                        int n20 = n3;
                                                        while (true) {
                                                            int n21;
                                                            char c = cArray19[n20];
                                                            switch (n3 % 5) {
                                                                case 0: {
                                                                    n21 = 14;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n21 = 2;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n21 = 65;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n21 = 119;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n21 = 11;
                                                                }
                                                            }
                                                            cArray19[n20] = (char)(c ^ n21);
                                                            ++n3;
                                                            cArray12 = cArray20;
                                                            n13 = n13;
                                                            if (n13 != 0) break;
                                                            cArray20 = cArray12;
                                                            n12 = n13;
                                                            n20 = n13;
                                                            cArray19 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                    } while (n13 > n3);
                                                }
                                                stringArray[1] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray21 = "KG\u00042".toCharArray();
                                                n3 = 0;
                                                int n22 = cArray21.length;
                                                cArray10 = cArray21;
                                                n11 = n22;
                                                if (n22 <= 1) break block67;
                                                cArray9 = cArray10;
                                                n10 = n11;
                                                if (n11 <= n3) break block68;
                                            }
                                            do {
                                                char[] cArray22 = cArray10;
                                                char[] cArray23 = cArray10;
                                                int n23 = n3;
                                                while (true) {
                                                    int n24;
                                                    char c = cArray22[n23];
                                                    switch (n3 % 5) {
                                                        case 0: {
                                                            n24 = 14;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n24 = 2;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n24 = 65;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n24 = 119;
                                                            break;
                                                        }
                                                        default: {
                                                            n24 = 11;
                                                        }
                                                    }
                                                    cArray22[n23] = (char)(c ^ n24);
                                                    ++n3;
                                                    cArray10 = cArray23;
                                                    n11 = n11;
                                                    if (n11 != 0) break;
                                                    cArray23 = cArray10;
                                                    n10 = n11;
                                                    n23 = n11;
                                                    cArray22 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n10 = n11;
                                            } while (n11 > n3);
                                        }
                                        stringArray[2] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray24 = "u2<Woo{2Wp?\u007fa\u001fy},a\f9s\",\u001ee ".toCharArray();
                                        n3 = 0;
                                        int n25 = cArray24.length;
                                        cArray8 = cArray24;
                                        n9 = n25;
                                        if (n25 <= 1) break block69;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block70;
                                    }
                                    do {
                                        char[] cArray25 = cArray8;
                                        char[] cArray26 = cArray8;
                                        int n26 = n3;
                                        while (true) {
                                            int n27;
                                            char c = cArray25[n26];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n27 = 14;
                                                    break;
                                                }
                                                case 1: {
                                                    n27 = 2;
                                                    break;
                                                }
                                                case 2: {
                                                    n27 = 65;
                                                    break;
                                                }
                                                case 3: {
                                                    n27 = 119;
                                                    break;
                                                }
                                                default: {
                                                    n27 = 11;
                                                }
                                            }
                                            cArray25[n26] = (char)(c ^ n27);
                                            ++n3;
                                            cArray8 = cArray26;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray26 = cArray8;
                                            n8 = n9;
                                            n26 = n9;
                                            cArray25 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                stringArray[3] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray27 = "u2<WfgloWp?\u007fa\u0004nm,".toCharArray();
                                n3 = 0;
                                int n28 = cArray27.length;
                                cArray6 = cArray27;
                                n7 = n28;
                                if (n28 <= 1) break block71;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block72;
                            }
                            do {
                                char[] cArray28 = cArray6;
                                char[] cArray29 = cArray6;
                                int n29 = n3;
                                while (true) {
                                    int n30;
                                    char c = cArray28[n29];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n30 = 14;
                                            break;
                                        }
                                        case 1: {
                                            n30 = 2;
                                            break;
                                        }
                                        case 2: {
                                            n30 = 65;
                                            break;
                                        }
                                        case 3: {
                                            n30 = 119;
                                            break;
                                        }
                                        default: {
                                            n30 = 11;
                                        }
                                    }
                                    cArray28[n29] = (char)(c ^ n30);
                                    ++n3;
                                    cArray6 = cArray29;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray29 = cArray6;
                                    n6 = n7;
                                    n29 = n7;
                                    cArray28 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[4] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray30 = "u2<Wc|qoWp?\u007fa\u001ab`,".toCharArray();
                        n3 = 0;
                        int n31 = cArray30.length;
                        cArray4 = cArray30;
                        n5 = n31;
                        if (n31 <= 1) break block73;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block74;
                    }
                    do {
                        char[] cArray31 = cArray4;
                        char[] cArray32 = cArray4;
                        int n32 = n3;
                        while (true) {
                            int n33;
                            char c = cArray31[n32];
                            switch (n3 % 5) {
                                case 0: {
                                    n33 = 14;
                                    break;
                                }
                                case 1: {
                                    n33 = 2;
                                    break;
                                }
                                case 2: {
                                    n33 = 65;
                                    break;
                                }
                                case 3: {
                                    n33 = 119;
                                    break;
                                }
                                default: {
                                    n33 = 11;
                                }
                            }
                            cArray31[n32] = (char)(c ^ n33);
                            ++n3;
                            cArray4 = cArray32;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray32 = cArray4;
                            n4 = n5;
                            n32 = n5;
                            cArray31 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[5] = new String(cArray3).intern();
                var0 = null;
                char[] cArray33 = "u2<Wxkao".toCharArray();
                n3 = 0;
                int n34 = cArray33.length;
                cArray2 = cArray33;
                n2 = n34;
                if (n34 <= 1) break block75;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block76;
            }
            do {
                char[] cArray34 = cArray2;
                char[] cArray35 = cArray2;
                int n35 = n3;
                while (true) {
                    int n36;
                    char c = cArray34[n35];
                    switch (n3 % 5) {
                        case 0: {
                            n36 = 14;
                            break;
                        }
                        case 1: {
                            n36 = 2;
                            break;
                        }
                        case 2: {
                            n36 = 65;
                            break;
                        }
                        case 3: {
                            n36 = 119;
                            break;
                        }
                        default: {
                            n36 = 11;
                        }
                    }
                    cArray34[n35] = (char)(c ^ n36);
                    ++n3;
                    cArray2 = cArray35;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray35 = cArray2;
                    n = n2;
                    n35 = n2;
                    cArray34 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[6] = new String(cArray).intern();
        z = stringArray;
        FIRST_DAY_OF_WEEK = Calendar.getInstance().getFirstDayOfWeek();
        DATE_TIME_FORMAT = DateFormat.getDateTimeInstance(3, 3);
        DATE_FORMAT = DateFormat.getDateInstance(3);
        TIME_FORMAT = DateFormat.getTimeInstance(3);
        fMonthNamesMap = new HashMap();
        fWeekNamesMap = new HashMap();
        fWeekDaysMap = new HashMap();
        FORMAT_SEC = new MessageFormat(z[6]);
        FORMAT_MIN_SEC = new MessageFormat(z[4]);
        FORMAT_HOUR_MIN = new MessageFormat(z[5]);
        FORMAT_DAYS_HOUR_MIN = new MessageFormat(z[3]);
    }
}

