/*
 * Decompiled with CFR 0.152.
 */
package dev.util;

import dev.util.StreamUtil;
import dev.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class StringConverter {
    static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    static final NumberFormat CURRENCY_FORMAT = NumberFormat.getCurrencyInstance();
    static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();
    static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    static final DateFormat DATE_TIME_FORMAT = DateFormat.getDateInstance(3);
    static final Map VALUE_CONVERTERS = new HashMap();
    static final String DELIMITER = ",";
    public static final String BYTE_DELIMITER = ",";
    public static final String LONG_DELIMITER = ",";

    public static void addValueConverter(Class clazz, Class clazz2, ValueConverter valueConverter) {
        VALUE_CONVERTERS.put(clazz.getName() + clazz2.getName(), valueConverter);
    }

    public static Object convert(Class clazz, Class clazz2, Object object) {
        Object object2;
        block5: {
            block4: {
                object2 = object;
                ValueConverter valueConverter = StringConverter.getConverter(clazz, clazz2);
                if (valueConverter == null) break block4;
                object2 = valueConverter.convert(object);
                if (!StreamUtil.z) break block5;
            }
            if (clazz2.equals(String.class)) {
                object2 = object.toString();
            }
        }
        return object2;
    }

    public static ValueConverter getConverter(Class clazz, Class clazz2) {
        return (ValueConverter)VALUE_CONVERTERS.get(clazz.getName() + clazz2.getName());
    }

    public static int toInt(String string) throws ParseException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = NUMBER_FORMAT.parse(string).intValue();
        }
        return n;
    }

    public static long toLong(String string) throws ParseException {
        long l;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l = NUMBER_FORMAT.parse(string).longValue();
        }
        return l;
    }

    public static float toFloat(String string) throws ParseException {
        float f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            f = NUMBER_FORMAT.parse(string).floatValue();
        }
        return f;
    }

    public static long toCurrency(String string) throws ParseException {
        long l;
        try {
            l = (long)(NUMBER_FORMAT.parse(string).floatValue() * 100.0f);
        }
        catch (ParseException parseException) {
            l = (long)(CURRENCY_FORMAT.parse(string).floatValue() * 100.0f);
        }
        return l;
    }

    public static double toDouble(String string) throws ParseException {
        double d;
        try {
            d = NUMBER_FORMAT.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            try {
                d = CURRENCY_FORMAT.parse(string).doubleValue();
            }
            catch (Exception exception) {
                d = PERCENT_FORMAT.parse(string).doubleValue();
            }
        }
        return d;
    }

    public static Date toDate(String string) throws ParseException {
        Date date;
        try {
            date = DATE_FORMAT.parse(string);
        }
        catch (ParseException parseException) {
            date = DATE_TIME_FORMAT.parse(string);
        }
        return date;
    }

    public static Color toColor(String string) {
        return new Color(Integer.parseInt(string));
    }

    public static String fromColor(Color color) {
        return String.valueOf(color.getRGB());
    }

    public static Rectangle toRectangle(String string) {
        boolean bl = StreamUtil.z;
        int[] nArray = new int[4];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens() && n < 4) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
            if (!bl) continue;
        }
        return new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static String fromRectangle(Rectangle rectangle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(rectangle.x);
        stringBuffer.append(",");
        stringBuffer.append(rectangle.y);
        stringBuffer.append(",");
        stringBuffer.append(rectangle.width);
        stringBuffer.append(",");
        stringBuffer.append(rectangle.height);
        return stringBuffer.toString();
    }

    public static Dimension toDimension(String string) {
        boolean bl = StreamUtil.z;
        int[] nArray = new int[2];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens() && n < 2) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
            if (!bl) continue;
        }
        return new Dimension(nArray[0], nArray[1]);
    }

    public static String fromDimension(Dimension dimension) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(dimension.width);
        stringBuffer.append(",");
        stringBuffer.append(dimension.height);
        return stringBuffer.toString();
    }

    public static Point toPoint(String string) {
        boolean bl = StreamUtil.z;
        int[] nArray = new int[2];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens() && n < 2) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
            if (!bl) continue;
        }
        return new Point(nArray[0], nArray[1]);
    }

    public static String fromPoint(Point point) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(point.x);
        stringBuffer.append(",");
        stringBuffer.append(point.y);
        return stringBuffer.toString();
    }

    public static String toString(byte[] byArray) {
        boolean bl = StreamUtil.z;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(byArray[i]);
            if (!bl) continue;
        }
        return stringBuffer.toString();
    }

    public static byte[] toBytes(String string) {
        boolean bl = StreamUtil.z;
        String[] stringArray = string.split(",");
        byte[] byArray = new byte[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            byArray[i] = Byte.parseByte(stringArray[i].trim());
            if (!bl) continue;
        }
        return byArray;
    }

    public static String toString(long[] lArray) {
        boolean bl = StreamUtil.z;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(lArray[i]);
            if (!bl) continue;
        }
        return stringBuffer.toString();
    }

    public static long[] toLongs(String string) {
        boolean bl = StreamUtil.z;
        String[] stringArray = string.split(",");
        long[] lArray = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            lArray[i] = Long.parseLong(stringArray[i].trim());
            if (!bl) continue;
        }
        return lArray;
    }

    static {
        StringConverter.addValueConverter(String.class, Double.class, new StringToDoubleConverter());
        StringConverter.addValueConverter(String.class, Long.class, new StringToLongConverter());
        StringConverter.addValueConverter(String.class, Integer.class, new StringToIntegerConverter());
        StringConverter.addValueConverter(String.class, Date.class, new StringToDateConverter());
    }

    public static class StringToDateConverter
    implements ValueConverter {
        public Object convert(Object object) {
            Date date = null;
            try {
                date = StringConverter.toDate(StringUtils.removeNotSymbols(object.toString()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return date;
        }
    }

    public static class StringToIntegerConverter
    implements ValueConverter {
        public Object convert(Object object) {
            Integer n = null;
            try {
                n = new Integer(new Double(StringConverter.toDouble(StringUtils.removeNotSymbols(object.toString()))).intValue());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return n;
        }
    }

    public static class StringToLongConverter
    implements ValueConverter {
        public Object convert(Object object) {
            Long l = null;
            try {
                l = new Long(new Double(StringConverter.toDouble(StringUtils.removeNotSymbols(object.toString()))).longValue());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return l;
        }
    }

    public static class StringToDoubleConverter
    implements ValueConverter {
        public Object convert(Object object) {
            Double d = null;
            try {
                d = new Double(StringConverter.toDouble(StringUtils.removeNotSymbols(object.toString())));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return d;
        }
    }

    public static interface ValueConverter {
        public Object convert(Object var1);
    }
}

