/*
 * Decompiled with CFR 0.152.
 */
package dev.util.collections;

import dev.util.StringUtils;
import dev.util.collections.ContainedListProvider;
import dev.util.collections.ContainerListener;
import dev.util.collections.ListProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class BoundList
extends ListProxy {
    public static final long serialVersionUID = 3392510652753377744L;
    private transient Vector fListeners = new Vector(2);
    protected Object fEventSource = this;
    protected Object fLock = this;
    protected boolean fNotifyOnSet = true;
    public static final int INITIAL_LISTENERS_COUNT = 2;
    public static /* synthetic */ boolean z;
    private static final /* synthetic */ String A;

    public BoundList(List list) {
        super(list);
    }

    public BoundList(List list, ContainerListener containerListener) {
        this(list);
        this.addContainerListener(containerListener);
    }

    public BoundList(ContainedListProvider containedListProvider) {
        super(containedListProvider);
    }

    public BoundList() {
    }

    public void setLock(Object object) {
        if (this.fLock != this) {
            throw new IllegalArgumentException(A);
        }
        this.fLock = object;
    }

    public void setEventSource(Object object) {
        this.fEventSource = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n, Object object) {
        Object object2 = this.fLock;
        synchronized (object2) {
            if (this.beforeAddElement(object)) {
                this.getContainedList().add(n, object);
                this.fireAddElement(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection collection) {
        boolean bl = ListProxy.z;
        boolean bl2 = false;
        Object object = this.fLock;
        synchronized (object) {
            ArrayList arrayList = new ArrayList();
            for (Object e : collection) {
                if (!this.getContainedList().contains(e)) {
                    arrayList.add(e);
                }
                if (!bl) continue;
            }
            if (this.beforeRemoveElements(collection) && (bl2 = this.getContainedList().retainAll(collection))) {
                this.fireRemoveElements(arrayList);
            }
        }
        if (StringUtils.z) {
            ListProxy.z = !bl;
        }
        return bl2;
    }

    public boolean isNotifyOnSet() {
        return this.fNotifyOnSet;
    }

    public void setNotifyOnSet(boolean bl) {
        this.fNotifyOnSet = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int n, Object object) {
        Object object2 = this.fLock;
        synchronized (object2) {
            if (this.fNotifyOnSet) {
                Object e = this.getContainedList().get(n);
                if (this.beforeRemoveElement(e) && this.beforeAddElement(object)) {
                    this.getContainedList().set(n, object);
                    this.fireRemoveElement(e);
                    this.fireAddElement(object);
                }
                return e;
            }
            return this.getContainedList().set(n, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        boolean bl = false;
        Object object2 = this.fLock;
        synchronized (object2) {
            if (this.beforeAddElement(object) && (bl = this.getContainedList().add(object))) {
                this.fireAddElement(object);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        boolean bl = false;
        Object object = this.fLock;
        synchronized (object) {
            if (this.beforeAddElements(collection) && (bl = this.getContainedList().addAll(collection))) {
                this.fireAddElements(collection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveToTail(Object object) {
        Object object2 = this.fLock;
        synchronized (object2) {
            int n = this.getContainedList().indexOf(object);
            if (n != -1) {
                this.getContainedList().remove(n);
                this.getContainedList().add(object);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveToHead(Object object) {
        Object object2 = this.fLock;
        synchronized (object2) {
            List list = this.getContainedList();
            int n = list.indexOf(object);
            if (n != -1) {
                list.remove(n);
                list.add(0, object);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Object object = this.fLock;
        synchronized (object) {
            if (this.beforeRemoveElements(collection) && (bl = this.getContainedList().removeAll(collection))) {
                this.fireRemoveElements(collection);
            }
        }
        return bl;
    }

    public void clear() {
        this.removeAll((Collection)new ArrayList(this.getContainedList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int n, Collection collection) {
        boolean bl = false;
        Object object = this.fLock;
        synchronized (object) {
            if (this.beforeAddElements(collection) && (bl = this.getContainedList().addAll(collection))) {
                this.fireAddElements(collection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        boolean bl = false;
        Object object2 = this.fLock;
        synchronized (object2) {
            if (this.beforeRemoveElement(object) && (bl = this.getContainedList().remove(object))) {
                this.fireRemoveElement(object);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int n) {
        Object var2_2 = null;
        Object object = this.fLock;
        synchronized (object) {
            if (this.beforeRemoveElement(this.getContainedList().get(n))) {
                var2_2 = this.getContainedList().remove(n);
                this.fireRemoveElement(var2_2);
            }
        }
        return var2_2;
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator() {
        return new BoundListIterator(this, 0);
    }

    public ListIterator listIterator(int n) {
        return new BoundListIterator(this, n);
    }

    protected boolean beforeAddElement(Object object) {
        return true;
    }

    protected boolean beforeRemoveElement(Object object) {
        return true;
    }

    protected boolean beforeAddElements(Collection collection) {
        return true;
    }

    protected boolean beforeRemoveElements(Collection collection) {
        return true;
    }

    public synchronized void addContainerListener(ContainerListener containerListener) {
        if (this.fListeners == null) {
            this.fListeners = new Vector(2);
        }
        this.fListeners.add(containerListener);
    }

    public synchronized void removeContainerListener(ContainerListener containerListener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove(containerListener);
    }

    protected void fireAddElement(Object object) {
        boolean bl = ListProxy.z;
        if (this.fListeners == null) {
            return;
        }
        int n = this.fListeners.size();
        for (int i = 0; i < n; ++i) {
            ContainerListener containerListener = (ContainerListener)this.fListeners.get(i);
            if (containerListener == null) continue;
            containerListener.elementAdded(object, this.fEventSource);
            if (!bl) continue;
        }
    }

    protected void fireRemoveElement(Object object) {
        boolean bl = ListProxy.z;
        if (this.fListeners == null) {
            return;
        }
        int n = this.fListeners.size();
        for (int i = 0; i < n; ++i) {
            ContainerListener containerListener = (ContainerListener)this.fListeners.get(i);
            if (containerListener == null) continue;
            containerListener.elementRemoved(object, this.fEventSource);
            if (!bl) continue;
        }
    }

    protected void fireAddElements(Collection collection) {
        boolean bl = ListProxy.z;
        if (this.fListeners == null) {
            return;
        }
        int n = this.fListeners.size();
        for (int i = 0; i < n; ++i) {
            ContainerListener containerListener = (ContainerListener)this.fListeners.get(i);
            if (containerListener == null) continue;
            containerListener.elementsAdded(collection, this.fEventSource);
            if (!bl) continue;
        }
    }

    protected void fireRemoveElements(Collection collection) {
        boolean bl = ListProxy.z;
        if (this.fListeners == null) {
            return;
        }
        int n = this.fListeners.size();
        for (int i = 0; i < n; ++i) {
            ContainerListener containerListener = (ContainerListener)this.fListeners.get(i);
            if (containerListener == null) continue;
            containerListener.elementsRemoved(collection, this.fEventSource);
            if (!bl) continue;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                Object var0 = null;
                char[] cArray3 = "\u0012u\u00190\u001b7iZ:W,\u007f\u001b?B~i\n>X7|\u0013>_".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 94;
                            break;
                        }
                        case 1: {
                            n6 = 26;
                            break;
                        }
                        case 2: {
                            n6 = 122;
                            break;
                        }
                        case 3: {
                            n6 = 91;
                            break;
                        }
                        default: {
                            n6 = 59;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        A = new String(cArray).intern();
    }

    class BoundListIterator
    implements ListIterator {
        private int fIndex = 0;
        private BoundList fList = null;

        public BoundListIterator(BoundList boundList2, int n) {
            this.fIndex = n;
            this.fList = boundList2;
        }

        public void add(Object object) {
            this.fList.add(object);
        }

        public boolean hasNext() {
            return this.fIndex <= this.fList.size() - 1;
        }

        public boolean hasPrevious() {
            return this.fIndex > 0;
        }

        public Object next() {
            Object object = this.fList.get(this.fIndex);
            ++this.fIndex;
            return object;
        }

        public int nextIndex() {
            if (this.fIndex == this.fList.size()) {
                return this.fIndex;
            }
            return this.fIndex + 1;
        }

        public Object previous() {
            --this.fIndex;
            Object object = this.fList.get(this.fIndex);
            return object;
        }

        public int previousIndex() {
            int n = this.fIndex - 1;
            if (n < 0) {
                n = -1;
            }
            return n;
        }

        public void remove() {
            this.fList.remove(this.fIndex - 1);
        }

        public void set(Object object) {
            this.fList.set(this.fIndex, object);
        }
    }
}

