/*
 * Decompiled with CFR 0.152.
 */
package dev.util.collections;

import dev.util.HashedList;
import dev.util.HashedListStrategy;
import dev.util.StringUtils;
import dev.util.collections.BoundList;
import dev.util.collections.ContainedListProvider;
import dev.util.collections.ContainerListener;
import dev.util.collections.ListProxy;
import dev.util.collections.ReadOnlyHashedBoundList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class HashedBoundList
extends BoundList
implements HashedList,
ContainerListener {
    public static final long serialVersionUID = -7987271815203275086L;
    protected HashedListStrategy fHashedListStrategy;
    protected transient HashMap fElementsHash;
    protected transient ReadOnlyHashedBoundList fReadOnlyHashedBoundList;
    public static /* synthetic */ boolean z;
    private static final /* synthetic */ String[] A;

    public HashMap getElementsHash() {
        if (this.fElementsHash == null) {
            this.fElementsHash = new HashMap();
        }
        return this.fElementsHash;
    }

    public HashedBoundList(List list, HashedListStrategy hashedListStrategy) {
        this(list, hashedListStrategy, null);
    }

    public HashedBoundList(List list, HashedListStrategy hashedListStrategy, ContainerListener containerListener) {
        super(list);
        this.fHashedListStrategy = null;
        this.fElementsHash = new HashMap();
        this.fReadOnlyHashedBoundList = null;
        if (hashedListStrategy == null) {
            throw new IllegalArgumentException(A[0]);
        }
        this.fHashedListStrategy = hashedListStrategy;
        this.elementsAdded(list, this);
        this.addContainerListener(this);
        if (containerListener != null) {
            this.addContainerListener(containerListener);
        }
    }

    public HashedBoundList(ContainedListProvider containedListProvider, HashedListStrategy hashedListStrategy) {
        boolean bl = ListProxy.z;
        super(containedListProvider);
        this.fHashedListStrategy = null;
        this.fElementsHash = new HashMap();
        this.fReadOnlyHashedBoundList = null;
        if (hashedListStrategy == null) {
            throw new IllegalArgumentException(A[0]);
        }
        this.fHashedListStrategy = hashedListStrategy;
        this.elementsAdded(containedListProvider.getList(), this);
        this.addContainerListener(this);
        if (bl) {
            StringUtils.z = !StringUtils.z;
        }
    }

    public HashedBoundList(HashedListStrategy hashedListStrategy) {
        this.fHashedListStrategy = null;
        this.fElementsHash = new HashMap();
        this.fReadOnlyHashedBoundList = null;
        this.fHashedListStrategy = hashedListStrategy;
        if (hashedListStrategy == null) {
            throw new IllegalArgumentException(A[0]);
        }
        this.addContainerListener(this);
    }

    public Object get(Object object) {
        HashMap hashMap = this.getElementsHash();
        if (hashMap == null || hashMap.size() != this.getContainedList().size()) {
            this.rebuildHash();
        }
        return hashMap.get(object);
    }

    public HashedListStrategy getHashedListStrategy() {
        return this.fHashedListStrategy;
    }

    public void elementAdded(Object object, Object object2) {
        Object object3 = this.getHashedListStrategy().getKeyForObject(object);
        if (object3 != null) {
            this.getElementsHash().put(object3, object);
        }
    }

    public void elementRemoved(Object object, Object object2) {
        this.getElementsHash().remove(this.getHashedListStrategy().getKeyForObject(object));
    }

    public void elementsAdded(Collection collection, Object object) {
        for (Object e : collection) {
            this.getElementsHash().put(this.getHashedListStrategy().getKeyForObject(e), e);
        }
    }

    public void elementsRemoved(Collection collection, Object object) {
        boolean bl = ListProxy.z;
        for (Object e : collection) {
            this.getElementsHash().remove(this.getHashedListStrategy().getKeyForObject(e));
            if (!bl) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int n, Object object) {
        Object object2 = null;
        Object object3 = this.fLock;
        synchronized (object3) {
            if (!this.fNotifyOnSet) {
                object2 = this.getContainedList().set(n, object);
                this.updateHash(object);
            } else {
                super.set(n, object);
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHash(Object object) {
        boolean bl = ListProxy.z;
        HashMap hashMap = this.getElementsHash();
        synchronized (hashMap) {
            Iterator iterator = this.getElementsHash().keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (this.getElementsHash().get(k).equals(object)) {
                    iterator.remove();
                    if (!bl) break;
                }
                if (!bl) continue;
            }
            this.getElementsHash().put(this.getHashedListStrategy().getKeyForObject(object), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildHash() {
        boolean bl = ListProxy.z;
        HashMap hashMap = this.getElementsHash();
        synchronized (hashMap) {
            this.getElementsHash().clear();
            for (Object e : this.getContainedList()) {
                this.getElementsHash().put(this.getHashedListStrategy().getKeyForObject(e), e);
                if (!bl) continue;
            }
        }
    }

    public boolean contains(Object object) {
        return this.getElementsHash().containsKey(this.getHashedListStrategy().getKeyForObject(object));
    }

    public boolean containsAll(Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException(A[2]);
        }
        if (!collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ReadOnlyHashedBoundList getReadOnlyHashedBoundList() {
        if (this.fReadOnlyHashedBoundList == null) {
            this.fReadOnlyHashedBoundList = new ReadOnlyHashedBoundList((List)this, this.getHashedListStrategy());
            this.addContainerListener(new ContainerListener(){

                public void elementAdded(Object object, Object object2) {
                    HashedBoundList.this.fReadOnlyHashedBoundList.fireAddElement(object);
                }

                public void elementRemoved(Object object, Object object2) {
                    HashedBoundList.this.fReadOnlyHashedBoundList.fireRemoveElement(object);
                }

                public void elementsAdded(Collection collection, Object object) {
                    HashedBoundList.this.fReadOnlyHashedBoundList.fireAddElements(collection);
                }

                public void elementsRemoved(Collection collection, Object object) {
                    HashedBoundList.this.fReadOnlyHashedBoundList.fireRemoveElements(collection);
                }
            });
        }
        return this.fReadOnlyHashedBoundList;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addContainerListener(this);
    }

    public static void main(String[] stringArray) {
        HashedBoundList hashedBoundList = new HashedBoundList(new ArrayList(), new HashedListStrategy(){

            public Object getKeyForObject(Object object) {
                return object.toString();
            }
        });
        System.out.println(hashedBoundList.getReadOnlyHashedBoundList().size());
        hashedBoundList.add(A[1]);
        System.out.println(hashedBoundList.getReadOnlyHashedBoundList().size());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block32: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block31: {
                char[] cArray3;
                Object var0;
                block30: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block29: {
                        char[] cArray5;
                        block28: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block27: {
                                stringArray = new String[3];
                                var0 = null;
                                char[] cArray7 = "COieqj\ne$nk\u001cu$qv\u001d`pge\u0016!wjm\u001am`\"`\n!wrg\fhbkg\u000b".toCharArray();
                                n3 = 0;
                                int n8 = cArray7.length;
                                cArray6 = cArray7;
                                n7 = n8;
                                if (n8 <= 1) break block27;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block28;
                            }
                            do {
                                char[] cArray8 = cArray6;
                                char[] cArray9 = cArray6;
                                int n9 = n3;
                                while (true) {
                                    int n10;
                                    char c = cArray8[n9];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n10 = 2;
                                            break;
                                        }
                                        case 1: {
                                            n10 = 111;
                                            break;
                                        }
                                        case 2: {
                                            n10 = 1;
                                            break;
                                        }
                                        case 3: {
                                            n10 = 4;
                                            break;
                                        }
                                        default: {
                                            n10 = 2;
                                        }
                                    }
                                    cArray8[n9] = (char)(c ^ n10);
                                    ++n3;
                                    cArray6 = cArray9;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray9 = cArray6;
                                    n6 = n7;
                                    n9 = n7;
                                    cArray8 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[0] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray10 = "3^0533^".toCharArray();
                        n3 = 0;
                        int n11 = cArray10.length;
                        cArray4 = cArray10;
                        n5 = n11;
                        if (n11 <= 1) break block29;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block30;
                    }
                    do {
                        char[] cArray11 = cArray4;
                        char[] cArray12 = cArray4;
                        int n12 = n3;
                        while (true) {
                            int n13;
                            char c = cArray11[n12];
                            switch (n3 % 5) {
                                case 0: {
                                    n13 = 2;
                                    break;
                                }
                                case 1: {
                                    n13 = 111;
                                    break;
                                }
                                case 2: {
                                    n13 = 1;
                                    break;
                                }
                                case 3: {
                                    n13 = 4;
                                    break;
                                }
                                default: {
                                    n13 = 2;
                                }
                            }
                            cArray11[n12] = (char)(c ^ n13);
                            ++n3;
                            cArray4 = cArray12;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray12 = cArray4;
                            n4 = n5;
                            n12 = n5;
                            cArray11 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[1] = new String(cArray3).intern();
                var0 = null;
                char[] cArray13 = "A\u0000mhga\u001bhkl\"\u001cikwn\u000b!fg\"\u001cqaak\thaf".toCharArray();
                n3 = 0;
                int n14 = cArray13.length;
                cArray2 = cArray13;
                n2 = n14;
                if (n14 <= 1) break block31;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block32;
            }
            do {
                char[] cArray14 = cArray2;
                char[] cArray15 = cArray2;
                int n15 = n3;
                while (true) {
                    int n16;
                    char c = cArray14[n15];
                    switch (n3 % 5) {
                        case 0: {
                            n16 = 2;
                            break;
                        }
                        case 1: {
                            n16 = 111;
                            break;
                        }
                        case 2: {
                            n16 = 1;
                            break;
                        }
                        case 3: {
                            n16 = 4;
                            break;
                        }
                        default: {
                            n16 = 2;
                        }
                    }
                    cArray14[n15] = (char)(c ^ n16);
                    ++n3;
                    cArray2 = cArray15;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray15 = cArray2;
                    n = n2;
                    n15 = n2;
                    cArray14 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[2] = new String(cArray).intern();
        A = stringArray;
    }
}

