/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.editors;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.tigris.subversion.subclipse.graph.Activator;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.editors.NodeTooltipFigure;

public class NodeFigure
extends RoundedRectangle {
    private Node node;
    private PolylineConnection source;
    private int sourceIndex;
    private boolean hasTags;
    private Color bgcolor;
    private boolean selected;

    public NodeFigure(Node node, Color bgcolor, Color fgcolor) {
        this.node = node;
        this.bgcolor = bgcolor;
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.setBackgroundColor(bgcolor);
        this.setForegroundColor(fgcolor);
        this.setOpaque(true);
        this.setToolTip((IFigure)new NodeTooltipFigure(node));
        this.setCursor(Cursors.HAND);
    }

    public PolylineConnection getSource() {
        return this.source;
    }

    public void setSource(PolylineConnection source, int sourceIndex) {
        this.source = source;
        this.sourceIndex = sourceIndex;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public Node getNode() {
        return this.node;
    }

    public void addTag(Node source) {
        NodeTooltipFigure tt = (NodeTooltipFigure)this.getToolTip();
        tt.addTag(source);
        this.hasTags = true;
        this.setForegroundColor(ColorConstants.black);
    }

    public void endLayout() {
        if (this.hasTags) {
            this.add((IFigure)NodeFigure.createLabel(String.valueOf(Long.toString(this.node.getRevision())) + "*", JFaceResources.getDefaultFont()), BorderLayout.CENTER);
        } else {
            this.add((IFigure)NodeFigure.createLabel(Long.toString(this.node.getRevision()), JFaceResources.getDefaultFont()), BorderLayout.CENTER);
        }
        NodeTooltipFigure tt = (NodeTooltipFigure)this.getToolTip();
        tt.endLayout();
    }

    public static Label createLabel(String text, Font font) {
        Label label = new Label(text);
        label.setFont(font);
        label.setForegroundColor(Activator.FONT_COLOR);
        return label;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.setBackgroundColor(ColorConstants.white);
        } else {
            this.setBackgroundColor(this.bgcolor);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }
}

