/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.popup.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.graph.cache.Cache;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.SVNAction;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;

public class DeleteCacheAction
extends SVNAction {
    private ISVNInfo info;
    private Exception error;

    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        final ISVNRemoteFolder[] selectedFolders = this.getSelectedRemoteFolders();
        this.error = null;
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                ISVNClientAdapter client = null;
                try {
                    try {
                        client = SVNProviderPlugin.getPlugin().getSVNClient();
                        DeleteCacheAction.this.info = client.getInfo(selectedFolders[0].getUrl());
                    }
                    catch (Exception e) {
                        DeleteCacheAction.this.error = e;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
            }
        });
        if (this.error != null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Policy.bind((String)"DeleteCacheAction.title"), (String)this.error.getMessage());
            return;
        }
        String uuid = this.info.getUuid();
        File f = Cache.getCacheDirectory(null);
        if (!(f = new File(f, uuid)).exists()) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Policy.bind((String)"DeleteCacheAction.title"), (String)Policy.bind((String)"DeleteCacheAction.noCache"));
            return;
        }
        Object[] url = new String[]{selectedFolders[0].getUrl().toString()};
        if (!MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Policy.bind((String)"DeleteCacheAction.title"), (String)Policy.bind((String)"DeleteCacheAction.confirm", (Object[])url))) {
            return;
        }
        File revisionsFile = new File(f, "revisions");
        if (!this.deleteFile(revisionsFile, true)) {
            return;
        }
        File logMessagesFile = new File(f, "logMessages");
        if (!this.deleteFile(logMessagesFile, true)) {
            return;
        }
        File revisionsTempFile = new File(f, "revisionsTemp");
        this.deleteFile(revisionsTempFile, false);
        File logMessagesTempFile = new File(f, "logMessagesTemp");
        this.deleteFile(logMessagesTempFile, false);
        this.deleteFile(f, true);
    }

    protected boolean isEnabled() throws TeamException {
        return true;
    }

    private boolean deleteFile(File f, boolean showErrorMessage) {
        if (!f.delete()) {
            if (showErrorMessage) {
                Object[] file = new String[]{f.getPath()};
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Policy.bind((String)"DeleteCacheAction.title"), (String)Policy.bind((String)"DeleteCacheAction.deleteError", (Object[])file));
            }
            return false;
        }
        return true;
    }
}

