/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.popup.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IEditorInput;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.graph.Activator;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditorInput;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.SVNAction;

public class RemoteResourceViewGraphAction
extends SVNAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                ISVNRemoteResource[] resources = RemoteResourceViewGraphAction.this.getSelectedRemoteResources();
                if (resources.length == 0) {
                    resources = RemoteResourceViewGraphAction.this.getSelectedRemoteFolders();
                }
                try {
                    if (resources.length > 0) {
                        RemoteResourceViewGraphAction.this.getTargetPage().openEditor((IEditorInput)new RevisionGraphEditorInput(resources[0]), "org.tigris.subversion.subclipse.graph.editors.revisionGraphEditor");
                    }
                }
                catch (Exception e) {
                    Activator.handleError(e);
                    Activator.showErrorDialog(RemoteResourceViewGraphAction.this.getErrorTitle(), e);
                }
            }
        }, false, 2);
    }

    protected String getErrorTitle() {
        return Policy.bind((String)"ViewGraphAction.viewGraph");
    }

    protected boolean isEnabled() throws TeamException {
        ISVNRemoteResource[] resources = this.getSelectedRemoteResources();
        if (resources.length == 1) {
            return true;
        }
        return resources.length == 0 && this.getSelectedRemoteFolders().length == 1;
    }
}

