/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.actions;

import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.MergeResultsFolder;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.views.MergeResultsView;
import com.collabnet.subversion.merge.wizards.DialogWizard;
import com.collabnet.subversion.merge.wizards.MergeWizardDialog;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNTreeConflict;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.ResolveAction;
import org.tigris.subversion.subclipse.ui.conflicts.ResolveTreeConflictWizard;
import org.tigris.subversion.subclipse.ui.wizards.SizePersistedWizardDialog;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;

public class MergeViewResolveAction
extends ResolveAction {
    private IStructuredSelection fSelection;
    private boolean showDialog = true;
    private int selectedResolution;
    private SVNTreeConflict treeConflict;
    private File mergePath;

    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        Iterator iter;
        boolean treeConflictDialogShown = false;
        boolean compare = false;
        this.mergePath = null;
        if (this.showDialog) {
            String message;
            IResource resource;
            ArrayList<Object> resources = new ArrayList<Object>();
            iter = this.fSelection.iterator();
            boolean folderSelected = false;
            boolean textConflicts = false;
            boolean propertyConflicts = false;
            boolean treeConflicts = false;
            while (iter.hasNext()) {
                MergeResult mergeResult = null;
                Object selectedObject = iter.next();
                if (selectedObject instanceof MergeResult) {
                    mergeResult = (MergeResult)selectedObject;
                }
                if (selectedObject instanceof MergeResultsFolder) {
                    folderSelected = true;
                    MergeResultsFolder mergeResultsFolder = (MergeResultsFolder)selectedObject;
                    resources.add(mergeResultsFolder.getFolder());
                    mergeResult = mergeResultsFolder.getMergeResult();
                }
                if (mergeResult == null || !mergeResult.hasTreeConflict() && !mergeResult.isConflicted() && !mergeResult.isPropertyConflicted()) continue;
                if (mergeResult.isConflicted()) {
                    textConflicts = true;
                }
                if (mergeResult.isPropertyConflicted()) {
                    propertyConflicts = true;
                }
                if (mergeResult.hasTreeConflict()) {
                    treeConflicts = true;
                }
                if (selectedObject instanceof MergeResultsFolder) continue;
                resources.add(mergeResult.getResource());
            }
            if (resources.size() > 1) {
                if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.MergeViewResolveAction_confirm, (String)Messages.MergeViewResolveAction_confirmMultiple)) {
                    return;
                }
                this.setResolution(6);
            } else if (treeConflicts) {
                resource = (IResource)resources.get(0);
                this.treeConflict = this.getTreeConflict(resource);
                if (this.treeConflict == null) {
                    message = String.valueOf(Messages.MergeViewResolveAction_confirmTreeConflict) + resource.getName() + "?";
                    if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.MergeViewResolveAction_confirm, (String)message)) {
                        return;
                    }
                    this.setResolution(6);
                } else {
                    ResolveTreeConflictWizard wizard = new ResolveTreeConflictWizard(this.treeConflict, this.getTargetPart());
                    SizePersistedWizardDialog dialog = new SizePersistedWizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard, "ResolveTreeConflict");
                    if (dialog.open() != 0) {
                        return;
                    }
                    treeConflictDialogShown = true;
                    compare = wizard.isCompare();
                    this.mergePath = wizard.getMergePath();
                }
            } else if (folderSelected) {
                resource = (IResource)resources.get(0);
                message = String.valueOf(Messages.MergeViewResolveAction_confirmProperty) + resource.getFullPath() + "?";
                if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.MergeViewResolveAction_confirm, (String)message)) {
                    return;
                }
                this.selectedResolution = 6;
                this.setResolution(this.selectedResolution);
            } else {
                IResource[] resourceArray = new IResource[resources.size()];
                resources.toArray(resourceArray);
                DialogWizard dialogResolveWizard = new DialogWizard(9);
                dialogResolveWizard.setResources(resourceArray);
                dialogResolveWizard.setTextConflicts(textConflicts);
                dialogResolveWizard.setPropertyConflicts(propertyConflicts);
                dialogResolveWizard.setTreeConflicts(treeConflicts);
                MergeWizardDialog resolveDialog = new MergeWizardDialog(Display.getDefault().getActiveShell(), (IWizard)dialogResolveWizard);
                if (resolveDialog.open() == 1) {
                    return;
                }
                this.selectedResolution = dialogResolveWizard.getResolution();
                this.setResolution(this.selectedResolution);
            }
        }
        if (!treeConflictDialogShown) {
            super.execute(action);
        }
        ArrayList<MergeOutput> mergeOutputs = new ArrayList<MergeOutput>();
        iter = this.fSelection.iterator();
        while (iter.hasNext()) {
            MergeResult mergeResult = null;
            Object selectedObject = iter.next();
            if (selectedObject instanceof MergeResult) {
                mergeResult = (MergeResult)selectedObject;
            }
            if (selectedObject instanceof MergeResultsFolder) {
                MergeResultsFolder mergeResultsFolder = (MergeResultsFolder)selectedObject;
                mergeResult = mergeResultsFolder.getMergeResult();
            }
            if (mergeResult == null || !mergeResult.hasTreeConflict() && !mergeResult.isConflicted() && !mergeResult.isPropertyConflicted()) continue;
            if (!compare) {
                String conflictResolution = Integer.toString(this.selectedResolution);
                mergeResult.setConflictResolution(conflictResolution);
                mergeResult.setPropertyResolution(conflictResolution);
                mergeResult.setTreeConflictResolution(conflictResolution);
                if (this.mergePath != null) {
                    MergeResult[] allResults;
                    MergeResult[] mergeResultArray = allResults = mergeResult.getMergeOutput().getMergeResults();
                    int n = allResults.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MergeResult checkResult = mergeResultArray[n2];
                        if (checkResult.getResource().getLocation().toFile().equals(this.mergePath)) {
                            try {
                                LocalResourceStatus status = SVNProviderPlugin.getPlugin().getStatusCacheManager().getStatus(checkResult.getResource());
                                if (!status.isTextConflicted()) break;
                                checkResult.setAction("C");
                                checkResult.setConflictResolution(" ");
                                checkResult.setError(true);
                            }
                            catch (SVNException sVNException) {}
                            break;
                        }
                        ++n2;
                    }
                }
            }
            if (mergeOutputs.contains(mergeResult.getMergeOutput())) continue;
            mergeOutputs.add(mergeResult.getMergeOutput());
        }
        for (MergeOutput mergeOutput : mergeOutputs) {
            mergeOutput.store();
        }
        MergeResultsView.getView().refresh();
        for (MergeOutput mergeOutput : mergeOutputs) {
            if (mergeOutput.hasUnresolvedConflicts()) continue;
            DialogWizard dialogWizard = new DialogWizard(2);
            dialogWizard.setMergeOutput(mergeOutput);
            MergeWizardDialog dialog = new MergeWizardDialog(Display.getDefault().getActiveShell(), (IWizard)dialogWizard, true);
            if (dialog.open() == 1) continue;
            MergeResultsView.getView().refresh();
        }
    }

    public void selectionChanged(IAction action, ISelection sel) {
        super.selectionChanged(action, sel);
        if (sel instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)sel;
        }
        try {
            action.setEnabled(this.isEnabled());
        }
        catch (Exception exception) {}
    }

    protected boolean isEnabled() throws TeamException {
        boolean enabled = super.isEnabled();
        if (enabled) {
            for (Object selectedObject : this.fSelection) {
                MergeResult mergeResult;
                if (!(selectedObject instanceof MergeResult) || !(mergeResult = (MergeResult)selectedObject).isResolved() || !mergeResult.isPropertyResolved() || !mergeResult.isTreeConflictResolved()) continue;
                enabled = false;
                break;
            }
        }
        return enabled;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    public void setShowDialog(boolean showDialog) {
        this.showDialog = showDialog;
    }

    private SVNTreeConflict getTreeConflict(final IResource resource) {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                ISVNClientAdapter client = null;
                try {
                    try {
                        client = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource).getRepository().getSVNClient();
                        ISVNStatus[] statuses = client.getStatus(resource.getLocation().toFile(), true, true, true);
                        int i = 0;
                        while (i < statuses.length) {
                            if (statuses[i].hasTreeConflict()) {
                                MergeViewResolveAction.this.treeConflict = new SVNTreeConflict(statuses[i]);
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        SVNUIPlugin.log((int)4, (String)e.getMessage(), (Throwable)e);
                        SVNWorkspaceRoot.getSVNResourceFor((IResource)resource).getRepository().returnSVNClient(client);
                    }
                }
                finally {
                    SVNWorkspaceRoot.getSVNResourceFor((IResource)resource).getRepository().returnSVNClient(client);
                }
            }
        });
        return this.treeConflict;
    }
}

