/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.wizards;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.IMergeInputProvider;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.wizards.MergeWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tigris.subversion.subclipse.ui.DepthComboHelper;

public class MergeWizardLastPage
extends WizardPage {
    private Button ignoreButton;
    private Button forceButton;
    private Label depthLabel;
    private Combo depthCombo;
    private Button textConflictPromptButton;
    private Button textConflictMarkButton;
    private Button propertyConflictPromptButton;
    private Button propertyConflictMarkButton;
    private Button binaryConflictPromptButton;
    private Button binaryConflictMarkButton;
    private Button binaryConflictUserButton;
    private Button binaryConflictIncomingButton;
    private Button treeConflictPromptButton;
    private Button treeConflictMarkButton;
    private Button treeConflictResolveButton;
    private IDialogSettings settings = Activator.getDefault().getDialogSettings();
    private static final String LAST_TEXT_CONFLICT_CHOICE = "MergeWizardMainPage.lastTextConflictChoice";
    private static final String LAST_PROPERTY_CONFLICT_CHOICE = "MergeWizardMainPage.lastPropertyConflictChoice";
    private static final String LAST_BINARY_CONFLICT_CHOICE = "MergeWizardMainPage.lastBinaryConflictChoice";
    private static final String LAST_TREE_CONFLICT_CHOICE = "MergeWizardMainPage.lastTreeConflictChoice";

    public MergeWizardLastPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(768));
        Group conflictGroup = new Group(outerContainer, 0);
        conflictGroup.setText(Messages.MergeWizardLastPage_conflictHandling);
        GridLayout conflictLayout = new GridLayout();
        conflictLayout.numColumns = 1;
        conflictGroup.setLayout((Layout)conflictLayout);
        conflictGroup.setLayoutData((Object)new GridData(768));
        Group textGroup = new Group((Composite)conflictGroup, 0);
        textGroup.setText(Messages.MergeWizardLastPage_textFiles);
        GridLayout textLayout = new GridLayout();
        textLayout.numColumns = 1;
        textGroup.setLayout((Layout)textLayout);
        textGroup.setLayoutData((Object)new GridData(768));
        this.textConflictPromptButton = new Button((Composite)textGroup, 16);
        this.textConflictPromptButton.setText(Messages.MergeWizardLastPage_prompt);
        this.textConflictMarkButton = new Button((Composite)textGroup, 16);
        this.textConflictMarkButton.setText(Messages.MergeWizardLastPage_mark);
        Group binaryGroup = new Group((Composite)conflictGroup, 0);
        binaryGroup.setText(Messages.MergeWizardLastPage_binaryFiles);
        GridLayout binaryLayout = new GridLayout();
        binaryLayout.numColumns = 1;
        binaryGroup.setLayout((Layout)binaryLayout);
        binaryGroup.setLayoutData((Object)new GridData(768));
        this.binaryConflictPromptButton = new Button((Composite)binaryGroup, 16);
        this.binaryConflictPromptButton.setText(Messages.MergeWizardLastPage_prompt2);
        this.binaryConflictMarkButton = new Button((Composite)binaryGroup, 16);
        this.binaryConflictMarkButton.setText(Messages.MergeWizardLastPage_mark2);
        this.binaryConflictUserButton = new Button((Composite)binaryGroup, 16);
        this.binaryConflictUserButton.setText(Messages.MergeWizardLastPage_useMine);
        this.binaryConflictIncomingButton = new Button((Composite)binaryGroup, 16);
        this.binaryConflictIncomingButton.setText(Messages.MergeWizardLastPage_useIncoming);
        Group propertyGroup = new Group((Composite)conflictGroup, 0);
        propertyGroup.setText(Messages.MergeWizardLastPage_propertyConflicts);
        GridLayout propertyLayout = new GridLayout();
        propertyLayout.numColumns = 1;
        propertyGroup.setLayout((Layout)propertyLayout);
        propertyGroup.setLayoutData((Object)new GridData(768));
        this.propertyConflictPromptButton = new Button((Composite)propertyGroup, 16);
        this.propertyConflictPromptButton.setText(Messages.MergeWizardLastPage_prompt3);
        this.propertyConflictMarkButton = new Button((Composite)propertyGroup, 16);
        this.propertyConflictMarkButton.setText(Messages.MergeWizardLastPage_mark3);
        Group treeConflictGroup = new Group((Composite)conflictGroup, 0);
        treeConflictGroup.setText(Messages.MergeWizardLastPage_0);
        GridLayout treeConflictLayout = new GridLayout();
        treeConflictLayout.numColumns = 1;
        treeConflictGroup.setLayout((Layout)treeConflictLayout);
        treeConflictGroup.setLayoutData((Object)new GridData(768));
        this.treeConflictPromptButton = new Button((Composite)treeConflictGroup, 16);
        this.treeConflictPromptButton.setText(Messages.MergeWizardLastPage_1);
        this.treeConflictMarkButton = new Button((Composite)treeConflictGroup, 16);
        this.treeConflictMarkButton.setText(Messages.MergeWizardLastPage_2);
        this.treeConflictResolveButton = new Button((Composite)treeConflictGroup, 16);
        this.treeConflictResolveButton.setText(Messages.MergeWizardLastPage_3);
        Group optionsGroup = new Group(outerContainer, 0);
        optionsGroup.setText(Messages.MergeWizardLastPage_mergeOptions);
        GridLayout optionsLayout = new GridLayout();
        optionsLayout.numColumns = 2;
        optionsGroup.setLayout((Layout)optionsLayout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.ignoreButton = new Button((Composite)optionsGroup, 32);
        this.ignoreButton.setText(Messages.MergeWizardLastPage_ignoreAncestry);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.ignoreButton.setLayoutData((Object)data);
        this.forceButton = new Button((Composite)optionsGroup, 32);
        this.forceButton.setText(Messages.MergeWizardLastPage_allUnversionedObstructions);
        data = new GridData();
        data.horizontalSpan = 2;
        this.forceButton.setLayoutData((Object)data);
        this.depthLabel = new Label((Composite)optionsGroup, 0);
        this.depthLabel.setText(Messages.MergeWizardLastPage_depth);
        this.depthCombo = new Combo((Composite)optionsGroup, 8);
        DepthComboHelper.addDepths((Combo)this.depthCombo, (boolean)true, (String)"Working copy");
        SelectionAdapter conflictSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MergeWizardLastPage.this.textConflictMarkButton.getSelection()) {
                    MergeWizardLastPage.this.settings.put(MergeWizardLastPage.LAST_TEXT_CONFLICT_CHOICE, 0);
                } else {
                    MergeWizardLastPage.this.settings.put(MergeWizardLastPage.LAST_TEXT_CONFLICT_CHOICE, 6);
                }
                if (MergeWizardLastPage.this.propertyConflictMarkButton.getSelection()) {
                    MergeWizardLastPage.this.settings.put(MergeWizardLastPage.LAST_PROPERTY_CONFLICT_CHOICE, 0);
                } else {
                    MergeWizardLastPage.this.settings.put(MergeWizardLastPage.LAST_PROPERTY_CONFLICT_CHOICE, 6);
                }
                if (MergeWizardLastPage.this.binaryConflictIncomingButton.getSelection()) {
                    MergeWizardLastPage.this.settings.put(MergeWizardLastPage.LAST_BINARY_CONFLICT_CHOICE, 2);
                } else if (MergeWizardLastPage.this.binaryConflictUserButton.getSelection()) {
                    MergeWizardLastPage.this.settings.put(MergeWizardLastPage.LAST_BINARY_CONFLICT_CHOICE, 3);
                } else if (MergeWizardLastPage.this.binaryConflictMarkButton.getSelection()) {
                    MergeWizardLastPage.this.settings.put(MergeWizardLastPage.LAST_BINARY_CONFLICT_CHOICE, 0);
                } else {
                    MergeWizardLastPage.this.settings.put(MergeWizardLastPage.LAST_BINARY_CONFLICT_CHOICE, 6);
                }
                if (MergeWizardLastPage.this.treeConflictPromptButton.getSelection()) {
                    MergeWizardLastPage.this.settings.put(MergeWizardLastPage.LAST_TREE_CONFLICT_CHOICE, -1);
                } else if (MergeWizardLastPage.this.treeConflictResolveButton.getSelection()) {
                    MergeWizardLastPage.this.settings.put(MergeWizardLastPage.LAST_TREE_CONFLICT_CHOICE, 6);
                } else {
                    MergeWizardLastPage.this.settings.put(MergeWizardLastPage.LAST_TREE_CONFLICT_CHOICE, 0);
                }
            }
        };
        this.textConflictMarkButton.addSelectionListener((SelectionListener)conflictSelectionListener);
        this.textConflictPromptButton.addSelectionListener((SelectionListener)conflictSelectionListener);
        this.propertyConflictMarkButton.addSelectionListener((SelectionListener)conflictSelectionListener);
        this.propertyConflictPromptButton.addSelectionListener((SelectionListener)conflictSelectionListener);
        this.binaryConflictIncomingButton.addSelectionListener((SelectionListener)conflictSelectionListener);
        this.binaryConflictUserButton.addSelectionListener((SelectionListener)conflictSelectionListener);
        this.binaryConflictMarkButton.addSelectionListener((SelectionListener)conflictSelectionListener);
        this.binaryConflictPromptButton.addSelectionListener((SelectionListener)conflictSelectionListener);
        this.treeConflictMarkButton.addSelectionListener((SelectionListener)conflictSelectionListener);
        this.treeConflictPromptButton.addSelectionListener((SelectionListener)conflictSelectionListener);
        this.treeConflictResolveButton.addSelectionListener((SelectionListener)conflictSelectionListener);
        this.initializeSelections();
        this.setPageComplete(true);
        this.setMessage(Messages.MergeWizardLastPage_message);
        this.setControl((Control)outerContainer);
    }

    public boolean isIgnore() {
        return this.ignoreButton.getSelection();
    }

    public boolean isForce() {
        return this.forceButton.getSelection();
    }

    public int getDepth() {
        return DepthComboHelper.getDepth((Combo)this.depthCombo);
    }

    private void initializeSelections() {
        int lastTextConflictChoice = 6;
        try {
            lastTextConflictChoice = this.settings.getInt(LAST_TEXT_CONFLICT_CHOICE);
        }
        catch (Exception exception) {}
        switch (lastTextConflictChoice) {
            case 6: {
                this.textConflictPromptButton.setSelection(true);
                break;
            }
            case 0: {
                this.textConflictMarkButton.setSelection(true);
                break;
            }
            default: {
                this.textConflictPromptButton.setSelection(true);
            }
        }
        int lastPropertyConflictChoice = lastTextConflictChoice;
        try {
            lastPropertyConflictChoice = this.settings.getInt(LAST_PROPERTY_CONFLICT_CHOICE);
        }
        catch (Exception exception) {}
        switch (lastPropertyConflictChoice) {
            case 6: {
                this.propertyConflictPromptButton.setSelection(true);
                break;
            }
            case 0: {
                this.propertyConflictMarkButton.setSelection(true);
                break;
            }
            default: {
                this.propertyConflictPromptButton.setSelection(true);
            }
        }
        int lastBinaryConflictChoice = 6;
        try {
            lastBinaryConflictChoice = this.settings.getInt(LAST_BINARY_CONFLICT_CHOICE);
        }
        catch (Exception exception) {}
        switch (lastBinaryConflictChoice) {
            case 6: {
                this.binaryConflictPromptButton.setSelection(true);
                break;
            }
            case 0: {
                this.binaryConflictMarkButton.setSelection(true);
                break;
            }
            case 3: {
                this.binaryConflictUserButton.setSelection(true);
                break;
            }
            case 2: {
                this.binaryConflictIncomingButton.setSelection(true);
                break;
            }
            default: {
                this.binaryConflictPromptButton.setSelection(true);
            }
        }
        int lastTreeConflictChoice = 0;
        try {
            lastTreeConflictChoice = this.settings.getInt(LAST_TREE_CONFLICT_CHOICE);
        }
        catch (Exception exception) {}
        switch (lastTreeConflictChoice) {
            case -1: {
                this.treeConflictPromptButton.setSelection(true);
                break;
            }
            case 6: {
                this.treeConflictResolveButton.setSelection(true);
                break;
            }
            default: {
                this.treeConflictMarkButton.setSelection(true);
            }
        }
    }

    public int getTextConflictHandling() {
        if (this.textConflictMarkButton.getSelection()) {
            return 0;
        }
        return 6;
    }

    public int getBinaryConflictHandling() {
        if (this.binaryConflictIncomingButton.getSelection()) {
            return 2;
        }
        if (this.binaryConflictUserButton.getSelection()) {
            return 3;
        }
        if (this.binaryConflictMarkButton.getSelection()) {
            return 0;
        }
        return 6;
    }

    public int getPropertyConflictHandling() {
        if (this.propertyConflictMarkButton.getSelection()) {
            return 0;
        }
        return 6;
    }

    public int getTreeConflictHandling() {
        if (this.treeConflictMarkButton.getSelection()) {
            return 0;
        }
        if (this.treeConflictResolveButton.getSelection()) {
            return 6;
        }
        return -1;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IMergeInputProvider selectedMergeInputProvider = ((MergeWizard)this.getWizard()).getSelectedMergeInputProvider();
            this.ignoreButton.setEnabled(!selectedMergeInputProvider.hideIgnoreAncestry());
            this.forceButton.setEnabled(!selectedMergeInputProvider.hideForce());
            this.depthLabel.setEnabled(!selectedMergeInputProvider.hideDepth());
            this.depthCombo.setEnabled(!selectedMergeInputProvider.hideDepth());
        }
    }
}

