/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.tigris.subversion.subclipse.core.ISVNLocalFile;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;

public class LocalResourceAdapterFactory
implements IAdapterFactory {
    private static Class[] SUPPORTED_TYPES = new Class[]{ISVNLocalResource.class, ISVNLocalFile.class, ISVNLocalFolder.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!(adaptableObject instanceof IResource)) {
            adaptableObject = ((IAdaptable)adaptableObject).getAdapter(IResource.class);
        }
        if (adaptableObject instanceof IResource) {
            IResource resource = (IResource)adaptableObject;
            if (ISVNLocalResource.class.equals((Object)adapterType)) {
                return SVNWorkspaceRoot.getSVNResourceFor(resource);
            }
            if (ISVNLocalFile.class.equals((Object)adapterType) && adaptableObject instanceof IFile) {
                IFile file = (IFile)resource;
                return SVNWorkspaceRoot.getSVNFileFor(file);
            }
            if (ISVNLocalFolder.class.equals((Object)adapterType) && adaptableObject instanceof IContainer) {
                IContainer container = (IContainer)resource;
                return SVNWorkspaceRoot.getSVNFolderFor(container);
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return SUPPORTED_TYPES;
    }
}

