/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.AddResourcesCommand;
import org.tigris.subversion.subclipse.core.commands.GetRemoteResourceCommand;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.compare.MultipleSelectionNode;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalResourceNode;
import org.tigris.subversion.subclipse.ui.compare.StatusAwareDifferencer;
import org.tigris.subversion.subclipse.ui.internal.Utils;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNLocalBaseCompareInput
extends CompareEditorInput
implements ISaveableWorkbenchPart {
    private Object fRoot;
    private final SVNRevision remoteRevision;
    private boolean readOnly;
    private SVNLocalResourceNode[] localResourceNodes;
    private ResourceEditionNode[] remoteResourceNodes;
    private List<IResource> unaddedResources;

    public SVNLocalBaseCompareInput(ISVNLocalResource[] resources, SVNRevision revision, boolean readOnly) throws SVNException, SVNClientException {
        super(new CompareConfiguration());
        this.remoteRevision = revision;
        this.readOnly = readOnly;
        this.localResourceNodes = new SVNLocalResourceNode[resources.length];
        this.remoteResourceNodes = new ResourceEditionNode[resources.length];
        this.unaddedResources = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            this.localResourceNodes[i] = new SVNLocalResourceNode(resources[i]);
            ISVNRemoteResource remoteResource = null;
            LocalResourceStatus status = resources[i].getStatus();
            if (status != null && (!status.isManaged() || status.isCopied())) {
                if (!status.isManaged()) {
                    this.unaddedResources.add(resources[i].getResource());
                } else {
                    ISVNClientAdapter svnClient = null;
                    try {
                        svnClient = resources[i].getRepository().getSVNClient();
                        ISVNInfo info = svnClient.getInfoFromWorkingCopy(resources[i].getFile());
                        SVNUrl copiedFromUrl = info.getCopyUrl();
                        if (copiedFromUrl != null) {
                            GetRemoteResourceCommand getRemoteResourceCommand = new GetRemoteResourceCommand(resources[i].getRepository(), copiedFromUrl, SVNRevision.HEAD);
                            getRemoteResourceCommand.run(null);
                            remoteResource = getRemoteResourceCommand.getRemoteResource();
                        }
                    }
                    finally {
                        resources[i].getRepository().returnSVNClient(svnClient);
                    }
                }
            }
            if (remoteResource == null) {
                remoteResource = resources[i].getRemoteResource(revision);
            }
            this.remoteResourceNodes[i] = new ResourceEditionNode(remoteResource);
            this.remoteResourceNodes[i].setLocalResource(this.localResourceNodes[i]);
            this.localResourceNodes[i].setRemoteResource(this.remoteResourceNodes[i]);
            ++i;
        }
        if (this.unaddedResources.size() > 0) {
            SVNWorkspaceRoot workspaceRoot = new SVNWorkspaceRoot((IContainer)this.unaddedResources.get(0).getProject());
            IResource[] unadded = new IResource[this.unaddedResources.size()];
            this.unaddedResources.toArray(unadded);
            AddResourcesCommand addResourcesCommand = new AddResourcesCommand(workspaceRoot, unadded, 2);
            addResourcesCommand.run(null);
        }
    }

    public SVNLocalBaseCompareInput(ISVNLocalResource[] resources, SVNRevision revision) throws SVNException, SVNClientException {
        this(resources, revision, false);
    }

    private void initLabels() {
        String rightLabel;
        String leftLabel;
        String title;
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftEditable(!this.readOnly);
        cc.setRightEditable(false);
        if (this.localResourceNodes.length > 1) {
            title = String.valueOf(Policy.bind("SVNLocalBaseCompareInput.0")) + this.remoteRevision;
            leftLabel = Policy.bind("SVNLocalBaseCompareInput.1");
            rightLabel = this.remoteRevision.toString();
        } else {
            title = Policy.bind("SVNCompareRevisionsInput.compareResourceAndVersions", new Object[]{this.localResourceNodes[0].getName()});
            leftLabel = Policy.bind("SVNCompareRevisionsInput.workspace", new Object[]{this.localResourceNodes[0].getName()});
            rightLabel = Policy.bind("SVNCompareRevisionsInput.repository", new Object[]{this.localResourceNodes[0].getName()});
        }
        this.setTitle(title);
        cc.setLeftLabel(leftLabel);
        cc.setRightLabel(rightLabel);
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.initLabels();
        MultipleSelectionNode left = new MultipleSelectionNode((Object[])this.localResourceNodes);
        MultipleSelectionNode right = new MultipleSelectionNode(this.remoteResourceNodes);
        Object differences = new StatusAwareDifferencer().findDifferences(false, monitor, null, null, left, right);
        if (differences instanceof DiffNode) {
            IDiffElement[] children;
            DiffNode diffNode = (DiffNode)differences;
            IDiffElement[] iDiffElementArray = children = diffNode.getChildren();
            int n = 0;
            int n2 = iDiffElementArray.length;
            while (n < n2) {
                DiffNode childDiffNode;
                IDiffElement child = iDiffElementArray[n];
                if (child instanceof DiffNode && (childDiffNode = (DiffNode)child).getLeft() == null && childDiffNode.getRight() instanceof ResourceEditionNode) {
                    diffNode.remove(child);
                }
                ++n;
            }
            if (!diffNode.hasChildren()) {
                return null;
            }
        }
        for (IResource unaddedResource : this.unaddedResources) {
            try {
                SVNWorkspaceRoot.getSVNResourceFor((IResource)unaddedResource).revert();
            }
            catch (Exception exception) {}
        }
        this.fRoot = differences;
        return differences;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveChanges(monitor);
        }
        catch (CoreException e) {
            Utils.handle(e);
        }
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.fRoot instanceof DiffNode) {
            try {
                SVNLocalBaseCompareInput.commit(pm, (DiffNode)this.fRoot);
            }
            finally {
                this.setDirty(false);
            }
        }
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        IDiffElement[] children;
        ITypedElement right;
        ITypedElement left = node.getLeft();
        if (left instanceof BufferedResourceNode) {
            ((BufferedResourceNode)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)right).commit(pm);
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                IDiffElement element = children[i];
                if (element instanceof DiffNode) {
                    SVNLocalBaseCompareInput.commit(pm, (DiffNode)element);
                }
                ++i;
            }
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        this.createContents(parent);
    }

    public void dispose() {
    }

    public IWorkbenchPartSite getSite() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
    }
}

