/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.ResolveResourcesCommand;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.RepositoryProviderOperation;

public class ResolveOperation
extends RepositoryProviderOperation {
    private int resolution;

    public ResolveOperation(IWorkbenchPart part, IResource[] resources, int resolution) {
        super(part, resources);
        this.resolution = resolution;
    }

    protected String getTaskName() {
        return Policy.bind("ResolveOperation.taskName");
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("ResolveOperation.0", provider.getProject().getName());
    }

    protected void execute(SVNTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws SVNException, InterruptedException {
        block6: {
            monitor.beginTask(null, 100);
            try {
                try {
                    ResolveResourcesCommand command = new ResolveResourcesCommand(provider.getSVNWorkspaceRoot(), resources, this.resolution);
                    command.run(Policy.subMonitorFor(monitor, 100));
                }
                catch (SVNException e) {
                    if (e.operationInterrupted()) {
                        this.showCancelledMessage();
                        break block6;
                    }
                    this.collectStatus(e.getStatus());
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

