/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.repository;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.repo.ISVNListener;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.authentication.KeyFilesManager;
import org.tigris.subversion.subclipse.ui.comments.CommentsManager;
import org.tigris.subversion.subclipse.ui.comments.ReleaseCommentDialog;
import org.tigris.subversion.subclipse.ui.dialogs.AddToVersionControlDialog;
import org.tigris.subversion.subclipse.ui.repository.IRepositoryListener;

public class RepositoryManager {
    List listeners = new ArrayList();
    private CommentsManager commentsManager = new CommentsManager();
    private KeyFilesManager keyFilesManager = new KeyFilesManager();

    public ISVNRepositoryLocation[] getKnownRepositoryLocations(IProgressMonitor monitor) {
        return SVNProviderPlugin.getPlugin().getRepositories().getKnownRepositories(monitor);
    }

    public void rootAdded(ISVNRepositoryLocation root) {
        for (IRepositoryListener listener : this.listeners) {
            listener.repositoryAdded(root);
        }
    }

    public void rootModified(ISVNRepositoryLocation root) {
        for (IRepositoryListener listener : this.listeners) {
            listener.repositoryModified(root);
        }
    }

    public void rootRemoved(ISVNRepositoryLocation root) {
        for (IRepositoryListener listener : this.listeners) {
            listener.repositoryRemoved(root);
        }
    }

    public void resourceDeleted(ISVNRemoteResource resource) {
        for (IRepositoryListener listener : this.listeners) {
            listener.remoteResourceDeleted(resource);
        }
    }

    public void resourceCreated(ISVNRemoteFolder parent, String resourceName) {
        for (IRepositoryListener listener : this.listeners) {
            listener.remoteResourceCreated(parent, resourceName);
        }
    }

    public void resourceCopied(ISVNRemoteResource source, ISVNRemoteFolder destination) {
        for (IRepositoryListener listener : this.listeners) {
            listener.remoteResourceCopied(source, destination);
        }
    }

    public void resourceMoved(ISVNRemoteResource resource, ISVNRemoteFolder destinationFolder, String destinationResourceName) {
        for (IRepositoryListener listener : this.listeners) {
            listener.remoteResourceMoved(resource, destinationFolder, destinationResourceName);
        }
    }

    public void startup() {
        this.commentsManager.loadCommentHistory();
        this.commentsManager.loadCommentTemplates();
        this.keyFilesManager.loadKeyFileHistory();
        SVNProviderPlugin.getPlugin().getRepositoryResourcesManager().addRepositoryListener(new ISVNListener(){

            public void repositoryAdded(ISVNRepositoryLocation root) {
                RepositoryManager.this.rootAdded(root);
            }

            public void repositoryRemoved(ISVNRepositoryLocation root) {
                RepositoryManager.this.rootRemoved(root);
            }

            public void remoteResourceDeleted(ISVNRemoteResource resource) {
                RepositoryManager.this.resourceDeleted(resource);
            }

            public void remoteResourceCreated(ISVNRemoteFolder parent, String resourceName) {
                RepositoryManager.this.resourceCreated(parent, resourceName);
            }

            public void remoteResourceCopied(ISVNRemoteResource source, ISVNRemoteFolder destination) {
                RepositoryManager.this.resourceCopied(source, destination);
            }

            public void remoteResourceMoved(ISVNRemoteResource resource, ISVNRemoteFolder destinationFolder, String destinationResourceName) {
                RepositoryManager.this.resourceMoved(resource, destinationFolder, destinationResourceName);
            }

            public void repositoryModified(ISVNRepositoryLocation root) {
                RepositoryManager.this.rootModified(root);
            }
        });
    }

    public void shutdown() throws TeamException {
        this.commentsManager.saveCommentHistory();
        this.commentsManager.saveCommentTemplates();
        this.keyFilesManager.saveKeyFilesHistory();
    }

    public void addRepositoryListener(IRepositoryListener listener) {
        this.listeners.add(listener);
    }

    public void removeRepositoryListener(IRepositoryListener listener) {
        this.listeners.remove(listener);
    }

    public void add(IResource[] resources, IProgressMonitor monitor) throws TeamException {
        Map table;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((table = this.getProviderMapping(resources)).get(null) != null) {
            throw new SVNException(Policy.bind("RepositoryManager.addErrorNotAssociated"));
        }
        Set keySet = table.keySet();
        monitor.beginTask("", keySet.size() * 1000);
        monitor.setTaskName(Policy.bind("RepositoryManager.adding"));
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
            SVNTeamProvider provider = (SVNTeamProvider)iterator.next();
            List list = (List)table.get(provider);
            IResource[] providerResources = list.toArray(new IResource[list.size()]);
            provider.add(providerResources, 0, (IProgressMonitor)subMonitor);
        }
    }

    public CommentsManager getCommentsManager() {
        return this.commentsManager;
    }

    public KeyFilesManager getKeyFilesManager() {
        return this.keyFilesManager;
    }

    public String promptForComment(Shell shell, IResource[] resourcesToCommit) {
        final int[] result = new int[1];
        final ReleaseCommentDialog dialog = new ReleaseCommentDialog(shell, resourcesToCommit);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = dialog.open();
                if (result[0] != 0) {
                    return;
                }
            }
        });
        if (result[0] != 0) {
            return null;
        }
        return dialog.getComment();
    }

    public IResource[] promptForResourcesToBeAdded(Shell shell, IResource[] unadded) {
        if (unadded == null) {
            return new IResource[0];
        }
        if (unadded.length == 0) {
            return unadded;
        }
        final IResource[][] result = new IResource[1][0];
        result[0] = null;
        final AddToVersionControlDialog dialog = new AddToVersionControlDialog(shell, unadded);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                int code = dialog.open();
                if (code == 2) {
                    result[0] = dialog.getResourcesToAdd();
                } else if (code == 3) {
                    result[0] = new IResource[0];
                }
            }
        });
        return result[0];
    }

    public void commit(IResource[] resources, String comment, boolean keepLocks, IProgressMonitor monitor) throws TeamException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        Map table = this.getProviderMapping(resources);
        Set keySet = table.keySet();
        monitor.beginTask("", keySet.size() * 1000);
        monitor.setTaskName(Policy.bind("RepositoryManager.committing"));
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
            SVNTeamProvider provider = (SVNTeamProvider)iterator.next();
            List list = (List)table.get(provider);
            IResource[] providerResources = list.toArray(new IResource[list.size()]);
            provider.checkin(providerResources, comment, keepLocks, 2, (IProgressMonitor)subMonitor);
        }
    }

    private Map getProviderMapping(IResource[] resources) {
        HashMap<RepositoryProvider, ArrayList<IResource>> result = new HashMap<RepositoryProvider, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resources[i].getProject(), (String)SVNProviderPlugin.getTypeId());
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    public void run(IRunnableWithProgress runnable, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        runnable.run(monitor);
    }
}

