/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeLabelProvider;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.ResourceWithStatusUtil;
import org.tigris.subversion.subclipse.ui.util.ResourceSelectionTreeDecorator;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class ResourceSelectionTree
extends Composite {
    private Tree tree;
    private int mode;
    private IResource[] resources;
    private ArrayList resourceList;
    private Set unversionedResourceList;
    private IContainer[] compressedFolders;
    private IContainer[] folders;
    private ArrayList folderList;
    private IContainer[] rootFolders;
    private ArrayList compressedFolderList;
    private TreeViewer treeViewer;
    private LabelProvider labelProvider;
    private String label;
    private Action treeAction;
    private Action flatAction;
    private Action compressedAction;
    private IDialogSettings settings;
    private HashMap statusMap;
    private ResourceComparator comparator = new ResourceComparator();
    private boolean checkbox;
    private IToolbarControlCreator toolbarControlCreator;
    private IRemoveFromViewValidator removeFromViewValidator;
    private SyncInfoSet syncInfoSet;
    private boolean showRemoveFromViewAction = true;
    private ResourceSelectionTreeDecorator resourceSelectionTreeDecorator = new ResourceSelectionTreeDecorator();
    private boolean resourceRemoved = false;
    private boolean includeUnversioned = true;
    private ResourceSelectionContentProvider resourceSelectionContentProvider = new ResourceSelectionContentProvider();
    private Action[] customOptions;
    public static final String MODE_SETTING = "ResourceSelectionTree.mode";
    public static final int MODE_COMPRESSED_FOLDERS = 0;
    public static final int MODE_FLAT = 1;
    public static final int MODE_TREE = 2;
    private static final int SPACEBAR = 32;

    public ResourceSelectionTree(Composite parent, int style, String label, IResource[] resources, HashMap statusMap, LabelProvider labelProvider, boolean checkbox, IToolbarControlCreator toolbarControlCreator, SyncInfoSet syncInfoSet) {
        super(parent, style);
        this.label = label;
        this.resources = resources;
        this.statusMap = statusMap;
        this.labelProvider = labelProvider;
        this.checkbox = checkbox;
        this.toolbarControlCreator = toolbarControlCreator;
        this.syncInfoSet = syncInfoSet;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
        if (resources != null) {
            IResource resource;
            Arrays.sort(resources, this.comparator);
            this.resourceList = new ArrayList();
            int i = 0;
            while (i < resources.length) {
                resource = resources[i];
                this.resourceList.add(resource);
                ++i;
            }
            this.unversionedResourceList = new HashSet();
            try {
                i = 0;
                while (i < resources.length) {
                    resource = resources[i];
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                    if (resource.exists() && !svnResource.getStatus().isManaged()) {
                        this.unversionedResourceList.add(resource);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                SVNUIPlugin.openError(this.getShell(), null, null, e);
            }
        }
        this.createControls();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public IResource[] getSelectedResources() {
        if (!this.checkbox) {
            return this.resources;
        }
        ArrayList<Object> selected = new ArrayList<Object>();
        Object[] checkedResources = ((CheckboxTreeViewer)this.treeViewer).getCheckedElements();
        int i = 0;
        while (i < checkedResources.length) {
            if (this.resourceList.contains(checkedResources[i])) {
                selected.add(checkedResources[i]);
            }
            ++i;
        }
        IResource[] selectedResources = new IResource[selected.size()];
        selected.toArray(selectedResources);
        return selectedResources;
    }

    public void setCustomOptions(Action[] customOptions) {
        this.customOptions = customOptions;
    }

    private void createControls() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(1808));
        ViewForm viewerPane = new ViewForm((Composite)this, 0x800800);
        viewerPane.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        CLabel toolbarLabel = new CLabel((Composite)viewerPane, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return super.computeSize(wHint, Math.max(24, hHint), changed);
            }
        };
        if (this.label != null) {
            toolbarLabel.setText(this.label);
        }
        viewerPane.setTopLeft((Control)toolbarLabel);
        int buttonGroupColumns = 1;
        if (this.toolbarControlCreator != null) {
            buttonGroupColumns += this.toolbarControlCreator.getControlCount();
        }
        ToolBar toolbar = new ToolBar((Composite)viewerPane, 0x800000);
        viewerPane.setTopCenter((Control)toolbar);
        ToolBarManager toolbarManager = new ToolBarManager(toolbar);
        if (this.toolbarControlCreator != null) {
            this.toolbarControlCreator.createToolbarControls(toolbarManager);
            toolbarManager.add((IContributionItem)new Separator());
        }
        this.flatAction = new Action(Policy.bind("ResourceSelectionTree.flat"), 8){

            public void run() {
                ResourceSelectionTree.this.mode = 1;
                ResourceSelectionTree.this.settings.put(ResourceSelectionTree.MODE_SETTING, 1);
                ResourceSelectionTree.this.treeAction.setChecked(false);
                ResourceSelectionTree.this.compressedAction.setChecked(false);
                ResourceSelectionTree.this.refresh();
            }
        };
        this.flatAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("elcl16/flatLayout.gif"));
        toolbarManager.add((IAction)this.flatAction);
        this.treeAction = new Action(Policy.bind("ResourceSelectionTree.tree"), 8){

            public void run() {
                ResourceSelectionTree.this.mode = 2;
                ResourceSelectionTree.this.settings.put(ResourceSelectionTree.MODE_SETTING, 2);
                ResourceSelectionTree.this.flatAction.setChecked(false);
                ResourceSelectionTree.this.compressedAction.setChecked(false);
                ResourceSelectionTree.this.refresh();
            }
        };
        this.treeAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("elcl16/treeLayout.gif"));
        toolbarManager.add((IAction)this.treeAction);
        this.compressedAction = new Action(Policy.bind("ResourceSelectionTree.compressedFolders"), 8){

            public void run() {
                ResourceSelectionTree.this.mode = 0;
                ResourceSelectionTree.this.settings.put(ResourceSelectionTree.MODE_SETTING, 0);
                ResourceSelectionTree.this.treeAction.setChecked(false);
                ResourceSelectionTree.this.flatAction.setChecked(false);
                ResourceSelectionTree.this.refresh();
            }
        };
        this.compressedAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("elcl16/compressedLayout.gif"));
        toolbarManager.add((IAction)this.compressedAction);
        toolbarManager.update(true);
        this.mode = 0;
        try {
            this.mode = this.settings.getInt(MODE_SETTING);
        }
        catch (Exception exception) {}
        switch (this.mode) {
            case 0: {
                this.compressedAction.setChecked(true);
                break;
            }
            case 1: {
                this.flatAction.setChecked(true);
                break;
            }
            case 2: {
                this.treeAction.setChecked(true);
                break;
            }
        }
        if (this.checkbox) {
            this.treeViewer = new CheckboxTreeViewer((Composite)viewerPane, 2);
            this.treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 32) {
                        Tree tree = (Tree)ResourceSelectionTree.this.treeViewer.getControl();
                        TreeItem[] items = tree.getSelection();
                        int i = 0;
                        while (i < items.length) {
                            if (i > 0) {
                                items[i].setChecked(!items[i].getChecked());
                            }
                            ++i;
                        }
                    }
                }
            });
        } else {
            this.treeViewer = new TreeViewer((Composite)viewerPane, 2);
        }
        this.tree = this.treeViewer.getTree();
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true));
        viewerPane.setContent((Control)this.tree);
        if (this.labelProvider == null) {
            this.labelProvider = new ResourceSelectionLabelProvider();
        }
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)this.resourceSelectionContentProvider);
        this.treeViewer.setUseHashlookup(true);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 125;
        this.treeViewer.getControl().setLayoutData((Object)gd);
        this.treeViewer.setInput((Object)this);
        this.treeViewer.expandAll();
        if (this.checkbox) {
            this.setAllChecked(true);
            ((CheckboxTreeViewer)this.treeViewer).addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    ResourceSelectionTree.this.handleCheckStateChange(event);
                }
            });
        }
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                ResourceSelectionTree.this.fillTreeMenu(menuMgr);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.treeViewer.getTree().setMenu(menu);
    }

    void setAllChecked(boolean state) {
        ((CheckboxTreeViewer)this.treeViewer).setAllChecked(state);
    }

    protected void fillTreeMenu(IMenuManager menuMgr) {
        if (this.checkbox) {
            Action selectAllAction = new Action(Policy.bind("ResourceSelectionTree.SelectAll")){

                public void run() {
                    ResourceSelectionTree.this.setAllChecked(true);
                }
            };
            menuMgr.add((IAction)selectAllAction);
            Action deselectAllAction = new Action(Policy.bind("ResourceSelectionTree.DeselectAll")){

                public void run() {
                    ResourceSelectionTree.this.setAllChecked(false);
                }
            };
            menuMgr.add((IAction)deselectAllAction);
            if (this.showIncludeUnversionedButton() && this.includeUnversioned) {
                menuMgr.add((IContributionItem)new Separator());
                Action selectUnversionedAction = new Action(Policy.bind("ResourceSelectionTree.SelectUnversioned")){

                    public void run() {
                        ResourceSelectionTree.this.checkUnversioned(ResourceSelectionTree.this.tree.getItems(), true);
                    }
                };
                menuMgr.add((IAction)selectUnversionedAction);
                Action deselectUnversionedAction = new Action(Policy.bind("ResourceSelectionTree.DeselectUnversioned")){

                    public void run() {
                        ResourceSelectionTree.this.checkUnversioned(ResourceSelectionTree.this.tree.getItems(), false);
                    }
                };
                menuMgr.add((IAction)deselectUnversionedAction);
            }
        }
        menuMgr.add((IContributionItem)new Separator());
        if (this.mode != 1) {
            Action expandAllAction = new Action(Policy.bind("SyncAction.expandAll")){

                public void run() {
                    ResourceSelectionTree.this.treeViewer.expandAll();
                }
            };
            menuMgr.add((IAction)expandAllAction);
        }
        if (this.showRemoveFromViewAction && !this.checkbox && !this.treeViewer.getSelection().isEmpty()) {
            Action removeAction = new Action(Policy.bind("ResourceSelectionTree.remove")){

                public void run() {
                    ResourceSelectionTree.this.removeFromView();
                }
            };
            menuMgr.add((IAction)removeAction);
        }
        if (this.customOptions != null) {
            menuMgr.add((IContributionItem)new Separator());
            int i = 0;
            while (i < this.customOptions.length) {
                menuMgr.add((IAction)this.customOptions[i]);
                ++i;
            }
        }
    }

    private void removeFromView() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (this.removeFromViewValidator != null && !this.removeFromViewValidator.canRemove(this.resourceList, selection)) {
            if (this.removeFromViewValidator.getErrorMessage() != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("ResourceSelectionTree.remove"), (String)this.removeFromViewValidator.getErrorMessage());
            }
            return;
        }
        for (IResource resource : selection) {
            this.remove(resource);
            this.resourceRemoved = true;
        }
        this.resources = new IResource[this.resourceList.size()];
        this.resourceList.toArray(this.resources);
        this.compressedFolders = null;
        this.rootFolders = null;
        this.folders = null;
        this.refresh();
    }

    private void remove(IResource resource) {
        ArrayList<IResource> removedResources = new ArrayList<IResource>();
        for (IResource checkResource : this.resourceList) {
            if (!checkResource.getFullPath().toString().equals(resource.getFullPath().toString()) && (this.mode == 1 || !this.isChild(checkResource, resource))) continue;
            removedResources.add(checkResource);
        }
        Iterator iter = removedResources.iterator();
        while (iter.hasNext()) {
            this.resourceList.remove(iter.next());
        }
    }

    public boolean showIncludeUnversionedButton() {
        return this.unversionedResourceList != null && this.unversionedResourceList.size() > 0;
    }

    public void removeUnversioned() {
        try {
            Iterator iter = this.unversionedResourceList.iterator();
            while (iter.hasNext()) {
                this.resourceList.remove(iter.next());
            }
            this.resources = new IResource[this.resourceList.size()];
            this.resourceList.toArray(this.resources);
            this.compressedFolders = null;
            this.rootFolders = null;
            this.folders = null;
            this.refresh();
            this.includeUnversioned = false;
        }
        catch (Exception e) {
            SVNUIPlugin.openError(this.getShell(), null, null, e);
        }
    }

    public void addUnversioned() {
        try {
            Iterator iter = this.unversionedResourceList.iterator();
            while (iter.hasNext()) {
                this.resourceList.add(iter.next());
            }
            this.resources = new IResource[this.resourceList.size()];
            this.resourceList.toArray(this.resources);
            Arrays.sort(this.resources, this.comparator);
            this.compressedFolders = null;
            this.rootFolders = null;
            this.folders = null;
            this.refresh();
            this.checkUnversioned(this.tree.getItems(), true);
            this.includeUnversioned = true;
        }
        catch (Exception e) {
            SVNUIPlugin.openError(this.getShell(), null, null, e);
        }
    }

    private void checkUnversioned(TreeItem[] items, boolean state) {
        int i = 0;
        while (i < items.length) {
            if (this.unversionedResourceList.contains(items[i].getData())) {
                items[i].setChecked(state);
            }
            this.checkUnversioned(items[i].getItems(), state);
            ++i;
        }
    }

    private boolean isChild(IResource resource, IResource parent) {
        IContainer container = resource.getParent();
        while (container != null) {
            if (container.getFullPath().toString().equals(parent.getFullPath().toString())) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    private void handleCheckStateChange(CheckStateChangedEvent event) {
        ((CheckboxTreeViewer)this.treeViewer).setGrayed(event.getElement(), false);
        ((CheckboxTreeViewer)this.treeViewer).setSubtreeChecked(event.getElement(), event.getChecked());
        IResource resource = (IResource)event.getElement();
        this.updateParentState(resource, event.getChecked());
    }

    private void updateParentState(IResource child, boolean baseChildState) {
        if (this.mode == 1 || child == null || child.getParent() == null || this.resourceList.contains(child.getParent())) {
            return;
        }
        CheckboxTreeViewer checkboxTreeViewer = (CheckboxTreeViewer)this.treeViewer;
        if (child == null) {
            return;
        }
        Object parent = this.resourceSelectionContentProvider.getParent(child);
        if (parent == null) {
            return;
        }
        boolean allSameState = true;
        Object[] children = null;
        children = this.resourceSelectionContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            if (checkboxTreeViewer.getChecked(children[i]) != baseChildState || checkboxTreeViewer.getGrayed(children[i])) {
                allSameState = false;
                break;
            }
            --i;
        }
        checkboxTreeViewer.setGrayed(parent, !allSameState);
        checkboxTreeViewer.setChecked(parent, !allSameState || baseChildState);
        this.updateParentState((IResource)parent, baseChildState);
    }

    private void refresh() {
        Object[] checkedElements = null;
        if (this.checkbox) {
            checkedElements = ((CheckboxTreeViewer)this.treeViewer).getCheckedElements();
        }
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
        if (this.checkbox) {
            ((CheckboxTreeViewer)this.treeViewer).setCheckedElements(checkedElements);
        }
    }

    private IContainer[] getRootFolders() {
        if (this.rootFolders == null) {
            this.getFolders();
        }
        return this.rootFolders;
    }

    private IContainer[] getCompressedFolders() {
        if (this.compressedFolders == null) {
            this.compressedFolderList = new ArrayList();
            int i = 0;
            while (i < this.resources.length) {
                IContainer parent;
                if (this.resources[i] instanceof IContainer && !this.compressedFolderList.contains(this.resources[i])) {
                    this.compressedFolderList.add(this.resources[i]);
                }
                if (!(this.resources[i] instanceof IContainer || (parent = this.resources[i].getParent()) == null || parent instanceof IWorkspaceRoot || this.compressedFolderList.contains(parent))) {
                    this.compressedFolderList.add(parent);
                }
                ++i;
            }
            this.compressedFolders = new IContainer[this.compressedFolderList.size()];
            this.compressedFolderList.toArray(this.compressedFolders);
            Arrays.sort(this.compressedFolders, this.comparator);
        }
        return this.compressedFolders;
    }

    private IResource[] getChildResources(IContainer parent) {
        ArrayList<IResource> children = new ArrayList<IResource>();
        int i = 0;
        while (i < this.resources.length) {
            IContainer parentFolder;
            if (!(this.resources[i] instanceof IContainer) && (parentFolder = this.resources[i].getParent()) != null && parentFolder.equals((Object)parent) && !children.contains(parentFolder)) {
                children.add(this.resources[i]);
            }
            ++i;
        }
        IResource[] childArray = new IResource[children.size()];
        children.toArray(childArray);
        return childArray;
    }

    private IResource[] getFolderChildren(IContainer parent) {
        ArrayList<Object> children = new ArrayList<Object>();
        this.folders = this.getFolders();
        int i = 0;
        while (i < this.folders.length) {
            if (this.folders[i].getParent() != null && this.folders[i].getParent().equals((Object)parent)) {
                children.add(this.folders[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.resources.length) {
            if (!(this.resources[i] instanceof IContainer) && this.resources[i].getParent() != null && this.resources[i].getParent().equals((Object)parent)) {
                children.add(this.resources[i]);
            }
            ++i;
        }
        IResource[] childArray = new IResource[children.size()];
        children.toArray(childArray);
        return childArray;
    }

    private IContainer[] getFolders() {
        ArrayList<IResource> rootList = new ArrayList<IResource>();
        if (this.folders == null) {
            this.folderList = new ArrayList();
            int i = 0;
            while (i < this.resources.length) {
                if (this.resources[i] instanceof IContainer) {
                    this.folderList.add(this.resources[i]);
                }
                IResource parent = this.resources[i];
                while (parent != null && !(parent instanceof IWorkspaceRoot)) {
                    if (!(parent.getParent() instanceof IWorkspaceRoot) && this.folderList.contains(parent.getParent())) break;
                    if (parent.getParent() == null || parent.getParent() instanceof IWorkspaceRoot) {
                        rootList.add(parent);
                    }
                    parent = parent.getParent();
                    this.folderList.add(parent);
                }
                ++i;
            }
            this.folders = new IContainer[this.folderList.size()];
            this.folderList.toArray(this.folders);
            Arrays.sort(this.folders, this.comparator);
            this.rootFolders = new IContainer[rootList.size()];
            rootList.toArray(this.rootFolders);
            Arrays.sort(this.rootFolders, this.comparator);
        }
        return this.folders;
    }

    public void setRemoveFromViewValidator(IRemoveFromViewValidator removeFromViewValidator) {
        this.removeFromViewValidator = removeFromViewValidator;
    }

    public void setShowRemoveFromViewAction(boolean showRemoveFromViewAction) {
        this.showRemoveFromViewAction = showRemoveFromViewAction;
    }

    public boolean isResourceRemoved() {
        if (this.checkbox) {
            this.resourceRemoved = this.resources.length > this.getSelectedResources().length;
        }
        return this.resourceRemoved;
    }

    public static IResource[] dedupeResources(IResource[] resources) {
        if (resources == null) {
            return null;
        }
        ArrayList<String> locations = new ArrayList<String>();
        ArrayList<IResource> uniqueResources = new ArrayList<IResource>();
        IResource[] iResourceArray = resources;
        int n = 0;
        int n2 = iResourceArray.length;
        while (n < n2) {
            IResource resource = iResourceArray[n];
            boolean parentDeleted = false;
            if (resource.getParent() != null && !resource.getParent().exists()) {
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource.getParent());
                try {
                    if (svnResource != null && svnResource.getStatus().isDeleted()) {
                        parentDeleted = true;
                    }
                }
                catch (SVNException sVNException) {}
            }
            if (!(!parentDeleted && resource.getParent() != null && !resource.getParent().exists() || resource.getLocation() != null && locations.contains(resource.getLocation().toString()))) {
                uniqueResources.add(resource);
                locations.add(resource.getLocation().toString());
            }
            ++n;
        }
        IResource[] uniqueResourceArray = new IResource[uniqueResources.size()];
        uniqueResources.toArray(uniqueResourceArray);
        return uniqueResourceArray;
    }

    private class ResourceSelectionContentProvider
    extends WorkbenchContentProvider {
        private ResourceSelectionContentProvider() {
        }

        public Object getParent(Object element) {
            return ((IResource)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ResourceSelectionTree.this.mode != 1 && element instanceof IContainer;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ResourceSelectionTree) {
                if (ResourceSelectionTree.this.mode == 1) {
                    return ResourceSelectionTree.this.resources;
                }
                if (ResourceSelectionTree.this.mode == 0) {
                    return ResourceSelectionTree.this.getCompressedFolders();
                }
                return ResourceSelectionTree.this.getRootFolders();
            }
            if (parentElement instanceof IContainer) {
                if (ResourceSelectionTree.this.mode == 0) {
                    return ResourceSelectionTree.this.getChildResources((IContainer)parentElement);
                }
                if (ResourceSelectionTree.this.mode == 2) {
                    return ResourceSelectionTree.this.getFolderChildren((IContainer)parentElement);
                }
            }
            return new Object[0];
        }
    }

    private class ResourceSelectionLabelProvider
    extends LabelProvider {
        private WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        private CompareConfiguration compareConfiguration = new CompareConfiguration();
        private AbstractSynchronizeLabelProvider syncLabelProvider = new AbstractSynchronizeLabelProvider(){

            protected ILabelProvider getDelegateLabelProvider() {
                return ResourceSelectionLabelProvider.this.workbenchLabelProvider;
            }

            protected boolean isDecorationEnabled() {
                return true;
            }

            protected IDiff getDiff(Object element) {
                IResource resource = (IResource)element;
                return new ResourceSelectionDiff(resource);
            }
        };

        private ResourceSelectionLabelProvider() {
        }

        public Image getImage(Object element) {
            if (ResourceSelectionTree.this.resourceList.contains(element)) {
                SVNStatusKind statusKind = ResourceWithStatusUtil.getStatusKind((IResource)element);
                Image image = null;
                if (element instanceof IContainer && (statusKind == null || !statusKind.equals((Object)SVNStatusKind.DELETED))) {
                    image = this.workbenchLabelProvider.getImage(element);
                    image = this.compareConfiguration.getImage(image, 0);
                } else {
                    if (statusKind != null) {
                        if (statusKind.hasTreeConflict()) {
                            image = this.workbenchLabelProvider.getImage(element);
                            image = ResourceSelectionTree.this.resourceSelectionTreeDecorator.getImage(image, 4);
                        } else if (statusKind != null && statusKind.equals((Object)SVNStatusKind.CONFLICTED)) {
                            image = this.workbenchLabelProvider.getImage(element);
                            image = ResourceSelectionTree.this.resourceSelectionTreeDecorator.getImage(image, 1);
                        }
                    }
                    if (image == null) {
                        image = this.syncLabelProvider.getImage(element);
                    }
                    if (element instanceof IContainer) {
                        return image;
                    }
                    if (ResourceSelectionTree.this.unversionedResourceList.contains(element)) {
                        image = ResourceSelectionTree.this.resourceSelectionTreeDecorator.getImage(image, 2);
                    }
                    if (statusKind != null && statusKind.equals((Object)SVNStatusKind.MISSING)) {
                        image = ResourceSelectionTree.this.resourceSelectionTreeDecorator.getImage(image, 3);
                    }
                }
                String propertyStatus = ResourceWithStatusUtil.getPropertyStatus((IResource)element);
                if (propertyStatus != null && propertyStatus.length() > 0) {
                    image = propertyStatus.equals("conflicted") ? ResourceSelectionTree.this.resourceSelectionTreeDecorator.getImage(image, 5) : ResourceSelectionTree.this.resourceSelectionTreeDecorator.getImage(image, 0);
                }
                return image;
            }
            Image image = this.workbenchLabelProvider.getImage(element);
            return this.compareConfiguration.getImage(image, 0);
        }

        public String getText(Object element) {
            if (ResourceSelectionTree.this.statusMap == null) {
                return this.workbenchLabelProvider.getText(element);
            }
            String text = null;
            IResource resource = (IResource)element;
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            if (ResourceSelectionTree.this.mode == 1) {
                text = String.valueOf(resource.getName()) + " - " + resource.getFullPath().toString();
            } else if (ResourceSelectionTree.this.mode == 0) {
                if (element instanceof IContainer) {
                    IContainer container = (IContainer)element;
                    text = container.getFullPath().makeRelative().toString();
                } else {
                    text = resource.getName();
                }
            } else {
                text = resource.getName();
            }
            if (svnResource != null) {
                try {
                    LocalResourceStatus status = svnResource.getStatus();
                    if (status != null) {
                        if (status.getMovedFromAbspath() != null) {
                            text = String.valueOf(text) + Policy.bind("ResourceSelectionTree.movedFrom") + status.getMovedFromAbspath().substring(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString().length()) + ")";
                        } else if (status.getMovedToAbspath() != null) {
                            text = String.valueOf(text) + Policy.bind("ResourceSelectionTree.movedTo") + status.getMovedToAbspath().substring(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString().length()) + ")";
                        }
                    }
                }
                catch (SVNException sVNException) {}
            }
            return text;
        }
    }

    private class ResourceSelectionDiff
    implements IThreeWayDiff {
        private IResource resource;

        public ResourceSelectionDiff(IResource resource) {
            this.resource = resource;
        }

        public int getDirection() {
            return 256;
        }

        public ITwoWayDiff getLocalChange() {
            return null;
        }

        public ITwoWayDiff getRemoteChange() {
            return null;
        }

        public int getKind() {
            int kind = 0;
            if (ResourceSelectionTree.this.syncInfoSet != null) {
                SyncInfo syncInfo = ResourceSelectionTree.this.syncInfoSet.getSyncInfo(this.resource);
                if (syncInfo != null) {
                    int change = SyncInfo.getChange((int)syncInfo.getKind());
                    if (change == 12) {
                        kind = 768;
                    } else if (change == 3) {
                        kind = 4;
                    } else if (change == 1) {
                        kind = 1;
                    } else if (change == 2) {
                        kind = 2;
                    }
                }
            } else {
                SVNStatusKind statusKind = (SVNStatusKind)ResourceSelectionTree.this.statusMap.get(this.resource);
                if (statusKind == null) {
                    kind = 0;
                } else if (statusKind.equals((Object)SVNStatusKind.CONFLICTED)) {
                    kind = 768;
                } else if (statusKind.equals((Object)SVNStatusKind.MODIFIED)) {
                    kind = 4;
                } else if (statusKind.equals((Object)SVNStatusKind.ADDED)) {
                    kind = 1;
                } else if (statusKind.equals((Object)SVNStatusKind.DELETED)) {
                    kind = 2;
                }
            }
            if (this.resource instanceof IContainer) {
                return 2;
            }
            return kind;
        }

        public IPath getPath() {
            return this.resource.getFullPath();
        }

        public String toDiffString() {
            return null;
        }
    }

    private class ResourceComparator
    implements Comparator {
        private ResourceComparator() {
        }

        public int compare(Object obj0, Object obj1) {
            IResource resource0 = (IResource)obj0;
            IResource resource1 = (IResource)obj1;
            return resource0.getFullPath().toOSString().compareTo(resource1.getFullPath().toOSString());
        }
    }

    public static interface IToolbarControlCreator {
        public void createToolbarControls(ToolBarManager var1);

        public int getControlCount();
    }

    public static interface IRemoveFromViewValidator {
        public boolean canRemove(ArrayList var1, IStructuredSelection var2);

        public String getErrorMessage();
    }
}

