//用来封装top对象提供的常用函数
//解决本地页面无法访问top对象的问题

//顶层页面window对象
var topWin = window.parent;
var tb = top.taskBuilder;

function requestByIPC(service, args, cb) {
  top.taskBuilder.requestByIPC(service, args, cb);
}

function openDefaultBrowser(url) {
  top.taskBuilder.openDefaultBrowser(url);
}

/**
 * 显示提示信息
 * @param  {[type]} msg [description]
 * @return {[type]}     [description]
 */
function showMsg(msg) {
	let str = msg.replace(/\'/g,"");
  str = str.replace(/\"/g,"");
  str = str.replace(/\\/g,"\\\\");
  top.showMsg(msg);
}

alert = function(msg){
  showMsg(msg);
};

confirm = function(msg, cb){
  top.confirm(msg, cb);
};

/**
 * 设置状态栏
 * @param {[type]} content [description]
 */
function setStatusBar(content) {
  top.setStatusBar(content);
}

/**
 * 显示错误信息
 * @param  {[type]} err [description]
 * @return {[type]}     [description]
 */
function showErr(err) {
	top.showErr(err);
}

/**
 * 打开页面
 * @param  {[type]} title [description]
 * @param  {[type]} url   [description]
 * @return {[type]}       [description]
 */
function openPage(title, url) {
  top.openPage(title, url);
}

/**
 * 打开对话框
 * @param  {[type]} title  [description]
 * @param  {[type]} url    [description]
 * @param  {[type]} width  [description]
 * @param  {[type]} height [description]
 * @param  {[type]} args   [description]
 * @param  {[type]} cb     [description]
 */
function openDialog(title, url, width, height, args, cb) {
  top.openDialog(title, url, width, height, null, window, args, cb);
}

function getCurDialogId() {
  return top.getCurDialogId();
}

function closeDialog(id) {
  top.closeDialog(id);
}

/**
 * 关闭当前对话框
 * @return {[type]} [description]
 */
function closeCurDialog() {
  top.closeCurDialog();
}

/**
 * 关闭当前页面
 * @return {[type]} [description]
 */
function closeCurPage() {
  top.closeCurPage();
}

/**
 * 当点击对话框确定按钮时
 * @param  {[type]} ret [description]
 * @return {[type]}     [description]
 */
function onDialogOK(ret) {
  top.onDialogOK(ret);
}

/**
 * 获得对话框请求参数
 * @return {[type]} [description]
 */
function getDialogArgs() {
  return sessionStorage.getItem("_OpenDialogArgs");
}

/**
 * 添加系统资源节点
 * @param {[type]}  parentId      [description]
 * @param {[type]}  id            [description]
 * @param {[type]}  type          [description]
 * @param {[type]}  level         [description]
 * @param {Boolean} hasChild      [description]
 * @param {[type]}  icon          [description]
 * @param {[type]}  name          [description]
 * @param {[type]}  tag           [description]
 * @param {[type]}  rightBtnTitle [description]
 * @param {[type]}  rightBtnIcon  [description]
 * @param {[type]}  rightBtnClick [description]
 */
function addSysResTreeNode(parentId, id, type, level, hasChild,  
    icon, name, tag, rightBtnTitle, rightBtnIcon, rightBtnClick) {
  top.addTreeNode(parentId, id, type, level, hasChild,  
    icon, name, tag, rightBtnTitle, rightBtnIcon, rightBtnClick);
}

function includeJs(filePath) {
  let jsCode = readFileSync(filePath);
  let script = document.createElement("script");
  script.type = 'text/javascript';
  script.innerHTML = jsCode;
  document.getElementsByTagName('head')[0].appendChild(script);
}