/**
 * 判断字符串是否以指定的子字符串开头
 * @param  {[type]} prefix [description]
 * @return {[type]}        [description]
 */
String.prototype.startWith = String.prototype.startsWith = function (prefix) {
  return this.indexOf(prefix) === 0;
}

/**
 * 判断字符串是否以指定的子字符串结尾
 * @param  {[type]} suffix [description]
 * @return {[type]}        [description]
 */
String.prototype.endWith = String.prototype.endsWith = function (suffix) {
  return this.match(suffix + "$") == suffix;
}

//计算字符串长度(英文占1个字符，中文汉字占2个字符)
String.prototype.gblen = function() {
  var len = 0;
  for (var i=0; i<this.length; i++) {
    if (this.charCodeAt(i)>127 || this.charCodeAt(i)==94) {
      len += 2;
    } else {
      len ++;
    }
  }
  return len;
}

/**
 * 全部替换
 * @param  {[type]} s1 [description]
 * @param  {[type]} s2 [description]
 * @return {[type]}    [description]
 */
String.prototype.replaceAll = function (s1, s2) {
  return this.replace(new RegExp(s1, "gm"), s2);
}

/**
 * 删除字符串两端的空格
 * @return {[type]} [description]
 */
String.prototype.trim = function () {
  return this.replace(/(^\s*)|(\s*$)/g,"");
}

/**
 * 将字符串转换为日期
 * @return {[type]} [description]
 */
String.prototype.toDate = function () {
  return new Date(this.replace(/-/g, '/'));
}

/**
* 将日期格式化为字符串
* @param  {[type]} style [description]
* @return {[type]}       [description]
*/
Date.prototype.format = function (style) {
	var y = this.getFullYear();
	var M = "0" + (this.getMonth() + 1);
	M = M.substring(M.length - 2);
	var d = "0" + this.getDate();
	d = d.substring(d.length - 2);
	var H = "0" + this.getHours();
	H = H.substring(H.length - 2);
	var h = this.getHours();
	if (h >= 12) h = h - 12;
	h = "0" + h;
	h = h.substring(h.length - 2);
	var m = "0" + this.getMinutes();
	m = m.substring(m.length - 2);
	var s = "0" + this.getSeconds();
	s = s.substring(s.length - 2);
	var ms = "00" + this.getMilliseconds();
	ms = ms.substring(ms.length - 3);
	var ret = (style + "").replaceAll('yyyy', y);
	ret = ret.replaceAll('yy', (y + '').substring(2));
	ret = ret.replaceAll('MM', M);
	ret = ret.replaceAll('dd', d);
	ret = ret.replaceAll('HH', H);
	ret = ret.replaceAll('hh', h);
	ret = ret.replaceAll('mm', m);
	ret = ret.replaceAll('ss', s);
	ret = ret.replaceAll('SSS', ms);
	return ret;
}

/**
* 为日期增加指定的值
* @param  {[type]} style [description]
* @return {[type]}       [description]
*/
Date.prototype.add = function (strInterval, Number) {
	var dtTmp = this;
	switch (strInterval) {
		case 's':
			return new Date(Date.parse(dtTmp) + 1000 * Number);
		case 'n':
			return new Date(Date.parse(dtTmp) + 60000 * Number);
		case 'h':
			return new Date(Date.parse(dtTmp) + 3600000 * Number);
		case 'd':
			return new Date(Date.parse(dtTmp) + 86400000 * Number);
		case 'w':
			return new Date(Date.parse(dtTmp) + 86400000 * 7 * Number);
		case 'q':
			return new Date(dtTmp.getFullYear(), dtTmp.getMonth() + Number * 3, dtTmp.getDate(), dtTmp.getHours(), dtTmp.getMinutes(), dtTmp.getSeconds());
		case 'm':
			return new Date(dtTmp.getFullYear(), dtTmp.getMonth() + Number, dtTmp.getDate(), dtTmp.getHours(), dtTmp.getMinutes(), dtTmp.getSeconds());
		case 'y':
			return new Date(dtTmp.getFullYear() + Number, dtTmp.getMonth(), dtTmp.getDate(), dtTmp.getHours(), dtTmp.getMinutes(), dtTmp.getSeconds());
	}
}

/**
* 计算两个日期之间的间隔
* @param  {[type]} endTime  [description]
* @param  {[type]} diffType [description]
* @return {[type]}          [description]
*/
Date.prototype.diff = function (endTime, diffType) {
	//将计算间隔类性字符转换为小写
	diffType = diffType.toLowerCase();
	var sTime = new Date(this); //开始时间
	var eTime = new Date(endTime); //结束时间
	//作为除数的数字
	var divNum = 1;
	switch (diffType) {
		case "second":
			divNum = 1000;
			break;
		case "minute":
			divNum = 1000 * 60;
			break;
		case "hour":
			divNum = 1000 * 3600;
			break;
		case "day":
			divNum = 1000 * 3600 * 24;
			break;
		default:
			break;
	}
	return parseInt((eTime.getTime() - sTime.getTime()) / parseInt(divNum));
}

/**
* 日期对象转换为JSON值
* @return {[type]} [description]
*/
Date.prototype.toJSON = function () {
	return this.format('yyyy-MM-dd hh:mm:ss');
}

/**
* 删除数组中指定的元素
* @param  {[type]} obj [description]
* @return {[type]}     [description]
*/
Array.prototype.remove = function (obj) {
	for (var i = 0; i < this.length; i++) {
		if (this[i] === obj) {
			this.splice(i, 1);
			return;
		}
	}
}

/**
 * 判断数组中是否存在指定的元素
 * @param  {[type]} obj [description]
 * @return {[type]}     [description]
 */
Array.prototype.contains = function (obj) {
  var i = this.length;
  while (i--) {
    if (this[i] === obj) {
        return true;
    }
  }
  return false;
}

/**
 * 是否为空值
 * @param  {[type]}  val [description]
 * @return {Boolean}     [description]
 */
function isNull(val) {
	return val == null || val == undefined || (typeof val == "string" && val.trim() == "");
}

/**
 * 判断是否是整数
 * @param  {[type]}  i [description]
 * @return {Boolean}   [description]
 */
function isInt(i) {
	return i == parseInt(i);
}

/**
 * 是否是对象
 * @param  {[type]}  obj [description]
 * @return {Boolean}     [description]
 */
function isObj(obj) {
	return Object.prototype.toString.call(obj) === '[object Object]';
}

/**
 * 格式化金额
 * @param  {[type]} s 输入值
 * @param  {[type]} n 小数点位数
 * @return {[type]}   返回值
 */
function formatMoney(s, n) {
	n = n > 0 && n <= 20 ? n : 2;
	s = parseFloat((s + "").replace(/[^\d\.-]/g, "")).toFixed(n) + "";
	var l = s.split(".")[0].split("").reverse();
	var r = s.split(".")[1];
	var t = "";
	for (var i = 0; i < l.length; i++) {
		t += l[i] + ((i + 1) % 3 === 0 && i + 1 != l.length ? "," : "");
	}
	return t.split("").reverse().join("") + "." + r;
}

/**
 * 格式化日期
 * @param  {[type]} d 输入值
 * @param  {[type]} f 格式
 * @return {[type]}   返回值
 */
function formatDate(d, f) {
	if (typeof d == "number") return new Date(d).format(f);
	return new Date(Date.parse(d.replace("T", " ").replace("+08:00", " ").replace(/-/g, "/"))).format(f);
}

/**
 * 格式化文件大小
 * @param  {[type]} bytes [description]
 * @return {[type]}       [description]
 */
function formatFileSize(bytes) {
	if (bytes === 0) return '0 B';
	var k = 1000,
	    // or 1024
	sizes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
	    i = Math.floor(Math.log(bytes) / Math.log(k));
	return (bytes / Math.pow(k, i)).toPrecision(3) + ' ' + sizes[i];
}

/**
 * 获得样式中的像素值，将px字母删掉，转换为整数
 * @param  {[type]} value [description]
 * @return {[type]}       [description]
 */
function getPixel(value) {
	return parseInt(new String(value).replace("px", ""));
}

/**
 * 获得URL中的所有参数
 * @param  {[type]} url [description]
 * @return {[type]}     [description]
 */
function getUrlArgs(url) {
	var args = {};
	var start = url.indexOf("?");
	if (start < 0) return args;
	var str = url.substr(start + 1);
	var strArr = str.split("&");
	for (var i = 0; i < strArr.length; i++) {
		var argName = strArr[i].substr(0, strArr[i].indexOf("="));
		var argValue = strArr[i].substr(strArr[i].indexOf("=") + 1);
		args[argName] = argValue;
	}
	return args;
}

/**
 * 获得URL中的指定参数的值
 * @param  {[type]} argName [description]
 * @return {[type]}         [description]
 */
function getUrlArg(argName) {
	var url = window.location.href;
	var start = url.indexOf("?");
	if (start < 0) return null;
	var str = url.substr(start + 1);
	var strArr = str.split("&");
	for (var i = 0; i < strArr.length; i++) {
		var aname = strArr[i].substr(0, strArr[i].indexOf("="));
		if (aname == argName) return decodeURIComponent(strArr[i].substr(strArr[i].indexOf("=") + 1));
	}
	return null;
}

/**
 * 将jQuery的RGB值转换为十六进制值
 * @param  {[type]} color [description]
 * @return {[type]}       [description]
 */
function rgb2hex(color) {
  var rgb = color.split(',');
  var r = parseInt(rgb[0].split('(')[1]);
  var g = parseInt(rgb[1]);
  var b = parseInt(rgb[2].split(')')[0]);

  var hex = "#" + ((1 << 24) + (r << 16) + (g << 8) + b).toString(16).slice(1);
  return hex;
}

/**
 * 将十六进制值颜色值转换为jQuery的RGB值
 * @param  {[type]} color [description]
 * @return {[type]}       [description]
 */
function hex2rgb(color) {
  var result;
  if ( color && color.constructor == Array && color.length == 3 )
      color = color;
  if (result = /rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(color))
      color = [parseInt(result[1]), parseInt(result[2]), parseInt(result[3])];
  if (result = /rgb\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*\)/.exec(color))
      color =[parseFloat(result[1])*2.55, parseFloat(result[2])*2.55, parseFloat(result[3])*2.55];
  if (result = /#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(color))
      color =[parseInt(result[1],16), parseInt(result[2],16), parseInt(result[3],16)];
  if (result = /#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(color))
      color =[parseInt(result[1]+result[1],16), parseInt(result[2]+result[2],16), parseInt(result[3]+result[3],16)];
  return "rgb("+color[0]+","+color[1]+","+color[2]+")";
}