/**
 * 颜色选择器
 */
function ColorPicker() {
	var ColorHex = new Array('00','33','66','99','CC','FF');
  var SpColorHex = new Array('FF0000','00FF00','0000FF','FFFF00','00FFFF','FF00FF');
  var that = this;

  this.popDiv = null;
  this.cptEl = null;
  this.cbSetVal = null;

  this.init = function() {
    $("body").append("<div id=\"colorPickerDiv\" class=\"color-picker-pop-div\" "
      +"style=\"position: absolute;z-index: 10000;top: 0;left: 0;padding: 10px;"
      +"border: 1px solid #999999;width: 252px;height: 175px;padding: 0;border-radius: 0;"
      +"background-color: #333333;display: none;box-shadow: 1px 1px 1px #000000;\">"
      +"<div style=\"width: 100%;height: 30px;line-height: 30px;color: #ffffff;clear: both;"
      +"font-size: 14px;\"><label style=\"float: left; margin-left:5px;\">当前颜色：</label>"  
      +"<div class=\"color-panel\" title=\"颜色值\" data-value=\"#000000\" style=\"float: left; "
      +"width:50px; height: 18px; margin-top: 5px; border: 1px solid #999999; "
      +"background-color:#000000;\"></div><input class=\"color-value\" data-type=\"h\" "
      +"type=\"text\" maxlength=\"7\" style=\"width: 70px; margin-left:5px; background-color: "
      +"#222222;height: 20px;margin-top: 5px;border: 1px solid #999999; color:#FFFFFF;\" />"
      +"<img src=\"images/clear.png\" style=\"cursor: pointer; vertical-align:middle; "
      +"margin-left:10px;\" title=\"清空\" onclick=\"colorPicker.clear()\" />"
      +"<img src=\"images/close.png\" title=\"关闭\" style=\"cursor: pointer; "
      +"vertical-align:middle; margin-left:5px;\" onclick=\"colorPicker.close()\" />"
      +"</div><div class=\"color-table\" style=\"height:150px; width:253px;\"></div></div>");
    this.popDiv = $("#colorPickerDiv");
  	var htmlStr = '<table border="1" cellspacing="0" cellpadding="0" '
      +'style="border-collapse: collapse;cursor:pointer;border:1px solid #999999;">';
    var colorValue = '';
    for(var i=0;i<2;i++){
      for(j=0;j<6;j++){
        htmlStr = htmlStr+'<tr height=12>'
        htmlStr = htmlStr+'<td width=11 data-color="#000000" style="background-color:#000000">'
        colorValue = i==0 ? ColorHex[j]+ColorHex[j]+ColorHex[j] : SpColorHex[j];
        htmlStr = htmlStr+'<td width=11 data-color="#'+colorValue+'" style="background-color:#'+colorValue+'">'
        htmlStr = htmlStr+'<td width=11 data-color="#000000" style="background-color:#000000">'
        for (k=0;k<3;k++) {
          for (l=0;l<6;l++){
            colorValue = ColorHex[k+i*3]+ColorHex[l]+ColorHex[j];
            htmlStr = htmlStr+'<td width=11 data-color="#'+colorValue+'" style="background-color:#'+colorValue+'">'
          }
        }
      }
    }
    this.popDiv.find(".color-table").append(htmlStr);
    this.popDiv.find(".color-value").click(function() {
      event.stopPropagation();
    });
    this.popDiv.find(".color-value").bind("keydown",function(e){
      var theEvent = e || window.event;
      var code = theEvent.keyCode || theEvent.which || theEvent.charCode;
      let color = $(this).val().trim();
      var type = "^#[0-9a-fA-F]{6}$";
      var re = new RegExp(type);
      if(color.match(re) == null) return;
      if(code == 13) {
        that.setColor(color);
        that.close();
      } else {
        that.popDiv.find(".color-panel").css("background", color);
      }
    });
    this.popDiv.find("td").click(function(){
      var color=$(this).attr("data-color");
		  that.popDiv.find(".color-panel").attr("data-value", "");
      that.popDiv.find(".color-panel").css("background", color);
      that.popDiv.find(".color-value").val($(this).attr("data-color"));
      that.setColor(color);
    });
  	this.popDiv.find("td").mouseover(function(){
      var color=$(this).attr("data-color");
      that.popDiv.find(".color-panel").css("background", color);
      that.popDiv.find(".color-value").val($(this).attr("data-color"));
    });
  }

  this.setColor = function(color) {
    if(this.cptEl) {
      this.cptEl.css("background", color);
      this.cptEl.attr("style-setting-value", color);
      this.cptEl = null;
    }
    if(this.cbSetVal) this.cbSetVal(color);
  }

  this.clear = function() {
    this.cptEl.val("");
    this.close();
  }

  this.close = function() {
    colorPicker.popDiv.hide();
    $("#maskDiv").hide();
    document.removeEventListener("click", colorPicker.close);
  }

  this.show = function(cptEl, cb) {
    this.cptEl = cptEl;
    this.cbSetVal = cb;
    let top = this.cptEl.offset().top+this.cptEl.height()+3;
    if(top+165>document.documentElement.clientHeight) top = document.documentElement.clientHeight - 185;
    let left = this.cptEl.offset().left;
    if(left+242>document.documentElement.clientWidth) left = document.documentElement.clientWidth - 262;
    this.popDiv.css("top", top+"px");
    this.popDiv.css("left", left+"px");
    this.popDiv.show();
    $("#maskDiv").show();
    document.addEventListener("click", this.close);
    event.stopPropagation();
  }
}

var colorPicker = new ColorPicker();