var CSSTypeInfo = [];

function CSSEditor() {
  this.isInit = false;
  this.styles = {};
  this.curStyleSheet = null;

  var that = this;

  this.loadStylesLib = function() {
    let strTFPStyles = top.taskBuilder.readFileSync('/node_modules/taskbuilder-tfp-designer/TFPStyles.json');
    CSSTypeInfo = JSON.parse(strTFPStyles);
    that.init();
  };
  
  /**
   * 初始化
   */
  this.init = function() {
    let htmlLib = "";
    for(var i=0;i<CSSTypeInfo.length;i++) {
      let category = CSSTypeInfo[i];
      htmlLib += "<div id=\"cssEditor_lib_"+category.name+"\" class=\"category-title\" "
        +"onclick=\"tfpDesigner.toggleCategoryItems('cssEditor_lib_"+category.name+"_items', this)\">";
      htmlLib += "<img src=\"../taskbuilder-renderer/images/arrow/right.png\" /><label>"+category.comment+"</label></div>";
      htmlLib += "<div class=\"ToolBarHorizontalSplitLine\"></div>";
      htmlLib += "<div id=\"cssEditor_lib_"+category.name+"_items\" "
        +"class=\"category-items cssEditor-lib-category\" style=\"display:none;\">";
      for(var j=0;j<category.styles.length;j++) {
        let style = category.styles[j];
        style._cname = category.name;
        this.styles[style.name] = style;
        htmlLib += "<div style-type=\""+style.name+"\" style=\"background-color:"+category.color
          +";\" draggable=\"false\"><img src=\""+style.icon+"\" /><label>"+style.comment+"</label></div>";
      }
      htmlLib += "</div>";
    }
    $("#divCSS_lib").append(htmlLib);

    $(".cssEditor-lib-category").find("div").mousedown(function() {
      var e = window.event;
      tfpDesigner.mouseInfo.downX = e.clientX;
      tfpDesigner.mouseInfo.downY = e.clientY;
      tfpDesigner.mouseInfo.dragType = "CreateStyle";
      tfpDesigner.mouseInfo.styleType = $(this).attr("style-type");
      tfpDesigner.mouseInfo.isDrag = true;
      $("#compoentDragging").find("img").attr("src", $(this).find("img").attr("src"));
      $("#compoentDragging").find("label").text($(this).find("label").text());
    });

    if(tfp.curPage.dataModel.cssFiles) {
      for(var i=0;i<tfp.curPage.dataModel.cssFiles.length;i++) {
        let cssFile = tfp.curPage.dataModel.cssFiles[i];
        this.addLinkCss(cssFile);
      }
    }

    if(tfp.curPage.dataModel.styleSheets) {
      for(var i=0;i<tfp.curPage.dataModel.styleSheets.length;i++) {
        let styleSheet = tfp.curPage.dataModel.styleSheets[i];
        this.addStyleSheet(styleSheet);
      }
    }

    this.isInit = true;
  };

  this.showStyleSheet = function(styleSheet) {
    $("#iptCurStyleSelector").val(styleSheet.id);
    $("#divCSS_top").show();
    $("#divCSS_split_top").show();
    $("#divCSS_lib").show();
    $("#divCSS_setting_content").html("");
    $("#divCSS_setting").show();
    $("#divCSS_code").show();

    if(this.curStyleSheet) {
      $("#cssEditor_page_styles").find("[style-sheet='"
        +this.curStyleSheet+"']").css("background-color", "");
      $("#cssEditor_page_styles").find("[style-sheet='"
        +this.curStyleSheet+"']").find("div").css("background-color", "");
    }
    this.curStyleSheet = styleSheet.id; 
    $("#cssEditor_page_styles").find("[style-sheet='"
      +this.curStyleSheet+"']").css("background-color", "#555555");
    $("#cssEditor_page_styles").find("[style-sheet='"
      +this.curStyleSheet+"']").find("div").css("background-color", "#555555");

    if(!cssEditor.editor) {
      let options = {
        mode: "css",
        lineNumbers: true,
        styleActiveLine: true,
        matchBrackets: true,
        selectionPointer: true,
        keyMap: "sublime",
        foldGutter: true,
        autoCloseBrackets: true,
        autofocus: true,
        readOnly: true,
        gutters: ["CodeMirror-lint-markers", "CodeMirror-linenumbers", "CodeMirror-foldgutter"],
        hintOptions: {completeSingle: false}
      };
      cssEditor.editor = CodeMirror(document.getElementById("divCSS_code_content"), options);
      cssEditor.editor.setOption("theme", "monokai");
      $("#divCSS_code_content").find(".CodeMirror").css("width", "100%");
      $("#divCSS_code_content").find(".CodeMirror").css("height", $("#divCSS_code_content").height()+"px");
    }
    cssEditor.editor.setValue("");
    let styleCode = styleSheet.id+" {\r\n";
    if(styleSheet.styles) {
      for(var i=0;i<styleSheet.styles.length;i++) {
        let style = styleSheet.styles[i];
        styleCode += "\t"+style.name+": "+style.value+";\r\n";
        this.addStyleItem(style.name, style.value);
      }
    }
    styleCode += "}";
    cssEditor.editor.setValue(styleCode);
  };

  this.addNewStyleSheet = function() {
    var e = window.event;
    e.stopPropagation();

    openDialog("添加样式", "taskbuilder-tfp-designer/addStyleSheet.html", "360px", "140px", 
      null, function(styleSheetName) {

      if(tfp.curPage.dataModel.styleSheets) {
        for(var i=0;i<tfp.curPage.dataModel.styleSheets.length;i++) {
          let styleSheet = tfp.curPage.dataModel.styleSheets[i];
          if(styleSheet.id==styleSheetName) {
            showMsg(styleSheetName+"已存在！");
            return;
          }
        }
      }

      if(!tfp.curPage.dataModel.styleSheets) tfp.curPage.dataModel.styleSheets = [];
      let styleSheet = {
        id: styleSheetName,
        styles: []
      };
      tfp.curPage.dataModel.styleSheets.push(styleSheet);

      that.addStyleSheet(styleSheet);
      that.showStyleSheet(styleSheet);
    });
  };

  this.setCurPageStyle = function() {
    let styleCode = "";
    for(var i=0; i<tfp.curPage.dataModel.styleSheets.length; i++) {
      let styleSheet = tfp.curPage.dataModel.styleSheets[i];
      styleCode += "\t"+styleSheet.id+" {";
      for(var j=0; j<styleSheet.styles.length; j++) {
        let style = styleSheet.styles[j];
        styleCode += style.name +": "+style.value+";";
      }
      styleCode += "}\r\n";
    }
    uiDesigner.pageFrameWin.$("#_tfpPageStyleSetting").empty(styleCode);
    uiDesigner.pageFrameWin.$("#_tfpPageStyleSetting").append(styleCode);
  };

  this.addStyleSheet = function(styleSheet) {
    $("#cssEditor_page_styles").append("<div style-sheet=\""+styleSheet.id
      +"\"><div>"+styleSheet.id+"</div>"
      +"<img src=\"images/del.png\" style=\"float:right;margin-left:0;"
      +"margin-top:4px;display:none;\" title=\"删除\" onclick=\""
      +"cssEditor.deleteStyleSheet($(this).parent())\"></div>");
    let newStyleSheetDiv = $("#cssEditor_page_styles").find("[style-sheet]").last();

    newStyleSheetDiv.click(function() {
      that.selectStyleSheet($(this));
    });

    newStyleSheetDiv.mouseover(function() {
      $(this).find("img").show();
    });

    newStyleSheetDiv.mouseout(function() {
      $(this).find("img").hide();
    });
  };

  this.selectStyleSheet = function(divStyleSheet) {
    let styleSheetId = divStyleSheet.attr("style-sheet");
    if(styleSheetId==this.curStyleSheet) return;
    for(var i=0;i<tfp.curPage.dataModel.styleSheets.length;i++) {
      let styleSheet = tfp.curPage.dataModel.styleSheets[i];
      if(styleSheet.id==styleSheetId) {
        this.showStyleSheet(styleSheet)
        return;
      }
    }
  };

  /**
   * 获得样式输入项的html
   * @param  {[type]} styleInput [description]
   * @return {[type]}            [description]
   */
  this.getStyleInputHtml = function(styleInput, value) {
    let str = "";
    if(styleInput == "string" || styleInput.type == "string") {
      str = "<input type=\"text\" class=\"style-item-input\" style=\"width:";
      str += styleInput.width ? styleInput.width : "100px";
      str += ";\" ";
      if(styleInput.maxLength) str += " maxlength=\""+styleInput.maxLength+"\"";
      if(value) str += " value=\""+value+"\"";
      str += " />"; 
    } else if(styleInput == "number" || styleInput.type == "number" 
      || styleInput == "px" || styleInput.type == "px"
      || styleInput == "em" || styleInput.type == "em"
      || styleInput == "cm" || styleInput.type == "cm"
      || styleInput == "%" || styleInput.type == "%") {
      str = "<input type=\"number\" class=\"style-item-input\" style=\"width:";
      str += styleInput.width ? styleInput.width : "40px";
      str += ";\" maxlength=8"; 
      if(value) str += " value=\""+value.replace("px", "").replace("em", "").replace("cm", "").replace("%", "")+"\"";
      str += " />";
      if(styleInput == "px" || styleInput.type == "px") {
        str += "<label style=\"margin-left:2px;margin-right:0;\">px</label>";
      } else if(styleInput == "em" || styleInput.type == "em") {
        str += "<label style=\"margin-left:2px;margin-right:0;\">em</label>";
      } else if(styleInput == "cm" || styleInput.type == "cm") {
        str += "<label style=\"margin-left:2px;margin-right:0;\">px</label>";
      } else if(styleInput == "%" || styleInput.type == "%") {
        str += "<label style=\"margin-left:2px;margin-right:0;\">%</label>";
      }
    } else if(styleInput == "px|%" || styleInput.type == "px|%") {
      str = "<input type=\"number\" class=\"style-item-input\" style=\"width:40px;\" maxlength=8";
      if(value) str += " value=\""+value.replace("px", "").replace("%", "")+"\"";
      str += " />";
      str += "<select>";
      str += "<option value=\"px\"";
      if(value && value.indexOf("px")>=0) str += " selected";
      str += ">px</option>";
      str += "<option value=\"%\"";
      if(value && value.indexOf("%")>=0) str += " selected";
      str += ">%</option>";
      str += "</select>";
    } else if(styleInput == "url" || styleInput.type == "url") {
      str = "<input type=\"text\" class=\"style-item-input\" style=\"width:";
      str += styleInput.width ? styleInput.width : "240px";
      str += ";\"  maxlength=\"";
      str += styleInput.maxLength ? styleInput.maxLength : "300";
      str += "\"";
      if(value) str += " value=\""+value.replace("url(","").replace(")", "")+"\"";
      str += " />"; 
    } else if(styleInput.type == "select") {
      str = "<select class=\"style-item-input\">";
      str += "<option></option>";
      if(styleInput.options) {
        for(var i=0;i<styleInput.options.length;i++) {
          let val = "",txt= "";
          if( typeof(styleInput.options[i]) == "string" ) {
            val = styleInput.options[i];
            txt = val;
          } else if(styleInput.options[i] instanceof Array) {
            if(styleInput.options[i].length>0) val = styleInput.options[i][0];
            if(styleInput.options[i].length>1) txt = styleInput.options[i][1];
            if(styleInput.options[i].length==1) txt = val;
          } else if(typeof styleInput.options[i] == 'object') {
            if(styleInput.options[i].value) val = styleInput.options[i].value;
            if(styleInput.options[i].text) {
              txt = styleInput.options[i].text;
            } else {
              txt = val;
            }
          }
          str += "<option value=\""+val+"\"";
          if(val==value) str += " selected";
          str += ">"+txt+"</option>";
        }
      }
      str += "</select>";
    } else if(styleInput.type == "switch") {
      str += "<div class=\"style-item-input switch\"><div";
      if(value==styleInput.value) str += " style=\"float: right; background-color:#0099ff;\"";
      str += "></div></div>";
    } else if(styleInput == "color" || styleInput.type == "color") {
      str += "<div class=\"color-picker style-item-input\" style-item-value=\""
        + (value ? value: "") +"\"";
      if(value) str += " style=\"background-color:"+value+";\" value=\""+value+"\"";
      str += "></div>";
    }
    return str;
  };

  this.addStyleItem = function(styleType, styleVal, isNew) {
    if(styleType=="extend") {
      openDialog("添加样式", "taskbuilder-tfp-designer/addExtendStyle.html", "360px", "180px", null, function(style) {
        that.addStyleItem(style.name, style.value);
      });
      return;
    }
    let divStyleDesigner = $("#divCSS_setting_content");
    if(!styleVal && divStyleDesigner.find("[style-type='"+styleType+"']").length>0) return;
    if(divStyleDesigner.find(".divCSS_setting_hint").length>0) divStyleDesigner.html("");
    //获得背景颜色
    let bgColor = "";
    let styleInfo = this.styles[styleType];
    let isExtend = false;
    if(!styleInfo) {
      styleInfo = {
        name: styleType,
        comment: styleType,
        icon: "images/morestyle.png",
        inputs: ["string"]
      };
      bgColor = "#666666";
      isExtend = true;
    } else {
      for(var i=0;i<CSSTypeInfo.length;i++) {
        let categoryStyle = CSSTypeInfo[i];
        if(categoryStyle.name==styleInfo._cname) {
          bgColor = categoryStyle.color;
          break;
        }
      }
    }
    let styleItemHtml = "<div class=\"cssEditor-style-row\">"
      +"<div class=\"cssEditor-style-item\" style-type=\""+styleInfo.name
      +"\" style=\"background-color:"+bgColor+";\"><img src=\""+styleInfo.icon
      +"\"/><label>"+styleInfo.comment+"</label>";
    if(styleInfo.inputs) {
      let vals = [];
      if(styleVal) vals = (styleVal+"").trim().split(" ");
      for(var i=0;i<styleInfo.inputs.length;i++) {
        if(vals.length>i) {
          styleItemHtml += this.getStyleInputHtml(styleInfo.inputs[i], vals[i]);
        } else {
          styleItemHtml += this.getStyleInputHtml(styleInfo.inputs[i]);
        }
      }
    }
    styleItemHtml += "</div><img src=\"images/delete_16_red.png\" class=\"del-img\" "
      +"onclick=\"cssEditor.deleteStyleItem($(this).prev())\" title=\"删除\" /></div>";
    divStyleDesigner.append(styleItemHtml);

    if(isExtend) this.setStyleValue(styleType, styleVal);

    let newStyleItem = divStyleDesigner.find(".cssEditor-style-item").last();

    if(isNew) {
      that.unSelectStyleItem();
      newStyleItem.parent().find(".del-img").show();
      newStyleItem.css("outline", "1px solid #ffcc00");
    }

    newStyleItem.click(function() {
      //uiDesigner.hidePopDiv();
      var e = window.event;
      e.stopPropagation();

      that.unSelectStyleItem();

      $(this).parent().find(".del-img").show();
      $(this).css("outline", "1px solid #ffcc00");
    });

    newStyleItem.find("input").change(function() {
      that.setStyleItemValue($(this).parent());
    });

    newStyleItem.find("select").change(function() {
      that.setStyleItemValue($(this).parent());
    });

    newStyleItem.find(".switch").click(function() {
      let styleType = $(this).parent().attr("style-type");
      let styleTypeInfo = that.styles[styleType];
      if($(this).find("div").css("float")=="left") {
        $(this).find("div").css("float", "right");
        $(this).find("div").css("background-color", "#0099ff");
        that.setStyleValue(styleType, styleTypeInfo.inputs[0].value);
      } else {
        $(this).find("div").css("float", "left");
        $(this).find("div").css("background-color", "#999999");
        that.setStyleValue(styleType, "");
      }
    });

    //设置颜色选择器
    newStyleItem.find(".color-picker").click(function() {
      let styleType = $(this).parent().attr("style-type");
      colorPicker.show($(this), function(color) {
        that.setStyleValue(styleType, color);
      });
    });
  };

  this.getStyleInputValue = function(styleItem, styleInput, index) {
    let styleVal= "";
    let ipt = styleItem.find(".style-item-input").eq(index);
    if(styleInput=="string" || styleInput=="number"
      || styleInput.type=="string" || styleInput.type=="number"
      || styleInput.type=="select") {
      styleVal = ipt.val().trim();
    } else if(styleInput=="px" || styleInput.type=="px") {
      styleVal = ipt.val().trim();
      if(styleVal=="") styleVal = "0";
      if(styleVal!="0") styleVal += "px";
    } else if(styleInput=="em" || styleInput.type=="em") {
      styleVal = ipt.val().trim();
      if(styleVal=="") styleVal = "0";
      if(styleVal!="0") styleVal += "em";
    } else if(styleInput=="cm" || styleInput.type=="cm") {
      styleVal = ipt.val().trim();
      if(styleVal=="") styleVal = "0";
      if(styleVal!="0") styleVal += "cm";
    } else if(styleInput=="px|%" || styleInput.type=="px|%") {
      styleVal = ipt.val().trim();
      if(styleVal!="") styleVal += ipt.next().val();
    } else if(styleInput == "url" || styleInput.type == "url") {
      styleVal = ipt.val().trim();
      if(styleVal!="") styleVal = "url("+styleVal+")";
    } else if(styleInput.type=="color") {
      if(ipt.attr("value")) styleVal = ipt.attr("value").toUpperCase();
    }
    return styleVal;
  };

  this.setStyleItemValue = function(styleItem) {
    let styleType = styleItem.attr("style-type");
    let styleVal = "";
    let styleTypeInfo = this.styles[styleType];
    //如果是扩展样式
    if(!styleTypeInfo) {
      styleVal = styleItem.find("input").val().trim();
      this.setStyleValue(styleType, styleVal);
      return;
    }
    if(styleTypeInfo.inputs) {
      for(var i=0;i<styleTypeInfo.inputs.length;i++) {
        let styleInput = styleTypeInfo.inputs[i];
        if(i>0 && !styleInput.noSpace) styleVal += " ";
        let val = this.getStyleInputValue(styleItem, styleInput, i);
        if(val=="" && styleTypeInfo.inputs.length>1) return;
        styleVal += val;
      }
    }
    this.setStyleValue(styleType, styleVal);
  };

  this.setStyleValue = function(styleType, styleVal) {
    if(!tfp.curPage.dataModel.styleSheets) tfp.curPage.dataModel.styleSheets = [];
    let styleSheet = this.getStyleSheet(this.curStyleSheet);
    if(!styleSheet) {
      styleSheet = {
        id: this.curStyleSheet,
        styles: []
      };
      tfp.curPage.dataModel.styleSheets.push(styleSheet);
    }
    let style = null;
    for(var i=0;i<styleSheet.styles.length;i++) {
      let s = styleSheet.styles[i];
      if(s.name==styleType) {
        if(styleVal!="") {
          s.value = styleVal;
          style = s;
        } else {
          styleSheet.styles.splice(i, 1);
        }
        break;
      }
    }
    if(!style && styleVal!="") {
      style = {
        name: styleType,
        value: styleVal
      };
      styleSheet.styles.push(style);
    }
    this.setStyleCode(styleSheet);
    this.setCurPageStyle();
  };

  this.setStyleCode = function(styleSheet) {
    let code = styleSheet.id+" {\r\n";
    for(var i=0;i<styleSheet.styles.length;i++) {
      let style = styleSheet.styles[i];
      code += "\t"+style.name+": "+style.value+";\r\n";
    }
    code += "}";
    this.editor.setValue(code);
  };

  this.getStyleSheet = function(id) {
    if(!tfp.curPage.dataModel.styleSheets) return null;
    for(var i=0;i<tfp.curPage.dataModel.styleSheets.length;i++) {
      let styleSheet = tfp.curPage.dataModel.styleSheets[i];
      if(styleSheet.id==id) return styleSheet;
    }
    return null;
  };

  this.deleteStyleItem = function(styleItem, isMutiSelect) {
    let styleType = styleItem.attr("style-type");
    styleItem.parent().remove();
    let styleSheet = this.getStyleSheet(this.curStyleSheet);
    if(styleSheet.styles) {
      for(var i=0;i<styleSheet.styles.length;i++) {
        let style = styleSheet.styles[i];
        if(style.name==styleType) {
          styleSheet.styles.splice(i, 1);
          break;
        }
      }
    }
    if(!isMutiSelect) this.setCurPageStyle();
    this.setStyleCode(styleSheet);
  };

  this.deleteSelectedStyleItem = function() {
    $("#divCSS_setting_content").find(".del-img:visible").each(function() {
      that.deleteStyleItem($(this).prev(), true);
    });
    this.setCurPageStyle();
  };

  this.selectStyleItem = function(styleType) {
    let styleItem = $("[style-type='"+styleType+"']");
    styleItem.parent().find(".del-img").show();
    styleItem.css("outline", "1px solid #ffcc00");
  }

  this.unSelectStyleItem = function() {
    $("#divCSS_setting_content").find(".del-img").hide();
    $("#divCSS_setting_content").find(".cssEditor-style-item").css("outline", "");
  };

  this.deleteStyleSheet = function(divStyleSheet) {
    let styleSheetId = divStyleSheet.attr("style-sheet");
    divStyleSheet.remove();
    if(styleSheetId==this.curStyleSheet) {
      this.curStyleSheet = null;
      $("#iptCurStyleSelector").val("");
      $("#divCSS_top").hide();
      $("#divCSS_split_top").hide();
      $("#divCSS_lib").hide();
      $("#divCSS_setting_content").html("");
      $("#divCSS_setting").hide();
      $("#divCSS_code").hide();
      this.editor.setValue("");
    }
    if(!tfp.curPage.dataModel.styleSheets) return;
    for(var i=0;i<tfp.curPage.dataModel.styleSheets.length;i++) {
      let styleSheet = tfp.curPage.dataModel.styleSheets[i];
      if(styleSheet.id==styleSheetId) {
        tfp.curPage.dataModel.styleSheets.splice(i, 1);      
        this.setCurPageStyle();
        return;
      }
    }
  };

  this.updateStyleSheetId = function() {
    let newId = $("#iptCurStyleSelector").val().trim();
    if(newId=="") {
      showMsg("样式规则不能为空！");
      $("#iptCurStyleSelector").val(this.curStyleSheet);
      return;
    }
    for(var i=0;i<tfp.curPage.dataModel.styleSheets.length;i++) {
      let styleSheet = tfp.curPage.dataModel.styleSheets[i];
      if(newId==styleSheet.id && newId!=this.curStyleSheet) {
        showMsg("样式规则已存在！");
        return;
      }
    }
    for(var i=0;i<tfp.curPage.dataModel.styleSheets.length;i++) {
      let styleSheet = tfp.curPage.dataModel.styleSheets[i];
      if(styleSheet.id==this.curStyleSheet) {
        styleSheet.id = newId;
        this.setStyleCode(styleSheet);
        break;
      }
    }
    let curStyleSheetDiv = $("[style-sheet='"+this.curStyleSheet+"']");
    this.curStyleSheet = newId;
    if(curStyleSheetDiv.length==0) return;
    curStyleSheetDiv.find("div").html(newId);
    curStyleSheetDiv.attr("style-sheet", newId);

    this.setCurPageStyle();
  };

  this.addLinkCss = function(filePath) {
    $("#cssEditor_link_styles").append("<div css-link=\""+filePath
      +"\"><div style=\"color:#0099FF;\">·&nbsp;"+top.taskBuilder.getFileName(filePath)+"</div>"
      +"<img src=\"images/del.png\" style=\"float:right;margin-left:0;"
      +"margin-top:4px;display:none;\" title=\"删除\" onclick=\""
      +"cssEditor.deleteLinkCss($(this).parent())\"></div>");

    let newDiv = $("#cssEditor_link_styles").find("[css-link]").last();

    newDiv.click(function() {
      openPage(top.taskBuilder.getFileName(filePath), "taskbuilder-code-editor/index.html?type=css&path=/web"+filePath);
    });

    newDiv.mouseover(function() {
      $(this).find("img").show();
    });

    newDiv.mouseout(function() {
      $(this).find("img").hide();
    });
  };

  this.addNewLinkCss = function() {
    var e = window.event;
    e.stopPropagation();

    let args = {
      fileTypes: ["css"]
    };

    openDialog("添加外部样式文件", "taskbuilder-tfp-designer/PathPicker.html", "480px", "480px", 
      JSON.stringify(args), function(filePath) {

      if(filePath.startsWith("/web/")) filePath = filePath.substr(4);

      if(tfp.curPage.dataModel.cssFiles) {
        for(var i=0;i<tfp.curPage.dataModel.cssFiles.length;i++) {
          let cssFile = tfp.curPage.dataModel.cssFiles[i];
          if(cssFile==filePath) {
            showMsg("该样式文件已添加关联！");
            return;
          }
        }
      }

      if(!tfp.curPage.dataModel.cssFiles) tfp.curPage.dataModel.cssFiles = [];
      tfp.curPage.dataModel.cssFiles.push(filePath);
      
      that.addLinkCss(filePath);

      uiDesigner.pageFrameWin.$("head").append(
        "<link rel=\"stylesheet\" type=\"text/css\" href=\""+tfp.getUrlRealPath(filePath)+"\">");
    });
  };

  this.deleteLinkCss = function(divCSSLink) {
    let filePath = divCSSLink.attr("css-link");
    divCSSLink.remove();
    if(tfp.curPage.dataModel.cssFiles) {
      for(var i=0;i<tfp.curPage.dataModel.cssFiles.length;i++) {
        let cssFile = tfp.curPage.dataModel.cssFiles[i];
        if(cssFile==filePath) {
          tfp.curPage.dataModel.cssFiles.splice(i, 1);
          uiDesigner.pageFrameWin.$("head").find("link[href='"+filePath+"']").remove();
          return;
        }
      }
    }
  };

  this.addFrameworkCss = function(url) {
    $("#cssEditor_framework_styles").append("<div css-link=\""+url
      +"\" style=\"color:#0099FF;\">&nbsp;·&nbsp;"+top.taskBuilder.getFileName(url)+"</div>");
    let newDiv = $("#cssEditor_framework_styles").find("[css-link]").last();
    newDiv.click(function() {
      openPage(top.taskBuilder.getFileName(url), "taskbuilder-code-editor/index.html?type=css&path="+url+"&readonly=true");
    });
  };
};

var cssEditor = new CSSEditor();