
function onResize() {
	uiDesigner.onResize();
}

function TFPDesigner() {
	this.curTFPFilePath = null;
	this.curDesignerId = "UI";
	this.tfpSrcCodeIsChanged = false;
	this.editorTFPSrc = null;
	this.ternServer = null;
	this.mouseInfo = {
		downX: 0,
		downY: 0,
		isDrag: false,
		input: null
	};

	var that = this;

	/***************************************** 加载TFP ******************************************/
  
  /**
   * 加载TFP文件
   * @return {[type]} [description]
   */
	this.loadTFP = function () {
		this.curTFPFilePath = getUrlArg("path");
		//如果是远程TFP
		if (this.curTFPFilePath.startsWith("/web/app/")) {
			window.parent.taskBuilder.requestByIPC(
				"dev/service/proj/getFileContent", 
				{ filePath: this.curTFPFilePath }, 
				function (req, res) {
				if (res.code != 0) {
					showMsg(res.message);
					return;
				}
				uiDesigner.init(JSON.parse(res.data));
			});
		} else {  //如果是本地TFP
			try {
			  let tfpData = tb.readFileSync(this.curTFPFilePath);
			  uiDesigner.init(JSON.parse(tfpData));
		  } catch(err) {
		  	console.log(err);
		  	showMsg(err.message);
		  }
		}
	}

	/**
	 * 获得当前TFP文件的源码，去掉设计时临时增加的一些属性
	 * @return {[type]} [description]
	 */
	this.getCurTFPSrc = function () {
		return JSON.stringify(tfp.curPage.dataModel, null, "\t");
	}

	this.showDesigner = function(designerId) {
		if (designerId == this.curDesignerId) return;
		if(this.curDesignerId=="TFPSrc" && this.tfpSrcCodeIsChanged) {
			let tfpObj = null;
			try {
				let tfpCode = this.editorTFPSrc.getValue()+"";
				tfpObj = JSON.parse(tfpCode); 
			} catch(err) {
				showMsg("解析TFP代码失败："+err.message);
				console.error(err.message);
				return;
			}
			uiDesigner.pageFrameWin.$("body").empty();
			$("#uiDesignerInvisibleCpts").empty();
			var divCptList = $("#uiDesignerLeftBar").find(".OptionPage").eq(1);
			divCptList.empty();
			tfp.components = {};
			tfp.loadPage(tfpObj);
			this.tfpSrcCodeIsChanged = false;
		}
		$("#div" + this.curDesignerId).hide();
		$("#bottomBar" + this.curDesignerId).css("background-color", "");
		$("#bottomBar" + this.curDesignerId).css("color", "#AAAAAA");
		this.curDesignerId = designerId;
		if (!this.ternServer) this.ternServer = new CodeMirror.TernServer({ defs: [jsdefs] });
		if (designerId == "TFPSrc") {
			if (!this.editorTFPSrc) {
				let options = {
					mode: "javascript",
					lineNumbers: true,
					styleActiveLine: true,
					matchBrackets: true,
					selectionPointer: true,
					keyMap: "sublime",
					foldGutter: true,
					autoCloseBrackets: true,
					autofocus: true,
					gutters: ["CodeMirror-lint-markers", "CodeMirror-linenumbers", "CodeMirror-foldgutter"],
					hintOptions: { completeSingle: false }
				};
				this.editorTFPSrc = CodeMirror(document.getElementById("divTFPSrc"), options);
				$("#divTFPSrc").find(".CodeMirror").css("width", "100%");
				$("#divTFPSrc").find(".CodeMirror").css("height", (document.documentElement.clientHeight - 64) + "px");

				CodeMirror.on(this.editorTFPSrc, 'change', function (instance, object) {
					if(that.editorTFPSrc.isSetValue) {
						that.tfpSrcCodeIsChanged = true;
					}
					var str = object.text[0];
					if (str.length == 1 && /^[a-zA-Z.]+$/.test(str) && str != "u" && str != "U") {
						CodeMirror.showHint(that.editorTFPSrc, CodeMirror.hint.custom);
						if (str == ".") that.ternServer.complete(that.editorTFPSrc);
					}
				});
				this.editorTFPSrc.setOption("theme", "monokai");
				this.editorTFPSrc.setOption("extraKeys", {
					"Ctrl-I": function (cm) { this.ternServer.showType(cm); },
					"Ctrl-O": function (cm) { this.ternServer.showDocs(cm); },
					"Alt-.": function (cm) { this.ternServer.jumpToDef(cm); },
					"Alt-,": function (cm) { this.ternServer.jumpBack(cm); },
					"Ctrl-Q": function (cm) { this.ternServer.rename(cm); },
					"Ctrl-.": function (cm) { this.ternServer.selectName(cm); },
					"Ctrl-S": function (cm) { tfpDesigner.save(); }
				});
				this.editorTFPSrc.on("cursorActivity", function (cm) { that.ternServer.updateArgHints(cm); });
			}
			$("#div" + designerId).show();
			this.editorTFPSrc.isSetValue = false;
			this.editorTFPSrc.setValue(this.getCurTFPSrc());
			this.editorTFPSrc.isSetValue = true;
		} else if (designerId == "HTML") {
			if (!this.editorHTML) {
				let mode = {
					name: "htmlmixed",
					scriptTypes: [{
						matches: /\/x-handlebars-template|\/x-mustache/i,
						mode: null
					},
					{
						matches: /^(?:text|application)\/(?:x-)?(?:java|ecma)script$|^$/i,
						mode: "javascript"
					}]
				};
				let options = {
					mode: mode,
					lineNumbers: true,
					styleActiveLine: true,
					matchBrackets: true,
					selectionPointer: true,
					keyMap: "sublime",
					foldGutter: true,
					autoCloseBrackets: true,
					autofocus: true,
					gutters: ["CodeMirror-lint-markers", "CodeMirror-linenumbers", "CodeMirror-foldgutter"],
					hintOptions: { completeSingle: false },
					matchTags: true,
					autoCloseTags: true,
					readOnly: true
				};
				this.editorHTML = CodeMirror(document.getElementById("divHTML"), options);
				this.editorHTML.setOption("theme", "monokai");
				$("#divHTML").find(".CodeMirror").css("width", "100%");
				$("#divHTML").find(".CodeMirror").css("height", (document.documentElement.clientHeight - 64) + "px");
			}
			$("#div" + designerId).show();
			window.parent.taskBuilder.requestByIPC(
				"dev/service/tfp/getHtml", 
				{ 
					pagePath: this.curTFPFilePath, 
					pageDataModel: tfp.curPage.dataModel
				}, 
				function (req, res) {
				if (res.code != 0) {
					showMsg(res.message);
					return;
				}
				//console.log(tfpHtml);
			  that.editorHTML.setValue(res.html);
			});
		} else if (designerId == "JS") {
			if (!jsEditor.isInit) {
				jsEditor.init();
			}
			$("#div" + designerId).show();
		} else if (designerId == "CSS") {
			if (!cssEditor.isInit) {
				cssEditor.loadStylesLib();
			}
			$("#div" + designerId).show();
		} else if (designerId == "UI") {
			$("#div" + designerId).show();
		}

		$("#bottomBar" + this.curDesignerId).css("background-color", "#444444");
		$("#bottomBar" + designerId).css("color", "#FFFFFF");
	}

	/****************************************** 保存TFP *******************************************/

	/**
	 * 保存TFP
	 */
	this.save = function (cb) {
		//保存JS脚本
		if (jsEditor.isInit && jsEditor.curFunc) {
			jsEditor.saveCode();
		}
		if (this.curTFPFilePath.startsWith("/web/app/")) {
			window.parent.taskBuilder.requestByIPC("dev/service/proj/saveFileContent", {
				filePath: this.curTFPFilePath,
				data: this.getCurTFPSrc()
			},
			function (req, res) {
				if (res.code != 0) {
					showMsg(res.message);
					return;
				}
				//that.createHtmlFile();
				showMsg("保存成功！");
				if(cb) cb();
			});
		} else {
			try {
			  tb.saveFile(this.curTFPFilePath, JSON.stringify(tfp.curPage.dataModel, null, "\t"));
			  showMsg("保存成功！");
				if(cb) cb();
		  } catch(err) {
		  	console.log(err);
		  	showMsg(err.message)
		  }
		}
	}

	this.saveAs = function (saveType) {
    if(saveType=="server") {
    	let args = {
				path: this.curTFPFilePath,
				filename: tb.getFileName(this.curTFPFilePath),
				onlyDir: true,
				listClientFile: true
			};
			openDialog("选择保存路径", "taskbuilder-tfp-designer/PathPicker.html", "480px", "480px",
			  JSON.stringify(args), function (ret) {
				console.log(ret);
			});
    } else {
    	tb.showSaveFileDialog({
				defaultPath: tb.getFileName(this.curTFPFilePath),
				filters: [
					{ name: 'tfp', extensions: ['tfp'] },
					{ name: 'html', extensions: ['html'] }
				]
			}, function (filename) {
				if (!filename) return;
				if (filename.toLowerCase().endsWith(".tfp")) {
					tb.saveFile(filename, JSON.stringify(tfp.curPage.dataModel, null, "\t"));
				  showMsg("保存完毕。");
				} else {
					tb.requestByIPC( "dev/service/tfp/getHtml", 
						{ 
							pagePath: that.curTFPFilePath, 
							pageDataModel: tfp.curPage.dataModel
						}, 
						function (req, res) {
						if (res.code != 0) {
							showMsg(res.message);
							return;
						}
						tb.saveFile(filename, res.html);
						showMsg("保存完毕。");
					});
				}
			});
		}
	}

	this.preview = function () {
		let that = this;
		this.save(function() {
			if (tfp.curPage.client == "tb") {
				if (tfp.curPage.pagetype == "dialog") {
					openDialog(tfp.curPage.title, that.curTFPFilePath,
						tfp.curPage.width, tfp.curPage.height);
				} else {
					openPage(tfp.curPage.title, that.curTFPFilePath);
				}
			} else {
				tb.showPreviewWindow(tfp.curPage.client, that.curTFPFilePath.substr(4));
			}
		});
	}

	this.createHtmlFile = function () {
		let tfpHtml = tfp.curPage.getHtml(); //this.compiler.compile(this.uiFramework, this.uiFramework.tfp, this.curTFPFilePath);
		window.parent.taskBuilder.requestByIPC(
			"dev/service/proj/saveFileContent", 
			{ filePath: this.curTFPFilePath + ".html", data: tfpHtml }, 
			function (req, res) {
			if (res.code != 0) {
				showMsg(res.message);
				return;
			}
			showMsg("保存成功！");
		});
	}

	this.toggleCategoryItems = function (categoryId, ele) {
		$("#" + categoryId).toggle("fast");
		let imgIcon = $(ele).find("img").eq(0);
		if (imgIcon.attr("src") == "../taskbuilder-renderer/images/arrow/down.png") {
			imgIcon.attr("src", "../taskbuilder-renderer/images/arrow/right.png");
		} else {
			imgIcon.attr("src", "../taskbuilder-renderer/images/arrow/down.png");
		}
	}

	this.maskDivOnClick = function() {
		this.hidePopMenu();
		let havePopDiv = false;
		$(".pop-div").each(function() {
			if($(this).is(":visible")) {
				havePopDiv = true;
				return false;
			}
		});
		if(havePopDiv) return;
		$("#maskDiv").hide();
	}

	this.hidePopMenu = function() {
		var popMenu = $("#popMenu");
		popMenu.hide();
		popMenu.empty();
	}

	this.showPopMenu = function(options, cb) {
		var srcEl = event.srcElement;
		if(srcEl.tagName!="DIV") srcEl = $(srcEl).parent().get(0);
		var popMenu = $("#popMenu");
		popMenu.empty();
		popMenu.css("top", ($(srcEl).offset().top+$(srcEl).height()+6)+"px");
		popMenu.css("left", $(srcEl).offset().left+"px");
		let width = "80px";
		if(options.width) width = options.width;
		if((width+"").indexOf("px")<0) width = width+"px";
		popMenu.css("width", width);
		let height = (options.items.length*30+20)+"px";
		if(options.height) height = options.height;
		if((height+"").indexOf("px")<0) height = height+"px";
		popMenu.css("height", height);
		if(options.allowNull) {
			popMenu.append("<div class=\"menu-item\" data-value=\"\"><span></span></div>");
		}
		for(var i=0;i<options.items.length;i++) {
			var item = options.items[i];
			var itemHtml = "<div class=\"menu-item\" data-value=\""+item.value+"\">";
			if(options.notCheck) {
				itemHtml += "&nbsp;";
			} else {
				if(options.value==item.value) {
				  itemHtml += "<div>√</div>";
			  } else {
			  	itemHtml += "<div></div>";
			  }
			}
		  if(options.showIcon) {
		  	itemHtml += "<div class=\"menu-icon\">";
		  	if(item.icon) itemHtml += "<img src=\""+item.icon+"\" />";
		  	itemHtml += "</div>";
		  }
		  itemHtml += "<span>"+item.text+"</span>";
		  itemHtml += "</div>";
		  popMenu.append(itemHtml);
		}
		$("#maskDiv").show();
		popMenu.show();
		popMenu.children("div").click(function() {
			var val = $(this).attr("data-value");
			var text = $(this).find("span").text();
			that.hidePopMenu();
			$("#maskDiv").hide();
			event.stopPropagation();
			if(cb) cb(val, text);
		});
		event.stopPropagation();
	}

	this.showSaveAsMenu = function() {
		tfpDesigner.showPopMenu({
			width: "80px", 
			notCheck: true,
			items: [{
				value: "server",
				text: "另存"
			},{
				value: "local",
				text: "另存到本地"
			}]
		}, function(val) {
			that.saveAs(val);
		});
	}

	this.onKeyDown = function(keyCode, ctrlKey, which) {
		if (this.curDesignerId != "UI" 
      || $("#popMenu:visible").length>0
      || $("#maskDiv:visible").length>0) return;
    if (keyCode == 67 && ctrlKey) {
      uiDesigner.copyCpts();
      return;
    }
    if (keyCode == 88 && ctrlKey) {
      uiDesigner.cutCpts();
      return;
    }
    if (keyCode == 86 && ctrlKey) {
      uiDesigner.pasteCpts();
      return;
    }
    if (which == 8) {
      if (uiDesigner.curSelectedCptId || uiDesigner.selectedCpts.length > 0) {
        //confirm("确定删除？", function() {
        uiDesigner.delCpts();
        //});
      }
    } else if (which == 38) {  //向上键
      uiDesigner.moveSelectedCpt("up");
    } else if (which == 40) {  //向下键
      uiDesigner.moveSelectedCpt("down");
    } else if (which == 37) {  //向左键
      uiDesigner.moveSelectedCpt("left");
    } else if (which == 39) {  //向右键
      uiDesigner.moveSelectedCpt("right");
    }
	}
}

var tfpDesigner = new TFPDesigner();

$(function() {

	colorPicker.init();

	$(".border-style").click(function() {
		uiDesigner.showBoderStyleType();
	});

	tfpDesigner.loadTFP();

	document.onmousemove = function () {
		if (!tfpDesigner.mouseInfo.dragType) return;
		var e = window.event;
		if (!tfpDesigner.mouseInfo.isDrag && (tfpDesigner.mouseInfo.downX != e.clientX
			|| tfpDesigner.mouseInfo.downY != e.clientY)) {
			tfpDesigner.mouseInfo.isDrag = true;
		}
		if (!tfpDesigner.mouseInfo.isDrag) return;
		if (tfpDesigner.mouseInfo.dragType == "MoveComponent") {
			if (uiDesigner.selectedCpts.contains(tfpDesigner.mouseInfo.cptId)) {
				for (var i = 0; i < uiDesigner.selectedCpts.length; i++) {
					uiDesigner.dragCpt(e, uiDesigner.selectedCpts[i], tfpDesigner.mouseInfo.offset[i]);
				}
			} else {
				uiDesigner.dragCpt(e, tfpDesigner.mouseInfo.cptId, tfpDesigner.mouseInfo.offset[0]);
			}
		} else if (tfpDesigner.mouseInfo.dragType == "SelectComponent") {
			let divSelectComponent = $("#selectComponentsBox");
			divSelectComponent.css("width", (e.clientX - tfpDesigner.mouseInfo.downX) + "px");
			divSelectComponent.css("height", (e.clientY - tfpDesigner.mouseInfo.downY) + "px");
			if (!divSelectComponent.is(":visible")) {
				divSelectComponent.css("left", tfpDesigner.mouseInfo.downX + "px");
				divSelectComponent.css("top", tfpDesigner.mouseInfo.downY + "px");
				divSelectComponent.show();
			}
		} else {
			if (e.clientX - tfpDesigner.mouseInfo.downX > 5 || e.clientX - tfpDesigner.mouseInfo.downX < -5
				|| e.clientY - tfpDesigner.mouseInfo.downY > 5 || e.clientY - tfpDesigner.mouseInfo.downY < -5) {
				var x = e.clientX + 2;
				var y = e.clientY;
				$("#compoentDragging").css("left", x + "px");
				$("#compoentDragging").css("top", y + "px");
				$("#compoentDragging").show();
			}
		}
	}

	document.onmouseup = function () {
		if (!tfpDesigner.mouseInfo.dragType) return;
		var e = window.event;
		tfpDesigner.mouseInfo.isDrag = false;
		$("#compoentDragging").css("left", "0");
		$("#compoentDragging").css("top", "62px");
		$("#compoentDragging").hide();
		$("#compoentDragging").find("img").attr("src", "");
		$("#compoentDragging").find("img").text("");
		tfpDesigner.mouseInfo.downX = 0;
		tfpDesigner.mouseInfo.downY = 0;
		var e = window.event;
		var srcEl = e.srcElement;
		//如果不是在设计器中间区域松开鼠标，则不添加组件
		if (tfpDesigner.mouseInfo.dragType == "CreateComponent") {
			if($(srcEl).attr("id")=="uiDesignerInvisibleCpts") {
				let cptType = tfpDesigner.mouseInfo.cptType;
				let cptMetaData = tfp.type(cptType);
				//如果是不可视组件
	      if (cptMetaData.isInvisible) {
	        tfp.use(cptType, function() {
	          let cpt = tfp.new(cptType, tfp.curPage);
	          if(!cpt) return;
	          uiDesigner.selectCpt(cpt.id);
	          window.focus();
	        });
	      }
			}
      tfpDesigner.mouseInfo.dragType = null;
			tfpDesigner.mouseInfo.cptType = null;
		} else if (tfpDesigner.mouseInfo.dragType == "CreateStyle") {
			tfpDesigner.mouseInfo.dragType = null;
			let divStyleDesigner = $(srcEl);
			if (divStyleDesigner.attr("id") != "divCSS_setting_content") {
				tfpDesigner.mouseInfo.styleType = null;
				return;
			}
			cssEditor.addStyleItem(tfpDesigner.mouseInfo.styleType, null, true);
			tfpDesigner.mouseInfo.styleType = null;
		} else if (tfpDesigner.mouseInfo.dragType == "CreateFunc") {
			tfpDesigner.mouseInfo.dragType = null;
			if ($(srcEl).parents("#divJS_code").length == 0) {
				tfpDesigner.mouseInfo.styleType = null;
				return;
			}
			jsEditor.addLibFunc($(srcEl), tfpDesigner.mouseInfo.funcName);
			tfpDesigner.mouseInfo.funcName = null;
		}
	}

  /*$("body").keyup(function (event) {
  	if(event.which==8) {
  		let iptId = $(event.target).attr("id");
  		if(!iptId || !tfp.components[iptId]) return;
    }
    tfpDesigner.onKeyDown(event.keyCode, event.ctrlKey, event.which);
  });*/
});