"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * 按钮组件
 * @param {[type]} dataModel [description]
 */
var Button = /*#__PURE__*/function (_VisibleComponent) {
  _inherits(Button, _VisibleComponent);

  var _super = _createSuper(Button);

  function Button(__tfp, dataModel, parent) {
    _classCallCheck(this, Button);

    return _super.call(this, __tfp, "Button", dataModel, parent);
  } //属性


  _createClass(Button, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.find("label").text(value);

        this.exeEventHandler("onChange");
      }
    }
  }, {
    key: "buttonType",
    get: function get() {
      return this.dataModel.buttonType;
    },
    set: function set(value) {
      var buttonType = "default";
      if (value) buttonType = value;

      if (!this.checkAttrOption("buttonType", buttonType)) {
        this._tfp.showMsg("按钮组件不支持类型：" + buttonType + "！");

        return;
      }

      this.dataModel.buttonType = buttonType;

      if (this._jqObj) {
        this._jqObj.removeClass("tfp-button-default tfp-button-primary tfp-button-info" + " tfp-button-warning tfp-button-success tfp-button-danger");

        this._jqObj.removeClass("tfp-button-default-plain tfp-button-primary-plain tfp-button-info-plain" + " tfp-button-warning-plain tfp-button-success-plain tfp-button-danger-plain");

        if (this.plain) {
          this._jqObj.addClass("tfp-button-" + buttonType + "-plain");
        } else {
          this._jqObj.addClass("tfp-button-" + buttonType);
        }
      }
    }
  }, {
    key: "theme",
    get: function get() {
      return this.dataModel.theme;
    },
    set: function set(value) {
      var theme = "rect";
      if (value) theme = value;

      if (!this.checkAttrOption("theme", theme)) {
        this._tfp.showMsg("按钮组件不支持风格：" + theme + "！");

        return;
      }

      this.dataModel.theme = theme;

      if (this._jqObj) {
        this._jqObj.removeClass("tfp-button-round tfp-button-rect tfp-button-circle");

        this._jqObj.addClass("tfp-button-" + theme);
      }
    }
  }, {
    key: "plain",
    get: function get() {
      return this.dataModel.plain;
    },
    set: function set(value) {
      this.dataModel.plain = value ? true : false;

      if (this._jqObj) {
        this._jqObj.removeClass("tfp-button-default tfp-button-primary tfp-button-info" + " tfp-button-warning tfp-button-success tfp-button-danger");

        this._jqObj.removeClass("tfp-button-default-plain tfp-button-primary-plain tfp-button-info-plain" + " tfp-button-warning-plain tfp-button-success-plain tfp-button-danger-plain");

        var buttonType = this.buttonType;
        if (!buttonType) buttonType = "default";

        if (this.dataModel.plain) {
          this._jqObj.addClass("tfp-button-" + buttonType + "-plain");
        } else {
          this._jqObj.addClass("tfp-button-" + buttonType);
        }
      }
    }
  }, {
    key: "showImage",
    get: function get() {
      return this.dataModel.showImage;
    },
    set: function set(value) {
      this.dataModel.showImage = value ? true : false;

      if (this._jqObj) {
        if (value) {
          if (this._jqObj.find("img").length > 0) {
            this._jqObj.find("img").parent().show();

            return;
          }

          if (this._tfp.isDesigning) {
            uiDesigner.showAttrSettingRow("imageUrl");
            uiDesigner.showAttrSettingRow("imageWidth");
            uiDesigner.showAttrSettingRow("imageHeight");
            uiDesigner.showAttrSettingRow("portrait");
            uiDesigner.showAttrSettingRow("hiddenText");
          }

          var imgUrl = this.dataModel.imageUrl;

          if (!imgUrl) {
            imgUrl = this._tfp.rootPath + "/src/components/button/images/default-photo.png";
          } else if (this._tfp.isDesigning) {
            imgUrl = this._tfp.getUrlRealPath(imgUrl);
          }

          var imgWidth = 24;
          if (this.dataModel.imageWidth) imgWidth = this.dataModel.imageWidth;
          if ((imgWidth + "").indexOf("px") < 0) imgWidth += "px";
          var imgHeight = 24;
          if (this.dataModel.imageHeight) imgHeight = this.dataModel.imageHeight;
          if ((imgHeight + "").indexOf("px") < 0) imgHeight += "px";
          var imgHtml = "<img src=\"" + imgUrl + "\" style=\"width:" + imgWidth + ";height:" + imgHeight + ";margin-top:3px;margin-bottom:3px;\" />";
          $("<div style=\"float:left;display:block;\">" + imgHtml + "</div>").insertBefore(this._jqObj.find("label"));

          this._jqObj.find("label").css("margin-left", "7px");

          this._jqObj.find("label").css("line-height", this._jqObj.height() + "px");
        } else {
          this._jqObj.find("img").parent().remove();

          this.dataModel.portrait = false;
          this.dataModel.hiddenText = false;
          this.dataModel.imageUrl = "";
          this.dataModel.imageWidth = 24;
          this.dataModel.imageHeight = 24;

          this._jqObj.find("label").css("margin-left", "0");

          this._jqObj.find("label").css("line-height", "30px");

          this._jqObj.find("label").show();

          if (this._tfp.isDesigning) {
            uiDesigner.hideAttrSettingRow("imageUrl");
            uiDesigner.hideAttrSettingRow("imageWidth");
            uiDesigner.hideAttrSettingRow("imageHeight");
            uiDesigner.setCurCptAttrSettingVal("imageWidth", "24");
            uiDesigner.setCurCptAttrSettingVal("imageHeight", "24"); //window.parent.$("[attr-name=imageWidth]").find("input").val("24");
            //window.parent.$("[attr-name=imageHeight]").find("input").val("24");

            uiDesigner.setCurCptAttrSettingVal("portrait", false);
            uiDesigner.hideAttrSettingRow("portrait");
            uiDesigner.setCurCptAttrSettingVal("hiddenText", false);
            uiDesigner.hideAttrSettingRow("hiddenText");
          }
        }
      }
    }
  }, {
    key: "imageUrl",
    get: function get() {
      return this.dataModel.imageUrl;
    },
    set: function set(value) {
      this.dataModel.imageUrl = value;

      if (this._jqObj) {
        if (this._tfp.isDesigning && value) {
          this._jqObj.find("img").attr("src", this._tfp.getUrlRealPath(value));
        } else {
          this._jqObj.find("img").attr("src", value);
        }
      }
    }
  }, {
    key: "imageWidth",
    get: function get() {
      return this.dataModel.imageWidth;
    },
    set: function set(value) {
      this.dataModel.imageWidth = value;

      if (this._jqObj) {
        this._jqObj.find("img").attr("width", value);
      }
    }
  }, {
    key: "imageHeight",
    get: function get() {
      return this.dataModel.imageHeight;
    },
    set: function set(value) {
      this.dataModel.imageHeight = value;

      if (this._jqObj) {
        this._jqObj.find("img").attr("height", value);

        if (!this.portrait) this._jqObj.find("label").css("line-height", this._jqObj.find("img").height() + 6 + "px");
      }
    }
  }, {
    key: "hiddenText",
    get: function get() {
      return this.dataModel.hiddenText;
    },
    set: function set(value) {
      this.dataModel.hiddenText = value ? true : false;

      if (this._jqObj) {
        if (this._jqObj.find("label").length == 0) return;

        if (value) {
          this.portrait = false;
          uiDesigner.setCurCptAttrSettingVal("portrait", false);
          uiDesigner.hideAttrSettingRow("portrait");

          this._jqObj.find("img").css("margin-top", "3px");

          this._jqObj.find("label").hide();
        } else {
          this._jqObj.find("label").show();

          this._jqObj.find("div").css("float", "left");

          this._jqObj.find("div").css("width", "");

          this._jqObj.find("img").css("margin-top", "3px");

          this._jqObj.find("label").css("margin-left", "7px");

          this._jqObj.find("label").css("line-height", this._jqObj.find("img").height() + 6 + "px");

          uiDesigner.showAttrSettingRow("portrait");
        }
      }
    }
  }, {
    key: "portrait",
    get: function get() {
      return this.dataModel.portrait;
    },
    set: function set(value) {
      this.dataModel.portrait = value ? true : false;

      if (this._jqObj) {
        if (this._jqObj.find("div").length == 0) return;

        if (value) {
          this._jqObj.find("div").css("float", "none");

          this._jqObj.find("div").css("width", "100%");

          this._jqObj.find("img").css("margin-top", "10px");

          this._jqObj.find("label").css("margin-left", "0");

          this._jqObj.find("label").css("line-height", "30px");
        } else {
          this._jqObj.find("div").css("float", "left");

          this._jqObj.find("div").css("width", "");

          this._jqObj.find("img").css("margin-top", "3px");

          this._jqObj.find("label").css("margin-left", "7px");

          this._jqObj.find("label").css("line-height", this._jqObj.find("img").height() + 6 + "px");
        }
      }
    }
  }, {
    key: "title",
    get: function get() {
      return this.dataModel.title;
    },
    set: function set(value) {
      this.dataModel.title = value;

      if (this._jqObj) {
        this._jqObj.attr("title", value);
      }
    }
  }, {
    key: "labelHeight",
    get: function get() {
      if (this.dataModel.labelHeight) return this._tfp.getPixel(this.dataModel.labelHeight);
      return 30;
    },
    set: function set(value) {
      this.dataModel.labelHeight = value;

      if (this._jqObj) {
        var height = value;
        if ((height + "").indexOf("px") < 0) height += "px";

        this._jqObj.find("label").css("line-height", height);
      }
    }
  }, {
    key: "css",
    value: function css(styleName, styleValue) {
      _get(_getPrototypeOf(Button.prototype), "css", this).call(this, styleName, styleValue);

      if (styleName == "height") {
        if (this._jqObj && !this.showImage) {
          //this._jqObj.css("line-height", styleValue);
          this._jqObj.find("label").css("line-height", styleValue);
        }
      }
    }
  }]);

  return Button;
}(_controller.VisibleComponent);

exports["default"] = Button;