"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("./controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * 图表组件
 * @param {[type]} dataModel [description]
 */
var Chart = /*#__PURE__*/function (_VisibleComponent) {
  _inherits(Chart, _VisibleComponent);

  var _super = _createSuper(Chart);

  function Chart(__tfp, inputType, dataModel, parent) {
    _classCallCheck(this, Chart);

    return _super.call(this, __tfp, inputType, dataModel, parent);
  }

  _createClass(Chart, [{
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "showLegend",
    get: function get() {
      return this.dataModel.showLegend;
    },
    set: function set(value) {
      this.dataModel.showLegend = value ? true : false;
    }
  }, {
    key: "showLabel",
    get: function get() {
      return this.dataModel.showLabel;
    },
    set: function set(value) {
      this.dataModel.showLabel = value ? true : false;
    }
  }, {
    key: "showLabelLine",
    get: function get() {
      return this.dataModel.showLabelLine;
    },
    set: function set(value) {
      this.dataModel.showLabelLine = value ? true : false;
    }
  }, {
    key: "showLoading",
    get: function get() {
      return this.dataModel.showLoading;
    },
    set: function set(value) {
      this.dataModel.showLoading = value ? true : false;
    }
  }, {
    key: "animation",
    get: function get() {
      return this.dataModel.animation;
    },
    set: function set(value) {
      this.dataModel.animation = value ? true : false;
    }
  }, {
    key: "getDemoData",
    value: function getDemoData() {
      var data = {
        seriesData: []
      };

      if (this.type != "ChartPie" && this.type != "ChartAnnular") {
        var dataSet = this.dataModel.series;

        if (!dataSet || dataSet.length == 0) {
          if (this.type == "ChartLine") {
            data.series = [{
              name: "演示数据",
              type: "line"
            }];
          } else if (this.type == "ChartBar") {
            data.series = [{
              name: "演示数据",
              type: "bar"
            }];
          } else if (this.type == "ChartBarY") {
            data.series = [{
              name: "演示数据",
              type: "bar"
            }];
          } else if (this.type == "ChartLineBar") {
            data.series = [{
              name: "演示数据1",
              type: "line"
            }, {
              name: "演示数据2",
              type: "bar"
            }];
          }

          dataSet = data.series;
        }

        data.categoryData = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];

        for (var i = 0; i < dataSet.length; i++) {
          var itemData = [];

          for (var j = 0; j < 7; j++) {
            itemData.push(Math.ceil(Math.random() * 1000));
          }

          data.seriesData.push(itemData);
        }
      } else {
        data.seriesData = [{
          value: 1048,
          name: '搜索引擎'
        }, {
          value: 735,
          name: '直接访问'
        }, {
          value: 580,
          name: '邮件营销'
        }, {
          value: 484,
          name: '联盟广告'
        }, {
          value: 300,
          name: '视频广告'
        }];
      }

      return data;
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (!this.chart) this.chart = echarts.init(document.getElementById(this.id));
      var option = {
        series: []
      }; //if(this.dataModel.darkMode) option.darkMode = true;

      if (this.type != "ChartPie" && this.type != "ChartAnnular") {
        if (this.dataModel.showLegend) {
          option.legend = {
            data: []
          };
        } else {
          delete option["legend"];
        }

        option.grid = {
          left: "40px",
          right: "20px"
        };

        if (this.type == "ChartBarY") {
          option.yAxis = {
            type: 'category'
          };

          if (this._tfp.isDesigning) {
            option.yAxis.data = data.categoryData;
          } else {
            option.yAxis.data = [];
          }

          option.xAxis = {
            type: 'value'
          };
        } else {
          option.xAxis = {
            type: 'category'
          };

          if (this._tfp.isDesigning) {
            option.xAxis.data = data.data;
          } else {
            option.xAxis.data = [];
          }

          option.yAxis = {
            type: 'value'
          };
        }

        var dataSet = this.dataModel.series;
        if (!dataSet || dataSet.length == 0) dataSet = data.series;

        for (var i = 0; i < dataSet.length; i++) {
          var s = dataSet[i];
          if (this.dataModel.showLegend) option.legend.data.push(s.name);
          var item = {
            name: s.name
          };

          if (this.type == "ChartLine") {
            item.type = "line";
          } else if (this.type == "ChartBar" || this.type == "ChartBarY") {
            item.type = "bar";
          } else {
            item.type = s.type;
          }

          if (this.dataModel.stack) {
            item.stack = "total";
          } else {
            delete item["stack"];
          }

          if (this.dataModel.smooth) {
            item.smooth = true;
          } else {
            item.smooth = false;
          }

          if (this.dataModel.showArea) {
            item.areaStyle = {};
          } else {
            delete item["areaStyle"];
          }

          item.label = {
            show: true
          };
          if (!this.dataModel.showLabel) item.label.show = false;
          item.labelLine = {
            show: true
          };
          if (!this.dataModel.showLabelLine) item.labelLine.show = false;

          if (this._tfp.isDesigning) {
            item.data = data.seriesData[i];
          } else {
            item.data = [];
          }

          option.series.push(item);
        }

        if (!this._tfp.isDesigning && this.dataModel.categoryField) {
          for (var i = 0; i < data.length; i++) {
            var rowData = data[i];

            if (this.type == "ChartBarY") {
              option.yAxis.data.push(rowData[this.dataModel.categoryField]);
            } else {
              option.xAxis.data.push(rowData[this.dataModel.categoryField]);
            }

            for (var j = 0; j < dataSet.length; j++) {
              var s = dataSet[j];
              var item = option.series[j];
              item.data.push(rowData[s.dataField]);
            }
          }
        }
      } else {
        var s = {
          type: "pie",
          data: []
        };

        if (this.type == "ChartPie") {
          if (this.dataModel.radius) {
            s.radius = this.dataModel.radius;
          } else {
            s.radius = "50%";
          }
        } else {
          var outerRadius = this.dataModel.outerRadius;
          if (!outerRadius) outerRadius = "40%";
          var innerRadius = this.dataModel.innerRadius;
          if (!innerRadius) innerRadius = "70%";
          s.radius = [outerRadius, innerRadius];
        }

        if (this._tfp.isDesigning) {
          s.data = data.seriesData;
        } else if (data && data.length > 0 && this.dataModel.nameField && this.dataModel.valueField) {
          for (var i = 0; i < data.length; i++) {
            var _rowData = data[i];
            var itemData = {
              name: _rowData[this.dataModel.nameField],
              value: _rowData[this.dataModel.valueField]
            };
            if (!itemData.name || !itemData.value && itemData.value != 0) continue;
            s.data.push(itemData);
          }
        }

        option.series.push(s);
      }

      if (this.dataModel.showLoading) this.chart.showLoading();
      this.chart.setOption(option);
      if (this.dataModel.showLoading) this.chart.hideLoading();
    }
  }, {
    key: "loadData",
    value: function loadData(args) {
      if (!this.dataModel.loadDataService) {
        alert("请为[" + this.id + "]设置加载数据服务！");
        return;
      }

      var serviceCpt = this._tfp.get(this.dataModel.loadDataService);

      if (!serviceCpt) {
        alert("ID为[" + this.dataModel.loadDataService + "]的组件不存在！");
        return;
      }

      if (!this.dataModel.dataBindingMember) {
        alert("请为[" + this.id + "]设置数据绑定成员！");
        return;
      }

      var that = this;
      serviceCpt.request(args, function (req, res) {
        if (res.code != 0) {
          tfp.showMsg(res.message);
          return;
        }

        if (that.dataModel.dataBindingMember) {
          that.bindData(res[that.dataModel.dataBindingMember]);
        } else {
          that.bindData(res);
        }
      });
    }
  }, {
    key: "render",
    value: function render() {
      _get(_getPrototypeOf(Chart.prototype), "render", this).call(this);

      if (this._tfp.isDesigning) {
        var data = this.getDemoData();
        this.bindData(data);
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      if (!this.dataModel.loadDataService) return;
      this.loadData();
    }
  }]);

  return Chart;
}(_controller.VisibleComponent);

exports["default"] = Chart;