"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisibleComponent = exports.InvisibleComponent = exports.FormInput = exports.ContainerComponent = exports.Component = void 0;

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var _parent = Symbol("parent");
/**
 * TaskUI组件基类
 */


var Component = /*#__PURE__*/function () {
  function Component(__tfp, typeName, dataModel, parent) {
    _classCallCheck(this, Component);

    if (!__tfp) {
      throw new Error("请提供tfp对象！");
      return;
    }

    if (!typeName) {
      console.log(dataModel);
      throw new Error("请提供组件类型！");
      return;
    }

    this._tfp = __tfp;
    this.level = 0; //组件相对页面组件的层次

    this.index = 0; //组件在父组件中的索引，主要用来排序
    //目前如果某个兄弟组件删除了，不会重置所有剩余的兄弟组件的索引
    //如果没有提供数据模型，则进行模型初始化

    if (!dataModel) {
      var metadata = this._tfp.type(typeName);

      if (!metadata) {
        throw new Error("请提供正确的组件类型！");
        return;
      }

      this.dataModel = {
        type: typeName
      };
      this.dataModel.id = this.dataModel.type.substr(0, 1).toLowerCase() + this.dataModel.type.substr(1) + this._tfp.getNewCptIndex(this.dataModel.type);
      var attrs = this.attrTypes; //设置组件默认属性

      for (var _i = 0; _i < attrs.length; _i++) {
        var attr = attrs[_i];

        if (attr["default"] || attr["default"] == 0 || attr["default"] == false) {
          if (attr.type.toLowerCase() == "string") {
            this.dataModel[attr.name] = attr["default"].replace("{id}", this.id);
          } else {
            this.dataModel[attr.name] = attr["default"];
          }
        }
      } //设置可视组件数据模型的默认样式


      if (metadata.defaultStyles) {
        this.dataModel.styles = {};

        for (var style in metadata.defaultStyles) {
          this.dataModel.styles[style] = metadata.defaultStyles[style];
        }
      }
    } else {
      //否则用传入的数据模型
      this.dataModel = dataModel;
      if (!this.dataModel.type) this.dataModel.type = typeName;
    } //设置组件数据模型的默认ID


    if (!this.dataModel.id) {
      this.dataModel.id = this.dataModel.type.substr(0, 1).toLowerCase() + this.dataModel.type.substr(1) + this._tfp.getNewCptIndex(this.dataModel.type);
    }

    this._tfp.components[this.dataModel.id] = this;
    if (this._tfp.isRuntime) window[this.dataModel.id] = this; //设置组件的父组件

    if (parent) {
      this[_parent] = parent;
      this.level = parent.level + 1;

      if (!this._tfp.isLoadingPage) {
        if (!parent.dataModel.components) parent.dataModel.components = [];
        var cptExists = false;

        for (var i = 0; i < parent.dataModel.components.length; i++) {
          var cdmTmp = parent.dataModel.components[i];

          if (cdmTmp.id == this.dataModel.id) {
            cptExists = true;
            continue;
          }

          if (cdmTmp.index >= this.index) this.index = cdmTmp.index + 1;
        }

        if (!cptExists) parent.dataModel.components.push(this.dataModel);
      }
    } else {//TODO 如果创建组件时没有提供父组件，则表示是临时组件，后续可以设置父组件
    }
  } //组件ID，每个组件的ID是唯一的，不能重复


  _createClass(Component, [{
    key: "id",
    get: function get() {
      return this.dataModel.id;
    },
    set: function set(value) {
      if (!value) return;
      var oldId = this.dataModel.id;
      if (oldId == value) return;

      for (var cptId in this._tfp.components) {
        if (cptId == value) {
          throw new Error("ID为的" + value + "组件已存在！");
          return;
        }
      }

      this.dataModel.id = value;
      delete this._tfp.components[oldId];
      this._tfp.components[this.dataModel.id] = this;

      if (this._tfp.isRuntime) {
        delete window[oldId];
        window[this.dataModel.id] = this;
      }

      if ($("#" + oldId).length > 0) {
        $("#" + oldId).attr("id", this.dataModel.id);
      }
    } //组件类型，组件一旦创建，不允许再修改类型

  }, {
    key: "type",
    get: function get() {
      return this.dataModel.type;
    },
    set: function set(value) {} //组件类型元数据，组件一旦创建，不允许再修改

  }, {
    key: "metadata",
    get: function get() {
      return this._tfp.type(this.dataModel.type);
    },
    set: function set(value) {} //父组件

  }, {
    key: "parent",
    get: function get() {
      return this[_parent];
    },
    set: function set(value) {
      //如果没有设置父组件
      if (!this[_parent]) {
        this[_parent] = value;
        if (!this[_parent].dataModel.components) this[_parent].dataModel.components = [];

        this[_parent].dataModel.components.push(this.dataModel);
      } else {
        if (this[_parent].id != value.id) {
          //如果已经设置了父组件，但新设置的父组件和原来的父组件不一样
          this[_parent].dataModel.components.remove(this.dataModel);

          this[_parent] = value;
          if (!this[_parent].dataModel.components) this[_parent].dataModel.components = [];

          this[_parent].dataModel.components.push(this.dataModel);
        } else {
          //如果父组件没有变化，则不需要执行后续操作
          return;
        }
      } //设置当前组件的层级和索引


      this.level = this[_parent].level + 1;

      for (var i = 0; i < this[_parent].dataModel.components.length; i++) {
        var cdmTmp = this[_parent].dataModel.components[i];
        if (cdmTmp.index >= this.index) this.index = cdmTmp.index + 1;
      }
    }
  }, {
    key: "attrTypes",
    get: function get() {
      var attrs = [];

      var metadata = this._tfp.type(this.type);

      if (metadata.attrs) {
        for (var i = 0; i < metadata.attrs.length; i++) {
          var attr = metadata.attrs[i];

          if (attr.type == "group" || attr.items) {
            for (var j = 0; j < attr.items.length; j++) {
              attrs.push(attr.items[j]);
            }
          } else {
            attrs.push(attr);
          }
        }
      }

      return attrs;
    },
    set: function set(value) {}
  }, {
    key: "attr",
    value: function attr(attrName, attrValue) {
      if (arguments.length == 0) return; //获取样式值

      if (arguments.length == 1) {
        return this[attrName];
      }

      this[attrName] = attrValue;
    }
    /**
     * 获得属性定义信息
     * @param  {[type]} attrName [description]
     * @return {[type]}          [description]
     */

  }, {
    key: "getAttrTypeInfo",
    value: function getAttrTypeInfo(attrName) {
      if (!this.metadata) {
        throw new Error("没有找到组件类型定义信息，请先引用类型信息！");
        return;
      }

      if (!this.metadata.attrs) {
        //throw new Error("没有找到组件的属性定义信息！");
        return null;
      }

      for (var i = 0; i < this.metadata.attrs.length; i++) {
        var attrInfo = this.metadata.attrs[i];

        if (attrInfo.type == "group" || attrInfo.items) {
          for (var j = 0; j < attrInfo.items.length; j++) {
            if (attrInfo.items[j].name == attrName) {
              return attrInfo.items[j];
            }
          }
        } else {
          if (this.metadata.attrs[i].name == attrName) {
            return this.metadata.attrs[i];
          }
        }
      }

      return null;
    }
    /**
     * 检查属性选项是否是组件类型定义中设置的选项
     * @param  {[type]} attrName [description]
     * @param  {[type]} attrVal  [description]
     * @return {[type]}          [description]
     */

  }, {
    key: "checkAttrOption",
    value: function checkAttrOption(attrName, attrVal) {
      var attr = this.getAttrTypeInfo(attrName);
      if (!attr) return false;
      var options = attr.options;
      if (!options) return false;

      for (var i = 0; i < options.length; i++) {
        if (options[i].value == attrVal) return true;
      }

      return false;
    }
    /**
     * 执行事件处理函数
     * @param  {[type]} eventName [description]
     * @return {[type]}           [description]
     */

  }, {
    key: "exeEventHandler",
    value: function exeEventHandler(eventName) {
      //设计时不执行任何事件处理函数
      if (this._tfp.isDesigning) return;
      var ret;

      if (this[eventName] && typeof this[eventName] == "function") {
        ret = this[eventName](arguments);
      } else if (this.dataModel[eventName]) {
        ret = eval(this.dataModel[eventName]);
      }

      if (ret) return ret;
    }
  }]);

  return Component;
}();

exports.Component = Component;

var InvisibleComponent = /*#__PURE__*/function (_Component) {
  _inherits(InvisibleComponent, _Component);

  var _super = _createSuper(InvisibleComponent);

  function InvisibleComponent(__tfp, typeName, dataModel, parent) {
    _classCallCheck(this, InvisibleComponent);

    return _super.call(this, __tfp, typeName, dataModel, parent);
  }

  _createClass(InvisibleComponent, [{
    key: "isInvisible",
    get: function get() {
      return true;
    },
    set: function set(value) {}
  }, {
    key: "render",
    value: function render() {
      //如果是不可视组件，只有在设计时需要渲染
      if (this._tfp.isDesigning) {
        window.parent.uiDesigner.addInvisibleComponent(this);

        this._tfp.initCptDesignSetting(this);
      }
    }
  }]);

  return InvisibleComponent;
}(Component);

exports.InvisibleComponent = InvisibleComponent;

var VisibleComponent = /*#__PURE__*/function (_Component2) {
  _inherits(VisibleComponent, _Component2);

  var _super2 = _createSuper(VisibleComponent);

  function VisibleComponent(__tfp, typeName, dataModel, parent) {
    var _this;

    _classCallCheck(this, VisibleComponent);

    _this = _super2.call(this, __tfp, typeName, dataModel, parent);
    _this._jqObj = null;
    _this.el = null;
    _this.isRendered = false;
    return _this;
  }

  _createClass(VisibleComponent, [{
    key: "isInvisible",
    get: function get() {
      return false;
    },
    set: function set(value) {}
  }, {
    key: "isContainer",
    get: function get() {
      return false;
    },
    set: function set(value) {}
  }, {
    key: "styles",
    get: function get() {
      return this.dataModel.styles;
    },
    set: function set(value) {}
  }, {
    key: "style",
    get: function get() {
      return this.dataModel.style;
    },
    set: function set(value) {
      if (!value) value = "";
      this.dataModel.style = value;

      if (this._jqObj) {
        var style = value.trim();
        if (style != "" && !style.endsWith(";")) style += ";";

        if (this.dataModel.styles) {
          for (var styleTmp in this.dataModel.styles) {
            style += styleTmp + ": " + this.dataModel.styles[styleTmp] + ";";
          }
        } //要保留设计时的外边框


        var outline = this._jqObj.css("outline");

        this._jqObj.attr("style", style);

        this._jqObj.css("outline", outline);
      }
    }
  }, {
    key: "class",
    get: function get() {
      return this.dataModel["class"];
    },
    set: function set(value) {
      if (!value) value = "";
      this.dataModel["class"] = value;

      if (this._jqObj) {
        this._jqObj.attr("class", value);
      }
    }
  }, {
    key: "indent",
    get: function get() {
      var _indent = "";

      for (var i = 0; i < this.level; i++) {
        _indent += "\t";
      }

      return _indent;
    },
    set: function set(value) {}
  }, {
    key: "css",
    value: function css(styleName, styleValue) {
      if (arguments.length == 0) return; //获取样式值

      if (arguments.length == 1) {
        if (!this.dataModel.styles) return null;
        return this.dataModel.styles[styleName];
      }

      if (this._jqObj) this._jqObj.css(styleName, styleValue);
      if (!this.dataModel.styles) this.dataModel.styles = {};

      if (styleValue == "" || styleValue == null) {
        delete this.dataModel.styles[styleName];
      } else {
        this.dataModel.styles[styleName] = styleValue;
      }
    }
  }, {
    key: "val",
    value: function val(value) {
      if (arguments.length == 0) return this.value;
      this.value = value;
    }
  }, {
    key: "show",
    value: function show() {
      if (this._jqObj) this._jqObj.show();
    }
  }, {
    key: "hide",
    value: function hide() {
      if (this._jqObj) this._jqObj.hide();
    }
  }, {
    key: "toggle",
    value: function toggle() {
      if (this._jqObj) this._jqObj.toggle();
    }
  }, {
    key: "focus",
    value: function focus() {
      if (this._jqObj) this._jqObj.focus();
    }
  }, {
    key: "getHtmlIndent",
    value: function getHtmlIndent() {
      if (this.indent) return this.indent;
      var indent = "";

      for (var i = 0; i < this.level; i++) {
        indent += "\t";
      }

      return indent;
    }
  }, {
    key: "render",
    value: function render() {
      if ((!this.parent || !this.parent.containerEl) && this.type != "Page") return;
      var Render = this._tfp.renders[this.type];
      var render = new Render(this._tfp, this.dataModel, this.level);

      if (this.type == "Page") {
        if (this.dataModel.pageElId && this._tfp.isRuntime) {
          this._jqObj = $("#" + this.dataModel.pageElId);
        } else {
          this._jqObj = $("body");
        }

        this._jqObj.append(render.getHtml());

        this._tfp.curPage = this;
      } else {
        $(this.parent.containerEl).append(render.getHtml());
        this._jqObj = $("#" + this.id);
      }

      if (this._jqObj.length > 0) this.el = this._jqObj.get(0);

      if (!this.isRendered && this._tfp.isDesigning) {
        this._tfp.initCptDesignSetting(this);
      }

      if (typeof window != "undefined" && !this._tfp.isDesigning) {
        window[this.id] = this;
      }

      if (this.dataModel.components) {
        for (var i = 0; i < this.dataModel.components.length; i++) {
          var cdmChild = this.dataModel.components[i];

          var cptChild = this._tfp.render(cdmChild, this);
        }
      }

      this.isRendered = true;
    }
  }, {
    key: "clear",
    value: function clear() {
      if (this.dataModel.components) {
        for (var i = 0; i < this.dataModel.components.length; i++) {
          var childCdm = this.dataModel.components[i];

          var child = this._tfp.get(childCdm.id);

          child.clear();
          if (child._jqObj) child._jqObj.remove();
          delete this._tfp.components[child.id];
        } //this.dataModel.components = [];

      }
    }
  }]);

  return VisibleComponent;
}(Component); //容器组件


exports.VisibleComponent = VisibleComponent;

var ContainerComponent = /*#__PURE__*/function (_VisibleComponent) {
  _inherits(ContainerComponent, _VisibleComponent);

  var _super3 = _createSuper(ContainerComponent);

  function ContainerComponent(__tfp, typeName, dataModel, parent) {
    var _this2;

    _classCallCheck(this, ContainerComponent);

    _this2 = _super3.call(this, __tfp, typeName, dataModel, parent);
    if (!_this2.dataModel.components) _this2.dataModel.components = [];
    return _this2;
  }

  _createClass(ContainerComponent, [{
    key: "isContainer",
    get: function get() {
      return true;
    },
    set: function set(value) {}
  }, {
    key: "containerEl",
    get: function get() {
      return this.el;
    },
    set: function set(value) {
      this.el = value;
    }
  }, {
    key: "components",
    get: function get() {
      return this.dataModel.components;
    },
    set: function set(value) {}
    /**
     * 添加子组件
     * @param {[type]} cptChild [description]
     */

  }, {
    key: "addChild",
    value: function addChild(cptChild) {
      cptChild.parent = this;
    }
    /**
     * 移除子组件
     * @param  {[type]} cptId [description]
     * @return {[type]}       [description]
     */

  }, {
    key: "removeChild",
    value: function removeChild(cptId) {
      for (var i = 0; i < this.dataModel.components.length; i++) {
        var childCdm = this.dataModel.components[i];

        if (childCdm.id == cptId) {
          var child = this._tfp.components[childCdm.id];
          child.clear();
          if (child._jqObj) child._jqObj.remove();

          if (this._tfp.isRuntime) {
            delete this._tfp.components[child.id];
            delete window[child.id];
          }

          child = null;
          childCdm = null;
          return;
        }
      }
    }
    /**
     * 清空子组件
     * @return {[type]} [description]
     */

  }, {
    key: "clearChildren",
    value: function clearChildren() {
      for (var i = 0; i < this.dataModel.components.length; i++) {
        var childCdm = this.dataModel.components[i];
        var child = this._tfp.components[childCdm.id];
        child.clear();
        if (child._jqObj) child._jqObj.remove();
        delete this._tfp.components[child.id];
        if (this._tfp.isRuntime) delete window[child.id];
        child = null;
        childCdm = null;
      }

      this.dataModel.components = [];
    }
  }]);

  return ContainerComponent;
}(VisibleComponent); //表单输入项组件


exports.ContainerComponent = ContainerComponent;

var FormInput = /*#__PURE__*/function (_VisibleComponent2) {
  _inherits(FormInput, _VisibleComponent2);

  var _super4 = _createSuper(FormInput);

  function FormInput(__tfp, typeName, dataModel, parent) {
    _classCallCheck(this, FormInput);

    return _super4.call(this, __tfp, typeName, dataModel, parent);
  }

  _createClass(FormInput, [{
    key: "isFormInput",
    get: function get() {
      return true;
    } //数据绑定格式

  }, {
    key: "dataBindingFormat",
    get: function get() {
      return this.dataModel.dataBindingFormat;
    },
    set: function set(value) {
      this.dataModel.dataBindingFormat = value;
    } //是否必填

  }, {
    key: "required",
    get: function get() {
      return this.dataModel.required;
    },
    set: function set(value) {
      this.dataModel.required = value ? true : false;
    } //是否只读

  }, {
    key: "readonly",
    get: function get() {
      return this.dataModel.readonly;
    },
    set: function set(value) {
      this.dataModel.readonly = value ? true : false;
      if (!this.dataModel.readonly) delete this.dataModel.readonly;

      if (this._jqObj && this._jqObj.length > 0 && !this._tfp.isDesigning) {
        var el = this._jqObj.get(0);

        if (el.tagName == "INPUT" || el.tagName == "SELECT" || el.tagName == "TEXTAREA") {
          el.readonly = this.dataModel.readonly;
        } else if (el.tagName == "DIV") {
          this._jqObj.find("input").each(function () {
            $(this).get(0).readonly = this.dataModel.readonly;
          });
        }
      }
    } //是否禁用

  }, {
    key: "disabled",
    get: function get() {
      return this.dataModel.disabled;
    },
    set: function set(value) {
      this.dataModel.disabled = value ? true : false;
      if (!this.dataModel.disabled) delete this.dataModel.disabled;

      if (this._jqObj && this._jqObj.length > 0 && !this._tfp.isDesigning) {
        var el = this._jqObj.get(0);

        if (el.tagName == "INPUT" || el.tagName == "SELECT" || el.tagName == "TEXTAREA") {
          el.disabled = this.dataModel.disabled;
        } else if (el.tagName == "DIV") {
          this._jqObj.find("input").each(function () {
            $(this).get(0).disabled = this.dataModel.disabled;
          });
        }
      }
    } //自动计算表达式

  }, {
    key: "formula",
    get: function get() {
      return this.dataModel.formula;
    },
    set: function set(value) {
      if (isNull(value)) {
        delete this.dataModel["formula"];
        return;
      }

      this.dataModel.formula = value;
    }
    /**
     * 当值发生变化时
     * @return {[type]} [description]
     */

  }, {
    key: "valueOnChange",
    value: function valueOnChange() {
      this._tfp.iptValueOnChange(this);
    }
    /**
     * 执行计算表达式
     * @return {[type]} [description]
     */

  }, {
    key: "exeFormula",
    value: function exeFormula() {
      if (!this.dataModel.formula) return;
      var val = this.dataModel.formula;
      var ipts = this.dataModel.formula.match(/\$\{[\w]+\}/g);

      for (var i = 0; i < ipts.length; i++) {
        var iptId = ipts[i].substr(2, ipts[i].length - 3);
        var ipt = this._tfp.components[iptId];
        if (!ipt) continue;
        var iptVal = ipt.value;

        if (ipt.type == "Text" && isNull(iptVal)) {
          //如果是单行输入框，且数据类型不是文本，则值为空时，将值设置为0，以便计算
          if (ipt.dataType == "int" || ipt.dataType == "float" || ipt.dataType == "money") {
            iptVal = "0";
          }
        } else if (ipt.type == "DataSet") {
          iptVal = ipt.id;
        }

        val = val.replaceAll("\$\{" + iptId + "\}", iptVal);
      }

      try {
        this.value = eval(val);
      } catch (err) {
        console.error("执行计算表达式出错：" + err.message);
      }
    }
    /**
     * 设置输入项的选项
     * @param {[type]} value [description]
     */

  }, {
    key: "setOptions",
    value: function setOptions(value) {
      if (!value) return;
      var options = [];

      if (typeof value == "string") {
        var arr = value.split(",");

        for (var i = 0; i < arr.length; i++) {
          var str = arr[i];

          if (str.trim() != "") {
            options.push({
              value: str,
              text: str
            });
          }
        }
      } else if (Array.isArray(value)) {
        for (var i = 0; i < value.length; i++) {
          var val = value[i];

          if (Object.prototype.toString.call(val) === '[object Object]') {
            options.push(val);
          } else {
            options.push({
              value: val,
              text: val
            });
          }
        }
      }

      this.dataModel.options = options;
    }
  }]);

  return FormInput;
}(VisibleComponent);

exports.FormInput = FormInput;