"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * 数据集组件
 * @param {[type]} dataModel [description]
 */
var DataSet = /*#__PURE__*/function (_VisibleComponent) {
  _inherits(DataSet, _VisibleComponent);

  var _super = _createSuper(DataSet);

  function DataSet(__tfp, dataModel, parent) {
    var _this;

    _classCallCheck(this, DataSet);

    _this = _super.call(this, __tfp, "DataSet", dataModel, parent);

    if (_this._tfp.isDesigning && (!_this.dataModel.columns || _this.dataModel.columns.length == 0)) {
      //默认创建1行3列
      _this.dataModel.columns = [{
        id: "col1",
        name: "第1列",
        type: "text",
        width: "60px"
      }, {
        id: "col2",
        name: "第2列",
        type: "text",
        width: "60px"
      }, {
        id: "col3",
        name: "第3列",
        type: "text",
        width: "60px"
      }];
    }

    return _this;
  } //属性


  _createClass(DataSet, [{
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    } //属性

  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "columns",
    get: function get() {
      return this.dataModel.columns;
    },
    set: function set(value) {
      this.dataModel.columns = value;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "rows",
    get: function get() {
      return this.getRows({
        checkRequired: false
      });
    },
    set: function set(value) {
      this.dataModel.rows = value;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "keyCol",
    get: function get() {
      return this.dataModel.keyCol;
    },
    set: function set(value) {
      this.dataModel.keyCol = value;

      if (this._jqObj) {//
      }
    }
  }, {
    key: "showAddButton",
    get: function get() {
      return this.dataModel.showAddButton;
    },
    set: function set(value) {
      this.dataModel.showAddButton = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showAddButton) {
          $(".tfp-dataset-header").css("height", "70px");
          $(".tfp-dataset-list").css("top", "71px");
          $(".tfp-dataset-toolbar").show();
          $(".tfp-dataset-button-add").show();
        } else {
          $(".tfp-dataset-button-add").hide();

          if (!this.dataModel.showAddFromDialogButton) {
            $(".tfp-dataset-toolbar").hide();
            $(".tfp-dataset-header").css("height", "30px");
            $(".tfp-dataset-list").css("top", "31px");
          }
        }
      }
    }
  }, {
    key: "addButtonText",
    get: function get() {
      if (!this.dataModel.addButtonText) this.dataModel.addButtonText = "添加";
      return this.dataModel.addButtonText;
    },
    set: function set(value) {
      this.dataModel.addButtonText = value;

      if (this._jqObj) {
        $(".tfp-dataset-button-add").html(value);
      }
    }
  }, {
    key: "showAddFromDialogButton",
    get: function get() {
      return this.dataModel.showAddFromDialogButton;
    },
    set: function set(value) {
      this.dataModel.showAddFromDialogButton = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showAddFromDialogButton) {
          $(".tfp-dataset-header").css("height", "70px");
          $(".tfp-dataset-list").css("top", "71px");
          $(".tfp-dataset-toolbar").show();
          $(".tfp-dataset-button-add-from-dialog").show();
        } else {
          $(".tfp-dataset-button-add-from-dialog").hide();

          if (!this.dataModel.showAddButton) {
            $(".tfp-dataset-toolbar").hide();
            $(".tfp-dataset-header").css("height", "30px");
            $(".tfp-dataset-list").css("top", "31px");
          }
        }
      }
    }
  }, {
    key: "addFromDialogButtonText",
    get: function get() {
      if (!this.dataModel.addFromDialogButtonText) this.dataModel.addFromDialogButtonText = "弹窗选择";
      return this.dataModel.addFromDialogButtonText;
    },
    set: function set(value) {
      this.dataModel.addFromDialogButtonText = value;

      if (this._jqObj) {
        $(".tfp-dataset-button-add-from-dialog").html(value);
      }
    }
  }, {
    key: "addFromDialogPath",
    get: function get() {
      return this.dataModel.addFromDialogPath;
    },
    set: function set(value) {
      this.dataModel.addFromDialogPath = value;
    }
  }, {
    key: "showCheckbox",
    get: function get() {
      return this.dataModel.showCheckbox;
    },
    set: function set(value) {
      this.dataModel.showCheckbox = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "enableDelete",
    get: function get() {
      return this.dataModel.enableDelete;
    },
    set: function set(value) {
      this.dataModel.enableDelete = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "reRenderBody",
    value: function reRenderBody() {
      this._jqObj.empty();

      this._jqObj.append(this.getBodyHtml());
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml() {
      var indent = this.getHtmlIndent();
      var headerHeight = 30;
      var showToolBar = false;

      if (this.dataModel.showAddButton || this.dataModel.showAddFromDialogButton) {
        showToolBar = true;
        headerHeight = 70;
      }

      var html = indent + "\t<div class=\"tfp-dataset-header\" style=\"height:" + headerHeight + "px;\">\r\n";
      html += indent + "\t\t<div class=\"tfp-dataset-toolbar\"";
      if (!showToolBar) html += " style=\"display:none;\"";
      html += ">\r\n";
      html += indent + "\t\t\t<div class=\"tfp-dataset-button-add\"";
      if (!this.dataModel.showAddButton) html += " style=\"display:none;\"";
      html += ">" + this.addButtonText + "</div>\r\n";
      html += indent + "\t\t\t<div class=\"tfp-dataset-button-add-from-dialog\"";
      if (!this.dataModel.showAddFromDialogButton) html += " style=\"display:none;\"";
      html += ">" + this.addFromDialogButtonText + "</div>\r\n";
      html += indent + "\t\t</div>\r\n";
      html += indent + "\t\t<div class=\"tfp-dataset-titlerow\" style=\"width:{rowWidth};\">\r\n";
      var rowWidth = 6;
      if (this.dataModel.enableDelete) rowWidth += 30;

      if (this.dataModel.columns) {
        if (this.dataModel.showCheckbox) {
          rowWidth += 24;
          html += indent + "\t\t\t<div style=\"width:24px; text-align: center;\">" + "<input type=\"checkbox\" class=\"tfp-checkbox tfp-dataset-checkall\" " + "style=\"margin-top:7px;\" onclick=\"" + this.id + ".checkAllOnClick(this)\" /></div>\r\n";
        }

        for (var _i = 0; _i < this.dataModel.columns.length; _i++) {
          var col = this.dataModel.columns[_i];
          html += indent + "\t\t\t<div";

          if (col.width) {
            html += " style='width:" + col.width + ";'";
            rowWidth += parseInt((col.width + '').replace("px", ""));
          } else {
            if (col.type == "switch") {
              html += " style='width:40px;'";
              rowWidth += 40;
            } else {
              html += " style='width:100px;'";
              rowWidth += 100;
            }
          }

          var colName = col.id;
          if (col.name) colName = col.name;
          html += ">" + colName + "</div>\r\n";
        }
      }

      html = html.replace("{rowWidth}", rowWidth + 6 + "px");
      html += indent + "\t\t</div>\r\n";
      html += indent + "\t</div>\r\n";
      html += indent + "\t<div class=\"tfp-dataset-list\" style=\"top:" + (headerHeight + 1) + "px;\">\r\n";

      if (this.dataModel.columns) {
        if (this.dataModel.rows && this.dataModel.rows.length > 0) {
          for (var i = 0; i < this.dataModel.rows.length; i++) {
            html += this.getRowHtml(this.dataModel.rows[i], indent, rowWidth);
          }
        } else if (this._tfp.isDesigning) {
          //设计时添加三行空行
          html += this.getRowHtml(null, indent, rowWidth);
          html += this.getRowHtml(null, indent, rowWidth);
          html += this.getRowHtml(null, indent, rowWidth);
        }
      }

      html += indent + "\t</div>\r\n";
      return html;
    }
  }, {
    key: "getRowWidth",
    value: function getRowWidth() {
      var rowWidth = 6;
      if (this.dataModel.enableDelete) rowWidth += 30;

      if (this.dataModel.columns) {
        if (this.dataModel.showCheckbox) rowWidth += 30;

        for (var i = 0; i < this.dataModel.columns.length; i++) {
          var col = this.dataModel.columns[i];

          if (col.width) {
            rowWidth += parseInt((col.width + '').replace("px", ""));
          } else {
            if (col.type == "switch") {
              rowWidth += 40;
            } else {
              rowWidth += 100;
            }
          }
        }
      }

      return rowWidth;
    }
    /**
     * 添加数据集行
     * @param {[type]} data [description]
     */

  }, {
    key: "getRowHtml",
    value: function getRowHtml(rowData, indent, rowWidth) {
      if (!this.dataModel.columns) return "";
      var htmlStr = indent + "\t\t<div class=\"tfp-dataset-row\" " + "style=\"width:" + this._tfp.formatPx(rowWidth) + ";\">\r\n";

      if (this.dataModel.showCheckbox) {
        htmlStr += indent + "\t\t\t<div style=\"width:24px; text-align: center;\">" + "<input type=\"checkbox\" class=\"tfp-checkbox tfp-dataset-checkbox\" " + "style=\"margin-top:6px;\" /></div>\r\n";
      }

      for (var i = 0; i < this.dataModel.columns.length; i++) {
        var col = this.dataModel.columns[i];
        htmlStr += indent + "\t\t\t<div style=\"";
        if (col.hidden) htmlStr += "display:none;";

        if (col.width) {
          htmlStr += "width:" + this._tfp.formatPx(col.width) + ";";
        } else {
          if (col.type == "switch") {
            htmlStr += "width:40px;";
          } else {
            htmlStr += "width:100px;";
          }
        }

        htmlStr += "\"";
        if (this.dataModel.cellOnDoubleClick) htmlStr += " ondblclick='" + this.dataModel.cellOnDoubleClick + "'";
        htmlStr += ">";

        if (col.type == "select" && !col.readonly) {
          htmlStr += "<select>";
          if (!col.required) htmlStr += "<option value=\"\"></option>";

          if (col.options) {
            var options = [];

            if (Array.isArray(col.options)) {
              for (var j = 0; j < col.options.length; j++) {
                var option = col.options[j];

                if (typeof option == "string") {
                  options.push({
                    value: option
                  });
                } else if (Object.prototype.toString.call(option) === '[object Object]') {
                  options.push(option);
                }
              }
            } else if (typeof col.options == "string") {
              var arr = (col.options + '').split(",");

              for (var j = 0; j < arr.length; j++) {
                options.push({
                  value: arr[j]
                });
              }
            }

            for (var j = 0; j < options.length; j++) {
              var _option = options[j];
              htmlStr += "<option value='" + _option.value + "'";
              if (rowData && rowData[col.id] == _option.value || col["default"] == _option.value && (!rowData || !rowData[col.id])) htmlStr += " selected";
              var text = _option.value;
              if (_option.text) text = _option.text;
              htmlStr += ">" + text + "</option>";
            }
          }

          htmlStr += "</select>";
        } else if (col.type == "switch" && !col.readonly) {
          var checked = false;
          if (rowData && rowData[col.id] + "" == "true" || col["default"] && (!rowData || isNull(rowData[col.id]))) checked = true;
          htmlStr += "<div class=\"switch\" value=\"" + checked + "\" style=\"height: 16px;\"";
          if (this._tfp.isRuntime) htmlStr += " onclick=\"" + this.id + ".switchOnClick(this)\"";
          htmlStr += ">";
          htmlStr += "<div";
          if (checked) htmlStr += " style=\"float: right; background-color:#0099ff;\"";
          htmlStr += "></div>";
          htmlStr += "</div>";
        } else {
          var iptType = "text";

          if (col.type == "int") {
            iptType = "number";
          } else if (col.type == "password") {
            iptType = "password";
          }

          htmlStr += "<input type=\"" + iptType + "\""; //if(col.onchange) htmlStr += " onchange='"+col.onchange+"'";

          if (this._tfp.isDesigning || col.readonly) htmlStr += " readonly";
          if (col.readonly && this._tfp.curPage.bgColorMode == "light") htmlStr += " style=\"background-color:#EEEEEE;\"";
          var cellValue = "";

          if (rowData && !isNull(rowData[col.id])) {
            cellValue = rowData[col.id];
          } else if (col["default"]) {
            cellValue = col["default"];
          }

          if (typeof cellValue == "string" && cellValue.indexOf("\"") >= 0) {
            htmlStr += " value='" + cellValue + "'";
          } else {
            htmlStr += " value=\"" + cellValue + "\"";
          }

          htmlStr += " />";
        }

        htmlStr += "</div>\r\n";
      }

      var delIconUrl = this._tfp.rootPath + "/src/components/dataset/images/delete-blue-24.png";

      if (this.dataModel.enableDelete) {
        htmlStr += indent + "\t\t\t<div style=\"width:30px;\">" + "<img src='" + delIconUrl + "' title=\"删除\"";
        if (this._tfp.isRuntime) htmlStr += " onclick=\"" + this.id + ".deleteRow(this)\"";
        htmlStr += " /></div>\r\n";
      }

      htmlStr += indent + "\t\t</div>\r\n";
      return htmlStr;
    }
  }, {
    key: "bindEventHandler",
    value: function bindEventHandler() {
      var divHeader = this._jqObj.find(".tfp-dataset-header").get(0);

      var divDataList = this._jqObj.find(".tfp-dataset-list").get(0);

      divDataList.scrollTop = 0;
      divDataList.addEventListener('scroll', function () {
        divHeader.scrollLeft = divDataList.scrollLeft;
      });
    }
  }, {
    key: "switchOnClick",
    value: function switchOnClick(divSwitch) {
      if ($(divSwitch).find("div").css("float") == "left") {
        $(divSwitch).find("div").css("float", "right");
        $(divSwitch).find("div").css("background-color", "#0099ff");
        $(divSwitch).attr("value", "true");
      } else {
        $(divSwitch).find("div").css("float", "left");

        if (this._tfp.curPage.bgColorMode == "dark") {
          $(divSwitch).find("div").css("background-color", "#666666");
        } else {
          $(divSwitch).find("div").css("background-color", "#999999");
        }

        $(divSwitch).attr("value", "false");
      }
    }
  }, {
    key: "exeFormula",
    value: function exeFormula(colR, rowData, curRowDiv, colIndex) {
      var colRFormula = this._tfp.replaceDataField(rowData, colR.formula);

      var formulaVal = null;

      try {
        formulaVal = eval(colRFormula);
      } catch (error) {
        console.error(error.message);
        return;
      }

      if (colR.type == "text" && colR.dataType != "text") {
        if (colR.dataType == "int") {
          formulaVal = parseInt(formulaVal);
        } else if (colR.dataType == "float") {
          formulaVal = parseFloat(formulaVal);
        } else if (colR.dataType == "money") {
          formulaVal = this._tfp.formatMoney(formulaVal);
        }
      }

      var colRDivIndex = colIndex;
      if (this.dataModel.showCheckbox) colRDivIndex++;
      curRowDiv.children().eq(colRDivIndex).find("input").val(formulaVal);

      this._tfp.iptValueOnChange(this);
    }
  }, {
    key: "addNewRow",
    value: function addNewRow(data) {
      var _this2 = this;

      var rowWidth = this.getRowWidth();
      var indent = this.getHtmlIndent();
      var rowHtml = this.getRowHtml(data, indent + "\t\t", rowWidth);

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.append(rowHtml);
      var lastRow = dataList.find(".tfp-dataset-row").last();

      if (lastRow.find("input").length > 0) {
        lastRow.find("input").eq(0).focus();
      } else if (lastRow.find("select").length > 0) {
        lastRow.find("select").eq(0).focus();
      }

      var that = this;

      var _loop = function _loop() {
        var col = _this2.dataModel.columns[i]; //如果当前列设置了值改变后需要执行的脚本
        //或者，与其他列存在计算关系

        if (!col.readonly && (col.onchange || _this2.calcCols && _this2.calcCols[col.id])) {
          var colDivIndex = i;
          if (_this2.dataModel.showCheckbox) colDivIndex++;
          lastRow.children().eq(colDivIndex).find("input").blur(function () {
            if (col.onchange) {
              try {
                eval(col.onchange);
              } catch (error) {
                console.error(error);
              }
            }

            if (that.calcCols && that.calcCols[col.id]) {
              //获得当前行的数据
              var curRowDiv = $(this).parent().parent();
              var rowIndex = curRowDiv.index();
              var rowData = that.getRow(rowIndex, {
                autoFormat: true
              }).row;
              var arr = that.calcCols[col.id];

              for (var j = 0; j < arr.length; j++) {
                for (var k = 0; k < that.dataModel.columns.length; k++) {
                  var colR = that.dataModel.columns[k];

                  if (arr[j] == colR.id && colR.formula) {
                    that.exeFormula(colR, rowData, curRowDiv, k);
                    break;
                  }
                }
              }
            }
          });
        }
      };

      for (var i = 0; i < this.dataModel.columns.length; i++) {
        _loop();
      }
    }
  }, {
    key: "deleteRow",
    value: function deleteRow(img) {
      $(img).parent().parent().remove();
      if (this.dataModel.onRemoveRow) eval(this.dataModel.onRemoveRow);
    }
  }, {
    key: "checkAllOnClick",
    value: function checkAllOnClick(cbk) {
      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.find(".tfp-dataset-checkbox").each(function () {
        $(this).get(0).checked = cbk.checked;
      });
    }
  }, {
    key: "checkAll",
    value: function checkAll() {
      if (!this.dataModel.showCheckbox) return;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.find(".tfp-dataset-checkbox").each(function () {
        $(this).get(0).checked = true;
      });
    }
  }, {
    key: "unCheckAll",
    value: function unCheckAll() {
      if (!this.dataModel.showCheckbox) return;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.find(".tfp-dataset-checkbox").each(function () {
        $(this).get(0).checked = false;
      });
    }
  }, {
    key: "checkRows",
    value: function checkRows(keys) {
      if (!this.dataModel.showCheckbox || !this.dataModel.keyCol || !keys) return;
      if (typeof keys == "string") keys = keys.split(",");
      var keyColIndex = 0;

      for (var i = 0; i < this.dataModel.columns.length; i++) {
        var col = this.dataModel.columns[i];

        if (col.id == this.dataModel.keyCol) {
          keyColIndex = i + 1;
          break;
        }
      }

      if (keyColIndex == 0) return;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.find(".tfp-dataset-row").each(function () {
        var keyColDiv = $(this).children("div").eq(keyColIndex);
        var key = keyColDiv.find("input").val();
        if (keys.contains(key)) $(this).find(".tfp-dataset-checkbox").get(0).checked = true;
      });
    }
  }, {
    key: "getCheckedRows",
    value: function getCheckedRows(cb) {
      if (cb) {
        this.getRows({
          onlyGetChecked: true,
          checkRequired: true
        }, cb);
        return;
      }

      return this.getRows({
        onlyGetChecked: true,
        checkRequired: true
      });
    }
  }, {
    key: "getRow",
    value: function getRow(index, options) {
      var checkRequired = false;
      var onlyGetChecked = false;
      var autoFormat = false;

      if (options) {
        if (options.checkRequired) checkRequired = true;
        if (options.onlyGetChecked) onlyGetChecked = true;
        if (options.autoFormat) autoFormat = true;
      }

      var dataList = this._jqObj.find(".tfp-dataset-list");

      var rowDiv = dataList.find(".tfp-dataset-row").eq(index);
      var row = {};
      var checked = false;

      if (this.dataModel.showCheckbox && rowDiv.find(".tfp-dataset-checkbox").get(0).checked) {
        checked = true;
        row.checked = true;
      }

      if (onlyGetChecked && !checked) return {
        row: null,
        isCheckOk: true
      };

      for (var i = 0; i < this.dataModel.columns.length; i++) {
        var col = this.dataModel.columns[i];
        var _index = i;
        if (this.dataModel.showCheckbox) _index++;
        var val = null;
        var colDiv = rowDiv.children("div").eq(_index);

        if (col.type == "text" || col.type == "password" || col.type == "number") {
          val = colDiv.find("input").val();
        } else if (col.type == "select") {
          val = colDiv.find(col.type).val();
        } else if (col.type == "switch") {
          val = false;
          if (colDiv.find(".switch").attr("value") == "true") val = true;
        }

        if (val == "") {
          if (col.required && checkRequired) {
            var colName = col.id;
            if (col.name) colName = col.name;

            this._tfp.showMsg(colName + "不能为空！");

            if (col.type == "text" || col.type == "select" || col.type == "password" || col.type == "number") {
              colDiv.find(col.type).focus();
            }

            return {
              row: null,
              isCheckOk: false
            };
          } else {
            if (col.type == "text" && autoFormat && col.dataType != "text") {
              if (col.dataType == "int") {
                val = 0;
              } else {
                val = 0.00;
              }
            }
          }
        } else {
          if (col.type == "text" && autoFormat && col.dataType != "text") {
            if (col.dataType == "int") {
              val = parseInt(val);
            } else {
              val = parseFloat(val);
            }
          }

          row[col.id] = val;
        }
      }

      return {
        row: row,
        isCheckOk: true
      };
    }
  }, {
    key: "getRows",
    value: function getRows(options, cb) {
      var checkRequired = false;
      var onlyGetChecked = false;

      if (options) {
        if (options.checkRequired) checkRequired = true;
        if (options.onlyGetChecked) onlyGetChecked = true;
      }

      if (onlyGetChecked && !this.dataModel.showCheckbox) return [];
      var that = this;
      var rows = [];
      var isCheckOk = true;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.find(".tfp-dataset-row").each(function (index) {
        var ret = that.getRow(index, options);

        if (!ret.isCheckOk) {
          isCheckOk = false;
          return false;
        }

        if (ret.row) rows.push(ret.row);
      });
      if (!isCheckOk) return;

      if (cb) {
        cb(rows);
      } else {
        return rows;
      }
    }
    /**
     * 求指定列的合计值
     * @param  {[type]} colName [description]
     * @return {[type]}         [description]
     */

  }, {
    key: "sum",
    value: function sum(colId) {
      var ret = 0;
      var colIndex = 0;
      var dataType = "text";

      for (var i = 0; i < this.columns.length; i++) {
        var col = this.columns[i];

        if (col.id == colId) {
          colIndex = i;
          if (this.dataModel.showCheckbox) colIndex++;
          if (col.dataType) dataType = col.dataType;
          break;
        }
      }

      var that = this;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.find(".tfp-dataset-row").each(function (index) {
        var cellVal = $(this).children().eq(colIndex).find("input").val().trim().replaceAll(",", "");

        if (cellVal != "") {
          if (dataType == "int") {
            if (isInt(cellVal)) ret += parseInt(cellVal);
          } else if (!isNaN(cellVal)) {
            ret += parseFloat(cellVal);
          }
        }
      });

      if (dataType == "money") {
        ret = this._tfp.formatMoney(ret);
      }

      return ret;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;
      $(".tfp-dataset-button-add").click(function () {
        that.addNewRow();
      });
      $(".tfp-dataset-button-add-from-dialog").click(function () {
        if (isNull(that.dataModel.addFromDialogPath)) {
          that._tfp.showMsg("请设置弹窗页面路径！");

          return;
        }

        var width = "640px";
        var height = "480px";
        if (that.dataModel.addFromDialogWidth) width = that.dataModel.addFromDialogWidth + "";
        if (width.indexOf("px") < 0) width += "px";
        if (that.dataModel.addFromDialogHeight) height = that.dataModel.addFromDialogHeight + "";
        if (height.indexOf("px") < 0) height += "px";

        that._tfp.openDialog(that.dataModel.addFromDialogButtonText, that.dataModel.addFromDialogPath, width, height, null, function (ret) {
          if (ret) {
            if (Array.isArray(ret)) {
              for (var _i2 = 0; _i2 < ret.length; _i2++) {
                that.addNewRow(ret[_i2]);
              }
            } else {
              that.addNewRow(ret);
            }
          }
        });
      }); //设置计算列关联的列，以便当关联列的数据发生变化时，自动执行计算列的值

      if (this.dataModel.columns) {
        //存在关联计算的列
        this.calcCols = {};

        for (var i = 0; i < this.dataModel.columns.length; i++) {
          var col = this.dataModel.columns[i]; //如果是计算列

          if (col.formula) {
            var arr = col.formula.match(/\{[\w]+\}/g);

            if (arr.length > 0) {
              for (var j = 0; j < arr.length; j++) {
                for (var k = 0; k < this.dataModel.columns.length; k++) {
                  var colR = this.dataModel.columns[k]; //如果当前列与计算列有关联，则标示为计算关联列

                  if ("{" + colR.id + "}" == arr[j]) {
                    if (!this.calcCols[colR.id]) {
                      this.calcCols[colR.id] = [];
                    }

                    if (!this.calcCols[colR.id].contains(col.id)) this.calcCols[colR.id].push(col.id);
                  }
                }
              }
            }
          }
        }
      }
    }
  }]);

  return DataSet;
}(_controller.VisibleComponent);

exports["default"] = DataSet;