"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "DataSet",
  "comment": "可编辑表格",
  "cssFiles": "style.{bgColorMode}.pc.css",
  "attrs": [{
    "name": "columns",
    "comment": "数据列设置",
    "type": "Dataset",
    "isPro": true,
    "keyCol": "id",
    "width": "640px",
    "height": "600px",
    "columns": [{
      "id": "id",
      "name": "列ID",
      "type": "String",
      "required": true
    }, {
      "id": "name",
      "name": "列名",
      "type": "String"
    }, {
      "id": "type",
      "name": "输入项类型",
      "type": "Select",
      "default": "text",
      "options": [{
        "value": "text",
        "text": "单行输入框"
      }, {
        "value": "select",
        "text": "下拉列表"
      }, {
        "value": "switch",
        "text": "开关"
      }, {
        "value": "password",
        "text": "密码"
      }]
    }, {
      "id": "dataType",
      "name": "数据类型",
      "type": "Select",
      "default": "text",
      "options": [{
        "value": "text",
        "text": "文本"
      }, {
        "value": "int",
        "text": "整数"
      }, {
        "value": "float",
        "text": "小数"
      }, {
        "value": "money",
        "text": "金额"
      }]
    }, {
      "id": "width",
      "name": "宽度",
      "type": "Size"
    }, {
      "id": "readonly",
      "name": "只读",
      "type": "Switch"
    }, {
      "id": "required",
      "name": "必填",
      "type": "Switch"
    }, {
      "id": "hidden",
      "name": "隐藏",
      "type": "Switch"
    }, {
      "id": "default",
      "name": "默认值",
      "type": "String"
    }, {
      "id": "options",
      "name": "可选值",
      "type": "String",
      "wrap": true
    }, {
      "id": "formula",
      "name": "自动计算表达式",
      "type": "String",
      "wrap": true
    }]
  }, {
    "name": "keyCol",
    "comment": "主键列",
    "type": "String"
  }, {
    "name": "showAddButton",
    "comment": "显示添加按钮",
    "type": "Switch",
    "default": true
  }, {
    "name": "addButtonText",
    "comment": "添加按钮文本",
    "type": "String",
    "default": "添加"
  }, {
    "name": "showAddFromDialogButton",
    "comment": "显示从弹窗选择添加",
    "type": "Switch"
  }, {
    "name": "addFromDialogButtonText",
    "comment": "弹窗选择按钮文本",
    "type": "String",
    "default": "弹窗选择"
  }, {
    "name": "addFromDialogPath",
    "comment": "弹窗页面路径",
    "type": "PathPicker",
    "fileTypes": ["html", "tfp"]
  }, {
    "name": "addFromDialogWidth",
    "comment": "弹窗宽度",
    "type": "Int",
    "default": 640
  }, {
    "name": "addFromDialogHeight",
    "comment": "弹窗高度",
    "type": "Int",
    "default": 480
  }, {
    "name": "showCheckbox",
    "comment": "显示选择框",
    "type": "Switch"
  }, {
    "name": "enableDelete",
    "comment": "允许删除",
    "type": "Switch",
    "default": true
  }],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "300px",
    "height": "200px",
    "position": "relative",
    "left": 0,
    "top": 0
  },
  "events": [{
    "name": "onAddRow",
    "comment": "添加数据行时"
  }, {
    "name": "onRemoveRow",
    "comment": "删除数据行时"
  }, {
    "name": "cellOnDoubleClick",
    "comment": "双击单元格时"
  }],
  "methods": [{
    "name": "addNewRow",
    "comment": "添加新行",
    "args": [{
      "name": "data",
      "comment": "数据",
      "type": "Object"
    }]
  }, {
    "name": "deleteRow",
    "comment": "删除行"
  }, {
    "name": "switchOnClick",
    "comment": "点击开关按钮",
    "args": [{
      "name": "switchDiv",
      "comment": "开关组件div元素",
      "type": "Object",
      "required": true
    }]
  }, {
    "name": "checkAllOnClick",
    "comment": "点击全选框",
    "args": [{
      "name": "cbkAll",
      "comment": "全选框input元素",
      "type": "Object",
      "required": true
    }]
  }, {
    "name": "checkAll",
    "comment": "全选"
  }, {
    "name": "unCheckAll",
    "comment": "全不选"
  }, {
    "name": "getRows",
    "comment": "获得选中的行",
    "args": [{
      "name": "options",
      "comment": "选项",
      "type": "Object"
    }, {
      "name": "cb",
      "comment": "回调函数",
      "type": "Function"
    }]
  }, {
    "name": "getCheckedRows",
    "comment": "获得选中的行",
    "args": [{
      "name": "cb",
      "comment": "回调函数",
      "type": "Function"
    }]
  }, {
    "name": "checkRows",
    "comment": "选中指定行",
    "args": [{
      "name": "keys",
      "comment": "要选中的键值",
      "type": "Array",
      "required": true
    }]
  }]
};
exports["default"] = _default;