"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * 日期时间组件
 * @param {[type]} dataModel [description]
 */
var DateTime = /*#__PURE__*/function (_FormInput) {
  _inherits(DateTime, _FormInput);

  var _super = _createSuper(DateTime);

  function DateTime(__tfp, dataModel, parent, inputType) {
    var _this;

    _classCallCheck(this, DateTime);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "DateTime", dataModel, parent);
    }

    return _possibleConstructorReturn(_this);
  } //属性


  _createClass(DateTime, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.find("input").val(value);
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "iconUrl",
    get: function get() {
      return this._tfp.rootPath + "/src/components/" + this.type.toLowerCase() + "/images/icon-24-" + this._tfp.curPage.contentColorMode + ".png";
    },
    set: function set(value) {}
  }, {
    key: "showIcon",
    get: function get() {
      return this.dataModel.showIcon;
    },
    set: function set(value) {
      this.dataModel.showIcon = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showIcon) {
          if (this._jqObj.find("img").length == 0) {
            this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
          }
        } else {
          this._jqObj.find("img").remove();
        }

        this.resetWidth();
      }
    }
  }, {
    key: "showSecond",
    get: function get() {
      return this.dataModel.showSecond;
    },
    set: function set(value) {
      this.dataModel.showSecond = value ? true : false;

      if (this._jqObj) {
        this.resetWidth();

        if (this.dataModel.defaultNow && this._tfp.isDesigning) {
          this._jqObj.find("input").val(this.getCurDateTime());
        }
      }
    }
  }, {
    key: "defaultNow",
    get: function get() {
      return this.dataModel.defaultNow;
    },
    set: function set(value) {
      this.dataModel.defaultNow = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.defaultNow && this._tfp.isDesigning) {
          this._jqObj.find("input").val(this.getCurDateTime());
        } else {
          this._jqObj.find("input").val("");
        }
      }
    }
  }, {
    key: "getIptWidth",
    value: function getIptWidth() {
      var iptWidth = 90;

      if (this.dataModel.type == "DateTime") {
        iptWidth = 130;
        if (this.dataModel.showSecond) iptWidth = 150;
      }

      return iptWidth;
    }
  }, {
    key: "resetWidth",
    value: function resetWidth() {
      var iptWidth = this.getIptWidth();
      var cptWidth = iptWidth;
      if (this.showIcon) cptWidth += 30;

      this._jqObj.find("input").css("width", iptWidth + "px");

      this._jqObj.css("width", cptWidth + "px");

      this._jqObj.css("min-width", cptWidth + "px");

      if (!this.dataModel.styles) this.dataModel.styles = {};
      this.dataModel.styles["width"] = cptWidth + "px";
      this.dataModel.styles["min-width"] = cptWidth + "px";
    }
  }, {
    key: "clear",
    value: function clear() {
      this.value = "";
      this.closePicker();
    }
  }, {
    key: "closePicker",
    value: function closePicker() {
      $(".tfp-datetime-picker").remove();
      $("body").unbind("click", this.closePicker);
    }
  }, {
    key: "showPicker",
    value: function showPicker() {
      var offset = this._jqObj.offset();

      var val = new Date();
      if (this.dataModel.value) val = new Date(this.dataModel.value);
      var width = 240;
      if (this.type == "DateTime") width = this.showSecond ? 393 : 343;
      var html = "<div class=\"tfp-datetime-picker\" data-cptid=\"" + this.id + "\" data-value=\"" + val.format("yyyy-MM-dd") + "\" style=\"top: " + (offset.top + 31) + "px; left:" + offset.left + "px; width: " + width + "px; display:none;\">";
      var imgDir = this._tfp.rootPath + "/src/components/datetime/images/";
      html += "<div style=\"width:100%;height:30px;border-bottom: 1px solid #CCCCCC;\">" + "<div class=\"tfp-datetime-picker-header\">" + "<div style=\"width:16px; margin-left:5px;\" title=\"上一年\">" + "<img src=\"" + imgDir + "double-arrow-left-" + this._tfp.curPage.contentColorMode + ".png\"></div>" + "<div style=\"width:16px;\" title=\"上一月\"><img src=\"" + imgDir + "arrow-left-" + this._tfp.curPage.contentColorMode + ".png\"></div>" + "<div style=\"width:166px; text-align:center;\"><span>" + val.getFullYear() + "</span> 年 <span>" + (val.getMonth() + 1) + "</span> 月</div>" + "<div style=\"width:16px;\" title=\"下一月\"><img src=\"" + imgDir + "arrow-right-" + this._tfp.curPage.contentColorMode + ".png\"></div>" + "<div style=\"width:16px;\" title=\"下一年\"><img src=\"" + imgDir + "double-arrow-right-" + this._tfp.curPage.contentColorMode + ".png\"></div>" + "</div>";

      if (this.type == "DateTime") {
        html += "<div class=\"tfp-datetime-picker-time-value\" " + "style=\"width: " + (this.showSecond ? 150 : 100) + "px;\">" + this.getTimeValue() + "</div>";
      }

      html += "</div><div style=\"width:100%;height:230px;\">";
      html += "<div class=\"tfp-datetime-picker-grid\">";
      html += "<div class=\"tfp-datetime-picker-grid-header\">";
      html += "<div>一</div><div>二</div><div>三</div><div>四</div><div>五</div><div>六</div><div>日</div>";
      html += "</div>";
      html += "</div>";

      if (this.type == "DateTime") {
        html += "<div class=\"tfp-datetime-picker-time-list\" " + "style=\"width: " + (this.showSecond ? 151 : 101) + "px;\">";
        html += this.getTimePickerHtml();
        html += "</div>";
      }

      html += "</div>";
      html += "<div class=\"tfp-datetime-picker-footer\"><span>清空</span>" + "<span style=\"color:#003399;\">今天</span>";
      if (this.type == "DateTime") html += "<input type=\"button\" value=\"确定\" />";
      html += "</div></div>";
      $("body").append(html);
      this.setDatePickerValue(val);
      var datetimePicker = $(".tfp-datetime-picker");
      var that = this;
      $(".tfp-datetime-picker-header").find("img").each(function (index) {
        $(this).click(function () {
          if (index == 0) {
            that.toPrevYear();
          } else if (index == 1) {
            that.toPrevMonth();
          } else if (index == 2) {
            that.toNextMonth();
          } else if (index == 3) {
            that.toNextYear();
          }

          event.stopPropagation();
        });
      });
      var footer = datetimePicker.find(".tfp-datetime-picker-footer");
      footer.find("span").eq(0).click(function () {
        that.clear();
      });
      footer.find("span").eq(1).click(function () {
        that.toToday();
      });
      datetimePicker.click(function () {
        event.stopPropagation();
      });
      datetimePicker.fadeIn("slow");

      if (this.type == "DateTime") {
        var timeList = $(".tfp-datetime-picker-time-list").find("ul");
        timeList.each(function () {
          $(this).find("li").each(function () {
            $(this).click(function () {
              $(this).parent().find("li").css("background-color", "");
              $(this).parent().find("li").css("color", "");
              $(this).css("background-color", "#3399FF");
              $(this).css("color", "#FFFFFF");
              $(this).parent().attr("data-value", $(this).html());
              var timeValue = timeList.eq(0).attr("data-value") + ":" + timeList.eq(1).attr("data-value");
              if (that.showSecond) timeValue += ":" + timeList.eq(2).attr("data-value");
              $(".tfp-datetime-picker-time-value").html(timeValue);
              event.stopPropagation();
            });
          });
          $(this).get(0).scrollTop = parseInt($(this).attr("data-value")) * 25;
        });
        footer.find("input").eq(0).click(function () {
          that.onCheckDateTime();
        });
      }

      $("body").bind("click", this.closePicker);
    }
  }, {
    key: "onCheckDateTime",
    value: function onCheckDateTime() {
      var val = $(".tfp-datetime-picker").attr("data-value");

      if (this.type == "DateTime") {
        var time = $(".tfp-datetime-picker-time-value").html();
        if (!time || time == "") time = "00:00";
        val += " " + time;
      }

      this.value = val;
      this.closePicker();
    }
  }, {
    key: "setDatePickerValue",
    value: function setDatePickerValue(date) {
      $(".tfp-datetime-picker").attr("data-value", date.format("yyyy-MM-dd"));
      $(".tfp-datetime-picker-header").find("span").eq(0).text(date.getFullYear());
      $(".tfp-datetime-picker-header").find("span").eq(1).text(date.getMonth() + 1);
      var firstDate = new Date(date.format("yyyy-MM-01"));
      var curWeek = firstDate.getDay();
      if (curWeek == 0) curWeek = 7;
      curWeek--;
      if (curWeek > 0) firstDate.setDate(firstDate.getDate() - curWeek);
      var grid = $(".tfp-datetime-picker-grid");
      grid.find(".tfp-datetime-picker-grid-row").remove();
      var index = 0;

      for (var i = 0; i < 6; i++) {
        var rowHtml = "<div class=\"tfp-datetime-picker-grid-row\">";

        for (var j = 0; j < 7; j++) {
          var dateTmp = new Date(firstDate.format("yyyy-MM-dd"));
          dateTmp.setDate(dateTmp.getDate() + index);
          var style = "";

          if (dateTmp.format("yyyy-MM-dd") == date.format("yyyy-MM-dd")) {
            style = "color:#FFFFFF; background-color:#3366FF;";
          } else if (dateTmp.format("yyyy-MM") != date.format("yyyy-MM")) {
            style = "color:#999999;";
          }

          rowHtml += "<div data-value=\"" + dateTmp.format("yyyy-MM-dd") + "\" style=\"" + style + "\">" + dateTmp.format("dd") + "</div>";
          index++;
        }

        rowHtml += "</div>";
        grid.append(rowHtml);
      }

      var that = this;
      grid.find(".tfp-datetime-picker-grid-row").each(function () {
        $(this).find("div").click(function () {
          if (that.type == "DateTime") {
            $(".tfp-datetime-picker-grid-row").find("div").each(function () {
              var dateTmp = $(this).attr("data-value");
              var curDate = $(".tfp-datetime-picker").attr("data-value");

              if (dateTmp == curDate) {
                $(this).css("background-color", "");

                if (dateTmp.substr(0, 7) != curDate.substr(0, 7)) {
                  $(this).css("color", "#999999");
                } else {
                  $(this).css("color", "");
                }

                return false;
              }
            });
            $(".tfp-datetime-picker").attr("data-value", $(this).attr("data-value"));
            $(this).css("background-color", "#3366FF");
            $(this).css("color", "#FFFFFF");
            event.stopPropagation();
          } else {
            that.value = $(this).attr("data-value");
            that.closePicker();
          }
        });
      });
    }
  }, {
    key: "getTimeValue",
    value: function getTimeValue() {
      var date;

      if (!this.dataModel.value) {
        date = new Date();

        if (this.showSecond) {
          return date.format("HH:mm:ss");
        } else {
          return date.format("HH:mm");
        }
      }

      if (this.showSecond) {
        date = new Date(this.dataModel.value);
        return date.format("HH:mm:ss");
      } else {
        date = new Date(this.dataModel.value + ":00");
        return date.format("HH:mm");
      }
    }
  }, {
    key: "getTimePickerHtml",
    value: function getTimePickerHtml() {
      var html = "";
      var vals = this.getTimeValue().split(":");
      html += "<ul data-value=\"" + (vals.length > 0 ? vals[0] : "00") + "\" style=\"height:230px;\">";

      for (var i = 0; i < 24; i++) {
        var hour = i < 10 ? "0" + i : i + "";
        html += "<li";
        if (vals.length > 0 && hour == vals[0]) html += " style=\"background-color: #3399FF;color: #FFFFFF;\"";
        html += ">" + hour + "</li>";
      }

      html += "</ul>";
      html += "<ul data-value=\"" + (vals.length > 1 ? vals[1] : "00") + "\" style=\"height:230px;\">";

      for (var i = 0; i < 60; i++) {
        var minute = i < 10 ? "0" + i : i + "";
        html += "<li";
        if (vals.length > 1 && minute == vals[1]) html += " style=\"background-color: #3399FF;color: #FFFFFF;\"";
        html += ">" + minute + "</li>";
      }

      html += "</ul>";

      if (this.showSecond) {
        html += "<ul data-value=\"" + (vals.length > 2 ? vals[2] : "00") + "\" style=\"height:230px;\">";

        for (var i = 0; i < 60; i++) {
          var second = i < 10 ? "0" + i : i + "";
          html += "<li";
          if (vals.length > 2 && second == vals[2]) html += " style=\"background-color: #3399FF;color: #FFFFFF;\"";
          html += ">" + second + "</li>";
        }

        html += "</ul>";
      }

      return html;
    }
  }, {
    key: "toToday",
    value: function toToday() {
      this.setDatePickerValue(new Date());
      event.stopPropagation();
    }
  }, {
    key: "toPrevYear",
    value: function toPrevYear() {
      var date = new Date($(".tfp-datetime-picker").attr("data-value"));
      date.setYear(date.getFullYear() - 1);
      this.setDatePickerValue(date);
    }
  }, {
    key: "toPrevMonth",
    value: function toPrevMonth() {
      var date = new Date($(".tfp-datetime-picker").attr("data-value"));
      date.setMonth(date.getMonth() - 1);
      this.setDatePickerValue(date);
    }
  }, {
    key: "toNextYear",
    value: function toNextYear() {
      var date = new Date($(".tfp-datetime-picker").attr("data-value"));
      date.setYear(date.getFullYear() + 1);
      this.setDatePickerValue(date);
    }
  }, {
    key: "toNextMonth",
    value: function toNextMonth() {
      var date = new Date($(".tfp-datetime-picker").attr("data-value"));
      date.setMonth(date.getMonth() + 1);
      this.setDatePickerValue(date);
    }
  }, {
    key: "getCurDateTime",
    value: function getCurDateTime() {
      if (this.type == "Date") return new Date().format("yyyy-MM-dd");

      if (this.type == "DateTime") {
        if (this.showSecond) {
          return new Date().format("yyyy-MM-dd HH:mm:ss");
        } else {
          return new Date().format("yyyy-MM-dd HH:mm");
        }
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.click(function () {
        if (that.dataModel.readonly || that.dataModel.disabled) return;

        if ($(".tfp-datetime-picker").length > 0) {
          var cptId = $(".tfp-datetime-picker").attr("data-cptid");
          if (cptId == that.id) return;
          that.closePicker();
        }

        that.showPicker();
        event.stopPropagation();
      });

      if (this.dataModel.defaultNow && !this.dataModel.value) {
        this.dataModel.value = this.getCurDateTime();

        this._jqObj.find("input").val(this.dataModel.value);
      }
    }
  }]);

  return DateTime;
}(_controller.FormInput);

exports["default"] = DateTime;