"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * 日期时间组件
 * @param {[type]} dataModel [description]
 */
var DateTime = /*#__PURE__*/function (_FormInput) {
  _inherits(DateTime, _FormInput);

  var _super = _createSuper(DateTime);

  function DateTime(__tfp, dataModel, parent, inputType) {
    var _this;

    _classCallCheck(this, DateTime);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "DateTime", dataModel, parent);
    }

    return _possibleConstructorReturn(_this);
  } //属性


  _createClass(DateTime, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      if (value != null && value != undefined) {
        if (value instanceof Date) {
          if (this.dataModel.type == "Date") {
            this.dataModel.value = value.format("yyyy-MM-dd");
          } else {
            if (this.dataModel.showSecond) {
              this.dataModel.value = value.format("yyyy-MM-dd hh:mm");
            } else {
              this.dataModel.value = value.format("yyyy-MM-dd hh:mm:ss");
            }
          }
        } else if (typeof value == "string") {
          this.dataModel.value = value;
        } else {//不支持
        }
      } else {
        this.dataModel.value = null;
      }

      if (this._jqObj) {
        if (this.dataModel.value) {
          this._jqObj.find("input").val(this.dataModel.value);
        } else {
          this._jqObj.find("input").val("");
        }
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "iconUrl",
    get: function get() {
      return this._tfp.rootPath + "/src/components/" + this.type.toLowerCase() + "/images/icon-24-" + this._tfp.curPage.contentColorMode + ".png";
    },
    set: function set(value) {}
  }, {
    key: "showIcon",
    get: function get() {
      return this.dataModel.showIcon;
    },
    set: function set(value) {
      this.dataModel.showIcon = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showIcon) {
          if (this._jqObj.find("img").length == 0) {
            this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
          }
        } else {
          this._jqObj.find("img").remove();
        }

        this.resetWidth();
      }
    }
  }, {
    key: "showSecond",
    get: function get() {
      return this.dataModel.showSecond;
    },
    set: function set(value) {
      this.dataModel.showSecond = value ? true : false;

      if (this._jqObj) {
        this.resetWidth();

        if (this.dataModel.defaultNow && this._tfp.isDesigning) {
          this._jqObj.find("input").val(this.getCurDateTime());
        }
      }
    }
  }, {
    key: "defaultNow",
    get: function get() {
      return this.dataModel.defaultNow;
    },
    set: function set(value) {
      this.dataModel.defaultNow = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.defaultNow && this._tfp.isDesigning) {
          this._jqObj.find("input").val(this.getCurDateTime());
        } else {
          this._jqObj.find("input").val("");
        }
      }
    }
  }, {
    key: "startYear",
    get: function get() {
      if (this.dataModel.startYear) return this.dataModel.startYear;
      return new Date().getFullYear() - 50;
    },
    set: function set(value) {
      this.dataModel.startYear = parseInt(value);
    }
  }, {
    key: "endYear",
    get: function get() {
      if (this.dataModel.endYear) return this.dataModel.endYear;
      return new Date().getFullYear() + 50;
    },
    set: function set(value) {
      this.dataModel.endYear = parseInt(value);
    }
  }, {
    key: "getIptWidth",
    value: function getIptWidth() {
      var iptWidth = 90;

      if (this.dataModel.type == "DateTime") {
        iptWidth = 130;
        if (this.dataModel.showSecond) iptWidth = 150;
      }

      return iptWidth;
    }
  }, {
    key: "resetWidth",
    value: function resetWidth() {
      var iptWidth = this.getIptWidth();
      var cptWidth = iptWidth;
      if (this.showIcon) cptWidth += 30;

      this._jqObj.find("input").css("width", iptWidth + "px");

      this._jqObj.css("width", cptWidth + "px");

      this._jqObj.css("min-width", cptWidth + "px");

      if (!this.dataModel.styles) this.dataModel.styles = {};
      this.dataModel.styles["width"] = cptWidth + "px";
      this.dataModel.styles["min-width"] = cptWidth + "px";
    }
  }, {
    key: "clear",
    value: function clear() {
      this.value = "";
      this.closePicker();
    }
  }, {
    key: "getCurDateTime",
    value: function getCurDateTime() {
      if (this.type == "Date") return new Date().format("yyyy-MM-dd");

      if (this.type == "DateTime") {
        if (this.showSecond) {
          return new Date().format("yyyy-MM-dd HH:mm:ss");
        } else {
          return new Date().format("yyyy-MM-dd HH:mm");
        }
      }
    }
  }, {
    key: "getDateOptions",
    value: function getDateOptions(optionsList) {
      var dateVal = new Date();
      if (this.dataModel.value) dateVal = new Date(this.dataModel.value);
      var yearOptions = {
        options: [],
        width: "80px",
        value: dateVal.getFullYear() + ""
      };

      for (var i = this.startYear; i <= this.endYear; i++) {
        yearOptions.options.push(i + "");
      }

      var curMonth = dateVal.getMonth() + 1;
      curMonth = curMonth < 10 ? "0" + curMonth : curMonth + "";
      var monthOptions = {
        options: [],
        width: this.dataModel.type == "DateTime" ? "60px" : "80px",
        value: curMonth
      };

      for (var i = 1; i <= 12; i++) {
        var month = i < 10 ? "0" + i : i + "";
        monthOptions.options.push(month);
      }

      monthOptions.onChange = function () {
        var month = window.popupList.getColumnVal(1);
        var dayCol = $(".tfp-popuplist-content-column").get(2);
        var items = $(dayCol).find(".tfp-popuplist-content-item");

        if (month == "02") {
          items.eq(32).hide();
          items.eq(33).hide();
          var year = parseInt(window.popupList.getColumnVal(0));

          if (year % 4 == 0) {
            items.eq(31).show();
          } else {
            items.eq(31).hide();
          }
        } else if (["04", "06", "09", "11"].contains(month)) {
          items.eq(31).show();
          items.eq(32).show();
          items.eq(33).hide();
        } else {
          items.eq(31).show();
          items.eq(32).show();
          items.eq(33).show();
        }
      };

      var curDay = dateVal.getDate();
      curDay = curDay < 10 ? "0" + curDay : curDay + "";
      var dateOptions = {
        options: [],
        width: this.dataModel.type == "DateTime" ? "60px" : "80px",
        value: curDay
      };

      for (var i = 1; i <= 31; i++) {
        var day = i < 10 ? "0" + i : i + "";
        dateOptions.options.push(day);
      }

      optionsList.push(yearOptions);
      optionsList.push(monthOptions);
      optionsList.push(dateOptions);
    }
  }, {
    key: "getTimeOptions",
    value: function getTimeOptions(optionsList) {
      var dateVal = new Date();
      if (this.dataModel.value) dateVal = new Date(this.dataModel.value);
      var curHour = dateVal.getHours();
      curHour = curHour < 10 ? "0" + curHour : curHour + "";
      var hourOptions = {
        options: [],
        width: "60px",
        value: curHour
      };

      for (var i = 0; i <= 23; i++) {
        var hour = i < 10 ? "0" + i : i + "";
        hourOptions.options.push(hour);
      }

      optionsList.push(hourOptions);
      var curMinute = dateVal.getMinutes();
      curMinute = curMinute < 10 ? "0" + curMinute : curMinute + "";
      var minuteOptions = {
        options: [],
        width: "60px",
        value: curMinute
      };

      for (var i = 0; i <= 59; i++) {
        var day = i < 10 ? "0" + i : i + "";
        minuteOptions.options.push(day);
      }

      optionsList.push(minuteOptions);

      if (this.showSecond) {
        var curSecond = dateVal.getSeconds();
        curSecond = curSecond < 10 ? "0" + curSecond : curSecond + "";
        var secondOptions = {
          options: [],
          width: "60px",
          value: curSecond
        };

        for (var i = 0; i <= 59; i++) {
          var _day = i < 10 ? "0" + i : i + "";

          secondOptions.options.push(_day);
        }

        optionsList.push(secondOptions);
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.click(function () {
        var optionsList = [];
        that.getDateOptions(optionsList);

        if (that.dataModel.type == "DateTime") {
          that.getTimeOptions(optionsList);
        }

        window.popupList.show(optionsList, function (vals) {
          console.log(vals);
          var val = vals[0] + "-" + vals[1] + "-" + vals[2];

          if (that.dataModel.type == "DateTime") {
            val += " " + vals[3] + ":" + vals[4];
            if (that.showSecond) val += ":" + vals[5];
          }

          that.value = val;
        });
      });
    }
  }]);

  return DateTime;
}(_controller.FormInput);

exports["default"] = DateTime;