"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * Excel导出组件
 * @param {[type]} dataModel [description]
 */
var ExcelExport = /*#__PURE__*/function (_VisibleComponent) {
  _inherits(ExcelExport, _VisibleComponent);

  var _super = _createSuper(ExcelExport);

  function ExcelExport(__tfp, dataModel, parent, inputType) {
    var _this;

    _classCallCheck(this, ExcelExport);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "ExcelExport", dataModel, parent);
    }

    return _possibleConstructorReturn(_this);
  } //属性


  _createClass(ExcelExport, [{
    key: "text",
    get: function get() {
      return this.dataModel.text;
    },
    set: function set(value) {
      this.dataModel.text = value;

      if (this._jqObj) {
        this._jqObj.html(value);
      }
    }
  }, {
    key: "theme",
    get: function get() {
      return this.dataModel.theme;
    },
    set: function set(value) {
      var theme = "rect";
      if (value) theme = value;

      if (!this.checkAttrOption("theme", theme)) {
        this._tfp.showMsg("不支持风格：" + theme + "！");

        return;
      }

      this.dataModel.theme = theme;

      if (this._jqObj) {
        this._jqObj.removeClass("tfp-button-round tfp-button-rect tfp-button-circle");

        this._jqObj.addClass("tfp-button-" + theme);
      }
    }
  }, {
    key: "service",
    get: function get() {
      return this.dataModel.service;
    },
    set: function set(value) {
      this.dataModel.service = value;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.click(function () {
        if (!that.dataModel.service) {
          that._tfp.showMsg("请设置导出数据的后台服务！");

          return;
        }

        var serviceCpt = that._tfp.components[that.dataModel.service];
        serviceCpt.request(null, function (req, res) {
          if (res.code != 0) {
            that._tfp.showMsg(res.message);

            return;
          }

          $('.exportlink').remove();
          $('body').append('<a class="exportlink" style="display:none;" href="javascript:"></a>');
          $('.exportlink').click(function () {
            var url = "/Download?fileCode=" + res.fileCode;
            window.location.href = that._tfp.setUrlAuthData(url);
          });
          $('.exportlink').click();
        });
      });
    }
  }]);

  return ExcelExport;
}(_controller.VisibleComponent);

exports["default"] = ExcelExport;