"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "ExcelImport",
  "comment": "Excel导入",
  "cssFiles": ["../button/style.{bgColorMode}.css", "style.css"],
  "attrs": [{
    "name": "text",
    "comment": "按钮文本",
    "type": "String",
    "default": "导入"
  }, {
    "name": "theme",
    "comment": "按钮风格",
    "type": "Select",
    "special": true,
    "default": "rect",
    "options": [{
      "value": "rect",
      "text": "矩形"
    }, {
      "value": "round",
      "text": "圆角矩形"
    }, {
      "value": "circle",
      "text": "椭圆形"
    }]
  }, {
    "name": "service",
    "comment": "导入服务",
    "type": "ServicePicker"
  }],
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "defaultStyles": {
    "background-color": "#0066ff",
    "border": "0",
    "color": "#ffffff"
  },
  "events": [{
    "name": "onImport",
    "comment": "完成导入后"
  }]
};
exports["default"] = _default;