"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * 弹性栅格组件
 * @param {[type]} dataModel [description]
 */
var FlexBox = /*#__PURE__*/function (_VisibleComponent) {
  _inherits(FlexBox, _VisibleComponent);

  var _super = _createSuper(FlexBox);

  function FlexBox(__tfp, dataModel, parent) {
    var _this;

    _classCallCheck(this, FlexBox);

    _this = _super.call(this, __tfp, "FlexBox", dataModel, parent);

    if (_this._tfp.isDesigning && (!_this.dataModel.components || _this.dataModel.components.length == 0)) {
      if (_this._tfp.curPage.client == "pc" || _this._tfp.curPage.client == "tb") {
        _this.dataModel.components = [{
          id: _this.id + "_panel1",
          type: "Panel",
          styles: {
            "flex-grow": 0,
            "flex-shrink": 0,
            "flex-basis": "180px",
            "height": "30px",
            "line-height": "30px"
          }
        }, {
          id: _this.id + "_panel2",
          type: "Panel",
          styles: {
            "flex-grow": 1,
            "flex-shrink": 0,
            "flex-basis": "auto",
            "height": "30px",
            "line-height": "30px"
          }
        }];
      } else if (_this._tfp.curPage.client == "phone") {
        _this.dataModel.components = [{
          id: _this.id + "_panel1",
          type: "Panel",
          styles: {
            "flex-grow": 0,
            "flex-shrink": 0,
            "flex-basis": "120px",
            "height": "30px",
            "line-height": "30px"
          }
        }, {
          id: _this.id + "_panel2",
          type: "Panel",
          styles: {
            "flex-grow": 1,
            "flex-shrink": 0,
            "flex-basis": "auto",
            "height": "30px",
            "line-height": "30px"
          }
        }];
      }
    }

    return _this;
  } //不是容器组件，但可以添加子组件


  _createClass(FlexBox, [{
    key: "containerEl",
    get: function get() {
      return this.el;
    }
  }, {
    key: "items",
    get: function get() {
      var items = [];

      if (this.dataModel.components) {
        for (var i = 0; i < this.dataModel.components.length; i++) {
          var itemDM = this.dataModel.components[i];
          items.push({
            id: itemDM.id,
            "flex-grow": itemDM.styles["flex-grow"],
            "flex-shrink": itemDM.styles["flex-shrink"],
            "flex-basis": itemDM.styles["flex-basis"]
          });
        }
      }

      return items;
    },
    set: function set(value) {
      var items = [];
      if (value) items = value;
      var components = [];

      for (var i = 0; i < items.length; i++) {
        var item = items[i];
        var cdm = null;

        if (item.id) {
          var panelChild = this._tfp.components[item.id];
          cdm = panelChild.dataModel; //delete this._tfp.components[panelChild.id];
        } else {
          var flexGrow = 1;
          if (!isNull(item["flex-grow"])) flexGrow = item["flex-grow"];
          var flexShrink = 0;
          if (!isNull(item["flex-shrink"])) flexShrink = item["flex-shrink"];
          var flexBasis = "auto";
          if (!isNull(item["flex-basis"])) flexBasis = item["flex-basis"];
          cdm = {
            type: "Panel",
            styles: {
              "flex-grow": flexGrow,
              "flex-shrink": flexShrink,
              "flex-basis": flexBasis,
              "height": "30px",
              "line-height": "30px"
            }
          }; //if(i>0) cdm.styles["margin-left"] = "10px";
        }

        components.push(cdm);
      }

      this.clear();
      this.dataModel.components = components;

      this._jqObj.remove();

      this.isRendered = false;
      this.render();
    }
  }, {
    key: "direction",
    get: function get() {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "flex-direction": "row"
        };
      }

      return this.dataModel.styles["flex-direction"];
    },
    set: function set(value) {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "flex-direction": "row"
        };
      }

      this.dataModel.styles["flex-direction"] = value;
      if (this._jqObj) this._jqObj.css("flex-direction", value);
    }
  }, {
    key: "wrap",
    get: function get() {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "flex-wrap": "nowrap"
        };
      }

      return this.dataModel.styles["flex-wrap"];
    },
    set: function set(value) {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "flex-wrap": "nowrap"
        };
      }

      this.dataModel.styles["flex-wrap"] = value ? "wrap" : "nowrap";
      if (this._jqObj) this._jqObj.css("flex-wrap", value);
    }
  }, {
    key: "align",
    get: function get() {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "justify-content": "flex-start"
        };
      }

      return this.dataModel.styles["justify-content"];
    },
    set: function set(value) {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "justify-content": "flex-start"
        };
      }

      this.dataModel.styles["justify-content"] = value;
      if (this._jqObj) this._jqObj.css("justify-content", value);
    }
  }, {
    key: "valign",
    get: function get() {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "align-items": "stretch"
        };
      }

      return this.dataModel.styles["align-items"];
    },
    set: function set(value) {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "align-items": "stretch"
        };
      }

      this.dataModel.styles["align-items"] = value;
      if (this._jqObj) this._jqObj.css("align-items", value);
    }
  }]);

  return FlexBox;
}(_controller.VisibleComponent);

exports["default"] = FlexBox;